; SPDX-License-Identifier: GPL-2.0-or-later
; Copyright (C) 2017-2020  Loris Chiocca
; Annotated functions and structures of the IBM Music Feature
; ---------------------------------------------------------------------------

FractionalNote  struc ; (sizeof=0x2)    ; XREF: RAM:masterTuneAsNoteFraction/r
                                        ; RAM:lastMidiOnOff_FractionAndNoteNumber/r ...
fraction:       db ?                    ; XREF: ym_setKeyCodeAndFraction+F/r
                                        ; ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+19/r ...
note:           db ?                    ; XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+33/w
                                        ; ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+63/w ...
FractionalNote  ends

; ---------------------------------------------------------------------------

MidiDataPacket  struc ; (sizeof=0x20)   ; XREF: processMidiState_01_36_37_38/t
                                        ; processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35/t ...
data:           db 16 dup(?)            ; XREF: processMidiState_01_36_37_38/t
                                        ; processMidiState_02_04/w ...
state:          db ?                    ; XREF: MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch:no_data/r
                                        ; MUSIC_MODE_LOOP_read_System_And_Dispatch:no_data/r ... ; Known states: 0x00, 0x01, 0x36, 0x37, 0x38
field_11:       db ?
field_12:       db ?
field_13:       db ?
field_14:       db ?
field_15:       db ?
field_16:       db ?
field_17:       db ?
field_18:       db ?
field_19:       db ?
field_1A:       db ?
field_1B:       db ?
field_1C:       db ?
field_1D:       db ?
field_1E:       db ?
field_1F:       db ?
MidiDataPacket  ends

; ---------------------------------------------------------------------------

; see page 6-8 in IMF Technical Reference Manual
InstrumentParameters struc ; (sizeof=0x80)
                                        ; XREF: RAM:activeInstrumentParameters/r
instrumentConfiguration:InstrumentConfiguration ?
                                        ; XREF: setInstrumentParameter_MidiChannelNumber+4/w
                                        ; setInstrumentParameter_NumberOfNotes+9/w ... ; Number of notes                  / 0-8
voiceDefinition:VoiceDefinition ?       ; XREF: setInstrumentParameter_LFOLoadEnable+4/w
                                        ; setInstrumentParameter_LFOLoadEnable+C/w ...
pitchbenderValueMSB:db ?                ; XREF: executeMidiCommand_PitchBender/w
pitchbenderValueLSB:db ?                ; XREF: executeMidiCommand_PitchBender+3/w
detuneAndPitchbendAsNoteFraction:FractionalNote ?
                                        ; XREF: executeMidiCommand_PitchBender+54/w
                                        ; executeMidiCommand_PitchBender+57/w
detuneAsNoteFraction:FractionalNote ?   ; XREF: setInstrumentParameter_06_07_common+1A/w
                                        ; setInstrumentParameter_06_07_common+1D/w ; total transpose value after "octave transpose" and "detune" (LSB)
volume:         db ?                    ; XREF: setInstrumentParameterVolume+C/w
flags:          db ?                    ; XREF: setInstrumentParameter_LFOSync+8/w
                                        ; setInstrumentParameter_LFOSync+14/w ... ; <a*****ps> <a>: LFO sync mode 0,1 (Sync ON) / <p> portamento ON/OFF / <s> sustain ON/OFF
operator1TotalLevel:db ?                ; XREF: setInstrumentParameter_OperatorTotalLevel:loc_1853/w
operator2TotalLevel:db ?
operator3TotalLevel:db ?
operator4TotalLevel:db ?
unused1:        db ?
channelMask:    db ?                    ; XREF: sub_1405+1F/w
                                        ; setInstrumentParameter_NumberOfNotes+1E/w ...
lastUsedChannel:db ?                    ; XREF: deallocateAssignedChannels+23/w
                                        ; executeMidiCommand_NoteONOFF_internal+7E/w ... ; is initially set to "1" and will be rotated to a active bit in channelMask
lastMidiOnOff_Duration_XXX:dw ?         ; XREF: applyInstrumentConfiguration?+3/w
                                        ; setInstrumentParameter_AllNotesOFF/w ... ; copy of field_63 at some point
lastMidiOnOff_FractionAndNoteNumber_XXX:FractionalNote ?
                                        ; XREF: realTimeMessage_FC_MonoMode+2B/w
                                        ; realTimeMessage_FC_MonoMode+31/w ...
lastMidiOnOff_Duration_YYY:dw ?         ; XREF: applyInstrumentConfiguration?+7/w
                                        ; setInstrumentParameter_AllNotesOFF+4/w ... ; copy of field_5F at some point
lastMidiOnOff_FractionAndNoteNumber_YYY:FractionalNote ?
                                        ; XREF: sub_264B+A/w
                                        ; sub_264B+10/w
strangeMemoryLSB:db ?                   ; XREF: ym_registerKey_setKeyCodeAndFraction+15/w
                                        ; resetYmChannelData+18/w
strangeMemoryMSB:db ?                   ; XREF: ym_registerKey_setKeyCodeAndFraction+18/w
                                        ; resetYmChannelData+1B/w
overflowToMidiOut:db ?                  ; XREF: setInstrumentParameter_MidiChannelNumber+9/w
                                        ; setInstrumentParameter_MidiChannelNumber:midiChannelFound/w ... ; bit0:???
unused2:        db 22 dup(?)
InstrumentParameters ends

; ---------------------------------------------------------------------------

InstrumentConfiguration struc ; (sizeof=0x10)
                                        ; XREF: InstrumentParameters/r
                                        ; ConfigurationData/r
numberOfNotes:  db ?                    ; XREF: setInstrumentParameter_NumberOfNotes+9/w
                                        ; setInstrumentParameter_NumberOfNotes+13/r ... ; Number of notes                  / 0-8
midiChannel:    db ?                    ; XREF: setInstrumentParameter_MidiChannelNumber+4/w ; MIDI channel number              / 0-15
noteNumberLimitHigh:db ?                ; XREF: setInstrumentParameter_NoteNumberLimitHigh+1/w
                                        ; setInstrumentParameter_NoteNumberLimitLow+9/w ; Note number limit high           / 0-127
noteNumberLimitLow:db ?                 ; XREF: setInstrumentParameter_NoteNumberLimitHigh+9/w
                                        ; setInstrumentParameter_NoteNumberLimitLow/w ; Note number limit low            / 0-127
voiceBankNumber:db ?                    ; XREF: setInstrumentParameter_VoiceBankNumber+8/w ; Voice bank number                / 0-6
voiceNumber:    db ?                    ; XREF: setInstrumentParameter_VoiceNumber+4/w ; Voice number                     / 0-47
detune:         db ?                    ; XREF: setInstrumentParameter_Detune/w ; Detune                           / -64-63 (2's complement)
octaveTranspose:db ?                    ; XREF: setInstrumentParameter_OctaveTranspose+4/w ; Octave transpose                 / 0-4 (2=Center)
outputLevel:    db ?                    ; XREF: setInstrumentParameter_OutputLevel/w ; Output level                     / 0-127
pan:            db ?                    ; XREF: setInstrumentParameter_Pan+1/w ; Pan                              / 0=L, 64=L+R, 127=R
lfoEnable:      db ?                    ; XREF: setInstrumentParameter_LFOEnable+4/w ; LFO enable                       / 0,1(OFF)
portamentoTime: db ?                    ; XREF: setInstrumentParameter_PortamentoTime/w ; Portamento time (pitch slide)       / 0=OFF, 1(fast)-127(slow)
pitchbenderRange:db ?                   ; XREF: setInstrumentParameter_PitchbenderRange+4/w ; Pitchbender range                / 0-12 number of half-steps (0=no pitch fluctuation)
polyMonoMode:   db ?                    ; XREF: setInstrumentParameter_MonoPolyMode+7/w ; MONO/POLY mode                   / 0(POLY), 1(MONO)
pmdController:  db ?                    ; XREF: setInstrumentParameter_PMDController+4/w ; PMD controller                   / 0=OFF, 1=Touch, 2=Wheel, 3=Breath, 4=Foot
reserved1:      db ?                    ; reserved
InstrumentConfiguration ends

; ---------------------------------------------------------------------------

ConfigurationData struc ; (sizeof=0xA0) ; XREF: ROM:ROMPresetConfiguration16/r
                                        ; ROM:ROMPresetConfiguration17/r ...
name:           db 8 dup(?)             ; XREF: setNodeParameterName0+1/w
                                        ; setNodeParameterName1+1/w ... ; ASCII
combineMode:    db ?                    ; XREF: initConfigurationRAMSlot+16/o
                                        ; loadInstrumentParameters_InstrumentConfiguration+10/r ... ; 0,1 (Combine ON)
lfoSpeed:       db ?                    ; XREF: proc_1393_called_for_Reboot/r
                                        ; setNodeParameterLFOSpeed+1/w ... ; 0~127
amplitudeModulationDepth:db ?           ; XREF: proc_1393_called_for_Reboot+5/r
                                        ; setNodeParameterAmpModDepth+1/w ... ; 0~127
pitchModulationDepth:db ?               ; XREF: proc_1393_called_for_Reboot+A/r
                                        ; setNodeParameterPitchModDepth+1/w ... ; 0~127
lfoWaveForm:    db ?                    ; XREF: proc_1393_called_for_Reboot+F/r
                                        ; setNodeParameterLFOWaveForm+4/w ... ; 0~3
noteNumberReceptionMode:db ?            ; XREF: sub_1405+3/r
                                        ; setNodeParameterNoteNrReceptionMode+4/w ... ; 0=All, 1=Even, 2=Odd
reserved:       db 18 dup(?)
instrumentConfigurations:InstrumentConfiguration 8 dup(?)
                                        ; XREF: SOFT_REBOOT+14/o
                                        ; setNodeParameterChainMode+45/o ...
ConfigurationData ends

; ---------------------------------------------------------------------------

OperatorDefinition struc ; (sizeof=0x8) ; XREF: VoiceDefinition/r
                                        ; VoiceDefinition/r ...
totalLevel:     db ?                    ; Operator: <0*******> <*>: Total level (TL)
field_1:        db ?                    ; Operator: <a***0000> <a>: Keyboard level scaling type (KLS Bit0) / <*>: Velocity sensitivity to total level (VSTL)
field_2:        db ?                    ; Operator: <aaaabbbb> <a>: Keyboard level scaling depth (KLSD) / <b>: Addition to "Total level"
field_3:        db ?                    ; Operator: <abbbcccc> <a>: KLS bit 1 / <b>: Detune (DT) / <c>: Multiple
field_4:        db ?                    ; Operator: <aa0*****> <a>: Keyboard rate scaling depth (KRSD) / <*>: Attack rate (AR)
field_5:        db ?                    ; Operator: <abb*****> <a>: Modulator(0)/Carrier(1) / <b>: Velocity sensitivity to attack rate (VSAR) / <*>: Decay 1 rate (D1R)
field_6:        db ?                    ; Operator: <aa0*****> <a>: Inharmonic / <*>: Decay 2 rate (D2R)
field_7:        db ?                    ; Operator: <aaaabbbb> <a>: Sustain level (SL) / <b>: Release rate (RR)
OperatorDefinition ends

; ---------------------------------------------------------------------------

VoiceDefinition struc ; (sizeof=0x40)   ; XREF: InstrumentParameters/r
                                        ; VoiceDefinitionBank/r
name:           db 7 dup(?)             ; Name of instrument
reserved1:      db ?                    ; <********> Reserved
lfoSpeed:       db ?                    ; XREF: setInstrumentParameter_LFOSpeed+2/w ; <********> LFO Speed
amplitudeModulationDepth:db ?           ; XREF: setInstrumentParameter_LFOLoadEnable+4/w
                                        ; setInstrumentParameter_LFOLoadEnable+C/w ... ; <a*******> <a>: LFO load mode 0,1 (Enable) / <*>: Amplitude modulation depth (AMD)
pitchModulationDepth:db ?               ; XREF: setInstrumentParameter_PitchModulationDepth+6/w
                                        ; setInstrumentParameter_LFOSync+4/w ... ; <a*******> <a>: LFO sync mode 0,1 (Sync ON) / <*>: Pitch modulation depth (PMD)
operatorEnable: db ?                    ; <0abcd000> Operator enable a=operator #4 ... d=operator #1
feedbackLevelAlgorithm:db ?             ; <11aaabbb> <a>: Feedback level / <b>: Algorithm
pmsAm:          db ?                    ; XREF: setInstrumentParameter_AmplitudeModulationSensitivity+A/w
                                        ; setInstrumentParameter_PitchModulationSensitivity+F/w ; <0aaa00bb> <a>: Pitch modulation sensitivity (PMS) / <b>: AM
lfoWaveForm:    db ?                    ; XREF: setInstrumentParameter_LFOWaveform+E/w ; <0**00000> <*>: LFO wave form
transpose:      db ?                    ; <********> <*>: Transpose -128~127
operator0:      OperatorDefinition ?    ; Operator 1
operator1:      OperatorDefinition ?    ; Operator 2
operator2:      OperatorDefinition ?    ; Operator 3
operator3:      OperatorDefinition ?    ; Operator 4
reserved2:      db 10 dup(?)
field_3A:       db ?                    ; <a*******> : <a> Mono/Poly mode <*> portamento time
field_3B:       db ?                    ; <*aaabbbb> : <b> PitchbenderRange <a> PMDController
reserved3:      db 4 dup(?)
VoiceDefinition ends

; ---------------------------------------------------------------------------

VoiceDefinitionBank struc ; (sizeof=0xC20)
                                        ; XREF: ROM:VoiceDefinitionBankRom1/r
                                        ; ROM:VoiceDefinitionBankRom2/r ...
name:           db 8 dup(?)             ; XREF: initConfigurationMemory+14/o ; string(C)
reserved:       db 24 dup(?)            ; XREF: initCustomInstrumentData+5/o
instrumentDefinitions:VoiceDefinition 48 dup(?)
VoiceDefinitionBank ends

; ---------------------------------------------------------------------------

YmChannelData   struc ; (sizeof=0x80)   ; XREF: RAM:strangeMemory/r
channel0_ptrInstrumentParameters:dw ?   ; XREF: sub_1405+25/w
                                        ; deallocateAssignedChannels+18/w ... ; ptr to InstrumentParameters (?)
channel0_currentlyPlaying:FractionalNote ?
                                        ; XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+30/w
                                        ; ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+33/w ...
channel1_ptrInstrumentParameters:dw ?   ; XREF: getYmChannelData:memoryLocationLookup/o ; ptr to InstrumentParameters
channel1_currentlyPlaying:FractionalNote ? ; unused?
channel2_ptrInstrumentParameters:dw ?   ; XREF: getYmChannelData:memoryLocationLookup/o ; ptr to InstrumentParameters
channel2_currentlyPlaying:FractionalNote ? ; unused?
channel3_ptrInstrumentParameters:dw ?   ; XREF: getYmChannelData:memoryLocationLookup/o ; ptr to InstrumentParameters
channel3_currentlyPlaying:FractionalNote ? ; unused?
channel4_ptrInstrumentParameters:dw ?   ; XREF: getYmChannelData:memoryLocationLookup/o ; ptr to InstrumentParameters
channel4_currentlyPlaying:FractionalNote ? ; unused?
channel5_ptrInstrumentParameters:dw ?   ; XREF: getYmChannelData:memoryLocationLookup/o ; ptr to InstrumentParameters
channel5_currentlyPlaying:FractionalNote ? ; unused?
channel6_ptrInstrumentParameters:dw ?   ; XREF: getYmChannelData:memoryLocationLookup/o ; ptr to InstrumentParameters
channel6_currentlyPlaying:FractionalNote ? ; unused?
channel7_ptrInstrumentParameters:dw ?   ; XREF: getYmChannelData:memoryLocationLookup/o ; ptr to InstrumentParameters
channel7_currentlyPlaying:FractionalNote ? ; unused?
channel0_operatorVolume:db 4 dup(?)     ; XREF: ym_calculateAndUpdateOperatorVolumes:loc_1D07/w
                                        ; ym_calculateAndUpdateOperatorVolumes:loc_1D27/w ...
channel1_operatorVolume:db 4 dup(?)
channel2_operatorVolume:db 4 dup(?)
channel3_operatorVolume:db 4 dup(?)
channel4_operatorVolume:db 4 dup(?)
channel5_operatorVolume:db 4 dup(?)
channel6_operatorVolume:db 4 dup(?)
channel7_operatorVolume:db 4 dup(?)
channel0_to_ym_channel:db ?             ; XREF: initAllMemoryBuffers+33/w
                                        ; setAllYmRegistersForAssignedChannels+15/w ; x eeee ccc / e operator enabled bits / c=channel number
channel0_flags: db ?                    ; XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+45/w
                                        ; ym_registerKey_setKeyCodeAndFraction_IncludingPortamento:hl_is_negative/w ... ; bit5: used when portamento changes
channel0_remainingDuration:dw ?         ; XREF: ym_registerKey_setKeyCodeAndFraction+C/w
                                        ; ym_registerKey_setKeyCodeAndFraction+F/w ... ; lastMidiOnOff_Duration
channel1_to_ym_channel:db ?
channel1_flags: db ?
channel1_remainingDuration:dw ?
channel2_to_ym_channel:db ?
channel2_flags: db ?
channel2_remainingDuration:dw ?
channel3_to_ym_channel:db ?
channel3_flags: db ?
channel3_remainingDuration:dw ?
channel4_to_ym_channel:db ?
channel4_flags: db ?
channel4_remainingDuration:dw ?
channel5_to_ym_channel:db ?
channel5_flags: db ?
channel5_remainingDuration:dw ?
channel6_to_ym_channel:db ?
channel6_flags: db ?
channel6_remainingDuration:dw ?
channel7_to_ym_channel:db ?
channel7_flags: db ?
channel7_remainingDuration:dw ?
channel0_portamentoAdjustment:FractionalNote ?
                                        ; XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+60/w
                                        ; ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+63/w ...
channel0_portamentoTarget:FractionalNote ?
                                        ; XREF: resetYmChannelData+9/w
                                        ; resetYmChannelData+C/w ...
channel1_portamentoAdjustment:FractionalNote ?
channel1_portamentoTarget:FractionalNote ?
channel2_portamentoAdjustment:FractionalNote ?
channel2_portamentoTarget:FractionalNote ?
channel3_portamentoAdjustment:FractionalNote ?
channel3_portamentoTarget:FractionalNote ?
channel4_portamentoAdjustment:FractionalNote ?
channel4_portamentoTarget:FractionalNote ?
channel5_portamentoAdjustment:FractionalNote ?
channel5_portamentoTarget:FractionalNote ?
channel6_portamentoAdjustment:FractionalNote ?
channel6_portamentoTarget:FractionalNote ?
channel7_portamentoAdjustment:FractionalNote ?
channel7_portamentoTarget:FractionalNote ?
YmChannelData   ends

; ---------------------------------------------------------------------------

YmChannelDataPre struc ; (sizeof=0x20)  ; XREF: RAM:strangeMemoryPre/r
channel0_FractionAndNoteNumber_AAA:FractionalNote ?
channel0_unused:dw ?
channel1_FractionAndNoteNumber_AAA:FractionalNote ?
channel1_unused:dw ?
channel2_FractionAndNoteNumber_AAA:FractionalNote ?
channel2_unused:dw ?
channel3_FractionAndNoteNumber_AAA:FractionalNote ?
channel3_unused:dw ?
channel4_FractionAndNoteNumber_AAA:FractionalNote ?
channel4_unused:dw ?
channel5_FractionAndNoteNumber_AAA:FractionalNote ?
channel5_unused:dw ?
channel6_FractionAndNoteNumber_AAA:FractionalNote ?
channel6_unused:dw ?
channel7_FractionAndNoteNumber_AAA:FractionalNote ?
channel7_unused:dw ?
YmChannelDataPre ends

; ---------------------------------------------------------------------------

; enum YA2151_PORT
YA2151_PORT_1:   equ 0
YA2151_PORT_2:   equ 1

; ---------------------------------------------------------------------------

; enum MIDI_STATE
MIDI_STATE_00:   equ 0                  ; XREF: processMidiState_00/s
                                        ; processMidiState_11/s ...
MIDI_STATE_01:   equ 1                  ; XREF: processMidiState_01_36_37_38+3/s
MIDI_STATE_02:   equ 2
MIDI_STATE_03:   equ 3                  ; XREF: processMidiState_02_04+3/s
MIDI_STATE_04:   equ 4                  ; XREF: processMidiState_03+3/s
MIDI_STATE_05:   equ 5
MIDI_STATE_06:   equ 6                  ; XREF: processMidiState_05_07+3/s
MIDI_STATE_07:   equ 7                  ; XREF: processMidiState_06+3/s
MIDI_STATE_08:   equ 8
MIDI_STATE_09:   equ 9                  ; XREF: processMidiState_08_09+3/s
MIDI_STATE_0A:   equ 0Ah
MIDI_STATE_0B:   equ 0Bh                ; XREF: processMidiState_0A_0C+3/s
MIDI_STATE_0C:   equ 0Ch                ; XREF: processMidiState_0B+3/s
MIDI_STATE_0D:   equ 0Dh
MIDI_STATE_0E:   equ 0Eh                ; XREF: processMidiState_0D_0E+3/s
MIDI_STATE_0F:   equ 0Fh
MIDI_STATE_10:   equ 10h                ; XREF: processMidiState_0F+3/s
MIDI_STATE_11:   equ 11h                ; XREF: processMidiState_10+3/s
MIDI_STATE_12:   equ 12h
MIDI_STATE_13:   equ 13h                ; XREF: processMidiState_12+3/s
MIDI_STATE_14:   equ 14h
MIDI_STATE_15:   equ 15h
MIDI_STATE_16:   equ 16h                ; XREF: processMidiState_15+8/s
MIDI_STATE_17:   equ 17h                ; XREF: processMidiState_16+8/s
MIDI_STATE_18:   equ 18h                ; XREF: processMidiState_17:value_0x70/s
MIDI_STATE_19:   equ 19h
MIDI_STATE_1A:   equ 1Ah                ; XREF: processMidiState_19+3/s
MIDI_STATE_1B:   equ 1Bh                ; XREF: processMidiState_1A+3/s
MIDI_STATE_1C:   equ 1Ch
MIDI_STATE_1D:   equ 1Dh                ; XREF: processMidiState_1C+3/s
MIDI_STATE_1E:   equ 1Eh                ; XREF: processMidiState_1D+3/s
MIDI_STATE_1F:   equ 1Fh                ; XREF: processMidiState_1E+3/s
MIDI_STATE_20:   equ 20h
MIDI_STATE_21:   equ 21h                ; XREF: processMidiState_20+3/s
MIDI_STATE_22:   equ 22h                ; XREF: processMidiState_21+3/s
MIDI_STATE_23:   equ 23h                ; XREF: processMidiState_22+3/s
MIDI_STATE_24:   equ 24h                ; XREF: processMidiState_23+3/s
MIDI_STATE_25:   equ 25h                ; XREF: processMidiState_24+3/s
MIDI_STATE_26:   equ 26h
MIDI_STATE_27:   equ 27h                ; XREF: processMidiState_26+3/s
MIDI_STATE_28:   equ 28h                ; XREF: processMidiState_27+3/s
MIDI_STATE_29:   equ 29h
MIDI_STATE_2A:   equ 2Ah                ; XREF: processMidiState_29+3/s
MIDI_STATE_2B:   equ 2Bh
MIDI_STATE_2C:   equ 2Ch                ; XREF: processMidiState_2B+3/s
MIDI_STATE_2D:   equ 2Dh
MIDI_STATE_2E:   equ 2Eh                ; XREF: processMidiState_2D+3/s
MIDI_STATE_2F:   equ 2Fh                ; XREF: processMidiState_2E+3/s
MIDI_STATE_30:   equ 30h
MIDI_STATE_31:   equ 31h                ; XREF: processMidiState_30+7/s
MIDI_STATE_32:   equ 32h                ; XREF: processMidiState_31+3/s
MIDI_STATE_33:   equ 33h                ; XREF: processMidiState_30:loc_7F0/s
MIDI_STATE_34:   equ 34h                ; XREF: processMidiState_33+3/s
MIDI_STATE_35:   equ 35h                ; XREF: processMidiState_34+3/s
MIDI_STATE_36:   equ 36h                ; XREF: processMidiState_15:loc_742/s
MIDI_STATE_37:   equ 37h                ; XREF: processMidiState_16:loc_750/s
MIDI_STATE_38:   equ 38h                ; XREF: processMidiState_17+C/s
MIDI_STATE_39:   equ 39h                ; XREF: processMidiState_17:value_0x71/s
MIDI_STATE_3A:   equ 3Ah                ; XREF: processMidiState_39_3C_3F+7/s
MIDI_STATE_3B:   equ 3Bh                ; XREF: processMidiState_3A+7/s
MIDI_STATE_3C:   equ 3Ch                ; XREF: processMidiState_3B+3/s
MIDI_STATE_3D:   equ 3Dh                ; XREF: processMidiState_3A:loc_819/s
MIDI_STATE_3E:   equ 3Eh                ; XREF: processMidiState_3D+3/s
MIDI_STATE_3F:   equ 3Fh                ; XREF: processMidiState_3E+3/s
MIDI_STATE_40:   equ 40h

; ---------------------------------------------------------------------------

; enum MIDI_PORT
MIDI_PORT_1:     equ 10h                ; XREF: readMidiInPortDuringInterruptHandler/s
                                        ; writeMidiOutPortDuringInterruptHandler+6/s ...
MIDI_PORT_2:     equ 11h                ; XREF: reset_midi_device+2/s
                                        ; reset_midi_device+6/s ...

; ---------------------------------------------------------------------------

; enum PIU_PORT
PIU_PORT0:       equ 20h                ; XREF: sendNextValueToSystemDuringInterruptHandler+C/s ; Data is transferred from the music card to the
                                        ; system by reading from Port 0. Port 0 (PIU0) is
                                        ; used in conjunction with bit 7 of PIU2 to transfer
                                        ; the 9-bit data word from the music card to the
                                        ; system. The ninth bit (bit 8) is read from PIU2
                                        ; prior to reading PIU0, as it may be overwritten
                                        ; when RxRDY is cleared. RxRDY is cleared by
                                        ; reading PIU0.
PIU_PORT1:       equ 21h                ; XREF: receiveNextValueFromSystemDuringInterruptHandler+E/s ; Data is transferred from the system to the music
                                        ; card by writing to Port 1 (PIU1). Port 1 is used
                                        ; in conjunction with bit 4 of the TCR to transfer
                                        ; the 9-bit word from the system to the music card.
                                        ; When data is written to PIU1, TxRDY is cleared.
PIU_PORT2:       equ 22h                ; XREF: sendOrReceiveNextValueToFromSystemDuringInterruptHandler/s
                                        ; restartIntoCustomMem:loc_1257/s ; Function of Port 2 bits in Mode 1:
                                        ; Group 1:
                                        ;  bit 0: INT1 (interrupt request)
                                        ;  bit 1: (R/W)BF1 (buffer full)
                                        ;  bit 2: (R/W)IE1 (interrupt enable flag)
                                        ; Group 0:
                                        ;  bit 3: INT0 (interrupt request)
                                        ;  bit 4: RIE0 (read interrupt enable flag) / I/O
                                        ;  bit 5: IBF0 (input buffer full) / I/O
                                        ;  bit 6: I/O / WIE0 (write interrupt enable flag)
                                        ;  bit 7: I/O / OBF0 (Output buffer full)
PIU_PCR:         equ 23h                ; XREF: reset_PIU_device+2/s
                                        ; initializePIUInput+E/s ... ; This register is used to initialize the PIU and for
                                        ; Bit Set/Reset operations of PIU2.
                                        ;
                                        ; [BD] - Initializes the PIU
                                        ; [05] - Sets bit 2 (Write Interrupt Enable) of PIU2
                                        ; [04] - Resets bit 2 (Read Interrupt Enable) of PIU2
                                        ; [09] - Sets bit 4 (Read Interrupt Enable) of PIU2
                                        ; [08] - Resets bit 4 (Read Interrupt Enable) of PIU2
;
; +-------------------------------------------------------------------------+
; |      This file was generated by The Interactive Disassembler (IDA)      |
; |           Copyright (c) 2019 Hex-Rays, <support@hex-rays.com>           |
; |                      License info: 48-3055-7374-0A                      |
; |                     Loris Chiocca, Personal license                     |
; +-------------------------------------------------------------------------+
;
; Input SHA256 : 5CD6E9DA9910C7E624C91F23E6964B752634C05E76540BCA329DB5E5CD068EC3
; Input MD5    : BA0021C4CF30F3C63ABC4370C79934EB
; Input CRC32  : 28C58A4F

; ---------------------------------------------------------------------------
; File Name   : I:\My Drive\IMF\Originals\IMF.BIN
; Format      : Binary file
; Base Address: 0000h Range: 0000h - 8000h Loaded length: 8000h


See also:
http://openmsx.org/doxygen/YM2151_8cc_source.html
https://github.com/masl123/YM2151-Arduino-Software/blob/master/src/YM2151.cpp

; Processor       : z80 []
; Target assembler: Zilog Macro Assembler

; ===========================================================================

; Segment type: Pure code
                segment ROM

loc_0:
                di
                jp      START
; ---------------------------------------------------------------------------
                db [ 4 ], 0FFh

; =============== S U B R O U T I N E =======================================


add_hl_a:                               ; CODE XREF: getActiveInstrumentParameters+4↓p
                                        ; getYmChannelData+4↓p ...
                add     a, l
                ld      l, a
                ret     nc
                inc     h
                ret
; End of function add_hl_a

; ---------------------------------------------------------------------------
byte_D:         db [ 2Bh ], 0FFh
                db 0C3h, 0FCh, 0FFh
CARD_NAME:      .ascii 'YAMAHA IBM MUSIC'
                                        ; DATA XREF: initConfigurationMemory↓o
                                        ; initConfigurationMemory+3D↓o ...
CARD_REV:       .ascii 'rel. M102.00.010'
                                        ; DATA XREF: processSysExCmd_NodeDumpRequestMessage_MusicCardRevision+33↓o
                db [ 0Bh ], 0FFh
                dw 45EDh

; =============== S U B R O U T I N E =======================================


jmpStopMusicProcessing:                 ; CODE XREF: atomicTableLookupCall_wrapped_musicProcessing+12↓p
                                        ; proc_1393_called_for_Reboot+3B↓j ...
                jp      stopMusicProcessing
; End of function jmpStopMusicProcessing


; =============== S U B R O U T I N E =======================================


jmpStartMusicProcessing:                ; CODE XREF: atomicTableLookupCall_wrapped_musicProcessing+5↓p
                                        ; SOFT_REBOOT+D↓p ...
                jp      startMusicProcessing
; End of function jmpStartMusicProcessing


; =============== S U B R O U T I N E =======================================

; c = MidiCmdByte / d = MidiDataByte 0 / e = MidiDataByte 1 / iy=ptr to InstrumentParameters

ym2151_JumpToExecuteMidiCommand:        ; CODE XREF: SoundProcessor_executeMidiCommand+53↓p
                jp      ym2151_executeMidiCommand
; End of function ym2151_JumpToExecuteMidiCommand


; =============== S U B R O U T I N E =======================================


JumpToHL:                               ; CODE XREF: atomicTableLookupCall_wrapped_musicProcessing+F↓p
                                        ; midiDataDispatcher_transitionToNewState+13↓p ...
                jp      (hl)
; End of function JumpToHL


; =============== S U B R O U T I N E =======================================

; a=InstrumentParameters nr -> hl = ptr to InstrumentParameters

getActiveInstrumentParameters:          ; CODE XREF: SOFT_REBOOT+19↓p
                                        ; initAllMemoryBuffers+16↓p ...
                add     a, a
                ld      hl, instrumentParameterLookup
                add     hl, a
                ld      a, (hl)
                inc     hl
                ld      h, (hl)
                ld      l, a
                ret
; ---------------------------------------------------------------------------
instrumentParameterLookup:dw activeInstrumentParameters,activeInstrumentParameters.instrumentConfiguration.numberOfNotes+80h,activeInstrumentParameters.instrumentConfiguration.numberOfNotes+100h,activeInstrumentParameters.instrumentConfiguration.numberOfNotes+180h,activeInstrumentParameters.instrumentConfiguration.numberOfNotes+200h,activeInstrumentParameters.instrumentConfiguration.numberOfNotes+280h,activeInstrumentParameters.instrumentConfiguration.numberOfNotes+300h,activeInstrumentParameters.instrumentConfiguration.numberOfNotes+380h
                                        ; DATA XREF: getActiveInstrumentParameters+1↑o
; End of function getActiveInstrumentParameters


; =============== S U B R O U T I N E =======================================

; a=memory partition -> hl = memory location ptr

getYmChannelData:                       ; CODE XREF: initAllMemoryBuffers+2D↓p
                                        ; sub_1405+19↓p ...
                add     a, a
                ld      hl, memoryLocationLookup
                add     hl, a
                ld      a, (hl)
                inc     hl
                ld      h, (hl)
                ld      l, a
                ret
; ---------------------------------------------------------------------------
memoryLocationLookup:dw strangeMemory.channel0_ptrInstrumentParameters,strangeMemory.channel1_ptrInstrumentParameters,strangeMemory.channel2_ptrInstrumentParameters,strangeMemory.channel3_ptrInstrumentParameters,strangeMemory.channel4_ptrInstrumentParameters,strangeMemory.channel5_ptrInstrumentParameters,strangeMemory.channel6_ptrInstrumentParameters,strangeMemory.channel7_ptrInstrumentParameters
                                        ; DATA XREF: getYmChannelData+1↑o
; End of function getYmChannelData


; =============== S U B R O U T I N E =======================================

; c = register / a = value

sendToYM2151_no_interrupts_allowed:     ; CODE XREF: sub_1405+36↓p
                                        ; setNodeParameterLFOSpeed+7↓p ...
                call    sendToYM2151_with_disabled_interrupts
                ei
                ret
; End of function sendToYM2151_no_interrupts_allowed


; =============== S U B R O U T I N E =======================================

; c = register/ a = value

sendToYM2151_with_disabled_interrupts:  ; CODE XREF: sendToYM2151_no_interrupts_allowed↑p
                                        ; reset_ym2151:loc_C45↓p ...
                di
                push    af
                ld      a, c
                out     (YA2151_PORT_1), a
                pop     af
                nop
                out     (YA2151_PORT_2), a
                ex      (sp), hl        ; delay
                ex      (sp), hl        ; delay
                ret
; End of function sendToYM2151_with_disabled_interrupts


; =============== S U B R O U T I N E =======================================

; iy = ptrInstrumentParameters / a = instrNr -> hl=pointer to instrument

getVoiceDefinitionOfSameBank:           ; CODE XREF: setInstrumentParameter_VoiceNumber+F↓p
                push    de
                push    af
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.voiceBankNumber)
                call    getVoiceDefinitionBank
                pop     af
                call    getVoiceDefinitionFromBank
                pop     de
                ret
; End of function getVoiceDefinitionOfSameBank


; =============== S U B R O U T I N E =======================================

; a = 0x00..0x30 instrument nr in CustomBankA, 0x31..0x5F instrument nr in CustomBankB -> hl=pointer to VoiceDefinition

getCustomVoiceDefinition:               ; CODE XREF: storeInstrumentParametersToCustomBank+4↓p
                push    de
                ld      hl, voiceDefinitionBankCustom1
                cp      30h ; '0'
                jr      c, loc_D2       ; if (a < 0x30) jp loc_D2
                sub     30h ; '0'
                ld      hl, voiceDefinitionBankCustom2

loc_D2:                                 ; CODE XREF: getCustomVoiceDefinition+6↑j
                call    getVoiceDefinitionFromBank
                pop     de
                ret
; End of function getCustomVoiceDefinition


; =============== S U B R O U T I N E =======================================

; hl = &VoiceDefinitionBank / a = instrNr -> hl=pointer to VoiceDefinition

getVoiceDefinitionFromBank:             ; CODE XREF: getVoiceDefinitionOfSameBank+9↑p
                                        ; getCustomVoiceDefinition:loc_D2↑p
                ld      de, 20h ; ' '
                add     hl, de          ; hl = bank.instrumentDefinitions
                ex      de, hl          ; de = bank.instrumentDefinitions
                ld      l, a
                ld      h, 0            ; hl = a
                add     hl, hl          ; hl = a*2
                add     hl, hl          ; hl = a*4
                add     hl, hl          ; hl = a*8
                add     hl, hl          ; hl = a*16
                add     hl, hl          ; hl = a*32
                add     hl, hl          ; hl = a*64
                add     hl, de          ; hl = a*64 + bank.instrumentDefinitions
                ret
; End of function getVoiceDefinitionFromBank


; =============== S U B R O U T I N E =======================================

; a = bankNr -> hl=pointer to voice definition bank

getVoiceDefinitionBank:                 ; CODE XREF: getVoiceDefinitionOfSameBank+5↑p
                                        ; processSysExCmd_NodeMessage_SetVoiceBankData:loc_2A8E↓p ...
                add     a, a

loc_E8:
                ld      hl, voiceDefinitionBankTable
                add     hl, a
                ld      a, (hl)
                inc     hl
                ld      h, (hl)
                ld      l, a
                ret
; ---------------------------------------------------------------------------
voiceDefinitionBankTable:dw voiceDefinitionBankCustom1
                                        ; DATA XREF: getVoiceDefinitionBank:loc_E8↑o
                dw voiceDefinitionBankCustom2
                dw VoiceDefinitionBankRom1
                dw VoiceDefinitionBankRom2
                dw VoiceDefinitionBankRom3
                dw VoiceDefinitionBankRom4
                dw VoiceDefinitionBankRom5
; End of function getVoiceDefinitionBank


; =============== S U B R O U T I N E =======================================

; a = configNr -> hl = pointer to config

getConfigurationData:                   ; CODE XREF: storeActiveConfigurationToCustomConfiguration+1F↓p
                                        ; setNodeParameterActiveConfigurationNr+7↓p ...
                push    de
                ld      hl, configurationRAM
                cp      10h
                jr      c, loc_10E      ; if (a < 0x10) jp loc_10E
                sub     10h
                ld      hl, ROMPresetConfiguration16

loc_10E:                                ; CODE XREF: getConfigurationData+6↑j
                push    hl
                ld      l, a
                ld      h, 0
                add     hl, hl
                add     hl, hl
                add     hl, hl
                add     hl, hl
                add     hl, hl
                ld      d, h
                ld      e, l
                add     hl, hl
                add     hl, hl
                add     hl, de
                pop     de
                add     hl, de
                pop     de
                ret
; End of function getConfigurationData


; =============== S U B R O U T I N E =======================================

; a=idx / hl=pointer

atomicTableLookupCall_wrapped_musicProcessing:
                                        ; CODE XREF: setNodeParameter+6↓j
                                        ; setInstrumentParameter+A↓j ...
                push    ix
                push    iy
                push    af
                call    jmpStartMusicProcessing
                pop     af
                add     a, a
                add     hl, a
                ld      a, (hl)
                inc     hl
                ld      h, (hl)
                ld      l, a
                call    (hl)
                call    jmpStopMusicProcessing
                pop     iy
                pop     ix
                ret
; End of function atomicTableLookupCall_wrapped_musicProcessing


; =============== S U B R O U T I N E =======================================

; jumptable 0000019E cases 15,24-31
; jumptable 00000141 cases 14-31,38,39

noOperation:                            ; CODE XREF: setNodeParameter+6↓j
                                        ; setInstrumentParameter+A↓j
                                        ; DATA XREF: ...
                ret
; End of function noOperation


; =============== S U B R O U T I N E =======================================

; a=idx 0..39 / c=value

setNodeParameter:                       ; CODE XREF: SOFT_REBOOT+3A↓p
                                        ; processMusicCardMessageSetPaths+35↓p ...
                cp      40
                ret     nc              ; if (a >= 0x28) ret
                ld      hl, nodeParameterMethods
                jp      atomicTableLookupCall_wrapped_musicProcessing ; switch 40 cases
; ---------------------------------------------------------------------------
nodeParameterMethods:dw setNodeParameterName0
                                        ; DATA XREF: setNodeParameter+3↑o
                dw setNodeParameterName1 ; jump table for switch statement
                dw setNodeParameterName2
                dw setNodeParameterName3
                dw setNodeParameterName4
                dw setNodeParameterName5
                dw setNodeParameterName6
                dw setNodeParameterName7
                dw setNodeParameterCombineMode
                dw setNodeParameterLFOSpeed
                dw setNodeParameterAmpModDepth
                dw setNodeParameterPitchModDepth
                dw setNodeParameterLFOWaveForm
                dw setNodeParameterNoteNrReceptionMode
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw setNodeParameterNodeNumber
                dw setNodeParameterMemoryProtection
                dw setNodeParameterActiveConfigurationNr
                dw setNodeParameterMasterTune
                dw setNodeParameterMasterOutputLevel
                dw setNodeParameterChainMode
                dw noOperation
                dw noOperation
; End of function setNodeParameter


; =============== S U B R O U T I N E =======================================

; a=paramNr (0x00-0x1F, 0x40-??) / c=value / iy=ptr to InstrumentParameters

setInstrumentParameter:                 ; CODE XREF: setInstrumentParameter_ForceRefreshOfParam_00_05+5↓p
                                        ; setInstrumentParameter_ForceRefreshOfParam_00_05+D↓p ...
                cp      40h ; '@'
                jr      nc, loc_1A1     ; if (a >= 0x40) jp loc_1A1
                cp      20h ; ' '
                ret     nc              ; if (a >= 0x20) ret
                ld      hl, setInstrumentConfigurationLookup
                jp      atomicTableLookupCall_wrapped_musicProcessing ; switch 32 cases
; ---------------------------------------------------------------------------

loc_1A1:                                ; CODE XREF: setInstrumentParameter+2↑j
                sub     40h ; '@'
                ld      b, a
                ld      hl, setVoiceDefinitionLookup
                ld      a, 0
                jp      atomicTableLookupCall_wrapped_musicProcessing
; ---------------------------------------------------------------------------
setInstrumentConfigurationLookup:dw setInstrumentParameter_NumberOfNotes
                                        ; DATA XREF: setInstrumentParameter+7↑o
                dw setInstrumentParameter_MidiChannelNumber ; jump table for switch statement
                dw setInstrumentParameter_NoteNumberLimitHigh
                dw setInstrumentParameter_NoteNumberLimitLow
                dw setInstrumentParameter_VoiceBankNumber
                dw setInstrumentParameter_VoiceNumber
                dw setInstrumentParameter_Detune
                dw setInstrumentParameter_OctaveTranspose
                dw setInstrumentParameter_OutputLevel
                dw setInstrumentParameter_Pan
                dw setInstrumentParameter_LFOEnable
                dw setInstrumentParameter_PortamentoTime
                dw setInstrumentParameter_PitchbenderRange
                dw setInstrumentParameter_MonoPolyMode
                dw setInstrumentParameter_PMDController
                dw noOperation
                dw setInstrumentParameter_LFOSpeed
                dw setInstrumentParameter_AmplitudeModulationDepth
                dw setInstrumentParameter_PitchModulationDepth
                dw setInstrumentParameter_LFOWaveform
                dw setInstrumentParameter_LFOLoadEnable
                dw setInstrumentParameter_LFOSync
                dw setInstrumentParameter_AmplitudeModulationSensitivity
                dw setInstrumentParameter_PitchModulationSensitivity
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation
                dw noOperation          ; jumptable 0000019E cases 15,24-31
                                        ; jumptable 00000141 cases 14-31,38,39
                dw noOperation          ; jumptable 0000019E cases 15,24-31
                                        ; jumptable 00000141 cases 14-31,38,39
                dw noOperation          ; jumptable 0000019E cases 15,24-31
                                        ; jumptable 00000141 cases 14-31,38,39
                dw noOperation          ; jumptable 0000019E cases 15,24-31
                                        ; jumptable 00000141 cases 14-31,38,39
setVoiceDefinitionLookup:               ; DATA XREF: setInstrumentParameter+10↑o
                dw setInstrumentParameter_VoiceDefinition
; End of function setInstrumentParameter


; =============== S U B R O U T I N E =======================================

; Attributes: noreturn

START:                                  ; CODE XREF: ROM:0001↑j
                di
                ld      a, 0AAh

check_mem_0x8000:                       ; CODE XREF: START+8↓j
                                        ; START+F↓j
                ld      hl, byte_8000
                ld      (hl), a
                cp      (hl)
                jr      nz, check_mem_0x8000 ; if (a != (hl)) jp check_mem_0x8000
                ld      hl, 0BFFFh
                ld      (hl), a
                cp      (hl)
                jr      nz, check_mem_0x8000 ; if (a != (hl)) jp check_mem_0x8000
                im      1
                ld      sp, 0FFFCh
                call    reset_PIU_device
; End of function START


; =============== S U B R O U T I N E =======================================


HARD_REBOOT:                            ; CODE XREF: processMusicCardMessageReboot+1↓j
                                        ; processMusicCardMessageDebugWriteToMemory_readByte2+5↓j ...
                di
                ld      sp, 0FFFCh
                xor     a
                ld      (copyOfCardName), a
                call    initAllMemoryBuffers
                ld      a, 0
                ld      (memoryProtection), a
                ld      a, 0E5h
                jr      SOFT_REBOOT
; End of function HARD_REBOOT


; =============== S U B R O U T I N E =======================================


RESTART_IN_MUSIC_MODE:                  ; CODE XREF: processMusicCardMessageSelectCardMode+A↓j
                ld      a, 0E0h
; End of function RESTART_IN_MUSIC_MODE


; =============== S U B R O U T I N E =======================================


SOFT_REBOOT:                            ; CODE XREF: HARD_REBOOT+12↑j
                di
                ld      sp, 0FFFCh
                push    af
                ld      a, 0
                ld      (cardMode), a
                call    initInterruptHandler
                call    jmpStartMusicProcessing
---
                ld      b, 8
                ld      c, 0
                ld      de, activeConfiguration.instrumentConfigurations

loc_23C:                                ; CODE XREF: SOFT_REBOOT+23↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                ld      bc, 10h
                ldir
                pop     bc
                inc     c
                djnz    loc_23C
                pop     af
---
                push    af
                cp      0E5h
                push    af
                call    nz, proc_13EB_called_for_SelectMusicCardMode
                pop     af
                call    z, proc_1393_called_for_Reboot
                call    processSystemRealTimeMessage_FC
                ld      a, (chainMode)
                ld      c, a
                ld      a, 25h ; '%'
                call    setNodeParameter
                call    logErrorOrSuccess
                call    clearIncomingMusicCardMessageBuffer
                call    set_MidiIn_To_SP_InitialState
                call    set_System_To_SP_InitialState
                call    initialize_ym2151_timers
                pop     af
                ld      (outgoingMusicCardMessageData), a
                ld      b, 1
                ld      hl, outgoingMusicCardMessageData
                call    send_card_bytes_to_System

loc_27D:                                ; CODE XREF: SOFT_REBOOT+61↓j
                call    MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch
                call    MUSIC_MODE_LOOP_read_System_And_Dispatch
                call    logErrorOrSuccess
                jr      loc_27D
; End of function SOFT_REBOOT


; =============== S U B R O U T I N E =======================================


RESTART_IN_THRU_MODE:                   ; CODE XREF: processMusicCardMessageSelectCardMode+D↓j
                di
                ld      sp, 0FFFCh
                ld      a, 1
                ld      (cardMode), a
                call    initInterruptHandler
                call    jmpStartMusicProcessing
                call    ym_key_off_on_all_channels
                call    clearIncomingMusicCardMessageBuffer
                call    initialize_ym2151_timers
                ld      a, 0E0h
                ld      (outgoingMusicCardMessageData), a
                ld      b, 1
                ld      hl, outgoingMusicCardMessageData
                call    send_card_bytes_to_System

loc_2AD:                                ; CODE XREF: RESTART_IN_THRU_MODE+32↓j
                                        ; RESTART_IN_THRU_MODE+3C↓j ...
                call    midiIn_readMidiDataByte
                jr      c, loc_2CB
                jr      z, loc_2B7
                call    send_midi_byte_to_System_in_THRU_mode

loc_2B7:                                ; CODE XREF: RESTART_IN_THRU_MODE+2A↑j
                call    system_read9BitMidiDataByte
                jr      z, loc_2AD
                jr      c, loc_2C6
                call    send_midi_byte_to_MidiOut
                call    clearIncomingMusicCardMessageBuffer
                jr      loc_2AD
; ---------------------------------------------------------------------------

loc_2C6:                                ; CODE XREF: RESTART_IN_THRU_MODE+34↑j
                call    processIncomingMusicCardMessageByte
                jr      loc_2AD
; ---------------------------------------------------------------------------

loc_2CB:                                ; CODE XREF: RESTART_IN_THRU_MODE+28↑j
                di
                call    resetMidiInBuffersAndPorts
                ei
                jr      loc_2AD
; End of function RESTART_IN_THRU_MODE


; =============== S U B R O U T I N E =======================================


initAllMemoryBuffers:                   ; CODE XREF: HARD_REBOOT+8↑p
                call    initConfigurationMemory
                ld      hl, bufferFromMidiIn
                ld      de,  bufferFromMidiIn+1
                ld      bc, 16FBh
                ld      (hl), 0
                ldir                    ; Clear memory from 0xE800 to 0xFEFA (?)
---
                ld      b, 8
                ld      c, 0

loc_2E6:                                ; CODE XREF: initAllMemoryBuffers+26↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                ld      bc, 10h
                add     hl, bc
                ld      e, l
                ld      d, h
                inc     de
                ld      (hl), 0
                ldir
                pop     bc
                inc     c
                djnz    loc_2E6
---
                ld      b, 8
                ld      c, 0

loc_2FE:                                ; CODE XREF: initAllMemoryBuffers+37↓j
                ld      a, c
                call    getYmChannelData
                push    hl
                pop     ix
                ld      (ix+YmChannelData.channel0_to_ym_channel), c
                inc     c
                djnz    loc_2FE
---
                ld      a, 0
                ld      (masterOutputLevel), a
                ld      a, 0
                ld      (cardMode), a
                ld      a, 0
                ld      (errorReport), a
                ld      a, 0
                ld      (configuredMidiFlowPath_MidiIn_To_System), a
                ld      a, 0
                ld      (configuredMidiFlowPath_System_To_MidiOut), a
                ld      a, 1Fh
                ld      (configuredMidiFlowPath_MidiIn_To_SP), a
                ld      a, 0
                ld      (configuredMidiFlowPath_System_To_SP), a
                ld      a, 0
                ld      (configuredMidiFlowPath_MidiIn_To_MidiOut), a
                ret
; End of function initAllMemoryBuffers


; =============== S U B R O U T I N E =======================================


initConfigurationMemory:                ; CODE XREF: initAllMemoryBuffers↑p
                ld      hl, CARD_NAME   ; "YAMAHA IBM MUSIC"
                ld      de, copyOfCardName
                ld      b, 12

loc_33C:                                ; CODE XREF: initConfigurationMemory+E↓j
                ld      a, (de)
                inc     de
                cp      (hl)
                jr      nz, loc_345     ; if (a != (hl)) jp loc_345
                inc     hl
                djnz    loc_33C
                ret
; ---------------------------------------------------------------------------

loc_345:                                ; CODE XREF: initConfigurationMemory+B↑j
                ld      hl, voiceDefinitionBankCustom1
                ld      de,  voiceDefinitionBankCustom1.name+1
                ld      bc, 273Fh
                ld      (hl), 0
                ldir
-------
                ld      ix, DefaultConfigurationSlotNameSuffix ; " 1 2 3 4 5 6 7 8 910111213141516"
                ld      de, configurationRAM
                ld      b, 10h

loc_35B:                                ; CODE XREF: initConfigurationMemory+2C↓j
                push    bc
                call    initConfigurationRAMSlot
                pop     bc
                djnz    loc_35B
-----
                ld      de, voiceDefinitionBankCustom1
                ld      hl, DefaultCustomInstrumentData1Name ; "user 1  "
                call    initCustomInstrumentData
                ld      hl, DefaultCustomInstrumentData2Name ; "user 2  "
                call    initCustomInstrumentData
-------
                ld      hl, CARD_NAME   ; "YAMAHA IBM MUSIC"
                ld      de, copyOfCardName
                ld      bc, 10h
                ldir
----
                ld      hl, ROMPresetConfiguration16
                ld      de, activeConfiguration
                ld      bc, 20h ; ' '
                ldir
-------
                ld      b, 8
                ld      c, 0

loc_38B:                                ; CODE XREF: initConfigurationMemory+67↓j
                push    bc
                push    hl
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     de
                pop     hl
                ld      bc, 10h
                ldir
                pop     bc
                inc     c
                djnz    loc_38B
------
                ld      a, 0
                ld      (nodeNumber), a
                ld      a, 10h
                ld      (activeConfigurationNr), a
                ld      a, 0
                ld      (chainMode), a
                ret
; End of function initConfigurationMemory


; =============== S U B R O U T I N E =======================================

; de=memory to init / ix=pointer to two characters (" 1" to "16")

initConfigurationRAMSlot:               ; CODE XREF: initConfigurationMemory+28↑p
                ld      hl, DefaultConfigurationSlotNamePrefix ; " user "
                ld      bc, 6
                ldir
----
                ld      a, (ix+0)
                ld      (de), a
                inc     de
                inc     ix
                ld      a, (ix+0)
                ld      (de), a
                inc     de
                inc     ix
                ld      hl, ROMPresetConfiguration16.combineMode
                ld      bc, 98h
                ldir
                ret
; ---------------------------------------------------------------------------
DefaultConfigurationSlotNamePrefix:.ascii ' user '
                                        ; DATA XREF: initConfigurationRAMSlot↑o
DefaultConfigurationSlotNameSuffix:.ascii ' 1 2 3 4 5 6 7 8 910111213141516'
                                        ; DATA XREF: initConfigurationMemory+1E↑o
; End of function initConfigurationRAMSlot


; =============== S U B R O U T I N E =======================================

; hl=pointer to 8 charaters (e.g. "user 1  ") / de=memory to be initialized

initCustomInstrumentData:               ; CODE XREF: initConfigurationMemory+34↑p
                                        ; initConfigurationMemory+3A↑p
                ld      bc, 8
                ldir
                ld      hl, VoiceDefinitionBankRom1.reserved
                ld      bc, 0C18h
                ldir
                ret
; End of function initCustomInstrumentData

; ---------------------------------------------------------------------------
DefaultCustomInstrumentData1Name:.ascii 'user 1  '
                                        ; DATA XREF: initConfigurationMemory+31↑o
DefaultCustomInstrumentData2Name:.ascii 'user 2  '
                                        ; DATA XREF: initConfigurationMemory+37↑o

; =============== S U B R O U T I N E =======================================

; void -> output into a-reg / c-flag=error / z-flag=has data

readMidiData:                           ; CODE XREF: MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch:loop↓p
                                        ; MUSIC_MODE_LOOP_read_System_And_Dispatch:loop↓p ...
                push    hl
                push    de
                push    bc
                push    ix
                push    iy
                call    readMidiDataWithTimeout
                pop     iy
                pop     ix
                pop     bc
                pop     de
                pop     hl
                ret
; End of function readMidiData


; =============== S U B R O U T I N E =======================================

; void -> output into a-reg / c-flag=error / z-flag=has data

readMidiDataWithTimeout:                ; CODE XREF: readMidiData+7↑p
                ld      a, 0FFh
                ld      (readMidiDataTimeoutCountdown), a ; readMidiDataTimeoutCountdown = 0xFF
---
                ld      a, (midi_ReceiveSource_SendTarget)
                bit     1, a
                jp      nz, readMidiData_from_system ; if (bit 1 of a != 0) jp loc_4B2
readMidiData_from_MidiIn
                ld      ix, midiDataPacketFromMidiIn

loc_433:                                ; CODE XREF: readMidiDataWithTimeout+21↓j
                                        ; readMidiDataWithTimeout+2B↓j ...
                call    midiIn_readMidiDataByte
                ld      c, a            ; c = midi data byte
                jr      c, midiReadError
                jr      nz, midi_data_available
no midi data
                call    isMidiDataPacket_in_state_01_36_37_38
                jr      nz, noMidiData
                call    hasReadMidiDataTimeoutExpired
                jr      nz, loc_433
                jr      readMidiData_timed_out
; ---------------------------------------------------------------------------

midi_data_available:                    ; CODE XREF: readMidiDataWithTimeout+17↑j
                cp      0F8h
                jr      c, midiIn_MidiDataDispatcher_00_to_F7 ; if (a < 0xf8) jp midiIn_MidiDataDispatcher_00_to_F7
                cp      0F9h
                jr      z, loc_433      ; if (a == 0xf9) jp loc_433
                cp      0FDh
                jr      nc, loc_433     ; if (a >= 0xfd) jp loc_433
                ld      hl, actualMidiFlowPath_MidiIn_To_MidiOut
                bit     4, (hl)
                call    nz, send_midi_byte_to_MidiOut ; if (bit 4 of (hl) != 0) call send_midi_byte_to_MidiOut
                ld      a, c
                ld      hl, actualMidiFlowPath_MidiIn_To_System
                bit     4, (hl)
                call    nz, send_midi_byte_to_System ; if (bit 4 of (hl) != 0) call send_midi_byte_to_System
                ld      a, c
                ld      hl, actualMidiFlowPath_MidiIn_To_SP
                bit     4, (hl)
                call    nz, processSystemRealTimeMessage ; if (bit 4 of (hl) != 0) call processSystemRealTimeMessage
                jr      loc_433
; ---------------------------------------------------------------------------

midiIn_MidiDataDispatcher_00_to_F7:     ; CODE XREF: readMidiDataWithTimeout+27↑j
                                        ; readMidiDataWithTimeout+8B↓p
                call    midiDataDispatcher_transitionToNewState
                ld      a, (actualMidiFlowPath_MidiIn_To_MidiOut)
                ld      b, a
                call    conditional_send_midi_byte_to_MidiOut
                ld      a, (actualMidiFlowPath_MidiIn_To_System)
                ld      b, a
                call    conditional_send_midi_byte_to_System
                or      0FFh
                ld      a, c
                ret
; ---------------------------------------------------------------------------

noMidiData:                             ; CODE XREF: readMidiDataWithTimeout+1C↑j
                                        ; readMidiDataWithTimeout+9E↓j
                xor     a
                ret
; ---------------------------------------------------------------------------

readMidiData_timed_out:                 ; CODE XREF: readMidiDataWithTimeout+23↑j
                ld      a, 0F4h
                call    reportErrorIfNeeded

midiReadError:                          ; CODE XREF: readMidiDataWithTimeout+15↑j
                di
                call    resetMidiInBuffersAndPorts
                ei
---
                ld      a, (actualMidiFlowPath_MidiIn_To_MidiOut)
                and     1Fh
                call    nz, sendActiveSenseCodeSafe
---
                ld      a, (actualMidiFlowPath_MidiIn_To_SP)
                and     1Fh
                call    nz, ym_key_off_on_all_channels
---
                ld      a, (actualMidiFlowPath_MidiIn_To_SP)
                bit     4, a
                call    nz, processSystemRealTimeMessage_FC ; if (bit 4 of a != 0) call processSystemRealTimeMessage_FC
---
                call    set_MidiIn_To_SP_InitialState
                ld      c, 0F7h
                call    midiIn_MidiDataDispatcher_00_to_F7
                scf
                ret
; ---------------------------------------------------------------------------

readMidiData_from_system:               ; CODE XREF: readMidiDataWithTimeout+A↑j
                ld      ix, midiDataPacketFromSystem

loc_4B6:                                ; CODE XREF: readMidiDataWithTimeout+A3↓j
                                        ; readMidiDataWithTimeout+B1↓j ...
                call    system_isMidiDataAvailable
                jr      c, system_data_pending
                jr      nz, midi_data_pending
-- no data available
                call    isMidiDataPacket_in_state_01_36_37_38
                jr      nz, noMidiData
                call    hasReadMidiDataTimeoutExpired
                jr      nz, loc_4B6
                jr      sendTimeoutToSystem
; ---------------------------------------------------------------------------

midi_data_pending:                      ; CODE XREF: readMidiDataWithTimeout+99↑j
                call    system_read9BitMidiDataByte
                ld      c, a
                cp      0F8h
                jr      c, system_MidiDataDispatcher_00_to_F7 ; if (a < 0xf8) jp system_MidiDataDispatcher_00_to_F7
                cp      0F9h
                jr      z, loc_4B6      ; if (a == 0xf9) jp loc_4B6
                cp      0FDh
                jr      nc, loc_4B6     ; if (a >= 0xfd) jp loc_4B6
                ld      hl, actualMidiFlowPath_System_To_MidiOut
                bit     4, (hl)
                call    nz, send_midi_byte_to_MidiOut ; if (bit 4 of (hl) != 0) call send_midi_byte_to_MidiOut
                ld      a, c
                ld      hl, actualMidiFlowPath_System_To_SP
                bit     4, (hl)
                call    nz, processSystemRealTimeMessage ; if (bit 4 of (hl) != 0) call processSystemRealTimeMessage
                jr      loc_4B6
; ---------------------------------------------------------------------------

system_MidiDataDispatcher_00_to_F7:     ; CODE XREF: readMidiDataWithTimeout+AD↑j
                                        ; readMidiDataWithTimeout+FD↓p
                call    clearIncomingMusicCardMessageBuffer

loc_4EF:                                ; CODE XREF: readMidiDataWithTimeout+107↓p
                call    midiDataDispatcher_transitionToNewState
                ld      a, (actualMidiFlowPath_System_To_MidiOut)
                ld      b, a
                call    conditional_send_midi_byte_to_MidiOut
                or      0FFh
                ld      a, c
                ret
; ---------------------------------------------------------------------------

sendTimeoutToSystem:                    ; CODE XREF: readMidiDataWithTimeout+A5↑j
                ld      a, 0F5h
                call    reportErrorIfNeeded
---
                ld      a, (actualMidiFlowPath_System_To_MidiOut)
                and     1Fh
                call    nz, sendActiveSenseCodeSafe
---
                ld      a, (actualMidiFlowPath_System_To_SP)
                and     1Fh
                call    nz, ym_key_off_on_all_channels
---
                ld      a, (actualMidiFlowPath_System_To_SP)
                bit     4, a
                call    nz, processSystemRealTimeMessage_FC ; if (bit 4 of a != 0) call processSystemRealTimeMessage_FC
                call    set_System_To_SP_InitialState
                ld      c, 0F7h         ; 0xF7 = End-of-command
                call    system_MidiDataDispatcher_00_to_F7
                scf
                ret
; ---------------------------------------------------------------------------

system_data_pending:                    ; CODE XREF: readMidiDataWithTimeout+97↑j
                call    set_System_To_SP_InitialState
                ld      c, 0F7h         ; 0xF7 = End-of-command
                call    loc_4EF
                scf
                ret
; End of function readMidiDataWithTimeout


; =============== S U B R O U T I N E =======================================

; ix=pointer to MidiDataPacket -> z-flag

isMidiDataPacket_in_state_01_36_37_38:  ; CODE XREF: readMidiDataWithTimeout+19↑p
                                        ; readMidiDataWithTimeout+9B↑p
                ld      a, (ix+MidiDataPacket.state)
                cp      1
                ret     z               ; if (a == 0x01) ret
                cp      36h ; '6'
                ret     z               ; if (a == 0x36) ret
                cp      37h ; '7'
                ret     z               ; if (a == 0x37) ret
                cp      38h ; '8'

ignoreSystemRealTimeMessage:            ; CODE XREF: processSystemRealTimeMessage+6↓j
                                        ; DATA XREF: processSystemRealTimeMessage:jpt_548↓o
                ret                     ; jumptable 00000548 cases 1,5-7
; End of function isMidiDataPacket_in_state_01_36_37_38


; =============== S U B R O U T I N E =======================================


hasReadMidiDataTimeoutExpired:          ; CODE XREF: readMidiDataWithTimeout+1E↑p
                                        ; readMidiDataWithTimeout+A0↑p
                ld      a, (readMidiDataTimeoutCountdown)
                and     a
                ret
; End of function hasReadMidiDataTimeoutExpired


; =============== S U B R O U T I N E =======================================

; c=RealTimeMessage midi code (F8-FF)

processSystemRealTimeMessage:           ; CODE XREF: readMidiDataWithTimeout+48↑p
                                        ; readMidiDataWithTimeout+C5↑p
                ld      a, c
                sub     0F8h
                ld      hl, jpt_548
                jp      atomicTableLookupCall_wrapped_musicProcessing ; switch 8 cases
; ---------------------------------------------------------------------------
jpt_548:        dw processSystemRealTimeMessage_F8
                                        ; DATA XREF: processSystemRealTimeMessage+3↑o
                dw ignoreSystemRealTimeMessage ; jump table for switch statement
                dw processSystemRealTimeMessage_FA_and_FB
                dw processSystemRealTimeMessage_FA_and_FB
                dw processSystemRealTimeMessage_FC
                dw ignoreSystemRealTimeMessage
                dw ignoreSystemRealTimeMessage
                dw ignoreSystemRealTimeMessage
; End of function processSystemRealTimeMessage


; =============== S U B R O U T I N E =======================================


decreaseReadMidiDataTimeout:            ; CODE XREF: process_ya2151_interrupts_callInInterruptHandler+1A↓p
                ld      a, (readMidiDataTimeoutCountdown)
                and     a
                ret     z
                dec     a
                ld      (readMidiDataTimeoutCountdown), a
                ret
; End of function decreaseReadMidiDataTimeout


; =============== S U B R O U T I N E =======================================

; a = byte to send -> c-flag for errors

send_midi_byte:                         ; CODE XREF: processSysExCmd_F0_43_2n_0C+E↓p
                                        ; processSysExCmd_F0_43_2n_0C+15↓p ...
                push    hl
                ld      hl, midi_ReceiveSource_SendTarget
                bit     0, (hl)
                jr      nz, sendToSystem ; if (bit 0 of (hl) != 0) jmp loc_578
-- send to midi out
                ld      hl, actualMidiFlowPath_MidiIn_To_SP
                bit     5, (hl)
                call    nz, send_midi_byte_to_MidiOut ; if (bit 5 of (hl) != 0) call send_midi_byte_to_MidiOut

loc_575:                                ; CODE XREF: send_midi_byte+18↓j
                pop     hl
                xor     a
                ret
; ---------------------------------------------------------------------------

sendToSystem:                           ; CODE XREF: send_midi_byte+6↑j
                ld      hl, actualMidiFlowPath_System_To_SP
                bit     5, (hl)
                jr      z, loc_575      ; if (bit 5 of (hl) == 0) jmp loc_575
                call    send_midi_byte_to_System
                pop     hl
                ret
; End of function send_midi_byte


; =============== S U B R O U T I N E =======================================


MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch:
                                        ; CODE XREF: SOFT_REBOOT:loc_27D↑p
                ld      a, 0
                ld      (midi_ReceiveSource_SendTarget), a ; read data from MIDI IN / send data to MIDI OUT

loop:                                   ; CODE XREF: MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch+1E↓j
                call    readMidiData
                jr      c, readError
                jr      z, no_data
we have received data
                ld      ix, midiDataPacketFromMidiIn
                ld      c, a
                ld      a, (actualMidiFlowPath_MidiIn_To_SP)
                ld      b, a
                call    conditional_send_midi_byte_to_SP

no_data:                                ; CODE XREF: MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch+A↑j
                ld      a, (midiDataPacketFromMidiIn.state)
                call    doesMidiDataPacketNeedAdditionalData_MUSIC_MODE
                jr      z, loop
                ret
; ---------------------------------------------------------------------------

readError:                              ; CODE XREF: MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch+8↑j
                and     60h ; '`'
                ret     z
                ld      hl, midi_error_message_2 ; "MIDI/error   !!!"
                jp      logErrorOrSuccess
; ---------------------------------------------------------------------------
midi_error_message_2:.ascii 'MIDI/error   !!!'
                                        ; DATA XREF: MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch+24↑o
; End of function MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch


; =============== S U B R O U T I N E =======================================


MUSIC_MODE_LOOP_read_System_And_Dispatch:
                                        ; CODE XREF: SOFT_REBOOT+5B↑p
                ld      a, 3
                ld      (midi_ReceiveSource_SendTarget), a ; read data from SYSTEM / send data to SYSTEM

loop:                                   ; CODE XREF: MUSIC_MODE_LOOP_read_System_And_Dispatch+1E↓j
                call    readMidiData
                jr      c, error
                jr      z, no_data
we have received data
                ld      ix, midiDataPacketFromSystem
                ld      c, a
                ld      a, (actualMidiFlowPath_System_To_SP)
                ld      b, a
                call    conditional_send_midi_byte_to_SP

no_data:                                ; CODE XREF: MUSIC_MODE_LOOP_read_System_And_Dispatch+A↑j
                ld      a, (midiDataPacketFromSystem.state)
                call    doesMidiDataPacketNeedAdditionalData_MUSIC_MODE
                jr      z, loop
                ret
; ---------------------------------------------------------------------------

error:                                  ; CODE XREF: MUSIC_MODE_LOOP_read_System_And_Dispatch+8↑j
                call    system_read9BitMidiDataByte
                ret     nc
                ret     z
                jp      processIncomingMusicCardMessageByte
; End of function MUSIC_MODE_LOOP_read_System_And_Dispatch


; =============== S U B R O U T I N E =======================================

; a=MidiDataPacket.midiState -> flags

doesMidiDataPacketNeedAdditionalData_MUSIC_MODE:
                                        ; CODE XREF: MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch+1B↑p
                                        ; MUSIC_MODE_LOOP_read_System_And_Dispatch+1B↑p
                push    af
                call    send_F7_to_MidiOut_if_timed_out
                call    send_F7_to_System_if_timed_out
                pop     af
                cp      1
                ret     z               ; if (a == 0x01) return
                cp      36h ; '6'
                ret     z               ; if (a == 0x36) return
                cp      37h ; '7'
                ret     z               ; if (a == 0x37) return
                cp      38h ; '8'
                ret
; End of function doesMidiDataPacketNeedAdditionalData_MUSIC_MODE


; =============== S U B R O U T I N E =======================================

; void -> void

set_MidiIn_To_SP_InitialState:          ; CODE XREF: SOFT_REBOOT+43↑p
                                        ; readMidiDataWithTimeout+86↑p
                xor     a
                ld      (midiDataPacketFromMidiIn.state), a
                push    ix
                push    iy
                call    SoundProcessor_SetToInitialState
                pop     iy
                pop     ix
                ret
; End of function set_MidiIn_To_SP_InitialState


; =============== S U B R O U T I N E =======================================

; void -> void

set_System_To_SP_InitialState:          ; CODE XREF: SOFT_REBOOT+46↑p
                                        ; readMidiDataWithTimeout+F8↑p ...
                xor     a
                ld      (midiDataPacketFromSystem.state), a
                push    ix
                push    iy
                call    SoundProcessor_SetToInitialState
                pop     iy
                pop     ix
                ret
; End of function set_System_To_SP_InitialState


; =============== S U B R O U T I N E =======================================

; c=midi byte / ix=pointer to MidiDataPacket

midiDataDispatcher_transitionToNewState:
                                        ; CODE XREF: readMidiDataWithTimeout:midiIn_MidiDataDispatcher_00_to_F7↑p
                                        ; readMidiDataWithTimeout:loc_4EF↑p
                ld      a, c
                cp      80h
                jr      nc, startNewMidiCommand ; if (a >= 0x80) jmp loc_635
                ld      l, (ix+MidiDataPacket.state)
                ld      h, 0
                add     hl, hl
                ld      de, midiStateTransitionTable
                add     hl, de
                ld      e, (hl)
                inc     hl
                ld      d, (hl)
                ex      de, hl
                call    (hl)            ; switch 64 cases
                ld      (ix+MidiDataPacket.state), a
                ret
; ---------------------------------------------------------------------------

startNewMidiCommand:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+3↑j
                ld      (ix+MidiDataPacket.data), a
                call    convert_midi_command_byte_to_initial_state
                ld      (ix+MidiDataPacket.state), a
                ret
; End of function midiDataDispatcher_transitionToNewState


; =============== S U B R O U T I N E =======================================

; a=midi byte -> a=initial midi state

convert_midi_command_byte_to_initial_state:
                                        ; CODE XREF: midiDataDispatcher_transitionToNewState+1D↑p
                cp      0F0h
                jr      nc, midi_byte_is_0xF0_or_higher ; if (a >= 0xf0) jmp loc_647
                rrca
                rrca
                rrca
                rrca                    ; a = midi byte >> 4

midi_byte_is_0xF0_or_higher:            ; CODE XREF: convert_midi_command_byte_to_initial_state+2↑j
                and     0Fh
                ld      hl, initialMidiStateTable
                add     hl, a
                ld      a, (hl)
                ret
; End of function convert_midi_command_byte_to_initial_state

; ---------------------------------------------------------------------------
(16 bytes / high nibble for midi command bytes 0x80-0xEF / low nibble for 0xF0-FF)
initialMidiStateTable:db 15h            ; DATA XREF: convert_midi_command_byte_to_initial_state+A↑o
                db 12h
                db 0Fh
                db 12h
                db 0
                db 0
                db 14h
                db 40h
                db 2
                db 2
                db 5
                db 0Ah
                db 0Dh
                db 8
                db 5
                db 0
midiStateTransitionTable:dw processMidiState_00, processMidiState_01_36_37_38, processMidiState_02_04
                                        ; DATA XREF: midiDataDispatcher_transitionToNewState+B↑o
                dw processMidiState_03, processMidiState_02_04, processMidiState_05_07 ; jump table for switch statement
                dw processMidiState_06, processMidiState_05_07, processMidiState_08_09
                dw processMidiState_08_09, processMidiState_0A_0C, processMidiState_0B
                dw processMidiState_0A_0C, processMidiState_0D_0E, processMidiState_0D_0E
                dw processMidiState_0F, processMidiState_10, processMidiState_11
                dw processMidiState_12, processMidiState_13, processMidiState_14
                dw processMidiState_15, processMidiState_16, processMidiState_17
                dw processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35, processMidiState_19
                dw processMidiState_1A, processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35
                dw processMidiState_1C, processMidiState_1D, processMidiState_1E
                dw processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35, processMidiState_20
                dw processMidiState_21, processMidiState_22, processMidiState_23
                dw processMidiState_24, processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35
                dw processMidiState_26, processMidiState_27, processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35
                dw processMidiState_29, processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35
                dw processMidiState_2B, processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35
                dw processMidiState_2D, processMidiState_2E, processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35
                dw processMidiState_30, processMidiState_31, processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35
                dw processMidiState_33, processMidiState_34, processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35
                dw processMidiState_01_36_37_38, processMidiState_01_36_37_38
                dw processMidiState_01_36_37_38, processMidiState_39_3C_3F
                dw processMidiState_3A, processMidiState_3B, processMidiState_39_3C_3F
                dw processMidiState_3D, processMidiState_3E, processMidiState_39_3C_3F
                dw processMidiState_40

; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 0

processMidiState_00:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      a, MIDI_STATE_00
                ret
; End of function processMidiState_00


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E cases 1,54-56

processMidiState_01_36_37_38:           ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+MidiDataPacket.data), c
                ld      a, MIDI_STATE_01
                ret
; End of function processMidiState_01_36_37_38


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E cases 2,4

processMidiState_02_04:                 ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, MIDI_STATE_03
                ret
; End of function processMidiState_02_04


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 3

processMidiState_03:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_04
                ret
; End of function processMidiState_03


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E cases 5,7

processMidiState_05_07:                 ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, MIDI_STATE_06
                ret
; End of function processMidiState_05_07


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 6

processMidiState_06:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_07
                ret
; End of function processMidiState_06


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E cases 8,9

processMidiState_08_09:                 ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, MIDI_STATE_09
                ret
; End of function processMidiState_08_09


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E cases 10,12

processMidiState_0A_0C:                 ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, MIDI_STATE_0B
                ret
; End of function processMidiState_0A_0C


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 11

processMidiState_0B:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_0C
                ret
; End of function processMidiState_0B


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E cases 13,14

processMidiState_0D_0E:                 ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, MIDI_STATE_0E
                ret
; End of function processMidiState_0D_0E


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 15

processMidiState_0F:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, MIDI_STATE_10
                ret
; End of function processMidiState_0F


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 16

processMidiState_10:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_11
                ret
; End of function processMidiState_10


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 17

processMidiState_11:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      a, MIDI_STATE_00
                ret
; End of function processMidiState_11


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 18

processMidiState_12:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, MIDI_STATE_13
                ret
; End of function processMidiState_12


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 19

processMidiState_13:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      a, MIDI_STATE_00
                ret
; End of function processMidiState_13


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 20

processMidiState_14:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      a, MIDI_STATE_00
                ret
; End of function processMidiState_14


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 21

processMidiState_15:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, c
                cp      43h ; 'C'
                jr      nz, loc_742     ; if (a != 0x43) jmp loc_742
                ld      a, MIDI_STATE_16
                ret
; ---------------------------------------------------------------------------

loc_742:                                ; CODE XREF: processMidiState_15+6↑j
                ld      a, MIDI_STATE_36
                ret
; End of function processMidiState_15


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 22

processMidiState_16:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, c
                cp      75h ; 'u'
                jr      nz, loc_750     ; if (a != 0x75) jmp loc_750
                ld      a, MIDI_STATE_17
                ret
; ---------------------------------------------------------------------------

loc_750:                                ; CODE XREF: processMidiState_16+6↑j
                ld      a, MIDI_STATE_37
                ret
; End of function processMidiState_16


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 23

processMidiState_17:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, c
                cp      70h ; 'p'
                jr      z, value_0x70   ; if (a == 0x70) jmp loc_762
                cp      71h ; 'q'
                jr      z, value_0x71   ; if (a == 0x71) jmp loc_765
                ld      a, MIDI_STATE_38
                ret
; ---------------------------------------------------------------------------

value_0x70:                             ; CODE XREF: processMidiState_17+6↑j
                ld      a, MIDI_STATE_18
                ret
; ---------------------------------------------------------------------------

value_0x71:                             ; CODE XREF: processMidiState_17+A↑j
                ld      a, MIDI_STATE_39
                ret
; End of function processMidiState_17


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E cases 24,27,31,37,40,42,44,47,50,53

processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35:
                                        ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+MidiDataPacket.data), 0FFh
                ld      (ix+ MidiDataPacket.data+1 ), c
                ld      a, c
                rrca
                rrca
                rrca
                rrca
                and     7
                ld      hl, byte_77E
                add     hl, a
                ld      a, (hl)
                ret
; End of function processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35

; ---------------------------------------------------------------------------
byte_77E:       db MIDI_STATE_19,MIDI_STATE_1C,MIDI_STATE_20,MIDI_STATE_26,MIDI_STATE_29,MIDI_STATE_2B,MIDI_STATE_2D,MIDI_STATE_30
                                        ; DATA XREF: processMidiState_18_1B_1F_25_28_2A_2C_2F_32_35+E↑o

; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 25

processMidiState_19:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_1A
                ret
; End of function processMidiState_19


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 26

processMidiState_1A:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_1B
                ret
; End of function processMidiState_1A


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 28

processMidiState_1C:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_1D
                ret
; End of function processMidiState_1C


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 29

processMidiState_1D:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_1E
                ret
; End of function processMidiState_1D


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 30

processMidiState_1E:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+4 ), c
                ld      a, MIDI_STATE_1F
                ret
; End of function processMidiState_1E


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 32

processMidiState_20:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_21
                ret
; End of function processMidiState_20


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 33

processMidiState_21:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_22
                ret
; End of function processMidiState_21


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 34

processMidiState_22:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+4 ), c
                ld      a, MIDI_STATE_23
                ret
; End of function processMidiState_22


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 35

processMidiState_23:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+5 ), c
                ld      a, MIDI_STATE_24
                ret
; End of function processMidiState_23


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 36

processMidiState_24:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+6 ), c
                ld      a, MIDI_STATE_25
                ret
; End of function processMidiState_24


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 38

processMidiState_26:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_27
                ret
; End of function processMidiState_26


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 39

processMidiState_27:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_28
                ret
; End of function processMidiState_27


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 41

processMidiState_29:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_2A
                ret
; End of function processMidiState_29


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 43

processMidiState_2B:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_2C
                ret
; End of function processMidiState_2B


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 45

processMidiState_2D:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                ld      a, MIDI_STATE_2E
                ret
; End of function processMidiState_2D


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 46

processMidiState_2E:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_2F
                ret
; End of function processMidiState_2E


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 48

processMidiState_30:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                bit     6, c
                jr      nz, loc_7F0     ; if (bit 6 of c != 0) jmp loc_7F0
                ld      a, MIDI_STATE_31
                ret
; ---------------------------------------------------------------------------

loc_7F0:                                ; CODE XREF: processMidiState_30+5↑j
                ld      a, MIDI_STATE_33
                ret
; End of function processMidiState_30


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 49

processMidiState_31:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_32
                ret
; End of function processMidiState_31


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 51

processMidiState_33:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_34
                ret
; End of function processMidiState_33


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 52

processMidiState_34:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+4 ), c
                ld      a, MIDI_STATE_35
                ret
; End of function processMidiState_34


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E cases 57,60,63

processMidiState_39_3C_3F:              ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+MidiDataPacket.data), 0FEh
                ld      (ix+1), c
                ld      a, MIDI_STATE_3A
                ret
; End of function processMidiState_39_3C_3F


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 58

processMidiState_3A:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+2 ), c
                bit     6, c
                jr      nz, loc_819     ; if (bit 6 of c != 0) jmp loc_819
                ld      a, MIDI_STATE_3B
                ret
; ---------------------------------------------------------------------------

loc_819:                                ; CODE XREF: processMidiState_3A+5↑j
                ld      a, MIDI_STATE_3D
                ret
; End of function processMidiState_3A


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 59

processMidiState_3B:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_3C
                ret
; End of function processMidiState_3B


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 61

processMidiState_3D:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+3 ), c
                ld      a, MIDI_STATE_3E
                ret
; End of function processMidiState_3D


; =============== S U B R O U T I N E =======================================

; jumptable 0000062E case 62

processMidiState_3E:                    ; CODE XREF: midiDataDispatcher_transitionToNewState+13↑j
                                        ; DATA XREF: ROM:midiStateTransitionTable↑o
                ld      (ix+ MidiDataPacket.data+4 ), c
                ld      a, MIDI_STATE_3F
                ret
; End of function processMidiState_3E


; =============== S U B R O U T I N E =======================================

; c=midi byte / ix=pointer to MidiDataPacket -> newState

processMidiState_40:                    ; DATA XREF: ROM:06E1↑o
                ld      a, MIDI_STATE_00
                ret
; End of function processMidiState_40


; =============== S U B R O U T I N E =======================================

; b=MidiFlowPath / c=midiData / ix=pointer to MidiDataPacket

conditional_send_midi_byte_to_SP:       ; CODE XREF: MUSIC_MODE_LOOP_read_MidiIn_And_Dispatch+15↑p
                                        ; MUSIC_MODE_LOOP_read_System_And_Dispatch+15↑p
                push    bc
                ld      a, (ix+MidiDataPacket.state)
                add     a, a
                ld      hl, midiStateTerminationTable
                add     hl, a
                ld      a, (hl)
                inc     hl
                and     b
                jr      z, dont_do_anything
                ld      a, (hl)
                ld      b, a
                and     a
                jr      z, dont_do_anything
                push    ix
                pop     hl
                ld      a, (hl)
                cp      0FEh
                call    nc, soundProcessor_handle_midi_0xFE_0xFF ; if (a >= 0xfe) call soundProcessor_handle_midi_0xFE_0xFF

conditional_send_midi_byte_to_SP_loc1:  ; CODE XREF: conditional_send_midi_byte_to_SP+27↓j
                ld      a, (hl)
                inc     hl
                push    hl
                push    bc
                call    SoundProcessor_processMidiByte
                pop     bc
                pop     hl
                djnz    conditional_send_midi_byte_to_SP_loc1

dont_do_anything:                       ; CODE XREF: conditional_send_midi_byte_to_SP+E↑j
                                        ; conditional_send_midi_byte_to_SP+13↑j
                pop     bc
                ret
; End of function conditional_send_midi_byte_to_SP


; =============== S U B R O U T I N E =======================================


soundProcessor_handle_midi_0xFE_0xFF:   ; CODE XREF: conditional_send_midi_byte_to_SP+1B↑p
                jr      z, loc_863      ; if (a == 0xfe) jmp loc_863
                call    SoundProcessor_SetState_SysEx_EventListTransferToMusicCard
                jr      loc_866
; ---------------------------------------------------------------------------

loc_863:                                ; CODE XREF: soundProcessor_handle_midi_0xFE_0xFF↑j
                call    SoundProcessor_SetState_SysEx_ParameterListTransferToMusicCard

loc_866:                                ; CODE XREF: soundProcessor_handle_midi_0xFE_0xFF+5↑j
                inc     hl
                dec     b
                ret
; End of function soundProcessor_handle_midi_0xFE_0xFF


; =============== S U B R O U T I N E =======================================

; b=MidiFlowPath / ix=pointer to MidiDataPacket

conditional_send_midi_byte_to_MidiOut:  ; CODE XREF: readMidiDataWithTimeout+54↑p
                                        ; readMidiDataWithTimeout+D4↑p
                ld      a, (ix+MidiDataPacket.state)
                cp      1
                jr      z, loc_88A      ; if (a == 0x01) jmp loc_88A
                push    bc
                add     a, a
                ld      hl, midiStateTerminationTable
                add     hl, a
                ld      a, (hl)         ; a = stateTermination.flow
                inc     hl
                and     b
                jr      z, loc_888
                ld      a, (hl)
                ld      b, a
                and     a
                jr      z, loc_888
                push    ix
                pop     hl
                call    sendMidiResponse_to_MidiOut

loc_888:                                ; CODE XREF: conditional_send_midi_byte_to_MidiOut+12↑j
                                        ; conditional_send_midi_byte_to_MidiOut+17↑j
                pop     bc
                ret
; ---------------------------------------------------------------------------

loc_88A:                                ; CODE XREF: conditional_send_midi_byte_to_MidiOut+5↑j
                ld      a, 8
                and     b
                ret     z
                ld      a, (ix+MidiDataPacket.data)
                jp      send_midi_byte_to_MidiOut
; End of function conditional_send_midi_byte_to_MidiOut


; =============== S U B R O U T I N E =======================================

; b=MidiFlowPath / ix=pointer to MidiDataPacket

conditional_send_midi_byte_to_System:   ; CODE XREF: readMidiDataWithTimeout+5B↑p
                ld      a, (ix+MidiDataPacket.state)
                cp      1
                jr      z, loc_8B5      ; if (a == 0x01) jmp loc_8B5
                push    bc
                add     a, a
                ld      hl, midiStateTerminationTable
                add     hl, a
                ld      a, (hl)
                inc     hl
                and     b
                jr      z, loc_8B3
                ld      a, (hl)
                ld      b, a
                and     a
                jr      z, loc_8B3
                push    ix
                pop     hl
                call    sendMidiResponse_to_System

loc_8B3:                                ; CODE XREF: conditional_send_midi_byte_to_System+12↑j
                                        ; conditional_send_midi_byte_to_System+17↑j
                pop     bc
                ret
; ---------------------------------------------------------------------------

loc_8B5:                                ; CODE XREF: conditional_send_midi_byte_to_System+5↑j
                ld      a, 8
                and     b
                ret     z
                ld      a, (ix+MidiDataPacket.data)
                jp      send_midi_byte_to_System
; End of function conditional_send_midi_byte_to_System

; ---------------------------------------------------------------------------
(0x40 double byte entries / 1st byte is a flow mask, 2nd byte is number of bytes to process)
midiStateTerminationTable:db   0,  0,  8,  1,  0,  0,  0,  0,  1,  3,  0,  0,  0,  0,  2,  3,  0,  0,  2,  2,  0,  0,  0,  0,  4,  3,  0,  0,  4,  2,  0,  0
                                        ; DATA XREF: conditional_send_midi_byte_to_SP+5↑o
                                        ; conditional_send_midi_byte_to_MidiOut+9↑o ...
                db   0,  0,  8,  3,  0,  0,  8,  2,  8,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  4,  0,  0,  0,  0,  0,  0,  1,  5
                db   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  7,  0,  0,  0,  0,  4,  4,  0,  0,  4,  3,  0,  0,  2,  3,  0,  0,  0,  0,  2,  4
                db   0,  0,  0,  0,  8,  4,  0,  0,  0,  0,  8,  5,  8,  2,  8,  3,  8,  4,  0,  0,  0,  0,  0,  0,  8,  4,  0,  0,  0,  0,  8,  5
                db  15,  1

; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 37

setNodeParameterChainMode:              ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                cp      2
                ret     nc              ; if (a >= 0x02) return
                ld      hl, bufferToMidiOut_HasDataInBuffer

loc_948:                                ; CODE XREF: setNodeParameterChainMode+9↓j
                bit     7, (hl)
                jr      z, loc_948      ; if (bit 7 of (hl) == 0) jmp loc_948
                ld      (chainMode), a
                ld      a, (cardMode)
                and     a
                ret     nz
                ld      a, (configuredMidiFlowPath_MidiIn_To_System)
                ld      (actualMidiFlowPath_MidiIn_To_System), a
                ld      a, (configuredMidiFlowPath_System_To_MidiOut)
                ld      (actualMidiFlowPath_System_To_MidiOut), a
                ld      a, (configuredMidiFlowPath_MidiIn_To_MidiOut)
                ld      (actualMidiFlowPath_MidiIn_To_MidiOut), a
                ld      a, (configuredMidiFlowPath_MidiIn_To_SP)
                or      20h ; ' '
                ld      (actualMidiFlowPath_MidiIn_To_SP), a
                ld      a, (configuredMidiFlowPath_System_To_SP)
                or      20h ; ' '
                ld      (actualMidiFlowPath_System_To_SP), a
                ld      a, c
                and     a
                call    nz, modifyActualMidiFlowPathForChainMode
                ld      a, (actualMidiFlowPath_MidiIn_To_MidiOut)
                and     a
                call    nz, sub_9AB
------
                ld      b, 8
                ld      c, 0
                ld      de, activeConfiguration.instrumentConfigurations

loc_989:                                ; CODE XREF: setNodeParameterChainMode+54↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                ld      bc, 10h
                ldir
                pop     bc
                inc     c
                djnz    loc_989
------
                jp      proc_13EB_called_for_SelectMusicCardMode
; End of function setNodeParameterChainMode


; =============== S U B R O U T I N E =======================================


modifyActualMidiFlowPathForChainMode:   ; CODE XREF: setNodeParameterChainMode+37↑p
                ld      a, (actualMidiFlowPath_MidiIn_To_SP)
                and     1Eh
                ld      (actualMidiFlowPath_MidiIn_To_MidiOut), a
                ld      a, (actualMidiFlowPath_System_To_SP)
                and     1Eh
                ld      (actualMidiFlowPath_System_To_MidiOut), a
                ret
; End of function modifyActualMidiFlowPathForChainMode


; =============== S U B R O U T I N E =======================================


sub_9AB:                                ; CODE XREF: setNodeParameterChainMode+3E↑p
                ld      a, (actualMidiFlowPath_MidiIn_To_SP)
                and     1Fh
                ld      (actualMidiFlowPath_MidiIn_To_SP), a
                ret
; End of function sub_9AB


; =============== S U B R O U T I N E =======================================


clearIncomingMusicCardMessageBuffer:    ; CODE XREF: SOFT_REBOOT+40↑p
                                        ; RESTART_IN_THRU_MODE+12↑p ...
                xor     a
                ld      (incomingMusicCardMessage_Expected), a
                ld      (incomingMusicCardMessage_Size), a
                ret
; End of function clearIncomingMusicCardMessageBuffer


; =============== S U B R O U T I N E =======================================

; a = next music card message byte

processIncomingMusicCardMessageByte:    ; CODE XREF: RESTART_IN_THRU_MODE:loc_2C6↑p
                                        ; MUSIC_MODE_LOOP_read_System_And_Dispatch+26↑j
                ld      c, a
                cp      80h
                call    nc, setIncomingMusicCardMessageBufferExpected ; if (a >= 0x80) call setIncomingMusicCardMessageBufferExpected
                ld      a, (incomingMusicCardMessage_Expected)
                and     a
                ret     z
                ld      a, (incomingMusicCardMessage_Size)
                ld      hl, incomingMusicCardMessageData
                add     hl, a
                ld      (hl), c
                ld      hl, incomingMusicCardMessage_Size
                inc     (hl)
                ld      hl, incomingMusicCardMessage_Expected
                dec     (hl)
                ret     nz
                ld      a, (incomingMusicCardMessageData)
                sub     0D0h
                ld      hl, jpt_9E2
                jp      atomicTableLookupCall_wrapped_musicProcessing ; switch 32 cases
; ---------------------------------------------------------------------------

setIncomingMusicCardMessageBufferExpected:
                                        ; CODE XREF: processIncomingMusicCardMessageByte+3↑p
                call    clearIncomingMusicCardMessageBuffer
                ld      a, c
                cp      0F0h
                ret     nc              ; if (a >= 0xf0) return
                sub     0D0h
                ret     c
                ld      hl, byte_9FE
                add     hl, a
                ld      a, (hl)
                ld      (incomingMusicCardMessage_Expected), a
                xor     a
                ld      (incomingMusicCardMessage_Size), a
                ret
; ---------------------------------------------------------------------------
byte_9FE:       db 1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,6,9,1,1,1,0,0,0,0,0,0,0,0,0
                                        ; DATA XREF: processIncomingMusicCardMessageByte+33↑o
jpt_9E2:        dw processMusicCardMessageCardModeStatus
                                        ; DATA XREF: processIncomingMusicCardMessageByte+23↑o
                dw processMusicCardMessageErrorReportStatus ; jump table for switch statement
                dw processMusicCardMessagePathParameterStatus
                dw processMusicCardMessageNodeParameterStatus
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw processMusicCardMessageSelectCardMode
                dw processMusicCardMessageSelectErrorReportMode
                dw processMusicCardMessageSetPaths
                dw processMusicCardMessageSetNodeParameters
                dw processMusicCardMessage1E4
                dw processMusicCardMessageReboot
                dw processMusicCardMessageDebugWriteToMemory
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
                dw ignoreMusicCardMessage
; ---------------------------------------------------------------------------

ignoreMusicCardMessage:                 ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ret                     ; jumptable 000009E2 cases 4-15,23-31
; ---------------------------------------------------------------------------

processMusicCardMessageCardModeStatus:  ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      a, 0D0h         ; jumptable 000009E2 case 0
                ld      (outgoingMusicCardMessageData), a
                ld      a, (cardMode)
                ld      (outgoingMusicCardMessageData+1), a
                ld      b, 2
; End of function processIncomingMusicCardMessageByte


; =============== S U B R O U T I N E =======================================


sendOutgoingMusicCardMessageData:       ; CODE XREF: processMusicCardMessageErrorReportStatus+D↓j
                                        ; processMusicCardMessagePathParameterStatus+12↓j ...
                ld      hl, outgoingMusicCardMessageData
                jp      send_card_bytes_to_System
; End of function sendOutgoingMusicCardMessageData


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 1

processMusicCardMessageErrorReportStatus:
                                        ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      a, 0D1h
                ld      (outgoingMusicCardMessageData), a
                ld      a, (errorReport)
                ld      (outgoingMusicCardMessageData+1), a
                ld      b, 2
                jp      sendOutgoingMusicCardMessageData
; End of function processMusicCardMessageErrorReportStatus


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 2

processMusicCardMessagePathParameterStatus:
                                        ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      a, 0D2h
                ld      (outgoingMusicCardMessageData), a
                ld      hl, configuredMidiFlowPath_MidiIn_To_System
                ld      de,  outgoingMusicCardMessageData+1
                ld      bc, 5
                ldir
                ld      b, 6
                jp      sendOutgoingMusicCardMessageData
; End of function processMusicCardMessagePathParameterStatus


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 3

processMusicCardMessageNodeParameterStatus:
                                        ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      hl, outgoingMusicCardMessageData
                ld      (hl), 0D3h
                inc     hl
                ld      a, (nodeNumber)
                ld      (hl), a
                inc     hl
                ld      a, (memoryProtection)
                ld      (hl), a
                inc     hl
                ld      a, (activeConfigurationNr)
                ld      (hl), a
                inc     hl
                ld      a, (masterTune)
                ld      (hl), a
                inc     hl
                ld      a, (masterOutputLevel)
                cpl
                and     7Fh
                ld      (hl), a
                inc     hl
                ld      a, (chainMode)
                ld      (hl), a
                inc     hl
                ld      (hl), 0
                inc     hl
                ld      (hl), 0
                inc     hl
                ld      b, 9
                jp      sendOutgoingMusicCardMessageData
; End of function processMusicCardMessageNodeParameterStatus


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 16

processMusicCardMessageSelectCardMode:  ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      a, (incomingMusicCardMessageData+1)
                cp      2
                ret     nc              ; if (a >= 0x02) return
                ld      (cardMode), a
                and     a
                jp      z, RESTART_IN_MUSIC_MODE
                jp      RESTART_IN_THRU_MODE
; End of function processMusicCardMessageSelectCardMode


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 17

processMusicCardMessageSelectErrorReportMode:
                                        ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      a, (incomingMusicCardMessageData+1)
                cp      2
                ret     nc              ; if (a >= 0x02) return
                ld      (errorReport), a
                ld      a, 0E1h
                ld      (outgoingMusicCardMessageData), a
                ld      b, 1
                jp      sendOutgoingMusicCardMessageData
; End of function processMusicCardMessageSelectErrorReportMode


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 18

processMusicCardMessageSetPaths:        ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      a, (incomingMusicCardMessageData+1)
                and     1Fh
                ld      (configuredMidiFlowPath_MidiIn_To_System), a
---
                ld      a, (incomingMusicCardMessageData+2)
                and     1Fh
                ld      (configuredMidiFlowPath_System_To_MidiOut), a
---
                ld      a, (incomingMusicCardMessageData+3)
                and     1Fh
                ld      (configuredMidiFlowPath_MidiIn_To_SP), a
---
                ld      c, a
---
                ld      a, (incomingMusicCardMessageData+4)
                and     1Fh
                bit     4, c
                jr      z, loc_B10      ; if (bit 4 of c == 0) jmp loc_B10
                and     0Fh

loc_B10:                                ; CODE XREF: processMusicCardMessageSetPaths+20↑j
                ld      (configuredMidiFlowPath_System_To_SP), a
---
                ld      a, (incomingMusicCardMessageData+5)
                and     1Fh
                ld      (configuredMidiFlowPath_MidiIn_To_MidiOut), a
---
                ld      a, (chainMode)
                ld      c, a
                ld      a, 25h ; '%'
                call    setNodeParameter
                ld      a, 0E2h
                ld      (outgoingMusicCardMessageData), a
                ld      b, 1
                jp      sendOutgoingMusicCardMessageData
; End of function processMusicCardMessageSetPaths


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 19

processMusicCardMessageSetNodeParameters:
                                        ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      a, (incomingMusicCardMessageData+1)
                ld      c, a
                ld      a, 20h ; ' '
                call    setNodeParameter
---
                ld      a, (incomingMusicCardMessageData+2)
                ld      c, a
                ld      a, 21h ; '!'
                call    setNodeParameter
---
                ld      a, (incomingMusicCardMessageData+3)
                ld      c, a
                ld      a, 22h ; '"'
                call    setNodeParameter
---
                ld      a, (incomingMusicCardMessageData+4)
                ld      c, a
                ld      a, 23h ; '#'
                call    setNodeParameter
---
                ld      a, (incomingMusicCardMessageData+5)
                ld      c, a
                ld      a, 24h ; '$'
                call    setNodeParameter
---
                ld      a, (incomingMusicCardMessageData+6)
                ld      c, a
                ld      a, 25h ; '%'
                call    setNodeParameter
---
                call    SoundProcessor_SetToInitialState
                ld      a, 0E3h
                ld      (outgoingMusicCardMessageData), a
                ld      b, 1
                jp      sendOutgoingMusicCardMessageData
; End of function processMusicCardMessageSetNodeParameters


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 20

processMusicCardMessage1E4:             ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                ld      a, (cardMode)
                and     a
                call    z, sendActiveSenseCodeSafe
                ld      a, 0E4h
                ld      (outgoingMusicCardMessageData), a
                ld      b, 1
                jp      sendOutgoingMusicCardMessageData
; End of function processMusicCardMessage1E4


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 21

processMusicCardMessageReboot:          ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                di
                jp      HARD_REBOOT
; End of function processMusicCardMessageReboot


; =============== S U B R O U T I N E =======================================

; jumptable 000009E2 case 22

processMusicCardMessageDebugWriteToMemory:
                                        ; CODE XREF: processIncomingMusicCardMessageByte+26↑j
                                        ; DATA XREF: processIncomingMusicCardMessageByte:jpt_9E2↑o
                call    ym_key_off_on_all_channels

loc_B89:                                ; CODE XREF: processMusicCardMessageDebugWriteToMemory+6↓j
                                        ; processMusicCardMessageDebugWriteToMemory+20↓j ...
                call    processMusicCardMessageDebugWriteToMemory_readByte1
                jr      nz, loc_B89

loc_B8E:                                ; CODE XREF: processMusicCardMessageDebugWriteToMemory+B↓j
                                        ; processMusicCardMessageDebugWriteToMemory+11↓j ...
                call    processMusicCardMessageDebugWriteToMemory_readByte1
                jr      z, loc_B8E
                ld      b, a
                call    processMusicCardMessageDebugWriteToMemory_readByte1
                jr      z, loc_B8E
                ld      d, a
                call    processMusicCardMessageDebugWriteToMemory_readByte1
                jr      z, loc_B8E
                ld      e, a
                call    processMusicCardMessageDebugWriteToMemory_readByte1
                jr      z, loc_B8E
                and     a
                jr      nz, loc_B89

loc_BA8:                                ; CODE XREF: processMusicCardMessageDebugWriteToMemory+29↓j
                call    processMusicCardMessageDebugWriteToMemory_readByte1
                jr      z, loc_B8E
                ld      (de), a
                inc     de
                djnz    loc_BA8
                jr      loc_B89
; End of function processMusicCardMessageDebugWriteToMemory


; =============== S U B R O U T I N E =======================================


processMusicCardMessageDebugWriteToMemory_readByte1:
                                        ; CODE XREF: processMusicCardMessageDebugWriteToMemory:loc_B89↑p
                                        ; processMusicCardMessageDebugWriteToMemory:loc_B8E↑p ...
                call    processMusicCardMessageDebugWriteToMemory_readByte2
                ret     z
                call    processMusicCardMessageDebugWriteToMemory_HexCharToByte
                add     a, a
                add     a, a
                add     a, a
                add     a, a
                ld      c, a
                call    processMusicCardMessageDebugWriteToMemory_readByte2
                ret     z
                call    processMusicCardMessageDebugWriteToMemory_HexCharToByte
                add     a, c
                ld      c, a
                or      0FFh
                ld      a, c
                ret
; End of function processMusicCardMessageDebugWriteToMemory_readByte1


; =============== S U B R O U T I N E =======================================


processMusicCardMessageDebugWriteToMemory_readByte2:
                                        ; CODE XREF: processMusicCardMessageDebugWriteToMemory_readByte1↑p
                                        ; processMusicCardMessageDebugWriteToMemory_readByte1+C↑p ...
                call    system_read9BitMidiDataByte
                jr      z, processMusicCardMessageDebugWriteToMemory_readByte2
                jp      nc, HARD_REBOOT
                cp      80h
                jp      nc, HARD_REBOOT ; if (a >= 0x80) jmp HARD_REBOOT
                cp      1Ah
                jp      z, restartIntoCustomMem ; if (a == Ctrl-Z) jmp restartIntoCustomMem
                cp      3Ah ; ':'
                ret
; End of function processMusicCardMessageDebugWriteToMemory_readByte2


; =============== S U B R O U T I N E =======================================


processMusicCardMessageDebugWriteToMemory_HexCharToByte:
                                        ; CODE XREF: processMusicCardMessageDebugWriteToMemory_readByte1+4↑p
                                        ; processMusicCardMessageDebugWriteToMemory_readByte1+10↑p
                cp      40h ; '@'
                jr      nc, loc_BEA     ; if (a >= 0x40) jmp loc_BEA
                sub     30h ; '0'
                and     0Fh
                ret
; ---------------------------------------------------------------------------

loc_BEA:                                ; CODE XREF: processMusicCardMessageDebugWriteToMemory_HexCharToByte+2↑j
                cp      60h ; '`'
                jr      nc, loc_BF3     ; if (a >= 0x60) jmp loc_BF3
                sub     37h ; '7'
                and     0Fh
                ret
; ---------------------------------------------------------------------------

loc_BF3:                                ; CODE XREF: processMusicCardMessageDebugWriteToMemory_HexCharToByte+B↑j
                sub     57h ; 'W'
                and     0Fh
                ret
; End of function processMusicCardMessageDebugWriteToMemory_HexCharToByte


; =============== S U B R O U T I N E =======================================


initInterruptHandler:                   ; CODE XREF: SOFT_REBOOT+A↑p
                                        ; RESTART_IN_THRU_MODE+9↑p ...
                ld      a, 0C3h
                ld      (byte_FFFC), a
                ld      hl, InterruptHandler
                ld      (word_FFFD), hl
                call    reset_ym2151
                jp      reset_midi_device
; End of function initInterruptHandler


; =============== S U B R O U T I N E =======================================


InterruptHandler:                       ; DATA XREF: initInterruptHandler+5↑o
                push    af
                push    bc
                push    de
                push    hl
                ld      hl, loc_C39
                push    hl              ; loc_C39 will be the return address from any jump to functions
is there data waiting from the midi interface?
                in      a, (MIDI_PORT_2)
                bit     1, a            ; test TxRDY
                jp      nz, readMidiInPortDuringInterruptHandler ; if (bit 1 of a != 0) jmp readMidiInPortDuringInterruptHandler
is the data waiting from ???
                ld      hl, midiTransmitReceiveFlag
                bit     0, (hl)
                jr      z, loc_C24      ; if (bit 0 of (hl) == 0) jmp loc_C24
                bit     0, a
                jp      nz, writeMidiOutPortDuringInterruptHandler ; if (bit 0 of a != 0) jmp writeMidiOutPortDuringInterruptHandler

loc_C24:                                ; CODE XREF: InterruptHandler+14↑j
                ld      a, 14h
                out     (YA2151_PORT_1), a
                in      a, (YA2151_PORT_2)
                ld      h, a
                ld      a, (ym2151_IRQ_stuff)
                out     (YA2151_PORT_2), a ; reset Timer A&B
                ld      a, h
                and     3
                jp      nz, process_ya2151_interrupts_callInInterruptHandler
                jp      sendOrReceiveNextValueToFromSystemDuringInterruptHandler
; ---------------------------------------------------------------------------

loc_C39:                                ; DATA XREF: InterruptHandler+4↑o
                pop     hl
                pop     de
                pop     bc
                pop     af
                ei
                ret
; End of function InterruptHandler


; =============== S U B R O U T I N E =======================================


reset_ym2151:                           ; CODE XREF: initInterruptHandler+B↑p
                ld      b, 20h ; ' '
                ld      c, 60h ; '`'
                ld      a, 7Fh

loc_C45:                                ; CODE XREF: reset_ym2151+C↓j
                call    sendToYM2151_with_disabled_interrupts ; set all TL (Total Level) values to 0x7F
                ex      (sp), hl
                ex      (sp), hl
                inc     c
                djnz    loc_C45
                ld      b, 8
                ld      c, 0
                ld      a, 10h

loc_C53:                                ; CODE XREF: reset_ym2151+1A↓j
                call    sendToYM2151_with_disabled_interrupts ; set all registers 00-0F to 0x10
                ex      (sp), hl
                ex      (sp), hl
                inc     c
                djnz    loc_C53
------
                ld      a, 63h ; 'c'
                ld      c, 10h
                call    sendToYM2151_with_disabled_interrupts ; set CLKA1 to 63h
                ex      (sp), hl
                ex      (sp), hl
                ld      a, 0
                ld      c, 11h
                call    sendToYM2151_with_disabled_interrupts ; set CLKA2 to 0
                ex      (sp), hl
                ex      (sp), hl
                ld      a, 0C5h
                ld      c, 12h
                call    sendToYM2151_with_disabled_interrupts ; set CLKB to 0
; End of function reset_ym2151


; =============== S U B R O U T I N E =======================================


initialize_ym2151_timers:               ; CODE XREF: SOFT_REBOOT+49↑p
                                        ; RESTART_IN_THRU_MODE+15↑p
                xor     a
                ld      (ya2151_timerA_counter), a
                ld      (ya2151_timerB_counter), a
                ld      (musicProcessingDepth), a
                ld      a, 3Fh ; '?'
                ld      c, 14h
                call    sendToYM2151_with_disabled_interrupts ; ya2151: reset the timers and enable IRQs
                ld      (ym2151_IRQ_stuff), a ; ym2151_IRQ_stuff = 0x3F /Timer A&B start + Timer A/B flag reset / Timer A/B IRQ enabled
                ret
; End of function initialize_ym2151_timers


; =============== S U B R O U T I N E =======================================

; a = bit0 & bit1 status of the yamaha IRQs

process_ya2151_interrupts_callInInterruptHandler:
                                        ; CODE XREF: InterruptHandler+2A↑j
                rrca
                push    af
                jr      nc, timerAFlag_not_set
--- TimerA triggered an IRQ
                ld      hl, ya2151_timerA_counter
                inc     (hl)            ; ya2151_timerA_counter++
                ld      hl, runningCommandOnMidiInTimerCountdown
                dec     (hl)            ; bytes_remaining_in_MidiOutBuf?--
                ld      hl, runningCommandOnSystemInTimerCountdown
                dec     (hl)            ; bytes_remaining_in_SystemBuf?--
                ld      hl, sendDataToSystemTimoutCountdown
                dec     (hl)            ; bytes_remaining_in_bufferC?--
                call    decreaseMidiInActiveSenseCounter
                call    sendActiveSenseCodeToMidiOutAfterTimeout
                call    decreaseReadMidiDataTimeout

timerAFlag_not_set:                     ; CODE XREF: process_ya2151_interrupts_callInInterruptHandler+2↑j
                pop     af
                rrca
                jr      nc, timerBFlag_not_set
--- timerB was triggered
                ld      hl, ya2151_timerB_counter ; ya2151_timerB_counter++
                inc     (hl)

timerBFlag_not_set:                     ; CODE XREF: process_ya2151_interrupts_callInInterruptHandler+1F↑j
                ld      a, (musicProcessingDepth)
                and     a
                ret     nz              ; if (musicProcessingDepth != 0) return
                inc     a
                ld      (musicProcessingDepth), a ; musicProcessingDepth++
; End of function process_ya2151_interrupts_callInInterruptHandler


; =============== S U B R O U T I N E =======================================


finalizeMusicProcessing:                ; CODE XREF: stopMusicProcessing+12↓p
                push    ix
                push    iy

loc_CBB:                                ; CODE XREF: finalizeMusicProcessing+29↓j
                                        ; finalizeMusicProcessing+33↓j
                di
                ld      a, (ya2151_timerA_counter)
                and     a
                jr      nz, non_zero_ya2151_timerA_counter ; if (byte_F5AC != 0) jmp loc_CD1
                ld      a, (ya2151_timerB_counter)
                and     a
                jr      nz, non_zero_ya2151_timerB_counter ; if (byte_F5AD != 0) jmp loc_CE2
                ld      hl, musicProcessingDepth
                dec     (hl)
                pop     iy
                pop     ix
                ret
; ---------------------------------------------------------------------------

non_zero_ya2151_timerA_counter:         ; CODE XREF: finalizeMusicProcessing+9↑j
                dec     a
                ld      (ya2151_timerA_counter), a ; byte_F5AC--
                ei
                call    ym_updateAllCurrentlyPlayingByPortamentoAdjustment
                ld      a, (ya2151_timerA_counter)
                and     a
                call    z, ym_updateKeyCodeAndFractionOnAllChannels
                jr      loc_CBB
; ---------------------------------------------------------------------------

non_zero_ya2151_timerB_counter:         ; CODE XREF: finalizeMusicProcessing+F↑j
                dec     a
                ld      (ya2151_timerB_counter), a ; byte_F5AD--
                ei
                call    logErrorOrSuccess
                jr      loc_CBB
; End of function finalizeMusicProcessing


; =============== S U B R O U T I N E =======================================


startMusicProcessing:                   ; CODE XREF: jmpStartMusicProcessing↑j
                di
                ld      a, (musicProcessingDepth)
                inc     a
                ld      (musicProcessingDepth), a
                ei
                ret
; End of function startMusicProcessing


; =============== S U B R O U T I N E =======================================


stopMusicProcessing:                    ; CODE XREF: jmpStopMusicProcessing↑j
                di
                ld      a, (musicProcessingDepth)
                dec     a
                ld      (musicProcessingDepth), a
                jr      nz, loc_D0E
do something once the counter is at zero
                ld      a, 1
                ld      (musicProcessingDepth), a ; This is kind of stupid - incrementing the depth so it can be decreased in the finalize routine
                push    hl
                push    de
                push    bc
                call    finalizeMusicProcessing
                pop     bc
                pop     de
                pop     hl

loc_D0E:                                ; CODE XREF: stopMusicProcessing+8↑j
                ei
                ret
; End of function stopMusicProcessing


; =============== S U B R O U T I N E =======================================


reset_midi_device:                      ; CODE XREF: initInterruptHandler+E↑j
                ld      a, 0
                out     (MIDI_PORT_2), a ; Mode: Synchronous (5-bit, No Parity, SyncDetect:Internally, SyncChar:2)
                ex      (sp), hl        ; wait
                ex      (sp), hl        ; wait
                out     (MIDI_PORT_2), a ; Sync Character 1
                ex      (sp), hl        ; wait
                ex      (sp), hl        ; wait
                out     (MIDI_PORT_2), a ; Sync Character 2
                ex      (sp), hl        ; wait
                ex      (sp), hl        ; wait
                ld      a, 40h ; '@'
                out     (MIDI_PORT_2), a ; Command: 0x40 = 01000000 => SOFTWARE RESET
                                        ; bit0: 0 = Transmit Enable: Disable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 0 = Receive Enable: Disable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 0 = Error Clear: No Operation
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 1 = Software Reset: Reset Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation
                ex      (sp), hl        ; wait
                ex      (sp), hl        ; wait
                ld      a, 4Eh ; 'N'
                out     (MIDI_PORT_2), a ; 0x4E = 01 00 11 10
                                        ; Asynchronous Mode Select:
                                        ; bit1&0: 10 = Baud Rate: x1 Clock
                                        ; bit3&2: 11 = Character-Length: 8bit
                                        ; bit5&4: 00 = Parity Generate/Check: Use Illegal
                                        ; bit7&6: 01 = Transmit Stop Bits: 1-bit
                ex      (sp), hl        ; wait
                ex      (sp), hl        ; wait
                ld      a, 4
                ld      (midiTransmitReceiveFlag), a
                ld      a, 14h
                out     (MIDI_PORT_2), a ; Command: 0x04 = 00000100 => Receive Enable
                                        ; bit0: 0 = Transmit Enable: Disable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 1 = Receive Enable: Enable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 0 = Error Clear: No Operation
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 0 = Software Reset: No Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation
                call    resetMidiOutBuffersAndPorts
                jp      resetMidiInBuffersAndPorts
; End of function reset_midi_device


; =============== S U B R O U T I N E =======================================

; void -> void

resetMidiInBuffersAndPorts:             ; CODE XREF: RESTART_IN_THRU_MODE+44↑p
                                        ; readMidiDataWithTimeout+6A↑p ...
                push    hl
                ld      hl, 0
                ld      (bufferFromMidiIn_LastReadByteIndex), hl
                ld      (bufferFromMidiIn_IndexForNextWriteByte), hl
                ld      a, 80h
                ld      (bufferFromMidiIn_HasDataInBuffer), a ; bufferFromMidiIn_HasDataInBuffer = 0x80
                ld      a, (midiTransmitReceiveFlag)
                or      10h
                out     (MIDI_PORT_2), a ; Command: 0x04 = 00010000 => Clear Error Flag
                                        ; bit0: 0 = Transmit Enable: Disable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 0 = Receive Enable: Disable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 1 = Error Clear: Error Flag Clear
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 0 = Software Reset: No Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation
                xor     a
                ld      (bufferFromMidiIn_lastActiveSenseCodeCountdown), a ; bufferFromMidiIn_mem_0xf629 = 0
                pop     hl
                ret
; End of function resetMidiInBuffersAndPorts


; =============== S U B R O U T I N E =======================================

; void -> void

readMidiInPortDuringInterruptHandler:   ; CODE XREF: InterruptHandler+C↑j
                in      a, (MIDI_PORT_1) ; read midi data
                ld      c, a
                in      a, (MIDI_PORT_2)
                and     38h ; '8'       ; 0x38 = 00111000 : bit5(FramingError), bit4(OverrunError), bit3(ParityError)
                jr      nz, errorsFound
                ld      a, (cardMode)
                and     a
                jr      nz, loc_D6C
MUSIC_MODE
                ld      a, c
                cp      0FEh
                jr      z, activeSenseReceived ; if (a == 0xfe) jmp loc_D9A
                call    resetMidiInActiveSenseCodeCountdownIfZero

loc_D6C:                                ; CODE XREF: readMidiInPortDuringInterruptHandler+D↑j
                ld      de, (bufferFromMidiIn_IndexForNextWriteByte)
                ld      hl, bufferFromMidiIn
                add     hl, de
                ld      (hl), c
---
                inc     de
                res     3, d
                ld      (bufferFromMidiIn_IndexForNextWriteByte), de
                ld      hl, bufferFromMidiIn_HasDataInBuffer
                res     7, (hl)
---
                ld      hl, (bufferFromMidiIn_LastReadByteIndex)
                or      a
                sbc     hl, de
                ret     nz
                call    resetMidiInBuffersAndPorts
                ld      hl, bufferFromMidiIn_HasDataInBuffer
                set     5, (hl)
                ret
; ---------------------------------------------------------------------------

errorsFound:                            ; CODE XREF: readMidiInPortDuringInterruptHandler+7↑j
                call    resetMidiInBuffersAndPorts
                ld      hl, bufferFromMidiIn_HasDataInBuffer
                set     6, (hl)
                ret
; ---------------------------------------------------------------------------

activeSenseReceived:                    ; CODE XREF: readMidiInPortDuringInterruptHandler+12↑j
                ld      a, 20h ; ' '
                ld      (bufferFromMidiIn_lastActiveSenseCodeCountdown), a ; bufferFromMidiIn_mem_0xf629 = 0x20
                ret
; End of function readMidiInPortDuringInterruptHandler


; =============== S U B R O U T I N E =======================================

; void -> output into a-reg / c-flag=error / z-flag=has data

midiIn_readMidiDataByte:                ; CODE XREF: RESTART_IN_THRU_MODE:loc_2AD↑p
                                        ; readMidiDataWithTimeout:loc_433↑p
                push    hl
                push    de
                di
                ld      hl, bufferFromMidiIn_HasDataInBuffer
                ld      a, (hl)
                and     70h ; 'p'
                jr      nz, bufferFromMidiIn_hasErrors
                bit     7, (hl)
                jr      nz, loc_DF1     ; if (bit 7 of (hl) != 0) jmp loc_DF1
                ld      de, (bufferFromMidiIn_LastReadByteIndex)
                ld      hl, bufferFromMidiIn
                add     hl, de
                or      0FFh
                ld      a, (hl)
                push    af
                inc     de
                res     3, d
                ld      (bufferFromMidiIn_LastReadByteIndex), de
                ld      hl, (bufferFromMidiIn_IndexForNextWriteByte)
                or      a
                sbc     hl, de
                jr      nz, loc_DCF
                ld      hl, bufferFromMidiIn_HasDataInBuffer
                set     7, (hl)

loc_DCF:                                ; CODE XREF: midiIn_readMidiDataByte+28↑j
                pop     af

loc_DD0:                                ; CODE XREF: midiIn_readMidiDataByte+4F↓j
                                        ; midiIn_readMidiDataByte+52↓j
                ei
                pop     de
                pop     hl
                ret
; ---------------------------------------------------------------------------

bufferFromMidiIn_hasErrors:             ; CODE XREF: midiIn_readMidiDataByte+9↑j
                push    af
                push    af
                call    resetMidiInBuffersAndPorts
                pop     af
                ei
                ld      h, 0F2h
                bit     6, a            ; read error flag
                jr      nz, loc_DE9     ; if (bit 6 of a != 0) jmp loc_DE9
                ld      h, 0F1h
                bit     5, a            ; overflow error flag
                jr      nz, loc_DE9     ; if (bit 5 of a != 0) jmp loc_DE9
                ld      h, 0F3h

loc_DE9:                                ; CODE XREF: midiIn_readMidiDataByte+3F↑j
                                        ; midiIn_readMidiDataByte+45↑j
                ld      a, h
                call    reportErrorIfNeeded
                pop     af
                scf
                jr      loc_DD0
; ---------------------------------------------------------------------------

loc_DF1:                                ; CODE XREF: midiIn_readMidiDataByte+D↑j
                or      a
                jr      loc_DD0
; End of function midiIn_readMidiDataByte


; =============== S U B R O U T I N E =======================================


resetMidiInActiveSenseCodeCountdownIfZero:
                                        ; CODE XREF: readMidiInPortDuringInterruptHandler+14↑p
                ld      a, (bufferFromMidiIn_lastActiveSenseCodeCountdown)
                and     a
                ret     z               ; if (bufferFromMidiIn_lastActiveSenseCodeCountdown != 0) return
                ld      a, 20h ; ' '
                ld      (bufferFromMidiIn_lastActiveSenseCodeCountdown), a ; bufferFromMidiIn_lastActiveSenseCodeCountdown = 0x20
                ret
; End of function resetMidiInActiveSenseCodeCountdownIfZero


; =============== S U B R O U T I N E =======================================


decreaseMidiInActiveSenseCounter:       ; CODE XREF: process_ya2151_interrupts_callInInterruptHandler+14↑p
                ld      a, (bufferFromMidiIn_lastActiveSenseCodeCountdown)
                and     a
                ret     z               ; if (bufferFromMidiIn_lastActiveSenseCodeCountdown == 0) return
                dec     a
                ld      (bufferFromMidiIn_lastActiveSenseCodeCountdown), a ; bufferFromMidiIn_lastActiveSenseCodeCountdown--
                ret     nz              ; if (bufferFromMidiIn_lastActiveSenseCodeCountdown != 0) return
active sense was not received within 300ms -> flag it
                ld      hl, bufferFromMidiIn_HasDataInBuffer
                set     4, (hl)         ; bufferFromMidiIn_HasDataInBuffer |= 0x10
                ret
; End of function decreaseMidiInActiveSenseCounter


; =============== S U B R O U T I N E =======================================

; void -> void

resetMidiOutBuffersAndPorts:            ; CODE XREF: reset_midi_device+23↑p
                                        ; sendActiveSenseCodeSafe+1F↓p
                push    hl
                ld      hl, 0
                ld      (bufferToMidiOut_LastReadByteIndex), hl
                ld      (bufferToMidiOut_IndexForNextWriteByte), hl
                ld      a, 80h
                ld      (bufferToMidiOut_HasDataInBuffer), a
                xor     a
                ld      (midiOut_CommandInProgress), a
                ld      a, 0Ah
                ld      (runningCommandOnMidiInTimerCountdown), a
                ld      a, (midiTransmitReceiveFlag)
                res     0, a
                ld      (midiTransmitReceiveFlag), a
                out     (MIDI_PORT_2), a ; Command: 0x04 = 00000001 => Transmit Disable
                                        ; bit0: 1 = Transmit Enable: Disable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 0 = Receive Enable: Disable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 0 = Error Clear: No Operation
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 0 = Software Reset: No Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation
                call    sendActiveSenseCode
                pop     hl
                ret
; End of function resetMidiOutBuffersAndPorts


; =============== S U B R O U T I N E =======================================


writeMidiOutPortDuringInterruptHandler: ; CODE XREF: InterruptHandler+18↑j
                ld      hl, (bufferToMidiOut_LastReadByteIndex) ; void -> void
                ld      h, 0F0h
                ld      a, (hl)         ; a = bufferToMidiOut[bufferToMidiOut_LastReadByteIndex]
                out     (MIDI_PORT_1), a
---
                inc     l
                ld      a, l
                ld      (bufferToMidiOut_LastReadByteIndex), a ; bufferToMidiOut_LastReadByteIndex++
---
                ld      a, (bufferToMidiOut_IndexForNextWriteByte)
                cp      l
                jr      nz, loc_E58     ; if (bufferToMidiOut_IndexForNextWriteByte != bufferToMidiOut_LastReadByteIndex) jmp loc_E58
---
                ld      hl, bufferToMidiOut_HasDataInBuffer
                set     7, (hl)         ; bufferToMidiOut_HasDataInBuffer = has_no_data
---
                ld      a, (midiTransmitReceiveFlag)
                res     0, a
                ld      (midiTransmitReceiveFlag), a ; byte_F623 &= 0xFE
                out     (MIDI_PORT_2), a ; Command: 0x04 = 00000000 => Transmit Disable
                                        ; bit0: 0 = Transmit Enable: Disable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 0 = Receive Enable: Disable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 0 = Error Clear: No Operation
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 0 = Software Reset: No Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation

loc_E58:                                ; CODE XREF: writeMidiOutPortDuringInterruptHandler+11↑j
                jp      initMidiOutActiveSensingCountdownMusicMode
; End of function writeMidiOutPortDuringInterruptHandler


; =============== S U B R O U T I N E =======================================

; a = byte to send

send_midi_byte_to_MidiOut:              ; CODE XREF: RESTART_IN_THRU_MODE+36↑p
                                        ; readMidiDataWithTimeout+36↑p ...
                cp      0F8h
                jr      nc, loc_E72     ; if (a >= 0xf8) jmp loc_E72
                cp      80h
                jr      c, loc_E72      ; if (a < 0x80) jmp loc_E72
                cp      0F1h
                jr      c, loc_E6F      ; if (a < 0xf1) jmp loc_E6F
                push    hl
                ld      hl, midiOut_CommandInProgress
                ld      (hl), 0
                jr      loop
; ---------------------------------------------------------------------------

loc_E6F:                                ; CODE XREF: send_midi_byte_to_MidiOut+A↑j
                ld      (midiOut_CommandInProgress), a

loc_E72:                                ; CODE XREF: send_midi_byte_to_MidiOut+2↑j
                                        ; send_midi_byte_to_MidiOut+6↑j
                push    hl

loop:                                   ; CODE XREF: send_midi_byte_to_MidiOut+12↑j
                                        ; send_midi_byte_to_MidiOut+28↓j
                ei
                nop
                di
---
                ld      hl, (bufferToMidiOut_IndexForNextWriteByte)
                ld      h, 0F0h
                ld      (hl), a         ; bufferToMidiOut[bufferToMidiOut_IndexForNextWriteByte] = a
---
                ld      h, a
                inc     l
                ld      a, (bufferToMidiOut_LastReadByteIndex)
---
                cp      l
                ld      a, h
                jr      z, loop
---
                ld      a, l
                ld      (bufferToMidiOut_IndexForNextWriteByte), a
                ld      hl, bufferToMidiOut_HasDataInBuffer
                res     7, (hl)
---
                ld      a, (midiTransmitReceiveFlag)
                set     0, a
                ld      (midiTransmitReceiveFlag), a ; byte_F623 |= 0x01
                out     (MIDI_PORT_2), a ; Command: 0x04 = 00000001 => Transmit Enable
                                        ; bit0: 1 = Transmit Enable: Enable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 0 = Receive Enable: Disable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 0 = Error Clear: No Operation
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 0 = Software Reset: No Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation
                ei
                pop     hl
                ret
; End of function send_midi_byte_to_MidiOut


; =============== S U B R O U T I N E =======================================

; b = number of bytes / hl=pointer to MidiDataPacket

sendMidiResponse_to_MidiOut:            ; CODE XREF: conditional_send_midi_byte_to_MidiOut+1C↑p
                                        ; forwardToMidiOut+3↓j ...
                ld      a, (hl)
                cp      0F7h
                jr      c, loc_EB5      ; if (a < 0xf7) jmp loc_EB5
                jr      z, send_F7_to_MidiOut_if_needed ; if (a == 0xf7) jmp send_F7_to_MidiOut_if_needed
                cp      0FFh
                jr      z, loc_EAB      ; if (a == 0xff) jmp loc_EAB
                cp      0FEh
                jr      z, loc_EB0      ; if (a == 0xfe) jmp loc_EB0
                ret
; ---------------------------------------------------------------------------

loc_EAB:                                ; CODE XREF: sendMidiResponse_to_MidiOut+9↑j
                call    send_F0_43_75_70_to_MidiOut
                jr      loc_EC5
; ---------------------------------------------------------------------------

loc_EB0:                                ; CODE XREF: sendMidiResponse_to_MidiOut+D↑j
                call    send_F0_43_75_71_to_MidiOut
                jr      loc_EC5
; ---------------------------------------------------------------------------

loc_EB5:                                ; CODE XREF: sendMidiResponse_to_MidiOut+3↑j
                cp      80h
                ret     c               ; if (a < 0x80) return
                call    send_F7_to_MidiOut_if_needed
                ld      a, (midiOut_CommandInProgress)
                cp      (hl)
                jr      z, loc_EC5      ; if (a == (hl)) jmp loc_EC5
                ld      a, (hl)
                call    send_midi_byte_to_MidiOut

loc_EC5:                                ; CODE XREF: sendMidiResponse_to_MidiOut+13↑j
                                        ; sendMidiResponse_to_MidiOut+18↑j ...
                inc     hl
                dec     b
                jr      z, loc_ED0

loc_EC9:                                ; CODE XREF: sendMidiResponse_to_MidiOut+33↓j
                ld      a, (hl)
                inc     hl
                call    send_midi_byte_to_MidiOut
                djnz    loc_EC9

loc_ED0:                                ; CODE XREF: sendMidiResponse_to_MidiOut+2C↑j
                ld      a, 0Ah
                ld      (runningCommandOnMidiInTimerCountdown), a
                ret
; End of function sendMidiResponse_to_MidiOut


; =============== S U B R O U T I N E =======================================

; void -> void

send_F7_to_MidiOut_if_needed:           ; CODE XREF: sendMidiResponse_to_MidiOut+5↑j
                                        ; sendMidiResponse_to_MidiOut+1D↑p ...
                ld      a, (midiOut_CommandInProgress)
                cp      0F0h
                jr      z, loc_EDF      ; if (a == 0xf0) jmp loc_EDF
                cp      0FEh

loc_EDF:                                ; CODE XREF: send_F7_to_MidiOut_if_needed+5↑j
                ret     c               ; if (a < 0xXX) return
                ld      a, 0F7h
                jp      send_midi_byte_to_MidiOut
; End of function send_F7_to_MidiOut_if_needed


; =============== S U B R O U T I N E =======================================

; void -> void

send_F0_43_75_70_to_MidiOut:            ; CODE XREF: sendMidiResponse_to_MidiOut:loc_EAB↑p
                ld      a, (midiOut_CommandInProgress)
                cp      0FFh
                ret     z               ; if (a == 0xff) return
                call    send_F7_to_MidiOut_if_needed
                ld      a, 0F0h
                call    send_midi_byte_to_MidiOut
                ld      a, 43h ; 'C'
                call    send_midi_byte_to_MidiOut
                ld      a, 75h ; 'u'
                call    send_midi_byte_to_MidiOut
                ld      a, 70h ; 'p'
                call    send_midi_byte_to_MidiOut
                ld      a, 0FFh
                ld      (midiOut_CommandInProgress), a
                ret
; End of function send_F0_43_75_70_to_MidiOut


; =============== S U B R O U T I N E =======================================

; void -> void

send_F0_43_75_71_to_MidiOut:            ; CODE XREF: sendMidiResponse_to_MidiOut:loc_EB0↑p
                ld      a, (midiOut_CommandInProgress)
                cp      0FEh
                ret     z               ; if (a == 0xfe) return
                call    send_F7_to_MidiOut_if_needed
                ld      a, 0F0h
                call    send_midi_byte_to_MidiOut
                ld      a, 43h ; 'C'
                call    send_midi_byte_to_MidiOut
                ld      a, 75h ; 'u'
                call    send_midi_byte_to_MidiOut
                ld      a, 71h ; 'q'
                call    send_midi_byte_to_MidiOut
                ld      a, 0FEh
                ld      (midiOut_CommandInProgress), a
                ret
; End of function send_F0_43_75_71_to_MidiOut


; =============== S U B R O U T I N E =======================================

; void -> void

send_F7_to_MidiOut_if_timed_out:        ; CODE XREF: doesMidiDataPacketNeedAdditionalData_MUSIC_MODE+1↑p
                ld      a, (runningCommandOnMidiInTimerCountdown)
                cp      0Bh
                ret     c               ; if (a < 0x0b) return
                ld      a, 0Ah
                ld      (runningCommandOnMidiInTimerCountdown), a
                ld      a, (midiOut_CommandInProgress)
                cp      0FEh
                jr      nc, loc_F46     ; if (a >= 0xfe) jmp loc_F46
                cp      0F0h
                jr      z, locret_F45   ; if (a == 0xf0) jmp locret_F45
                xor     a
                ld      (midiOut_CommandInProgress), a

locret_F45:                             ; CODE XREF: send_F7_to_MidiOut_if_timed_out+14↑j
                ret
; ---------------------------------------------------------------------------

loc_F46:                                ; CODE XREF: send_F7_to_MidiOut_if_timed_out+10↑j
                ld      a, 0F7h
                jp      send_midi_byte_to_MidiOut
; End of function send_F7_to_MidiOut_if_timed_out


; =============== S U B R O U T I N E =======================================


sendActiveSenseCodeSafe:                ; CODE XREF: readMidiDataWithTimeout+73↑p
                                        ; readMidiDataWithTimeout+E5↑p ...
                ld      hl, 3
                call    wait            ; wait(3)
                di
                ld      hl, activeSenseSendingState
                bit     0, (hl)
                jr      nz, loc_F72     ; if (bit 0 of byte_F632 != 0) jmp loc_F72
                set     0, (hl)         ; byte_F632 |= 0x01
                call    sendActiveSenseCode
                xor     a
                ld      (midiOutActiveSensingCountdown), a ; midiOutActiveSensingCountdown = 0
                ei
                ld      hl, 5000
                call    wait            ; wait(5000)
                di
                call    resetMidiOutBuffersAndPorts
                ld      hl, activeSenseSendingState
                res     0, (hl)

loc_F72:                                ; CODE XREF: sendActiveSenseCodeSafe+C↑j
                ei
                ret
; End of function sendActiveSenseCodeSafe


; =============== S U B R O U T I N E =======================================


wait:                                   ; CODE XREF: sendActiveSenseCodeSafe+3↑p
                                        ; sendActiveSenseCodeSafe+1B↑p ...
                ld      b, 61

loc_F76:                                ; CODE XREF: wait:loc_F76↓j
                djnz    $               ; wait
                dec     hl
                ld      a, l
                or      h
                jr      nz, wait        ; loop for another hl-times
                ret
; End of function wait


; =============== S U B R O U T I N E =======================================


sendActiveSenseCodeToMidiOutAfterTimeout:
                                        ; CODE XREF: process_ya2151_interrupts_callInInterruptHandler+17↑p
                ld      a, (midiOutActiveSensingCountdown)
                and     a
                ret     z               ; if (byte_F62F == 0) return
                dec     a
                ld      (midiOutActiveSensingCountdown), a ; byte_F62F--
                ret     nz              ; if (byte_F62F != 0) return
                jr      sendActiveSenseCodeToMidiOut
; End of function sendActiveSenseCodeToMidiOutAfterTimeout


; =============== S U B R O U T I N E =======================================


sendActiveSenseCode:                    ; CODE XREF: resetMidiOutBuffersAndPorts+22↑p
                                        ; sendActiveSenseCodeSafe+10↑p
                ld      a, (cardMode)
                and     a
                jr      z, sendActiveSenseCodeToMidiOut ; if (cardMode == MUSIC_MODE) jmp sendActiveSenseCodeToMidiOut
-- cardMode is in THRU mode
                xor     a
                ld      (midiOutActiveSensingCountdown), a ; midiOutActiveSensingCountdown = 0
                ret
; End of function sendActiveSenseCode


; =============== S U B R O U T I N E =======================================


sendActiveSenseCodeToMidiOut:           ; CODE XREF: sendActiveSenseCodeToMidiOutAfterTimeout+A↑j
                                        ; sendActiveSenseCode+4↑j
                ld      a, 5
                out     (MIDI_PORT_2), a ; Command: 0x04 = 00000101 => Transmit Enable / Receive Enable
                                        ; bit0: 1 = Transmit Enable: Enable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 1 = Receive Enable: Enable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 0 = Error Clear: No Operation
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 0 = Software Reset: No Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation
                ex      (sp), hl        ; wait
                ex      (sp), hl        ; wait

loc_F9B:                                ; CODE XREF: sendActiveSenseCodeToMidiOut+A↓j
                in      a, (MIDI_PORT_2)
                bit     0, a            ; test TxRDY
                jr      z, loc_F9B      ; if (bit 0 of a == 0) jmp loc_F9B
                ld      a, 0FEh
                out     (MIDI_PORT_1), a ; send "Active Sense" to MIDI
                ex      (sp), hl        ; wait
                ex      (sp), hl        ; wait
                ld      a, 4
                out     (MIDI_PORT_2), a ; Command: 0x04 = 00000100 => Transmit Disable / Receive Enable
                                        ; bit0: 0 = Transmit Enable: Disable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 1 = Receive Enable: Enable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 0 = Error Clear: No Operation
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 0 = Software Reset: No Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation
                jr      initMidiOutActiveSensingCountdown
; End of function sendActiveSenseCodeToMidiOut


; =============== S U B R O U T I N E =======================================


initMidiOutActiveSensingCountdownMusicMode:
                                        ; CODE XREF: writeMidiOutPortDuringInterruptHandler:loc_E58↑j
                ld      a, (cardMode)
                and     a
                ret     nz              ; if (cardMode != MUSIC_MODE) return
; End of function initMidiOutActiveSensingCountdownMusicMode


; =============== S U B R O U T I N E =======================================


initMidiOutActiveSensingCountdown:      ; CODE XREF: sendActiveSenseCodeToMidiOut+16↑j
                ld      a, 10h
                ld      (midiOutActiveSensingCountdown), a ; byte_F62F = 0x10
                ret
; End of function initMidiOutActiveSensingCountdown


; =============== S U B R O U T I N E =======================================


reset_PIU_device:                       ; CODE XREF: START+16↑p
                ld      a, 0A6h
enable mode 1 on PIU device
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0xA6 // 1 01 0 0 1 1 0
                                        ; bit 7: 1 - command select "mode select"
                                        ; Group 0:
                                        ;  bit 6&5: 01 - Mode: Mode 1
                                        ;  bit 4:   0  - Port 0: Output
                                        ;  bit 3:   0  - Port 2 (Upper): Output
                                        ; Group 1:
                                        ;  bit 2:   1  - Mode: Mode 1
                                        ;  bit 1:   1  - Port 1: Input
                                        ;  bit 0:   0  - Port 2 (Lower): Output
                call    initializePIUOutput
                jp      initializePIUInput
; End of function reset_PIU_device


; =============== S U B R O U T I N E =======================================


sendOrReceiveNextValueToFromSystemDuringInterruptHandler:
                                        ; CODE XREF: InterruptHandler+2D↑j
                in      a, (PIU_PORT2)
                bit     3, a            ; Test for interrupt request on group 0 (INT0)
                jp      nz, sendNextValueToSystemDuringInterruptHandler
                bit     0, a            ; Test for interrupt request on group 1 (INT1)
                jp      nz, receiveNextValueFromSystemDuringInterruptHandler
                ret
; End of function sendOrReceiveNextValueToFromSystemDuringInterruptHandler


; =============== S U B R O U T I N E =======================================


initializePIUInput:                     ; CODE XREF: reset_PIU_device+7↑j
                xor     a
                ld      (bufferFromSystem_LastReadByteIndex), a
                ld      (bufferFromSystem_IndexForNextWriteByte), a
                ld      a, 80h
                ld      (bufferFromSystem_HasDataInBuffer), a
                ld      a, 5            ; probably: Write Interrupt Enable
enable write interrupt on group 1
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0x05 = 0 000 010 1
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 010 - Port 2 bit select: bit2
                                        ; bit 0: 1 - bit set/reset: set
                ret
; End of function initializePIUInput


; =============== S U B R O U T I N E =======================================


receiveNextValueFromSystemDuringInterruptHandler:
                                        ; CODE XREF: sendOrReceiveNextValueToFromSystemDuringInterruptHandler+9↑j
                ld      hl, (bufferFromSystem_IndexForNextWriteByte)
                ld      h, 0F1h         ; hl = &bufferAFromSystem[bufferFromSystem_IndexForNextWriteByte]
                in      a, (MIDI_PORT_2)
                rlca
                xor     1
                and     1
                ld      (hl), a         ; bufferAFromSystem[bufferFromSystem_IndexForNextWriteByte] = (in(MIDI_PORT_2) >> 7) ^ 1
                inc     h
                in      a, (PIU_PORT1)
                ld      (hl), a         ; bufferBFromSystem[bufferFromSystem_IndexForNextWriteByte] = in(PIU_PORT_1)
                inc     l
                ld      a, l
                ld      (bufferFromSystem_IndexForNextWriteByte), a ; bufferFromSystem_IndexForNextWriteByte++
---
                ld      a, (bufferFromSystem_LastReadByteIndex)
                cp      l
                jr      nz, loc_1000    ; if (bufferFromSystem_LastReadByteIndex != bufferFromSystem_IndexForNextWriteByte) jmp loc_1000
                ld      a, 4
disable write interrupt on group 1
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0x04 = 0 000 010 0
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 010 - Port 2 bit select: bit2
                                        ; bit 0: 0 - bit set/reset: reset

loc_1000:                               ; CODE XREF: receiveNextValueFromSystemDuringInterruptHandler+1A↑j
                ld      hl, bufferFromSystem_HasDataInBuffer
                res     7, (hl)
                ret
; End of function receiveNextValueFromSystemDuringInterruptHandler


; =============== S U B R O U T I N E =======================================

; void -> c-flag=error? / z-flag=has data?
; Returns:
;  no data   -> a=0 / C=cleared / Z=set
;  midi data -> a=0 / C=cleared / Z=reset
;  sys data  -> a=next data / C=set / Z=reset

system_isMidiDataAvailable:             ; CODE XREF: readMidiDataWithTimeout:loc_4B6↑p
                                        ; system_isMidiDataAvailable+2A↓j
                ld      a, (bufferFromSystem_HasDataInBuffer)
                bit     7, a
                jr      z, loc_100F     ; if (bit 7 of a == 0) jmp loc_100F
                xor     a               ; C and N flags cleared
                ret
; ---------------------------------------------------------------------------

loc_100F:                               ; CODE XREF: system_isMidiDataAvailable+5↑j
                di
                push    hl
                ld      hl, (bufferFromSystem_LastReadByteIndex)
                ld      h, 0F1h         ; hl = &bufferAFromSystem[bufferFromSystem_LastReadByteIndex]
                bit     0, (hl)
                jr      nz, system_data_pending ; if (bit 0 of (hl) != 0) jmp loc_101F
-- data is normal midi data
                or      0FFh            ; C and N flags cleared
                pop     hl
                ei
                ret
; ---------------------------------------------------------------------------

system_data_pending:                    ; CODE XREF: system_isMidiDataAvailable+12↑j
                inc     h               ; bufferB
                ld      a, (hl)         ; a = bufferBFromSystem[bufferFromSystem_LastReadByteIndex]
                cp      0F0h
                jr      nc, ignore_system_command_greater_or_eq_0xF0 ; if (a >= 0xf0) jmp loc_1029
system_command_less_than_0xF0
                scf                     ; Carry flag set, H and N cleared
                pop     hl
                ei
                ret
; ---------------------------------------------------------------------------

ignore_system_command_greater_or_eq_0xF0:
                                        ; CODE XREF: system_isMidiDataAvailable+1D↑j
                inc     l
                ld      a, l
                ld      (bufferFromSystem_LastReadByteIndex), a
                pop     hl
                ei
                jr      system_isMidiDataAvailable
; End of function system_isMidiDataAvailable


; =============== S U B R O U T I N E =======================================

; void -> output into a-reg / c-flag=The 9th bit of system data / z-flag=has data

system_read9BitMidiDataByte:            ; CODE XREF: RESTART_IN_THRU_MODE:loc_2B7↑p
                                        ; readMidiDataWithTimeout:midi_data_pending↑p ...
                ld      a, (bufferFromSystem_HasDataInBuffer)
                bit     7, a
                jr      z, loc_103B     ; if (bit 7 of a == 0) jmp loc_103B
                xor     a
                ret
; ---------------------------------------------------------------------------

loc_103B:                               ; CODE XREF: system_read9BitMidiDataByte+5↑j
                di
                push    hl
                or      0FFh
                ld      hl, (bufferFromSystem_LastReadByteIndex)
                ld      h, 0F1h         ; hl = &bufferAFromSystem[bufferFromSystem_LastReadByteIndex]
                ld      a, (hl)         ; a = bufferAFromSystem[bufferFromSystem_LastReadByteIndex]
                rrca
                ld      h, 0F2h         ; hl = &bufferBFromSystem[bufferFromSystem_LastReadByteIndex]
                ld      a, (hl)         ; a = bufferBFromSystem[bufferFromSystem_LastReadByteIndex]
                push    af
                inc     l
                ld      a, l
                ld      (bufferFromSystem_LastReadByteIndex), a
                ld      a, (bufferFromSystem_IndexForNextWriteByte)
                cp      l
                jr      nz, loc_105A    ; if (bufferFromSystem_IndexForNextWriteByte != bufferFromSystem_LastReadByteIndex) jmp loc_105A
                ld      hl, bufferFromSystem_HasDataInBuffer
                set     7, (hl)

loc_105A:                               ; CODE XREF: system_read9BitMidiDataByte+21↑j
                ld      a, 5
enable write interrupt on group 1
                out     (PIU_PCR), a    ; 0x05 = 0 000 010 1
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 010 - Port 2 bit select: bit2
                                        ; bit 0: 1 - bit set/reset: set
                pop     af
                pop     hl
                ei
                ret     nc
                push    af
                and     0F0h
                cp      0F0h
                jr      z, loc_106B     ; if (a == 0xf0) jmp loc_106B
                pop     af
                ret
; ---------------------------------------------------------------------------

loc_106B:                               ; CODE XREF: system_read9BitMidiDataByte+35↑j
                pop     af
                jr      system_read9BitMidiDataByte
; End of function system_read9BitMidiDataByte


; =============== S U B R O U T I N E =======================================


initializePIUOutput:                    ; CODE XREF: reset_PIU_device+4↑p
                                        ; send9bitDataToSystem_with_timeout:timeout↓p
                xor     a
                ld      (bufferToSystem_LastReadByteIndex), a
                ld      (bufferToSystem_IndexForNextWriteByte), a
                ld      (system_CommandInProgress), a
                ld      a, 0Ah
                ld      (runningCommandOnSystemInTimerCountdown), a
                ld      a, 80h
                ld      (bufferToSystem_HasDataInBuffer), a ; bufferToSystem_HasDataInBuffer = no_data
clear the "unused data bit" (group 0 - I/O bit 4)
                ld      a, 8
                out     (PIU_PCR), a    ; 0x08 = 0 000 100 0
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 100 - Port 2 bit select: bit4
                                        ; bit 0: 0 - bit set/reset: reset
set "bit9" to zero
                ld      a, 0Ah
                out     (PIU_PCR), a    ; 0x0A = 0 000 101 0
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 101 - Port 2 bit select: bit5
                                        ; bit 0: 0 - bit set/reset: reset
disable group0 write interrupt
                ld      a, 0Ch
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0x0C = 0 000 110 0
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 110 - Port 2 bit select: bit6
                                        ; bit 0: 0 - bit set/reset: reset
                ret
; End of function initializePIUOutput


; =============== S U B R O U T I N E =======================================


sendNextValueToSystemDuringInterruptHandler:
                                        ; CODE XREF: sendOrReceiveNextValueToFromSystemDuringInterruptHandler+4↑j
                ld      hl, (bufferToSystem_LastReadByteIndex)
                ld      h, 0F3h         ; hl = &bufferAToSystem[bufferToSystem_LastReadByteIndex]
                ld      a, 0Ah
                or      (hl)
set "bit9" to bufferAToSystem[bufferToSystem_LastReadByteIndex]
                out     (PIU_PCR), a    ; out PIU_PORT_3, bufferAToSystem[bufferToSystem_LastReadByteIndex] | 0x0A = 0 000 101 0
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 101 - Port 2 bit select: bit5
                                        ; bit 0: 0 - bit set/reset: reset
                inc     h               ; hl = &bufferBToSystem[bufferToSystem_LastReadByteIndex]
                ld      a, (hl)
                out     (PIU_PORT0), a  ; out PIU_PORT_0, bufferBToSystem[bufferToSystem_LastReadByteIndex]
                inc     l
                ld      a, l
                ld      (bufferToSystem_LastReadByteIndex), a ; bufferToSystem_LastReadByteIndex++
                ld      a, (bufferToSystem_IndexForNextWriteByte)
                cp      l
                ret     nz              ; if (bufferToSystem_IndexForNextWriteByte != bufferToSystem_LastReadByteIndex) return
                ld      hl, bufferToSystem_HasDataInBuffer
                set     7, (hl)         ; bufferToSystem_HasDataInBuffer |= 0x80 = no-data
                ld      a, 0Ch
disable write interrupts on group 0
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0x0C = 0 000 110 0
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 110 - Port 2 bit select: bit6
                                        ; bit 0: 0 - bit set/reset: reset
                ret
; End of function sendNextValueToSystemDuringInterruptHandler


; =============== S U B R O U T I N E =======================================


reportErrorIfNeeded:                    ; CODE XREF: readMidiDataWithTimeout+66↑p
                                        ; readMidiDataWithTimeout+DD↑p ...
                push    hl
                ld      hl, errorReport
                bit     0, (hl)
                pop     hl
                ret     z               ; if (errorReport is disabled) return
                push    bc
                ld      b, 1
                ld      c, a
                jr      send9bitDataToSystem_with_timeout
; End of function reportErrorIfNeeded


; =============== S U B R O U T I N E =======================================

; a = value

send_card_byte_to_System:               ; CODE XREF: send_card_bytes_to_System+F↓p
                push    bc
                ld      b, 1
                ld      c, a
                cp      0F0h
                jr      nc, send9bitDataToSystem_with_timeout ; if (a >= 0xf0) jmp send9bitDataToSystem_with_timeout
                cp      80h
                jr      c, send9bitDataToSystem_with_timeout ; if (a < 0x80) jmp send9bitDataToSystem_with_timeout
                xor     a
                ld      (system_CommandInProgress), a ; system_CommandInProgress = 0
                jr      send9bitDataToSystem_with_timeout
; End of function send_card_byte_to_System


; =============== S U B R O U T I N E =======================================


send_midi_byte_to_System_in_THRU_mode:  ; CODE XREF: RESTART_IN_THRU_MODE+2C↑p
                push    bc
                ld      b, 0
                ld      c, a
                xor     a
                ld      (system_CommandInProgress), a
                jr      send9bitDataToSystem_with_timeout
; End of function send_midi_byte_to_System_in_THRU_mode


; =============== S U B R O U T I N E =======================================

; a = byte to send

send_midi_byte_to_System:               ; CODE XREF: readMidiDataWithTimeout+3F↑p
                                        ; send_midi_byte+1A↑p ...
                push    bc
                ld      b, 0
                ld      c, a
                cp      0F8h
                jr      nc, send9bitDataToSystem_with_timeout ; if (a >= 0xf8) jmp send9bitDataToSystem_with_timeout
                cp      80h
                jr      c, send9bitDataToSystem_with_timeout ; if (a < 0x80) jmp send9bitDataToSystem_with_timeout
                cp      0F1h
                jr      c, send_midi_command_byte_to_System ; if (a < 0xf1) jmp send_midi_command_byte_to_System
                push    hl
                ld      hl, system_CommandInProgress
                ld      (hl), 0         ; system_CommandInProgress = 0
                jr      send9bitDataToSystem_with_timeout2
; End of function send_midi_byte_to_System


; =============== S U B R O U T I N E =======================================


send_midi_command_byte_to_System:       ; CODE XREF: send_midi_byte_to_System+E↑j
                ld      (system_CommandInProgress), a
; End of function send_midi_command_byte_to_System


; =============== S U B R O U T I N E =======================================

; bc = 9bit data

send9bitDataToSystem_with_timeout:      ; CODE XREF: reportErrorIfNeeded+C↑j
                                        ; send_card_byte_to_System+6↑j ...
                push    hl

send9bitDataToSystem_with_timeout2:     ; CODE XREF: send_midi_byte_to_System+16↑j
                ld      a, 3
                ld      (sendDataToSystemTimoutCountdown), a

loc_10FC:                               ; CODE XREF: send9bitDataToSystem_with_timeout+1C↓j
                ei
                ld      a, (sendDataToSystemTimoutCountdown)
                cp      4
                jr      nc, timeout     ; if (a >= 0x04) jmp loc_1126
                di
                ld      hl, (bufferToSystem_IndexForNextWriteByte)
                ld      h, 0F3h         ; hl = &bufferAToSystem[bufferToSystem_IndexForNextWriteByte]
                ld      (hl), b
                inc     h
                ld      (hl), c         ; hl = &bufferBToSystem[bufferToSystem_IndexForNextWriteByte]
                inc     l
                ld      a, (bufferToSystem_LastReadByteIndex)
                cp      l
                jr      z, loc_10FC     ; if (bufferToSystem_LastReadByteIndex == bufferToSystem_IndexForNextWriteByte) jmp loc_10FC
---
                ld      a, l
                ld      (bufferToSystem_IndexForNextWriteByte), a ; bufferToSystem_IndexForNextWriteByte++
                ld      hl, bufferToSystem_HasDataInBuffer
                res     7, (hl)
                ld      a, 0Dh
enable write interrupts on group 0
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0x0D = 0 000 110 1
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 110 - Port 2 bit select: bit6
                                        ; bit 0: 1 - bit set/reset: set
                ei
                pop     hl
                pop     bc
                or      a
                ret
; ---------------------------------------------------------------------------

timeout:                                ; CODE XREF: send9bitDataToSystem_with_timeout+C↑j
                call    initializePIUOutput
                ei
                ld      a, 0F0h
                call    reportErrorIfNeeded
                pop     hl
                pop     bc
                scf
                ret
; End of function send9bitDataToSystem_with_timeout


; =============== S U B R O U T I N E =======================================

; b = number of bytes / hl=pointer to midi data

sendMidiResponse_to_System:             ; CODE XREF: conditional_send_midi_byte_to_System+1C↑p
                ld      a, (hl)
                cp      0F7h
                jr      c, loc_1150     ; if (a < 0xf7) jmp loc_1150
                jr      z, send_F7_to_System_if_needed_0 ; if (a == 0xf7) jmp sub_1176
                cp      0FFh
                jr      z, loc_1144     ; if (a == 0xff) jmp loc_1144
                cp      0FEh
                jr      z, loc_114A     ; if (a == 0xfe) jmp loc_114A

successReturn:                          ; CODE XREF: sendMidiResponse_to_System+1F↓j
                                        ; sendMidiResponse_to_System+41↓j ...
                xor     a
                ret
; ---------------------------------------------------------------------------

loc_1144:                               ; CODE XREF: sendMidiResponse_to_System+9↑j
                call    send_F0_43_75_70_to_System
                jr      nc, endBigIf
                ret
; ---------------------------------------------------------------------------

loc_114A:                               ; CODE XREF: sendMidiResponse_to_System+D↑j
                call    send_F0_43_75_71_to_System
                jr      nc, endBigIf
                ret
; ---------------------------------------------------------------------------

loc_1150:                               ; CODE XREF: sendMidiResponse_to_System+3↑j
                cp      80h
                jr      c, successReturn ; if (a < 0x80) jmp loc_1142
                call    send_F7_to_System_if_needed_0
                ret     c
                ld      a, (system_CommandInProgress)
                cp      (hl)
                jr      z, endBigIf     ; if (a == (hl)) jmp loc_1163
                ld      a, (hl)
                call    send_midi_byte_to_System
                ret     c

endBigIf:                               ; CODE XREF: sendMidiResponse_to_System+14↑j
                                        ; sendMidiResponse_to_System+1A↑j ...
                inc     hl
                dec     b
                jr      z, loc_116F

loop:                                   ; CODE XREF: sendMidiResponse_to_System+3A↓j
                ld      a, (hl)
                inc     hl
                call    send_midi_byte_to_System
                ret     c
                djnz    loop

loc_116F:                               ; CODE XREF: sendMidiResponse_to_System+32↑j
                ld      a, 0Ah
                ld      (runningCommandOnSystemInTimerCountdown), a
                jr      successReturn
; End of function sendMidiResponse_to_System


; =============== S U B R O U T I N E =======================================


send_F7_to_System_if_needed_0:          ; CODE XREF: sendMidiResponse_to_System+5↑j
                                        ; sendMidiResponse_to_System+21↑p ...
                ld      a, (system_CommandInProgress)
                cp      0F0h
                jr      z, loc_1181     ; if (a == 0xf0) jmp loc_1181
                cp      0FEh
                jr      c, successReturn ; if (a < 0xfe) jmp loc_1142

loc_1181:                               ; CODE XREF: send_F7_to_System_if_needed_0+5↑j
                ld      a, 0F7h
                jp      send_midi_byte_to_System
; End of function send_F7_to_System_if_needed_0


; =============== S U B R O U T I N E =======================================


send_F0_43_75_70_to_System:             ; CODE XREF: sendMidiResponse_to_System:loc_1144↑p
                ld      a, (system_CommandInProgress)
                cp      0FFh
                ret     z               ; if (a == 0xff) return
                call    send_F7_to_System_if_needed_0
                ret     c
                ld      a, 0F0h
                call    send_midi_byte_to_System
                ret     c
                ld      a, 43h ; 'C'
                call    send_midi_byte_to_System
                ret     c
                ld      a, 75h ; 'u'
                call    send_midi_byte_to_System
                ret     c
                ld      a, 70h ; 'p'
                call    send_midi_byte_to_System
                ret     c
                ld      a, 0FFh
                ld      (system_CommandInProgress), a
                ret
; End of function send_F0_43_75_70_to_System


; =============== S U B R O U T I N E =======================================


send_F0_43_75_71_to_System:             ; CODE XREF: sendMidiResponse_to_System:loc_114A↑p
                ld      a, (system_CommandInProgress)
                cp      0FEh
                ret     z               ; if (a == 0xfe) return
                call    send_F7_to_System_if_needed_0
                ret     c
                ld      a, 0F0h
                call    send_midi_byte_to_System
                ret     c
                ld      a, 43h ; 'C'
                call    send_midi_byte_to_System
                ret     c
                ld      a, 75h ; 'u'
                call    send_midi_byte_to_System
                ret     c
                ld      a, 71h ; 'q'
                call    send_midi_byte_to_System
                ret     c
                ld      a, 0FEh
                ld      (system_CommandInProgress), a
                ret
; End of function send_F0_43_75_71_to_System


; =============== S U B R O U T I N E =======================================

; b = number of bytes / hl = ptr to bytes to send

send_card_bytes_to_System:              ; CODE XREF: SOFT_REBOOT+55↑p
                                        ; RESTART_IN_THRU_MODE+22↑p ...
                ld      a, (hl)
                cp      80h
                jr      c, writeSuccess ; if (a < 0x80) jmp midi_data_byte
                cp      0F0h
                jr      nc, writeSuccess ; if (a >= 0xf0) jmp midi_data_byte
                call    send_F7_to_System_if_needed
                ret     c               ; return on error

loc_11E3:                               ; CODE XREF: send_card_bytes_to_System+13↓j
                ld      a, (hl)
                inc     hl
                call    send_card_byte_to_System
                ret     c               ; return on error
                djnz    loc_11E3
---
                ld      a, 0Ah
                ld      (runningCommandOnSystemInTimerCountdown), a

writeSuccess:                           ; CODE XREF: send_card_bytes_to_System+3↑j
                                        ; send_card_bytes_to_System+7↑j ...
                xor     a
                ret
; End of function send_card_bytes_to_System


; =============== S U B R O U T I N E =======================================

; void -> void

send_F7_to_System_if_needed:            ; CODE XREF: send_card_bytes_to_System+9↑p
                ld      a, (system_CommandInProgress)
                cp      0F0h
                jr      z, loc_11FD     ; if (a == 0xf0) jmp loc_11FD
                cp      0FEh
                jr      c, writeSuccess ; if (a < 0xfe) jmp loc_11F0

loc_11FD:                               ; CODE XREF: send_F7_to_System_if_needed+5↑j
                ld      a, 0F7h
                jp      send_midi_byte_to_System
; End of function send_F7_to_System_if_needed


; =============== S U B R O U T I N E =======================================

; void -> void

send_F7_to_System_if_timed_out:         ; CODE XREF: doesMidiDataPacketNeedAdditionalData_MUSIC_MODE+4↑p
                ld      a, (runningCommandOnSystemInTimerCountdown)
                cp      0Bh
                ret     c               ; if (a < 0x0b) return
-- oops, we have timed out
                ld      a, 0Ah
                ld      (runningCommandOnSystemInTimerCountdown), a
                ld      a, (system_CommandInProgress)
                cp      0FEh
                jr      nc, commandInProgress_is_0xFE_or_0xFF ; if (a >= 0xfe) jmp loc_121D
                cp      0F0h
                jr      z, commandInProgress_is_0xF0 ; if (a == 0xf0) jmp locret_121C
                xor     a
                ld      (system_CommandInProgress), a

commandInProgress_is_0xF0:              ; CODE XREF: send_F7_to_System_if_timed_out+14↑j
                ret
; ---------------------------------------------------------------------------

commandInProgress_is_0xFE_or_0xFF:      ; CODE XREF: send_F7_to_System_if_timed_out+10↑j
                ld      a, 0F7h
                jp      send_midi_byte_to_System
; End of function send_F7_to_System_if_timed_out


; =============== S U B R O U T I N E =======================================


restartIntoCustomMem:                   ; CODE XREF: processMusicCardMessageDebugWriteToMemory_readByte2+F↑j
                ld      a, 0E6h
                ld      (outgoingMusicCardMessageData), a
                ld      b, 1
                ld      hl, outgoingMusicCardMessageData
                call    send_card_bytes_to_System

loc_122F:                               ; CODE XREF: restartIntoCustomMem+12↓j
                ld      a, (bufferToSystem_HasDataInBuffer)
                bit     7, a
                jr      z, loc_122F     ; if (bit 7 of a == 0) jmp loc_122F
                di
                call    initInterruptHandler
                ld      a, 30h ; '0'
                ld      c, 14h
                call    sendToYM2151_with_disabled_interrupts ; set ?four different field?
                ld      a, 0
                out     (MIDI_PORT_2), a ; Command: 0x00 = 00000000 => Transmit Disable / Receive Disable
                                        ; bit0: 1 = Transmit Enable: Disable
                                        ; bit1: 0 = ^DTR Pin Control: ^DTR=1
                                        ; bit2: 1 = Receive Enable: Disable
                                        ; bit3: 0 = Send Break: TxDATA Pin Normal Operation
                                        ; bit4: 0 = Error Clear: No Operation
                                        ; bit5: 0 = ^RTS Pin Control: ^RTS=1
                                        ; bit6: 0 = Software Reset: No Operation
                                        ; bit7: 0 = Enter Hunt Phase: No Hunt Operation
                ld      a, 0C3h
                ld      (byte_FFFC), a
                ld      hl, 0C003h
                ld      (word_FFFD), hl ; the the interrupt handler to 0xC003
                ld      sp, 0FFFCh      ; reset the stack
                ld      a, 0Dh
enable write interrupts on group 0
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0x0D = 0 000 110 1
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 110 - Port 2 bit select: bit6
                                        ; bit 0: 1 - bit set/reset: set

loc_1257:                               ; CODE XREF: restartIntoCustomMem+39↓j
                in      a, (PIU_PORT2)
                bit     3, a            ; loop until the interrupt request group 0 was set
                jr      z, loc_1257     ; if (bit 3 of a == 0) jmp loc_1257
                ld      a, 0Ch
disable write interrupts on group 0
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0x0C = 0 000 110 0
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 110 - Port 2 bit select: bit6
                                        ; bit 0: 0 - bit set/reset: reset
                ld      a, 4
disable write interrupt on group 1
                out     (PIU_PCR), a    ; out     (PIU_PORT_3), 0x04 = 0 000 010 0
                                        ;
                                        ; Command Select: 0 - Bit manipulation
                                        ; bits 6&5&4: unused
                                        ; bit 3&2&1: 010 - Port 2 bit select: bit2
                                        ; bit 0: 0 - bit set/reset: reset
                jp      byte_C000
; End of function restartIntoCustomMem


; =============== S U B R O U T I N E =======================================

; hl=char* to message -> void

logErrorOrSuccess:                      ; CODE XREF: SOFT_REBOOT+3D↑p
                                        ; SOFT_REBOOT+5E↑p ...
                xor     a
                ret
; End of function logErrorOrSuccess


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 32

setNodeParameterNodeNumber:             ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                cp      10h
                ret     nc              ; if (a >= 0x10) return
                ld      (nodeNumber), a
                jp      ym_key_off_on_all_channels
; End of function setNodeParameterNodeNumber


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 33

setNodeParameterMemoryProtection:       ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                cp      2
                ret     nc              ; if (a >= 0x02) return
                ld      (memoryProtection), a
                ret
; End of function setNodeParameterMemoryProtection


; =============== S U B R O U T I N E =======================================

; c = value

storeActiveConfigurationToCustomConfiguration:
                                        ; CODE XREF: processSysExCmd_StoreRequest_StoreConfigurationData+34↓p
                ld      a, c
                cp      10h
                ret     nc              ; if (a >= 0x10) return
---
                ld      ix, activeInstrumentParameters
                ld      b, 8
                ld      de, activeConfiguration.instrumentConfigurations

loc_1289:                               ; CODE XREF: storeActiveConfigurationToCustomConfiguration+1C↓j
                push    bc
                push    ix
                pop     hl
                ld      bc, 10h
                ldir                    ; for(i=0; i<8; i++) { memcpy(&activeConfiguration.instrumentConfigurations[i], activeInstrumentParameters[i].instrumentConfiguration, 0x10); }
                ld      bc, 80h
                add     ix, bc
                pop     bc
                djnz    loc_1289
---
                ld      a, c
                call    getConfigurationData
                ex      de, hl
                ld      hl, activeConfiguration
                ld      bc, 0A0h
                ldir                    ; memcpy(getConfigurationData(value), &activeConfiguration, 0xA0)
                ret
; End of function storeActiveConfigurationToCustomConfiguration


; =============== S U B R O U T I N E =======================================

; c=newMidiChannel / iy=ptr to InstrumentParameters

setInstrumentParameter_MidiChannelNumber:
                                        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                cp      16
                ret     nc              ; if (a >= 16) return
---
                ld      (iy+InstrumentParameters.instrumentConfiguration.midiChannel), a
                push    ix
                ld      (iy+InstrumentParameters.overflowToMidiOut), 0
                ld      a, (chainMode)
                and     a
                jr      z, chainModeOFF
chainModeON:
                ld      a, c
                ld      b, 8
                ld      de, 80h
                ld      ix, activeInstrumentParameters

loc_12C5:                               ; CODE XREF: setInstrumentParameter_MidiChannelNumber+24↓j
                cp      (ix+InstrumentParameters.instrumentConfiguration.midiChannel)
                jr      z, midiChannelFound ; if (newMidiChannel == (ix+InstrumentParameters.instrumentConfiguration.midiChannel)) jmp loc_12CE
                add     ix, de
                djnz    loc_12C5

midiChannelFound:                       ; CODE XREF: setInstrumentParameter_MidiChannelNumber+20↑j
                ld      (ix+InstrumentParameters.overflowToMidiOut), 1
                jr      loc_12DD
; ---------------------------------------------------------------------------
if (newMidiChannel == (InstrumentParameters[ix].instrumentConfiguration.midiChannel)) {
    InstrumentParameters[ix].overflowToMidiOut = 0;
}

loc_12D4:                               ; CODE XREF: setInstrumentParameter_MidiChannelNumber+37↓j
                cp      (ix+InstrumentParameters.instrumentConfiguration.midiChannel)
                jr      nz, loc_12DD    ; if (a != (ix+InstrumentParameters.instrumentConfiguration.midiChannel)) jmp loc_12DD
                ld      (ix+InstrumentParameters.overflowToMidiOut), 0

loc_12DD:                               ; CODE XREF: setInstrumentParameter_MidiChannelNumber+2A↑j
                                        ; setInstrumentParameter_MidiChannelNumber+2F↑j
                add     ix, de
                djnz    loc_12D4

chainModeOFF:                           ; CODE XREF: setInstrumentParameter_MidiChannelNumber+11↑j
                pop     ix
                jp      setDefaultInstrumentParameters
; End of function setInstrumentParameter_MidiChannelNumber


; =============== S U B R O U T I N E =======================================

; c=0x00..0x30 instrument nr in CustomBankA, 0x31..0x5F instrument nr in CustomBankB / iy=ptr to InstrumentParameters -> c-flag for errors

storeInstrumentParametersToCustomBank:  ; CODE XREF: processSysExCmd_StoreRequest_StoreVoiceData+3D↓p
                ld      a, c
                cp      60h ; '`'
                ret     nc              ; if (a >= 0x60) return
                call    getCustomVoiceDefinition
                ex      de, hl
                push    iy
                pop     hl
                ld      bc, 10h
                add     hl, bc          ; hl = &(ptrInstrumentParameters.voiceDefinition)
                ld      bc, 40h ; '@'
                ldir                    ; memcpy(getCustomVoiceDefinition(value), ptrInstrumentParameters.voiceDefinition, 0x40)
                ret
; End of function storeInstrumentParametersToCustomBank


; =============== S U B R O U T I N E =======================================

; c = MidiCmdByte / d = MidiDataByte 0 / e = MidiDataByte 1 / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand:              ; CODE XREF: ym2151_JumpToExecuteMidiCommand↑j
                ld      a, c
                rrca
                rrca
                rrca
                rrca
                and     7               ; a = (MidiCmdByte >> 4) & 7
                ld      hl, executeMidiCommandLookup
                jp      atomicTableLookupCall_wrapped_musicProcessing ; switch 8 cases
; ---------------------------------------------------------------------------
c = MidiCmdByte (0xAX, 0xFX) / d = MidiDataByte 0 / e = MidiDataByte 1 / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_Ignore:       ; CODE XREF: ym2151_executeMidiCommand+A↑j
                                        ; DATA XREF: ym2151_executeMidiCommand:executeMidiCommandLookup↓o
                ret                     ; jumptable 00001305 cases 2,7
; ---------------------------------------------------------------------------
c = MidiCmdByte (0xDX) / d = value / e = unused / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_AfterTouch:   ; CODE XREF: ym2151_executeMidiCommand+A↑j
                                        ; DATA XREF: ym2151_executeMidiCommand:executeMidiCommandLookup↓o
                ld      c, d            ; jumptable 00001305 case 5
                jp      setInstrumentParameter_AfterTouch
; ---------------------------------------------------------------------------
c = MidiCmdByte (0x8X) / d = note number / e = key velocity (ignored) / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_NoteOFF:      ; CODE XREF: ym2151_executeMidiCommand+A↑j
                                        ; DATA XREF: ym2151_executeMidiCommand:executeMidiCommandLookup↓o
                ld      e, 0            ; jumptable 00001305 case 0
c = MidiCmdByte (0x9X) / d = note number / e = key velocity / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_NoteON:       ; CODE XREF: ym2151_executeMidiCommand+A↑j
                                        ; DATA XREF: ym2151_executeMidiCommand:executeMidiCommandLookup↓o
                jp      executeMidiCommand_NoteONOFF ; jumptable 00001305 case 1
; ---------------------------------------------------------------------------
c = MidiCmdByte (0xCX) / d = voice number (0-47) / e = unused / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_VoiceChange:  ; CODE XREF: ym2151_executeMidiCommand+A↑j
                                        ; DATA XREF: ym2151_executeMidiCommand:executeMidiCommandLookup↓o
                ld      c, d            ; jumptable 00001305 case 4
                call    setInstrumentParameter_VoiceNumber
                jp      logErrorOrSuccess
; ---------------------------------------------------------------------------
c = MidiCmdByte (0xBX) / d = control number / e = control value / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_ControlChange:
                                        ; CODE XREF: ym2151_executeMidiCommand+A↑j
                                        ; DATA XREF: ym2151_executeMidiCommand:executeMidiCommandLookup↓o
                ld      c, e            ; jumptable 00001305 case 3
                ld      a, d
                cp      40h ; '@'
                jr      nc, loc_133C    ; if (a >= 0x40) jmp loc_133C
                cp      1
                jp      z, setInstrumentParameterModulationWheel ; if (a == 0x01) jmp setInstrumentParameterModulationWheel
                cp      2
                jp      z, setInstrumentParameterBreathController ; if (a == 0x02) jmp setInstrumentParameterBreathController
                cp      4
                jp      z, setInstrumentParameterFootController ; if (a == 0x04) jmp setInstrumentParameterFootController
                cp      5
                jr      z, ym2151_executeMidiCommand_ControlChange_PortamentoTime ; if (a == 0x05) jmp ym2151_executeMidiCommand_ControlChange_PortamentoTime
                cp      7
                jp      z, setInstrumentParameterVolume ; if (a == 0x07) jmp setInstrumentParameterVolume
                cp      0Ah
                jr      z, ym2151_executeMidiCommand_ControlChange_PanControl ; if (a == 0x0a) jmp ym2151_executeMidiCommand_ControlChange_PanControl
                ret
; ---------------------------------------------------------------------------

loc_133C:                               ; CODE XREF: ym2151_executeMidiCommand+22↑j
                cp      40h ; '@'
                jp      z, setInstrumentParameterSustainOnOff ; if (a == 0x40) jmp setInstrumentParameterSustainOnOff
                cp      41h ; 'A'
                jp      z, setInstrumentParameterPortamentoOnOff ; if (a == 0x41) jmp setInstrumentParameterPortamentoOnOff
                cp      42h ; 'B'
                jp      z, setInstrumentParameterSostenutoOnOff ; if (a == 0x42) jmp setInstrumentParameterSostenutoOnOff
                cp      7Bh ; '{'
                jp      z, setInstrumentParameter_AllNotesOFF ; if (a == 0x7b) jmp setInstrumentParameter7B
                cp      7Eh ; '~'
                jr      z, ym2151_executeMidiCommand_ControlChange_InstrumentParameter_MonoMode ; if (a == 0x7e) jmp ym2151_executeMidiCommand_ControlChange_InstrumentParameter_MonoMode
                cp      7Fh
                jr      z, ym2151_executeMidiCommand_ControlChange_InstrumentParameter_PolyMode ; if (a == 0x7f) jmp ym2151_executeMidiCommand_ControlChange_InstrumentParameter_PolyMode
                ret
; ---------------------------------------------------------------------------
c = control value / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_ControlChange_PortamentoTime:
                                        ; CODE XREF: ym2151_executeMidiCommand+35↑j
                call    setInstrumentParameter_PortamentoTime
                jp      logErrorOrSuccess
; ---------------------------------------------------------------------------
c = control value / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_ControlChange_PanControl:
                                        ; CODE XREF: ym2151_executeMidiCommand+3E↑j
                call    setInstrumentParameter_Pan
                jp      logErrorOrSuccess
; ---------------------------------------------------------------------------
c = control value / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_ControlChange_InstrumentParameter_MonoMode:
                                        ; CODE XREF: ym2151_executeMidiCommand+57↑j
                call    setInstrumentParameter_MonoMode
                jp      logErrorOrSuccess
; ---------------------------------------------------------------------------
c = control value / iy=ptr to InstrumentParameters

ym2151_executeMidiCommand_ControlChange_InstrumentParameter_PolyMode:
                                        ; CODE XREF: ym2151_executeMidiCommand+5B↑j
                call    setInstrumentParameter_PolyMode
                jp      logErrorOrSuccess
; ---------------------------------------------------------------------------
executeMidiCommandLookup:               ; DATA XREF: ym2151_executeMidiCommand+7↑o
                dw ym2151_executeMidiCommand_NoteOFF ; jump table for switch statement
                dw ym2151_executeMidiCommand_NoteON
                dw ym2151_executeMidiCommand_Ignore
                dw ym2151_executeMidiCommand_ControlChange
                dw ym2151_executeMidiCommand_VoiceChange
                dw ym2151_executeMidiCommand_AfterTouch
                dw executeMidiCommand_PitchBender
                dw ym2151_executeMidiCommand_Ignore
; End of function ym2151_executeMidiCommand


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 34

setNodeParameterActiveConfigurationNr:  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                cp      14h
                ret     nc              ; if (a >= 0x14) return
                ld      (activeConfigurationNr), a
                call    getConfigurationData
                ld      de, activeConfiguration
                ld      bc, 0A0h
                ldir                    ; memcpy(&NodeParameterName0, getConfigurationData(value), 0xA0)
; End of function setNodeParameterActiveConfigurationNr


; =============== S U B R O U T I N E =======================================


proc_1393_called_for_Reboot:            ; CODE XREF: SOFT_REBOOT+2E↑p
                                        ; processSysExCmd_NodeMessage_SetConfiguration1+2E↓p
                ld      a, (activeConfiguration.lfoSpeed)
                ld      c, a
                push    bc
                ld      a, (activeConfiguration.amplitudeModulationDepth)
                ld      c, a
                push    bc
                ld      a, (activeConfiguration.pitchModulationDepth)
                ld      c, a
                push    bc
                ld      a, (activeConfiguration.lfoWaveForm)
                ld      c, a
                push    bc
                call    sub_1405

loc_13AA:                               ; CODE XREF: proc_1393_called_for_Reboot+29↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                call    loadInstrumentParameters_InstrumentConfiguration
                ld      de, -10h
                add     ix, de
                pop     bc
                dec     c
                djnz    loc_13AA
                pop     bc
                call    setNodeParameterLFOWaveForm
                pop     bc
                call    setNodeParameterPitchModDepth
                pop     bc
                call    setNodeParameterAmpModDepth
                pop     bc
                call    setNodeParameterLFOSpeed
                jp      jmpStopMusicProcessing
; End of function proc_1393_called_for_Reboot


; =============== S U B R O U T I N E =======================================


sub_13D1:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration2+61↓p
                call    sub_1405

loc_13D4:                               ; CODE XREF: sub_13D1+15↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                call    setInstrumentParameter00_05_safe
                ld      de, -10h
                add     ix, de
                pop     bc
                dec     c
                djnz    loc_13D4
                jp      jmpStopMusicProcessing
; End of function sub_13D1


; =============== S U B R O U T I N E =======================================


proc_13EB_called_for_SelectMusicCardMode:
                                        ; CODE XREF: SOFT_REBOOT+2A↑p
                                        ; setNodeParameterChainMode+56↑j
                call    sub_1405

loc_13EE:                               ; CODE XREF: proc_13EB_called_for_SelectMusicCardMode+15↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                call    setInstrumentParameter00to0A_safe
                ld      de, -10h
                add     ix, de
                pop     bc
                dec     c
                djnz    loc_13EE
                jp      jmpStopMusicProcessing
; End of function proc_13EB_called_for_SelectMusicCardMode


; =============== S U B R O U T I N E =======================================

; void / returns b=8, c=7, ix=0xE3A0

sub_1405:                               ; CODE XREF: proc_1393_called_for_Reboot+14↑p
                                        ; sub_13D1↑p ...
                call    jmpStartMusicProcessing
                ld      a, (activeConfiguration.noteNumberReceptionMode)
                ld      c, a
                call    setNodeParameterNoteNrReceptionMode
-------
                ld      b, 8
                ld      c, 0            ; tmpInstrumentParameterNr = 0
                ld      de, 0

loc_1416:                               ; CODE XREF: sub_1405+29↓j
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy              ; iy = getActiveInstrumentParameters(tmpInstrumentParameterNr)
                ld      a, c
                call    getYmChannelData
                push    hl
                pop     ix              ; ix = getMemoryLocation2(tmpInstrumentParameterNr)
                ld      (iy+InstrumentParameters.channelMask), d ; channelMask = 0
                ld      (ix+YmChannelData.channel0_ptrInstrumentParameters), e ; channel0_memA_byte1 = 0
                ld      (ix+ YmChannelData.channel0_ptrInstrumentParameters+1 ), d ; channel0_memA_byte2 = 0
                inc     c               ; tmpInstrumentParameterNr++
                djnz    loc_1416
-------
                ld      a, (masterTune)
                ld      c, a
                call    setNodeParameterMasterTune
                ld      a, 0
                ld      c, 0Fh          ; setNoiseEnable
                call    sendToYM2151_no_interrupts_allowed ; NoiseEnable=0 / NoiseFReQuency=0
                ld      b, 8
                ld      c, 7
                ld      ix, 0E3A0h      ; activeConfiguration.instrumentConfigurations[7]
                ret
; End of function sub_1405


; =============== S U B R O U T I N E =======================================

; ix = instrumentConfigurationData to copy / iy = ptr InstrumentParameters

loadInstrumentParameters_InstrumentConfiguration:
                                        ; CODE XREF: proc_1393_called_for_Reboot+1F↑p
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1+45↓p
                call    jmpStartMusicProcessing
                push    ix
                push    ix
                pop     hl              ; hl = ix
                push    iy
                pop     de              ; de = ptrInstrumentParameters
                ld      bc, 10h
                ldir                    ; memcpy(ptrInstrumentParameters.instrumentConfiguration, ix, 0x10)
                ld      a, (activeConfiguration.combineMode)
                ld      c, a
                push    bc
                ld      c, 0
                call    setNodeParameterCombineMode
                call    setInstrumentParameter_ForceRefreshOfParam_00_05
                pop     bc
                call    setNodeParameterCombineMode
                jp      pop_ix_jmp_StopMusicProcessing
; End of function loadInstrumentParameters_InstrumentConfiguration


; =============== S U B R O U T I N E =======================================

; iy = ptrInstrumentParameters / ix = source data

setInstrumentParameter00_05_safe:       ; CODE XREF: sub_13D1+B↑p
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2+45↓p
                call    jmpStartMusicProcessing
                push    ix
                push    ix
                pop     hl
                push    iy
                pop     de
                ld      bc, 0Bh
                ldir                    ; memcpy(ptrInstrumentParameters.instrumentConfiguration, ix, 0x0B)
                call    setInstrumentParameter_ForceRefreshOfParam_00_05
                jp      pop_ix_jmp_StopMusicProcessing
; End of function setInstrumentParameter00_05_safe


; =============== S U B R O U T I N E =======================================

; iy = ptrInstrumentParameters / ix = source data

setInstrumentParameter00to0A_safe:      ; CODE XREF: proc_13EB_called_for_SelectMusicCardMode+B↑p
                call    jmpStartMusicProcessing
                push    ix
                push    ix
                pop     hl
                push    iy
                pop     de
                ld      bc, 0Bh
                ldir                    ; memcpy(ptrInstrumentParameters.instrumentConfiguration, ix, 0x0B)
                call    setInstrumentParameter_ForceRefreshOfParam_00to0A

pop_ix_jmp_StopMusicProcessing:         ; CODE XREF: loadInstrumentParameters_InstrumentConfiguration+21↑j
                                        ; setInstrumentParameter00_05_safe+13↑j
                pop     ix
                jp      jmpStopMusicProcessing
; End of function setInstrumentParameter00to0A_safe


; =============== S U B R O U T I N E =======================================


setInstrumentParameter_ForceRefreshOfParam_00_05:
                                        ; CODE XREF: loadInstrumentParameters_InstrumentConfiguration+1A↑p
                                        ; setInstrumentParameter00_05_safe+10↑p
                ld      a, 0
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                call    setInstrumentParameter
                ld      a, 5
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.voiceNumber)
                call    setInstrumentParameter
                jr      loc_14B3
; End of function setInstrumentParameter_ForceRefreshOfParam_00_05


; =============== S U B R O U T I N E =======================================

; iy = ptrInstrumentParameters

setInstrumentParameter_ForceRefreshOfParam_00to0A:
                                        ; CODE XREF: setInstrumentParameter00to0A_safe+10↑p
                ld      a, 0
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                call    setInstrumentParameter

loc_14B3:                               ; CODE XREF: setInstrumentParameter_ForceRefreshOfParam_00_05+10↑j
                ld      a, 1
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.midiChannel)
                call    setInstrumentParameter
                ld      a, 2
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitHigh)
                call    setInstrumentParameter
                ld      a, 3
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitLow)
                call    setInstrumentParameter
                ld      a, 6
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.detune)
                call    setInstrumentParameter
                ld      a, 7
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.octaveTranspose)
                call    setInstrumentParameter
                ld      a, 8
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.outputLevel)
                call    setInstrumentParameter
                ld      a, 9
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.pan)
                call    setInstrumentParameter
                ld      a, 0Ah
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.lfoEnable)
                call    setInstrumentParameter
                ret
; End of function setInstrumentParameter_ForceRefreshOfParam_00to0A


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 0

setNodeParameterName0:                  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                ld      (activeConfiguration.name), a
                ret
; End of function setNodeParameterName0


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 1

setNodeParameterName1:                  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                ld      (activeConfiguration.name+1), a
                ret
; End of function setNodeParameterName1


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 2

setNodeParameterName2:                  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                ld      (activeConfiguration.name+2), a
                ret
; End of function setNodeParameterName2


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 3

setNodeParameterName3:                  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                ld      (activeConfiguration.name+3), a
                ret
; End of function setNodeParameterName3


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 4

setNodeParameterName4:                  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                ld      (activeConfiguration.name+4), a
                ret
; End of function setNodeParameterName4


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 5

setNodeParameterName5:                  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                ld      (activeConfiguration.name+5), a
                ret
; End of function setNodeParameterName5


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 6

setNodeParameterName6:                  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                ld      (activeConfiguration.name+6), a
                ret
; End of function setNodeParameterName6


; =============== S U B R O U T I N E =======================================

; jumptable 00000141 case 7

setNodeParameterName7:                  ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                ld      (activeConfiguration.name+7), a
                ret
; End of function setNodeParameterName7


; =============== S U B R O U T I N E =======================================


setNodeParameterCombineMode:            ; CODE XREF: setNodeParameter+6↑j
                                        ; loadInstrumentParameters_InstrumentConfiguration+17↑p ...
                ld      a, c            ; jumptable 00000141 case 8
                cp      2
                ret     nc              ; if (a >= 0x02) return
                ld      (activeConfiguration.combineMode), a
                ret
; End of function setNodeParameterCombineMode


; =============== S U B R O U T I N E =======================================

; c = value (0=All, 1=Even, 2=Odd)

setNodeParameterNoteNrReceptionMode:    ; CODE XREF: setNodeParameter+6↑j
                                        ; sub_1405+7↑p
                                        ; DATA XREF: ...
                ld      a, c            ; jumptable 00000141 case 13
                cp      3
                ret     nc              ; if (a >= 0x03) return
                ld      (activeConfiguration.noteNumberReceptionMode), a
                jp      ym_key_off_on_all_channels
; End of function setNodeParameterNoteNrReceptionMode


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_NumberOfNotes:   ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                cp      9
                ret     nc              ; if (a >= 0x09) return
                push    af
                call    deallocateAssignedChannels
                pop     af
                ld      (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes), a
                and     a
                jr      z, sub_154F
                call    getFreeChannels
                ld      a, c
                cp      (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                jr      c, sub_1555     ; if (a < (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)) jmp loc_1555
                ld      d, (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                call    allocateChannels
                ld      (iy+InstrumentParameters.channelMask), c
; End of function setInstrumentParameter_NumberOfNotes


; =============== S U B R O U T I N E =======================================


sub_154F:                               ; CODE XREF: setInstrumentParameter_NumberOfNotes+D↑j
                                        ; sub_1555+23↓p ...
                call    setDefaultInstrumentParameters
                jp      setAllYmRegistersForAssignedChannels
; End of function sub_154F


; =============== S U B R O U T I N E =======================================


sub_1555:                               ; CODE XREF: setInstrumentParameter_NumberOfNotes+16↑j
                push    iy
                ld      b, 8
                ld      c, 0

loc_155B:                               ; CODE XREF: sub_1555+13↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                call    deallocateAssignedChannels
                pop     bc
                inc     c
                djnz    loc_155B
---
                pop     iy
                call    getFreeChannels
                ld      d, (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                call    allocateChannels
                ld      (iy+InstrumentParameters.channelMask), c
                call    sub_154F
---
                ld      b, 8
                ld      c, 0
                push    iy
                pop     de

loc_1582:                               ; CODE XREF: sub_1555+56↓j
                push    bc
                push    de
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                or      a
                sbc     hl, de
                jr      z, loc_15A8
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                and     a
                jr      z, loc_15A8
                call    getFreeChannels
                ld      d, (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                call    allocateChannels
                ld      (iy+InstrumentParameters.channelMask), c
                ld      (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes), e
                call    sub_154F

loc_15A8:                               ; CODE XREF: sub_1555+39↑j
                                        ; sub_1555+3F↑j
                pop     de
                pop     bc
                inc     c
                djnz    loc_1582
                ret
; End of function sub_1555


; =============== S U B R O U T I N E =======================================


deallocateAssignedChannels:             ; CODE XREF: setInstrumentParameter_NumberOfNotes+5↑p
                                        ; sub_1555+E↑p
                call    setDefaultInstrumentParameters
                ld      a, (iy+InstrumentParameters.channelMask)
                ld      b, 8
                ld      hl, 0
                ld      de, 4
                ld      ix, strangeMemory

loc_15C0:                               ; CODE XREF: deallocateAssignedChannels+1D↓j
                rrca
                jr      nc, loc_15C9
                ld      (ix+YmChannelData.channel0_ptrInstrumentParameters), l
                ld      (ix+ YmChannelData.channel0_ptrInstrumentParameters+1 ), h

loc_15C9:                               ; CODE XREF: deallocateAssignedChannels+13↑j
                add     ix, de
                djnz    loc_15C0
                ld      (iy+InstrumentParameters.channelMask), 0
                ld      (iy+InstrumentParameters.lastUsedChannel), 1
                ret
; End of function deallocateAssignedChannels


; =============== S U B R O U T I N E =======================================

; void -> b= inverted mask of channels / c = number of free channels

getFreeChannels:                        ; CODE XREF: setInstrumentParameter_NumberOfNotes+F↑p
                                        ; sub_1555+17↑p ...
                ld      a, 0
                ld      b, 8
                ld      hl, activeInstrumentParameters.channelMask
                ld      de, 80h         ; de = sizeof(InstrumentParameters)

loc_15E0:                               ; CODE XREF: getFreeChannels+C↓j
                or      (hl)
                add     hl, de
                djnz    loc_15E0
a = activeInstrumentParameters[0..7].channelMask ORed
                cpl                     ; CPL inverts all bits of A
                ld      d, a
                ld      b, 8
                ld      c, 0

loc_15EA:                               ; CODE XREF: getFreeChannels:loc_15EE↓j
                add     a, a
                jr      nc, loc_15EE
                inc     c

loc_15EE:                               ; CODE XREF: getFreeChannels+15↑j
                djnz    loc_15EA
                ld      b, d
                ret
; End of function getFreeChannels


; =============== S U B R O U T I N E =======================================

; b = inverted channel mask / d = number of notes to allocate / iy=ptr to InstrumentParameters -> c = channelMask / e = numberOfNotes

allocateChannels:                       ; CODE XREF: setInstrumentParameter_NumberOfNotes+1B↑p
                                        ; sub_1555+1D↑p ...
                ld      a, b
                ld      b, 8
                ld      c, 0
                ld      e, 0
                push    iy
                pop     hl
                ld      ix, strangeMemory

loc_1600:                               ; CODE XREF: allocateChannels+26↓j
                rrca
                rr      c
                bit     7, c
                jr      z, loc_1611     ; if (bit 7 of c == 0) jmp loc_1611
                ld      (ix+YmChannelData.channel0_ptrInstrumentParameters), l
                ld      (ix+ YmChannelData.channel0_ptrInstrumentParameters+1 ), h
                inc     e
                dec     d
                jr      z, allocatedAllChannels

loc_1611:                               ; CODE XREF: allocateChannels+13↑j
                push    de
                ld      de, 4
                add     ix, de
                pop     de
                djnz    loc_1600
                ret
; ---------------------------------------------------------------------------

allocatedAllChannels:                   ; CODE XREF: allocateChannels+1D↑j
                dec     b
                ret     z

loc_161D:                               ; CODE XREF: allocateChannels+2D↓j
                rrc     c
                djnz    loc_161D
                ret
; End of function allocateChannels


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_NoteNumberLimitHigh:
                                        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                ld      (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitHigh), a
                cp      (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitLow)
                jr      nc, loc_162E    ; if (a >= (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitLow)) jmp loc_162E
                ld      (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitLow), a

loc_162E:                               ; CODE XREF: setInstrumentParameter_NoteNumberLimitHigh+7↑j
                jp      setDefaultInstrumentParameters
; End of function setInstrumentParameter_NoteNumberLimitHigh


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_NoteNumberLimitLow:
                                        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitLow), c
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitHigh)
                cp      c
                jr      nc, loc_163D    ; if (a >= c) jmp loc_163D
                ld      (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitHigh), c

loc_163D:                               ; CODE XREF: setInstrumentParameter_NoteNumberLimitLow+7↑j
                jp      setDefaultInstrumentParameters
; End of function setInstrumentParameter_NoteNumberLimitLow


; =============== S U B R O U T I N E =======================================

; a = MidiDataByte 0 / c = MidiDataByte 1 / d = MidiDataByte 0 / e = MidiDataByte 1 / iy=ptr to InstrumentParameters

setInstrumentParameter_MonoMode:        ; CODE XREF: ym2151_executeMidiCommand:ym2151_executeMidiCommand_ControlChange_InstrumentParameter_MonoMode↑p
                ld      a, c
                cp      1
                call    z, loc_164F     ; if (a == 0x01) call loc_164F
                ret
; End of function setInstrumentParameter_MonoMode


; =============== S U B R O U T I N E =======================================

; a = MidiDataByte 0 / c = MidiDataByte 1 / d = MidiDataByte 0 / e = MidiDataByte 1 / iy=ptr to InstrumentParameters

setInstrumentParameter_PolyMode:        ; CODE XREF: ym2151_executeMidiCommand:ym2151_executeMidiCommand_ControlChange_InstrumentParameter_PolyMode↑p
                ld      c, 0
                jr      loc_164F
; End of function setInstrumentParameter_PolyMode


; =============== S U B R O U T I N E =======================================

; c=0 is POLY 1 is MONO / iy=ptr to InstrumentParameters

setInstrumentParameter_MonoPolyMode:    ; CODE XREF: setInstrumentParameter+A↑j
                                        ; applyVoiceDefinition?+54↓p
                                        ; DATA XREF: ...
                ld      a, c            ; jumptable 0000019E case 13
                cp      2
                ret     nc              ; if (a >= 0x02) return

loc_164F:                               ; CODE XREF: setInstrumentParameter_MonoMode+3↑p
                                        ; setInstrumentParameter_PolyMode+2↑j
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.polyMonoMode)
                ld      (iy+InstrumentParameters.instrumentConfiguration.polyMonoMode), c
                xor     c
                call    nz, applyInstrumentConfiguration?
                ret
; End of function setInstrumentParameter_MonoPolyMode


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_LFOLoadEnable:   ; CODE XREF: setInstrumentParameter+A↑j
                                        ; applyVoiceDefinition?:loc_17FA↓p
                                        ; DATA XREF: ...
                ld      a, c            ; jumptable 0000019E case 20
                cp      2
                ret     nc              ; if (a >= 0x02) return
                res     7, (iy+InstrumentParameters.voiceDefinition.amplitudeModulationDepth)
                bit     0, c
                jr      z, loc_166A     ; if (bit 0 of c == 0) jmp loc_166A
                set     7, (iy+InstrumentParameters.voiceDefinition.amplitudeModulationDepth)

loc_166A:                               ; CODE XREF: setInstrumentParameter_LFOLoadEnable+A↑j
                call    isLfoModeEnabled
                ret     z
                ld      c, (iy+InstrumentParameters.voiceDefinition.lfoSpeed)
                rr      c
                res     7, c
                call    setNodeParameterLFOSpeed
---
                ld      c, (iy+InstrumentParameters.voiceDefinition.amplitudeModulationDepth)
                res     7, c
                call    setNodeParameterAmpModDepth
---
                ld      c, (iy+InstrumentParameters.voiceDefinition.pitchModulationDepth)
                res     7, c
                call    setNodeParameterPitchModDepth
---
                ld      a, (iy+InstrumentParameters.voiceDefinition.lfoWaveForm)
                rlca
                rlca
                rlca
                and     3
                ld      c, a
                jp      setNodeParameterLFOWaveForm
; End of function setInstrumentParameter_LFOLoadEnable


; =============== S U B R O U T I N E =======================================


isLfoModeEnabled:                       ; CODE XREF: setInstrumentParameter_LFOLoadEnable:loc_166A↑p
                                        ; setInstrumentParameter_LFOSpeed+5↓p ...
                bit     7, (iy+InstrumentParameters.voiceDefinition.amplitudeModulationDepth)
                ret     z               ; if (bit 7 of (iy+25) == 0) return
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                and     a
                ret
; End of function isLfoModeEnabled


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_LFOSpeed:        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                add     a, a
                ld      (iy+InstrumentParameters.voiceDefinition.lfoSpeed), a
                call    isLfoModeEnabled
                ret     z
; End of function setInstrumentParameter_LFOSpeed


; =============== S U B R O U T I N E =======================================


setNodeParameterLFOSpeed:               ; CODE XREF: setNodeParameter+6↑j
                                        ; proc_1393_called_for_Reboot+38↑p ...
                ld      a, c            ; jumptable 00000141 case 9
                ld      (activeConfiguration.lfoSpeed), a
                add     a, a
                ld      c, 18h          ; setLFOFreq
                call    sendToYM2151_no_interrupts_allowed ; LFRQ
                ret
; End of function setNodeParameterLFOSpeed


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_AmplitudeModulationDepth:
                                        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, (iy+InstrumentParameters.voiceDefinition.amplitudeModulationDepth)
                and     80h
                or      c
                ld      (iy+InstrumentParameters.voiceDefinition.amplitudeModulationDepth), a
                call    isLfoModeEnabled
                ret     z
; End of function setInstrumentParameter_AmplitudeModulationDepth


; =============== S U B R O U T I N E =======================================


setNodeParameterAmpModDepth:            ; CODE XREF: setNodeParameter+6↑j
                                        ; proc_1393_called_for_Reboot+34↑p ...
                ld      a, c            ; jumptable 00000141 case 10
                ld      (activeConfiguration.amplitudeModulationDepth), a
                ld      a, c
                ld      c, 19h          ; setPhaseDepth or setAmpDepth
                call    sendToYM2151_no_interrupts_allowed ;  PMD/AMD
                ret
; End of function setNodeParameterAmpModDepth


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_PitchModulationDepth:
                                        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, (iy+InstrumentParameters.voiceDefinition.pitchModulationDepth)
                and     80h
                or      c
                ld      (iy+InstrumentParameters.voiceDefinition.pitchModulationDepth), a
                call    isLfoModeEnabled
                ret     z
; End of function setInstrumentParameter_PitchModulationDepth


; =============== S U B R O U T I N E =======================================

; c = control value / iy=ptr to InstrumentParameters

setNodeParameterPitchModDepth:          ; CODE XREF: setNodeParameter+6↑j
                                        ; proc_1393_called_for_Reboot+30↑p ...
                ld      a, c            ; jumptable 00000141 case 11
                ld      (activeConfiguration.pitchModulationDepth), a
                or      80h
                ld      c, 19h          ; setPhaseDepth or setAmpDepth
                call    sendToYM2151_no_interrupts_allowed ; PMD/AMD
                ret
; End of function setNodeParameterPitchModDepth


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_LFOWaveform:     ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                cp      4
                ret     nc              ; if (a >= 0x04) return
                rrca
                rrca
                rrca
                ld      b, a
                ld      a, (iy+InstrumentParameters.voiceDefinition.lfoWaveForm)
                and     9Fh
                or      b
                ld      (iy+InstrumentParameters.voiceDefinition.lfoWaveForm), a
                call    isLfoModeEnabled
                ret     z
; End of function setInstrumentParameter_LFOWaveform


; =============== S U B R O U T I N E =======================================


setNodeParameterLFOWaveForm:            ; CODE XREF: setNodeParameter+6↑j
                                        ; proc_1393_called_for_Reboot+2C↑p ...
                ld      a, c            ; jumptable 00000141 case 12
                cp      4
                ret     nc              ; if (a >= 0x04) return
                ld      (activeConfiguration.lfoWaveForm), a
                ld      c, 1Bh          ; setWaveForm
                call    sendToYM2151_no_interrupts_allowed ; ConTrol output / Wave form
                ret
; End of function setNodeParameterLFOWaveForm


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_LFOSync:         ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                cp      2
                ret     nc              ; if (a >= 0x02) return
---
                res     7, (iy+InstrumentParameters.voiceDefinition.pitchModulationDepth)
                res     7, (iy+InstrumentParameters.flags)
                bit     0, c
                jr      z, locret_171D  ; if (bit 0 of c == 0) jmp locret_171D
                set     7, (iy+InstrumentParameters.voiceDefinition.pitchModulationDepth)
                set     7, (iy+InstrumentParameters.flags)

locret_171D:                            ; CODE XREF: setInstrumentParameter_LFOSync+E↑j
                ret
; End of function setInstrumentParameter_LFOSync


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_PMDController:   ; CODE XREF: setInstrumentParameter+A↑j
                                        ; applyVoiceDefinition?+61↓j
                                        ; DATA XREF: ...
                ld      a, c
                cp      5
                ret     nc              ; if (a >= 0x05) return
                ld      (iy+InstrumentParameters.instrumentConfiguration.pmdController), a
                ret
; End of function setInstrumentParameter_PMDController


; =============== S U B R O U T I N E =======================================

; c = value / iy=ptr to InstrumentParameters

setInstrumentParameter_AfterTouch:      ; CODE XREF: ym2151_executeMidiCommand+F↑j
                ld      a, 1
; ---------------------------------------------------------------------------
                jp      setInstrumentParameterController
; End of function setInstrumentParameter_AfterTouch


; =============== S U B R O U T I N E =======================================

; c = control value / iy=ptr to InstrumentParameters

setInstrumentParameterModulationWheel:  ; CODE XREF: ym2151_executeMidiCommand+26↑j
                ld      a, 2
; ---------------------------------------------------------------------------
                jp      setInstrumentParameterController
; End of function setInstrumentParameterModulationWheel

a = MidiDataByte 0 / c = MidiDataByte 1 / d = MidiDataByte 0 / e = MidiDataByte 1 / iy=ptr to InstrumentParameters

; =============== S U B R O U T I N E =======================================

; c = control value / iy=ptr to InstrumentParameters

setInstrumentParameterBreathController: ; CODE XREF: ym2151_executeMidiCommand+2B↑j
                ld      a, 3
; ---------------------------------------------------------------------------
                jp      setInstrumentParameterController
; End of function setInstrumentParameterBreathController


; =============== S U B R O U T I N E =======================================

; c = control value / iy=ptr to InstrumentParameters

setInstrumentParameterFootController:   ; CODE XREF: ym2151_executeMidiCommand+30↑j
                ld      a, 4
; End of function setInstrumentParameterFootController


; =============== S U B R O U T I N E =======================================

; a = control type (1=AfterTouch, 2=ModulationWheel, 3=BreathController, 4=FootController) / c = control value / iy=ptr to InstrumentParameters

setInstrumentParameterController:
                cp      (iy+InstrumentParameters.instrumentConfiguration.pmdController)
                ret     nz              ; if (a != (iy+InstrumentParameters.instrumentConfiguration.pmdController)) return
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.numberOfNotes)
                and     a
                ret     z               ; if (instrumentConfiguration.numberOfNotes == 0) return
                jp      setNodeParameterPitchModDepth
; End of function setInstrumentParameterController


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_AmplitudeModulationSensitivity:
                                        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                cp      4
                ret     nc              ; if (a >= 0x04) return
---
                ld      a, (iy+InstrumentParameters.voiceDefinition.pmsAm)
                and     0FCh
                or      c
                ld      (iy+InstrumentParameters.voiceDefinition.pmsAm), a
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.lfoEnable)
                jr      setInstrumentParameter_LFOEnable
; End of function setInstrumentParameter_AmplitudeModulationSensitivity


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_PitchModulationSensitivity:
                                        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                cp      8
                ret     nc              ; if (a >= 0x08) return
                add     a, a
                add     a, a
                add     a, a
                add     a, a
                ld      c, a
                ld      a, (iy+InstrumentParameters.voiceDefinition.pmsAm)
                and     8Fh
                or      c
                ld      (iy+InstrumentParameters.voiceDefinition.pmsAm), a
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.lfoEnable)
; End of function setInstrumentParameter_PitchModulationSensitivity


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_LFOEnable:       ; CODE XREF: setInstrumentParameter+A↑j
                                        ; setInstrumentParameter_AmplitudeModulationSensitivity+10↑j ...
                ld      a, c            ; jumptable 0000019E case 10
                cp      2
                ret     nc              ; if (a >= 0x02) return
                ld      (iy+InstrumentParameters.instrumentConfiguration.lfoEnable), c
                ld      a, 0
                bit     0, c
                jr      nz, loc_1774    ; if (bit 0 of c != 0) jmp loc_1774
                ld      a, (iy+InstrumentParameters.voiceDefinition.pmsAm)

loc_1774:                               ; CODE XREF: setInstrumentParameter_LFOEnable+B↑j
                ld      c, 38h ; '8'
                jr      sub_1792
; End of function setInstrumentParameter_LFOEnable


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_Pan:             ; CODE XREF: setInstrumentParameter+A↑j
                                        ; ym2151_executeMidiCommand:ym2151_executeMidiCommand_ControlChange_PanControl↑p ...
                ld      a, c            ; jumptable 0000019E case 9
                ld      (iy+InstrumentParameters.instrumentConfiguration.pan), a
                ld      c, 40h ; '@'
                and     60h ; '`'
                jr      z, loc_178A
                ld      c, 80h
                cp      60h ; '`'
                jr      z, loc_178A     ; if (a == 0x60) jmp loc_178A
                ld      c, 0C0h

loc_178A:                               ; CODE XREF: setInstrumentParameter_Pan+8↑j
                                        ; setInstrumentParameter_Pan+E↑j
                ld      a, (iy+InstrumentParameters.voiceDefinition.feedbackLevelAlgorithm)
                and     3Fh ; '?'
                or      c
                ld      c, 20h ; ' '
; End of function setInstrumentParameter_Pan


; =============== S U B R O U T I N E =======================================

; c = register / a = value

sub_1792:                               ; CODE XREF: setInstrumentParameter_LFOEnable+12↑j
                ld      b, 8
                ld      d, (iy+InstrumentParameters.channelMask)

loc_1797:                               ; CODE XREF: sub_1792+B↓j
                rr      d
                call    c, sendToYM2151_no_interrupts_allowed
                inc     c
                djnz    loc_1797
                ret
; End of function sub_1792


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_VoiceBankNumber: ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                cp      7
                ret     nc              ; if (a >= 0x07) return
                cp      (iy+InstrumentParameters.instrumentConfiguration.voiceBankNumber)
                ret     z               ; if (a == (iy+InstrumentParameters.instrumentConfiguration.voiceBankNumber)) return
                ld      (iy+InstrumentParameters.instrumentConfiguration.voiceBankNumber), a
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.voiceNumber)
; End of function setInstrumentParameter_VoiceBankNumber


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_VoiceNumber:     ; CODE XREF: setInstrumentParameter+A↑j
                                        ; ym2151_executeMidiCommand+18↑p
                                        ; DATA XREF: ...
                ld      a, c            ; jumptable 0000019E case 5
                cp      30h ; '0'
                ret     nc              ; if (a >= 0x30) return
                ld      (iy+InstrumentParameters.instrumentConfiguration.voiceNumber), a
                push    iy
                pop     hl              ; hl = ptr to InstrumentParameters
                ld      de, 10h
                add     hl, de          ; hl = 0x10 + ptr to InstrumentParameters
                ex      de, hl          ; de = 0x10 + ptr to InstrumentParameters
                call    getVoiceDefinitionOfSameBank
                ld      bc, 40h ; '@'
                ldir                    ; memcpy(&instrumentParameters.voiceDefinition, getVoiceDefinition(...), 0x40)
                jp      applyInstrumentParameter?
; End of function setInstrumentParameter_VoiceNumber


; =============== S U B R O U T I N E =======================================

; Changes the ptrInstrumentParameters.voiceDefinition
;
; b=paramNr minus 0x40 / c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_VoiceDefinition: ; DATA XREF: setInstrumentParameter:setVoiceDefinitionLookup↑o
                ld      a, b
                add     a, 10h
                ld      e, a
                ld      d, 0            ; de = paramNr+0x10
                push    iy
                pop     hl
                add     hl, de          ; hl = ptrInstrumentParameters.voiceDefinition[paramNr]
                ld      (hl), c         ; ptrInstrumentParameters.voiceDefinition[paramNr] = value
                jp      applyVoiceDefinition?
; End of function setInstrumentParameter_VoiceDefinition


; =============== S U B R O U T I N E =======================================

; iy=ptr to InstrumentParameters

applyInstrumentParameter?:              ; CODE XREF: setInstrumentParameter_VoiceNumber+17↑j
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentVoice+39↓p
                call    jmpStartMusicProcessing
                call    applyInstrumentConfiguration?
                call    applyVoiceDefinition?
                jp      jmpStopMusicProcessing
; End of function applyInstrumentParameter?


; =============== S U B R O U T I N E =======================================

; iy=ptr to InstrumentParameters

applyVoiceDefinition?:                  ; CODE XREF: setInstrumentParameter_VoiceDefinition+B↑j
                                        ; applyInstrumentParameter?+6↑p
                res     7, (iy+InstrumentParameters.flags)
                bit     7, (iy+InstrumentParameters.voiceDefinition.pitchModulationDepth)
                jr      z, loc_17F0     ; if (bit 7 of (iy+InstrumentParameters.voiceDefinition.pitchModulationDepth) == 0) jmp loc_17F0
                set     7, (iy+InstrumentParameters.flags)

loc_17F0:                               ; CODE XREF: applyVoiceDefinition?+8↑j
                ld      c, 0
                bit     7, (iy+InstrumentParameters.voiceDefinition.amplitudeModulationDepth)
                jr      z, loc_17FA     ; if (bit 7 of (iy+InstrumentParameters.voiceDefinition.amplitudeModulationDepth) == 0) jmp loc_17FA
                ld      c, 1

loc_17FA:                               ; CODE XREF: applyVoiceDefinition?+14↑j
                call    setInstrumentParameter_LFOLoadEnable
                push    iy
                push    iy
                pop     ix              ; ix = iy
                ld      b, 4
                ld      de, 8

loc_1808:                               ; CODE XREF: applyVoiceDefinition?+2F↓j
                push    bc
                call    setInstrumentParameter_OperatorTotalLevel
                pop     bc
                add     ix, de
                inc     iy
                djnz    loc_1808
                pop     iy
                call    setAllYmRegistersForAssignedChannels
                ld      a, (activeConfiguration.combineMode)
                bit     0, a
                ret     z               ; if (bit 0 of a == 0) return
                ld      a, (iy+InstrumentParameters.voiceDefinition.field_3B)
                and     0Fh
                ld      c, a
                call    setInstrumentParameter_PitchbenderRange
                ld      c, (iy+InstrumentParameters.voiceDefinition.field_3A)
                res     7, c
                call    setInstrumentParameter_PortamentoTime
                ld      a, (iy+InstrumentParameters.voiceDefinition.field_3A)
                rlca
                and     1
                ld      c, a
                call    setInstrumentParameter_MonoPolyMode
                ld      a, (iy+InstrumentParameters.voiceDefinition.field_3B)
                rrca
                rrca
                rrca
                rrca
                and     7
                ld      c, a
                jp      setInstrumentParameter_PMDController ; jumptable 0000019E case 14
; End of function applyVoiceDefinition?


; =============== S U B R O U T I N E =======================================

; ix = InstrumentParameter ptr (+ operator)

setInstrumentParameter_OperatorTotalLevel:
                                        ; CODE XREF: applyVoiceDefinition?+27↑p
                ld      a, (ix+InstrumentParameters.voiceDefinition.operator0.field_2)
                and     0Fh
                add     a, (ix+InstrumentParameters.voiceDefinition.operator0.totalLevel)
                jp      p, loc_1853
                ld      a, 7Fh

loc_1853:                               ; CODE XREF: setInstrumentParameter_OperatorTotalLevel+8↑j
                ld      (iy+InstrumentParameters.operator1TotalLevel), a
                ret
; End of function setInstrumentParameter_OperatorTotalLevel


; =============== S U B R O U T I N E =======================================


setAllYmRegistersForAssignedChannels:   ; CODE XREF: sub_154F+3↑j
                                        ; applyVoiceDefinition?+33↑p
                ld      a, (iy+InstrumentParameters.voiceDefinition.operatorEnable)
                and     78h ; 'x'
                ld      c, a            ; c = voiceDefinition.operatorEnable & 0x78 = mask the operator enabled flags
---
                ld      b, 8
                ld      a, (iy+InstrumentParameters.channelMask)
                ld      de, 4
                ld      ix, strangeMemory

loc_1869:                               ; CODE XREF: setAllYmRegistersForAssignedChannels+1B↓j
                rra
                jr      nc, loc_186F
                ld      (ix+YmChannelData.channel0_to_ym_channel), c

loc_186F:                               ; CODE XREF: setAllYmRegistersForAssignedChannels+13↑j
                inc     c
                add     ix, de
                djnz    loc_1869
---
                ld      c, 40h ; '@'
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator0.field_3)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register 40h to 47h
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator2.field_3)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register 48h to 4Fh
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator1.field_3)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register 50h to 57h
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator3.field_3)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register 58h to 5Fh
                ld      c, 0A0h
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator0.field_5)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register A0h to A7h
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator2.field_5)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register A8h to AFh
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator1.field_5)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register B0h to B7h
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator3.field_5)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register B8h to BFh
                ld      c, 0C0h
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator0.field_6)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register C0h to C7h
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator2.field_6)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register C8h to CFh
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator1.field_6)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register D0h to D7h
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator3.field_6)
                call    sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels ; send for register D8h to DFh
---
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.lfoEnable)
                call    setInstrumentParameter_LFOEnable
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.pan)
                jp      setInstrumentParameter_Pan
; End of function setAllYmRegistersForAssignedChannels


; =============== S U B R O U T I N E =======================================

; iy=ptr to InstrumentParameters / a = value / c = register
;
; if (field_5D & 0x01) { sendToYM2151(c+0, a); }
; if (field_5D & 0x02) { sendToYM2151(c+1, a); }
; if (field_5D & 0x04) { sendToYM2151(c+2, a); }
; if (field_5D & 0x08) { sendToYM2151(c+3, a); }
; if (field_5D & 0x10) { sendToYM2151(c+4, a); }
; if (field_5D & 0x20) { sendToYM2151(c+5, a); }
; if (field_5D & 0x40) { sendToYM2151(c+6, a); }
; if (field_5D & 0x80) { sendToYM2151(c+7, a); }
;

sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels:
                                        ; CODE XREF: setAllYmRegistersForAssignedChannels+22↑p
                                        ; setAllYmRegistersForAssignedChannels+28↑p ...
                ld      b, 8
                ld      d, (iy+InstrumentParameters.channelMask)

loc_18D3:                               ; CODE XREF: sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels+B↓j
                rr      d
                call    c, sendToYM2151_no_interrupts_allowed
                inc     c
                djnz    loc_18D3
                ret
; End of function sendToYM2151_no_interrupts_allowed_ForAllAssignedChannels


; =============== S U B R O U T I N E =======================================


ym_updateKeyCodeAndFractionOnAllChannels:
                                        ; CODE XREF: finalizeMusicProcessing+26↑p
                ld      ix, strangeMemory
                ld      b, 8

loc_18E2:                               ; CODE XREF: ym_updateKeyCodeAndFractionOnAllChannels+1D↓j
                bit     6, (ix+YmChannelData.channel0_flags)
                jr      z, loc_18F4     ; if (bit 6 of (ix+65) == 0) jmp loc_18F4
                ld      l, (ix+YmChannelData.channel0_ptrInstrumentParameters)
                ld      h, (ix+ YmChannelData.channel0_ptrInstrumentParameters+1 )
                push    hl
                pop     iy
                call    ym_setKeyCodeAndFraction

loc_18F4:                               ; CODE XREF: ym_updateKeyCodeAndFractionOnAllChannels+A↑j
                ld      de, 4
                add     ix, de
                djnz    loc_18E2
                ret
; End of function ym_updateKeyCodeAndFractionOnAllChannels


; =============== S U B R O U T I N E =======================================

; ix = strangemem / iy = ptrInstrumentParameters

ym_setKeyCodeAndFraction:               ; CODE XREF: ym_updateKeyCodeAndFractionOnAllChannels+15↑p
                                        ; ym_registerKey_setKeyCodeAndFraction+1B↓j
                ld      l, (ix+YmChannelData.channel0_currentlyPlaying.fraction)
                ld      h, (ix+YmChannelData.channel0_currentlyPlaying.note)
                ld      e, (iy+InstrumentParameters.detuneAndPitchbendAsNoteFraction)
                ld      d, (iy+InstrumentParameters.detuneAndPitchbendAsNoteFraction.note)
                call    cropToPlayableRange
                ld      de, (masterTuneAsNoteFraction.fraction)
                call    cropToPlayableRange
                ld      d, 19h          ; ad = ym2151KeyCodeTable reference
                ld      a, 34h ; '4'    ; ad = ym2151KeyCodeTable reference
                add     a, h            ; d = 0x19 / a=0x34+h / hl=cropped
                ld      e, a            ; d = 0x19 / a=0x34+h / e=0x34+h / hl=cropped
                jr      nc, loc_191B
                inc     d               ; if overflow { inc d }

loc_191B:                               ; CODE XREF: ym_setKeyCodeAndFraction+1C↑j
                ld      a, (de)         ; a = ym2151KeyCodeTable[cropped >> 8] / hl=cropped
                ld      h, a            ; h = a = ym2151KeyCodeTable[cropped >> 8]
                ld      a, (ix+YmChannelData.channel0_to_ym_channel)
                and     7
                add     a, 28h ; '('    ; a = 0x28 + ((ix+StrangeMemory.channel0_memC) & 7)
                ld      c, a            ; c = a = 0x28 + ((ix+StrangeMemory.channel0_memC) & 7)
                add     a, 8            ; c = 0x28 + ((ix+StrangeMemory.channel0_memC) & 7)
                                        ; a = 0x30 + ((ix+StrangeMemory.channel0_memC) & 7)
                ld      e, a            ; c = 0x28 + ((ix+StrangeMemory.channel0_memC) & 7)
                                        ; e = a = 0x30 + ((ix+StrangeMemory.channel0_memC) & 7)
                ld      a, h            ; c = 0x28 + ((ix+StrangeMemory.channel0_memC) & 7)
                                        ; e = 0x30 + ((ix+StrangeMemory.channel0_memC) & 7)
                                        ; a = ym2151KeyCodeTable[cropped >> 8]
                call    sendToYM2151_with_disabled_interrupts ; sendToYM2151_with_disabled_interrupts(0x28 + ((ix+StrangeMemory.channel0_memC) & 7), ym2151KeyCodeTable[cropped >> 8])
                nop
                nop
                ld      a, l
                ld      c, e
                call    sendToYM2151_no_interrupts_allowed ; sendToYM2151_no_interrupts_allowed(0x30 + ((ix+StrangeMemory.channel0_memC) & 7), cropped && 0xFF)
                ret
; End of function ym_setKeyCodeAndFraction

; ---------------------------------------------------------------------------
https://github.com/masl123/YM2151-Arduino-Software/blob/master/src/YM2151.cpp
ym2151KeyCodeTable:db    0Eh,     0,     1,     2,     4,     5,     6,     8,     9,   0Ah,   0Ch,   0Dh,   0Eh,     0,     1,     2
                db      4,     5,     6,     8,     9,   0Ah,   0Ch,   0Dh,   0Eh,   10h,   11h,   12h,   14h,   15h,   16h,   18h
                db    19h,   1Ah,   1Ch,   1Dh,   1Eh,   20h,   21h,   22h,   24h,   25h,   26h,   28h,   29h,   2Ah,   2Ch,   2Dh
                db    2Eh,   30h,   31h,   32h,   34h,   35h,   36h,   38h,   39h,   3Ah,   3Ch,   3Dh,   3Eh,   40h,   41h,   42h
                db    44h,   45h,   46h,   48h,   49h,   4Ah,   4Ch,   4Dh,   4Eh,   50h,   51h,   52h,   54h,   55h,   56h,   58h
                db    59h,   5Ah,   5Ch,   5Dh,   5Eh,   60h,   61h,   62h,   64h,   65h,   66h,   68h,   69h,   6Ah,   6Ch,   6Dh
                db    6Eh,   70h,   71h,   72h,   74h,   75h,   76h,   78h,   79h,   7Ah,   7Ch,   7Dh,   7Eh,   70h,   71h,   72h
                db    74h,   75h,   76h,   78h,   79h,   7Ah,   7Ch,   7Dh,   7Eh,   70h,   71h,   72h,   74h,   75h,   76h,   78h

; =============== S U B R O U T I N E =======================================

; HL      DE              HL
; 0000    0000            0000 (returned from 19BB)
; 0001    0001            0002 (returned from 19BB)
; 4000    4000            7400 (returned from 19C3 after subtracting 1x)
; FFFE    0001            7BFF (returned from 19C3 after subtracting multiple times)
; 0000    FFFF            0BFF (returned from 19CD after adding 1x)
; 0001    FFFF            0000 (returned from 19C5)
; 0002    FFFF            0001 (returned from 19C5)
; FFFF    FFFF            FFFE (returned from 19C5)
; 8000    FFFF            7FFF (returned from 19C5)
; 0000    8000            0400 (returned from 19CD after adding multiple times)
;
; hl=unsigned word / de=signed word -> hl

cropToPlayableRange:                    ; CODE XREF: ym_setKeyCodeAndFraction+C↑p
                                        ; ym_setKeyCodeAndFraction+13↑p ...
                bit     7, d
                jr      nz, de_is_negative ; if (bit 7 of d != 0) jmp loc_19C4
de_is_positive
                or      a               ; clear carry flag
                adc     hl, de
                ret     p               ; if (hl+de < 0x8000) return hl+de
                ld      a, h

loc_19BD:                               ; CODE XREF: cropToPlayableRange+B↓j
                sub     12              ; number of notes in an octave :)
                jp      m, loc_19BD     ; if (a<0) jmp loc_19BD
                ld      h, a
                ret
; ---------------------------------------------------------------------------

de_is_negative:                         ; CODE XREF: cropToPlayableRange+2↑j
                add     hl, de
                ret     c
                ld      a, h

loc_19C7:                               ; CODE XREF: cropToPlayableRange+15↓j
                add     a, 12           ; number of notes in an octave :)
                jp      m, loc_19C7     ; if (a<0) jmp loc_19C7
                ld      h, a
                ret
; End of function cropToPlayableRange


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_PortamentoTime:  ; CODE XREF: setInstrumentParameter+A↑j
                                        ; ym2151_executeMidiCommand:ym2151_executeMidiCommand_ControlChange_PortamentoTime↑p ...
                ld      (iy+InstrumentParameters.instrumentConfiguration.portamentoTime), c ; jumptable 0000019E case 11
                jr      portamentoChanged
; End of function setInstrumentParameter_PortamentoTime


; =============== S U B R O U T I N E =======================================

; c = control value (0=OFF, 0x7F=ON) / iy=ptr to InstrumentParameters

setInstrumentParameterPortamentoOnOff:  ; CODE XREF: ym2151_executeMidiCommand+48↑j
                                        ; setDefaultInstrumentParameters+D↓p
                ld      a, c
                and     a
                jr      z, portamentoOff
                cp      7Fh
                ret     nz              ; if (a != 0x7f) return
portamentoOn:
                set     1, (iy+InstrumentParameters.flags)
                jr      portamentoChanged
; ---------------------------------------------------------------------------

portamentoOff:                          ; CODE XREF: setInstrumentParameterPortamentoOnOff+2↑j
                res     1, (iy+InstrumentParameters.flags)

portamentoChanged:                      ; CODE XREF: setInstrumentParameter_PortamentoTime+3↑j
                                        ; setInstrumentParameterPortamentoOnOff+B↑j
                bit     1, (iy+InstrumentParameters.flags)
                jr      z, portamentoIsOff ; if (bit 1 of (iy+InstrumentParameters.field_57) == 0) jmp loc_19EF
portamentoInOn:
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.portamentoTime)
                and     a
                ret     nz              ; if (instrumentConfiguration.portamentoTime != 0) return

portamentoIsOff:                        ; CODE XREF: setInstrumentParameterPortamentoOnOff+15↑j
                ld      b, 8
                ld      c, (iy+InstrumentParameters.channelMask)
                ld      de, 4
                ld      ix, strangeMemory

loc_19FB:                               ; CODE XREF: setInstrumentParameterPortamentoOnOff+2F↓j
                rrc     c
                call    c, ym_finishPortamento
                add     ix, de
                djnz    loc_19FB
                ret
; End of function setInstrumentParameterPortamentoOnOff


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

ym_registerKey_setKeyCodeAndFraction_IncludingPortamento:
                                        ; CODE XREF: sub_26DA+3↓j
                                        ; sub_26FB+3↓p
                bit     1, (iy+InstrumentParameters.flags)
                jp      z, ym_registerKey_setKeyCodeAndFraction_Special ; if (bit 1 of (iy+InstrumentParameters.field_57) == 0) jmp sub_1ABE
---
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.portamentoTime)
                and     a
                jp      z, ym_registerKey_setKeyCodeAndFraction_Special
---
                push    iy
                ld      l, (iy+InstrumentParameters.strangeMemoryLSB)
                ld      h, (iy+InstrumentParameters.strangeMemoryMSB)
                push    hl
                pop     iy
                ld      hl, (lastMidiOnOff_FractionAndNoteNumber.fraction)
                ld      e, (iy-20h)     ; WTF ?!
                ld      d, (iy-1Fh)     ; WTF ?!
                or      a
                sbc     hl, de
                ld      e, (iy+YmChannelData.channel0_currentlyPlaying.fraction)
                ld      d, (iy+YmChannelData.channel0_currentlyPlaying.note)
                pop     iy
                jp      z, ym_registerKey_setKeyCodeAndFraction_Special
                ld      (ix+YmChannelData.channel0_currentlyPlaying.fraction), e
                ld      (ix+YmChannelData.channel0_currentlyPlaying.note), d
                ld      l, (ix+YmChannelData.channel0_portamentoTarget.fraction)
                ld      h, (ix+YmChannelData.channel0_portamentoTarget.note)
                or      a
                sbc     hl, de
                jr      z, ym_registerKey_setKeyCodeAndFraction_Special
---
                bit     7, h
                jr      nz, hl_is_negative ; if (bit 7 of h != 0) jmp loc_1A6D
hl is positive
                set     5, (ix+YmChannelData.channel0_flags)
                ld      a, h
                rrca
                and     3Fh ; '?'
                jr      nz, loc_1A56
                ld      a, 1

loc_1A56:                               ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+4D↑j
                ld      b, 8
                ld      d, 0
                ld      e, a
                call    ym_getPortamentoTimeFactor
This next block is a multiplication :)
hl = de * sub_1A8C()

loc_1A5E:                               ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento:loc_1A63↓j
                add     hl, hl
                rla
                jr      nc, loc_1A63
                add     hl, de

loc_1A63:                               ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+5B↑j
                djnz    loc_1A5E
                ld      (ix+YmChannelData.channel0_portamentoAdjustment.fraction), l
                ld      (ix+YmChannelData.channel0_portamentoAdjustment.note), h
                jr      ym_registerKey_setKeyCodeAndFraction
; ---------------------------------------------------------------------------

hl_is_negative:                         ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+43↑j
                set     5, (ix+YmChannelData.channel0_flags)
                ld      b, 8
                ld      d, 0FFh
                ld      e, h
                rrc     e
                set     7, e
                call    ym_getPortamentoTimeFactor
This next block is a multiplication :)
hl = de * sub_1A8C()

loc_1A7D:                               ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento:loc_1A82↓j
                add     hl, hl
                rla
                jr      nc, loc_1A82
                add     hl, de

loc_1A82:                               ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+7A↑j
                djnz    loc_1A7D
                ld      (ix+YmChannelData.channel0_portamentoAdjustment.fraction), l
                ld      (ix+YmChannelData.channel0_portamentoAdjustment.note), h
                jr      ym_registerKey_setKeyCodeAndFraction
; End of function ym_registerKey_setKeyCodeAndFraction_IncludingPortamento


; =============== S U B R O U T I N E =======================================


ym_getPortamentoTimeFactor:             ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+56↑p
                                        ; ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+75↑p
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.portamentoTime)
                rrca
                rrca
                and     1Fh
                ld      hl, byte_1A9E
                add     hl, a
                ld      a, (hl)
                ld      hl, 0
                ret
; ---------------------------------------------------------------------------
byte_1A9E:      db 0FFh, 80h, 56h, 40h, 34h, 2Bh, 25h, 20h, 1Dh, 1Ah, 18h, 16h, 14h, 13h, 12h, 11h
                                        ; DATA XREF: ym_getPortamentoTimeFactor+7↑o
                db  10h, 0Fh, 0Eh, 0Dh, 0Ch, 0Bh, 0Ah, 09h, 08h, 07h, 06h, 05h, 04h, 03h, 02h, 01h
; End of function ym_getPortamentoTimeFactor


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

ym_registerKey_setKeyCodeAndFraction_Special:
                                        ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+4↑j
                                        ; ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+B↑j ...
                res     5, (ix+YmChannelData.channel0_flags)
                ld      l, (ix+YmChannelData.channel0_portamentoTarget)
                ld      h, (ix+YmChannelData.channel0_portamentoTarget.note)
                ld      (ix+YmChannelData.channel0_currentlyPlaying), l
                ld      (ix+YmChannelData.channel0_currentlyPlaying.note), h
; End of function ym_registerKey_setKeyCodeAndFraction_Special


; =============== S U B R O U T I N E =======================================


ym_registerKey_setKeyCodeAndFraction:   ; CODE XREF: ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+66↑j
                                        ; ym_registerKey_setKeyCodeAndFraction_IncludingPortamento+85↑j
                ld      hl, (lastMidiOnOff_FractionAndNoteNumber.fraction)
                ld      (ix-20h), l     ; WTF ?!
                ld      (ix-1Fh), h     ; WTF ?!
---
                ld      hl, (lastMidiOnOff_Duration)
                ld      (ix+YmChannelData.channel0_remainingDuration), l
                ld      (ix+ YmChannelData.channel0_remainingDuration+1 ), h
                push    ix
                pop     hl
                ld      (iy+InstrumentParameters.strangeMemoryLSB), l
                ld      (iy+InstrumentParameters.strangeMemoryMSB), h
                jp      ym_setKeyCodeAndFraction
; End of function ym_registerKey_setKeyCodeAndFraction


; =============== S U B R O U T I N E =======================================


ym_updateAllCurrentlyPlayingByPortamentoAdjustment:
                                        ; CODE XREF: finalizeMusicProcessing+1F↑p
                call    jmpStartMusicProcessing
                ld      b, 8
                ld      ix, strangeMemory

loc_1AF5:                               ; CODE XREF: ym_updateAllCurrentlyPlayingByPortamentoAdjustment+1F↓j
                bit     5, (ix+YmChannelData.channel0_flags)
                jr      z, loc_1B06     ; if (bit 5 of (ix+StrangeMemory.channel0_memC.byte1) == 0) jmp loc_1B06
                bit     6, (ix+YmChannelData.channel0_flags)
                jr      z, loc_1B06     ; if (bit 6 of (ix+StrangeMemory.channel0_memC.byte1) == 0) jmp loc_1B06
                push    bc
                call    ym_updateCurrentlyPlayingByPortamentoAdjustment
                pop     bc

loc_1B06:                               ; CODE XREF: ym_updateAllCurrentlyPlayingByPortamentoAdjustment+D↑j
                                        ; ym_updateAllCurrentlyPlayingByPortamentoAdjustment+13↑j
                ld      de, 4
                add     ix, de
                djnz    loc_1AF5
                jp      jmpStopMusicProcessing
; End of function ym_updateAllCurrentlyPlayingByPortamentoAdjustment


; =============== S U B R O U T I N E =======================================


ym_updateCurrentlyPlayingByPortamentoAdjustment:
                                        ; CODE XREF: ym_updateAllCurrentlyPlayingByPortamentoAdjustment+16↑p
                ld      l, (ix+YmChannelData.channel0_currentlyPlaying.fraction)
                ld      h, (ix+YmChannelData.channel0_currentlyPlaying.note)
                ld      e, (ix+YmChannelData.channel0_portamentoAdjustment.fraction)
                ld      d, (ix+YmChannelData.channel0_portamentoAdjustment.note)
                bit     7, d
                jr      nz, loc_1B37    ; if (bit 7 of d != 0) jmp loc_1B37
---
de is positive
                add     hl, de
                jp      c, ym_finishPortamento
                ld      (ix+YmChannelData.channel0_currentlyPlaying.fraction), l
                ld      (ix+YmChannelData.channel0_currentlyPlaying.note), h
---
                ld      e, (ix+YmChannelData.channel0_portamentoTarget.fraction)
                ld      d, (ix+YmChannelData.channel0_portamentoTarget.note)
                or      a
                sbc     hl, de
                ret     c
                jp      ym_finishPortamento
; ---------------------------------------------------------------------------
de is "negative"

loc_1B37:                               ; CODE XREF: ym_updateCurrentlyPlayingByPortamentoAdjustment+E↑j
                add     hl, de
                jp      nc, ym_finishPortamento
                ld      (ix+YmChannelData.channel0_currentlyPlaying.fraction), l
                ld      (ix+YmChannelData.channel0_currentlyPlaying.note), h
---
                ld      e, (ix+YmChannelData.channel0_portamentoTarget.fraction)
                ld      d, (ix+YmChannelData.channel0_portamentoTarget.note)
                ex      de, hl
                or      a
                sbc     hl, de          ; fractionAndNoteNumber_CCC - fractionAndNoteNumber_AAA
                ret     c
; End of function ym_updateCurrentlyPlayingByPortamentoAdjustment


; =============== S U B R O U T I N E =======================================

; ix = ptr StrangeMemory

ym_finishPortamento:                    ; CODE XREF: setInstrumentParameterPortamentoOnOff+2A↑p
                                        ; ym_updateCurrentlyPlayingByPortamentoAdjustment+11↑j ...
                res     5, (ix+YmChannelData.channel0_flags)
                ld      l, (ix+YmChannelData.channel0_portamentoTarget.fraction)
                ld      h, (ix+YmChannelData.channel0_portamentoTarget.note)
                ld      (ix+YmChannelData.channel0_currentlyPlaying.fraction), l
                ld      (ix+YmChannelData.channel0_currentlyPlaying.note), h
                ret
; End of function ym_finishPortamento


; =============== S U B R O U T I N E =======================================

; c=value

setNodeParameterMasterTune:             ; CODE XREF: setNodeParameter+6↑j
                                        ; sub_1405+2F↑p
                                        ; DATA XREF: ...
                ld      a, c            ; jumptable 00000141 case 35
                ld      (masterTune), a
                add     a, a
                ld      h, 0
                jp      p, loc_1B69
                ld      h, 0FFh

loc_1B69:                               ; CODE XREF: setNodeParameterMasterTune+7↑j
                ld      l, a            ; hl = signed expanded value
                add     hl, hl          ; hl = signed(value) * 2
                ld      de, -1ECh
                add     hl, de
                ld      (masterTuneAsNoteFraction.fraction), hl
                ret
; End of function setNodeParameterMasterTune


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_Detune:          ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      (iy+InstrumentParameters.instrumentConfiguration.detune), c
                jr      setInstrumentParameter_06_07_common
; End of function setInstrumentParameter_Detune


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_OctaveTranspose: ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      a, c
                cp      5
                ret     nc              ; if (a >= 0x05) return
                ld      (iy+InstrumentParameters.instrumentConfiguration.octaveTranspose), a
; End of function setInstrumentParameter_OctaveTranspose


; =============== S U B R O U T I N E =======================================

; iy=ptr to InstrumentParameters

setInstrumentParameter_06_07_common:    ; CODE XREF: setInstrumentParameter_Detune+3↑j
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.octaveTranspose)
                ld      hl, octaveTransposeTable
                add     hl, a
                ld      d, (hl)
                ld      e, 0            ; de = (ptrInstrumentParameters.instrumentConfiguration.octaveTranspose-2)*12
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.detune)
                add     a, a
                ld      h, 0
                jp      p, loc_1B96
                ld      h, 0FFh

loc_1B96:                               ; CODE XREF: setInstrumentParameter_06_07_common+12↑j
                ld      l, a
                add     hl, hl
                add     hl, de          ; hl = XXXX + (ptrInstrumentParameters.instrumentConfiguration.octaveTranspose-2)*12
                ld      (iy+InstrumentParameters.detuneAsNoteFraction), l
                ld      (iy+InstrumentParameters.detuneAsNoteFraction.note), h
                ld      e, (iy+InstrumentParameters.pitchbenderValueMSB)
                ld      d, (iy+InstrumentParameters.pitchbenderValueLSB)
                jp      executeMidiCommand_PitchBender
; End of function setInstrumentParameter_06_07_common

; ---------------------------------------------------------------------------
octaveTransposeTable:db  232, 244,   0,  12,  24
                                        ; DATA XREF: setInstrumentParameter_06_07_common+3↑o
                                        ; -24, -12, 0, 12, 24

; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_PitchbenderRange:
                                        ; CODE XREF: setInstrumentParameter+A↑j
                                        ; applyVoiceDefinition?+42↑p
                                        ; DATA XREF: ...
                ld      a, c            ; jumptable 0000019E case 12
                cp      0Dh
                ret     nc              ; if (a >= 0x0d) return
                ld      (iy+InstrumentParameters.instrumentConfiguration.pitchbenderRange), a
                ld      e, (iy+InstrumentParameters.pitchbenderValueMSB)
                ld      d, (iy+InstrumentParameters.pitchbenderValueLSB)
; End of function setInstrumentParameter_PitchbenderRange


; =============== S U B R O U T I N E =======================================

; c = MidiCmdByte (0xEn) / d = MidiDataByte 0 (7bit Value LSB) / e = MidiDataByte 1 (7bit Value MSB) / iy=ptr to InstrumentParameters

executeMidiCommand_PitchBender:         ; CODE XREF: ym2151_executeMidiCommand+A↑j
                                        ; setInstrumentParameter_06_07_common+26↑j ...
                ld      (iy+InstrumentParameters.pitchbenderValueMSB), e ; jumptable 00001305 case 6
                ld      (iy+InstrumentParameters.pitchbenderValueLSB), d
                ld      hl, 0
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.pitchbenderRange)
                and     a
                jr      z, noPitchbenderRange
                ld      l, d            ; hl = valueLSB
                add     hl, hl          ; hl = valueLSB * 2
                ld      h, e            ; hl = (valueMSB<<8) + valueLSB * 2
                ld      de, 4000h       ; de = 0x4000
                xor     a
                sbc     hl, de          ; hl = (valueMSB<<8) + valueLSB * 2 - 0x4000
                jr      nc, loc_1BD5    ; if (hl>=0) goto loc_1BD5
                cpl                     ; invert all bits of "a"
---

loc_1BD5:                               ; CODE XREF: executeMidiCommand_PitchBender+18↑j
                rrca                    ; The carry becomes the value leaving on the right
                rr      h
                rr      l               ; hl = signed-hl >> 1
---
                rrca                    ; The carry becomes the value leaving on the right
                rr      h
                rr      l               ; hl = signed-hl >> 1
                ex      de, hl          ; de = [(valueMSB<<8) + valueLSB * 2 - 0x4000] / 4
summary: pitchBend = de * instrumentConfiguration.pitchbenderRange
                ld      hl, 0           ; pitchBend = 0
                ld      c, (iy+InstrumentParameters.instrumentConfiguration.pitchbenderRange)
                bit     3, c
                jr      z, loc_1BEB     ; if (bit 3 of c == 0) jmp loc_1BEB
                add     hl, de          ; if (instrumentConfiguration.pitchbenderRange & 0x08) pitchBend += de

loc_1BEB:                               ; CODE XREF: executeMidiCommand_PitchBender+2E↑j
                add     hl, hl          ; pitchBend = pitchBend * 2
                bit     2, c
                jr      z, loc_1BF1     ; if (bit 2 of c == 0) jmp loc_1BF1
                add     hl, de          ; if (instrumentConfiguration.pitchbenderRange & 0x04) pitchBend += de

loc_1BF1:                               ; CODE XREF: executeMidiCommand_PitchBender+34↑j
                add     hl, hl          ; pitchBend = pitchBend * 2
                bit     1, c
                jr      z, loc_1BF7     ; if (bit 1 of c == 0) jmp loc_1BF7
                add     hl, de          ; if (instrumentConfiguration.pitchbenderRange & 0x02) pitchBend += de

loc_1BF7:                               ; CODE XREF: executeMidiCommand_PitchBender+3A↑j
                add     hl, hl
                bit     0, c
                jr      z, noPitchbenderRange ; if (bit 0 of c == 0) jmp loc_1BFD
                add     hl, de          ; if (instrumentConfiguration.pitchbenderRange & 0x01) pitchBend += de

noPitchbenderRange:                     ; CODE XREF: executeMidiCommand_PitchBender+D↑j
                                        ; executeMidiCommand_PitchBender+40↑j
                add     hl, hl          ; hl = pitchBend * 2
                adc     a, a
                add     hl, hl          ; hl = pitchBend * 2
                adc     a, a
                add     hl, hl          ; hl = pitchBend * 2
                adc     a, a
                add     hl, hl          ; hl = pitchBend * 2
                adc     a, a            ; a = number of set bits in hl[15..12]
---
                ld      l, h            ; l = pitchBend[11..4]
                ld      h, a            ; h = number of set bits in hl[15..12]
                ld      e, (iy+InstrumentParameters.detuneAsNoteFraction)
                ld      d, (iy+InstrumentParameters.detuneAsNoteFraction.note)
                add     hl, de
                ld      (iy+InstrumentParameters.detuneAndPitchbendAsNoteFraction), l
                ld      (iy+InstrumentParameters.detuneAndPitchbendAsNoteFraction.note), h
                ret
; End of function executeMidiCommand_PitchBender


; =============== S U B R O U T I N E =======================================

; iy=ptr to InstrumentParameters

setInstrumentVolume:                    ; CODE XREF: setNodeParameterMasterOutputLevel+13↓p
                                        ; setInstrumentParameter_OutputLevel+3↓j ...
                ld      b, 8
                ld      de, 4
                ld      h, (iy+InstrumentParameters.channelMask)
                ld      ix, strangeMemory
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.outputLevel)
                cpl                     ; CPL inverts all bits of A
                and     7Fh
                add     a, (iy+InstrumentParameters.volume)
                jp      m, loc_1C35
                ld      l, a
                ld      a, (masterOutputLevel)
                add     a, l
                jp      p, loc_1C37

loc_1C35:                               ; CODE XREF: setInstrumentVolume+15↑j
                ld      a, 7Fh

loc_1C37:                               ; CODE XREF: setInstrumentVolume+1D↑j
                ld      l, a

loc_1C38:                               ; CODE XREF: setInstrumentVolume+2A↓j
                rr      h
                call    c, ym_setOperatorVolumes
                add     ix, de
                djnz    loc_1C38
                ret
; End of function setInstrumentVolume


; =============== S U B R O U T I N E =======================================

; l=instrument volume / ix=ptr StrangeMemory / iy=ptr to InstrumentParameters

ym_setOperatorVolumes:                  ; CODE XREF: setInstrumentVolume+25↑p
                ld      a, (ix+YmChannelData.channel0_to_ym_channel)
                and     7
                add     a, 60h ; '`'    ; setOpVolume
                ld      c, a
                ld      a, (ix+YmChannelData.channel0_operatorVolume)
                bit     7, (iy+InstrumentParameters.voiceDefinition.operator0.field_5) ; check "Modulator/Carrier"
                call    ym_setOperatorVolume
                ld      a, (ix+ YmChannelData.channel0_operatorVolume+2 )
                bit     7, (iy+InstrumentParameters.voiceDefinition.operator2.field_5) ; check "Modulator/Carrier"
                call    ym_setOperatorVolume
                ld      a, (ix+ YmChannelData.channel0_operatorVolume+1 )
                bit     7, (iy+InstrumentParameters.voiceDefinition.operator1.field_5) ; check "Modulator/Carrier"
                call    ym_setOperatorVolume
                ld      a, (ix+ YmChannelData.channel0_operatorVolume+3 )
                bit     7, (iy+InstrumentParameters.voiceDefinition.operator3.field_5) ; check "Modulator/Carrier"

ym_setOperatorVolume:                   ; CODE XREF: ym_setOperatorVolumes+F↑p
                                        ; ym_setOperatorVolumes+19↑p ...
                jr      z, loc_1C77     ; if "Modulator" jmp
                add     a, l
                jp      p, loc_1C77
                ld      a, 7Fh

loc_1C77:                               ; CODE XREF: ym_setOperatorVolumes:ym_setOperatorVolume↑j
                                        ; ym_setOperatorVolumes+30↑j
                or      80h
                call    sendToYM2151_no_interrupts_allowed
                ld      a, c
                add     a, 8
                ld      c, a
                ret
; End of function ym_setOperatorVolumes


; =============== S U B R O U T I N E =======================================


ym_updateOperatorVolumes:               ; CODE XREF: ym_calculateAndUpdateOperatorVolumes+95↓j
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.outputLevel)
                cpl
                and     7Fh
                add     a, (iy+InstrumentParameters.volume)
                jp      m, loc_1C95
                ld      l, a
                ld      a, (masterOutputLevel)
                add     a, l
                jp      p, loc_1C97

loc_1C95:                               ; CODE XREF: ym_updateOperatorVolumes+9↑j
                ld      a, 7Fh          ; if a>0x7F then a = 0x7F

loc_1C97:                               ; CODE XREF: ym_updateOperatorVolumes+11↑j
                ld      l, a
                ld      a, (ix+YmChannelData.channel0_to_ym_channel)
                and     7
                add     a, 60h ; '`'
                ld      c, a
---
                ld      a, (ix+YmChannelData.channel0_operatorVolume)
                bit     7, (iy+InstrumentParameters.voiceDefinition.operator0.field_5)
                call    loc_1CC5
                ld      a, (ix+ YmChannelData.channel0_operatorVolume+2 )
                bit     7, (iy+InstrumentParameters.voiceDefinition.operator2.field_5)
                call    loc_1CC5
                ld      a, (ix+ YmChannelData.channel0_operatorVolume+1 )
                bit     7, (iy+InstrumentParameters.voiceDefinition.operator1.field_5)
                call    loc_1CC5
                ld      a, (ix+ YmChannelData.channel0_operatorVolume+3 )
                bit     7, (iy+InstrumentParameters.voiceDefinition.operator3.field_5)

loc_1CC5:                               ; CODE XREF: ym_updateOperatorVolumes+26↑p
                                        ; ym_updateOperatorVolumes+30↑p ...
                jr      z, loc_1CCD
                add     a, l
                jp      p, loc_1CCD
                ld      a, 7Fh

loc_1CCD:                               ; CODE XREF: ym_updateOperatorVolumes:loc_1CC5↑j
                                        ; ym_updateOperatorVolumes+47↑j
                call    sendToYM2151_no_interrupts_allowed
                ld      a, c
                add     a, 8
                ld      c, a
; End of function ym_updateOperatorVolumes

                ret

; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

ym_calculateAndUpdateOperatorVolumes:   ; CODE XREF: ym_noteON↓p
                ld      a, (ix+YmChannelData.channel0_portamentoTarget.note)
                rra
                and     3Fh ; '?'
                ld      h, a
                ld      a, (lastMidiOnOff_KeyVelocity)
                sub     2
                jr      nc, loc_1CE5
                ld      a, 0

loc_1CE5:                               ; CODE XREF: ym_calculateAndUpdateOperatorVolumes+C↑j
                rrca
                rrca
                and     1Fh
                ld      l, a
---
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator0.field_3)
                ld      c, (iy+InstrumentParameters.voiceDefinition.operator0.field_2)
                ld      d, (iy+InstrumentParameters.voiceDefinition.operator0.field_1)
                call    getKeyboardLevelScaling
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator0.field_5)
                ld      d, (iy+InstrumentParameters.voiceDefinition.operator0.field_1)
                call    carrierOrModulatorTableLookup
                add     a, (iy+InstrumentParameters.operator1TotalLevel)
                jp      p, loc_1D07
                ld      a, 7Fh          ; if a>0x7F then a = 0x7F

loc_1D07:                               ; CODE XREF: ym_calculateAndUpdateOperatorVolumes+2D↑j
                ld      (ix+YmChannelData.channel0_operatorVolume), a
---
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator2.field_3)
                ld      c, (iy+InstrumentParameters.voiceDefinition.operator2.field_2)
                ld      d, (iy+InstrumentParameters.voiceDefinition.operator2.field_1)
                call    getKeyboardLevelScaling
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator2.field_5)
                ld      d, (iy+InstrumentParameters.voiceDefinition.operator2.field_1)
                call    carrierOrModulatorTableLookup
                add     a, (iy+InstrumentParameters.operator3TotalLevel)
                jp      p, loc_1D27
                ld      a, 7Fh          ; if a>0x7F then a = 0x7F

loc_1D27:                               ; CODE XREF: ym_calculateAndUpdateOperatorVolumes+4D↑j
                ld      (ix+ YmChannelData.channel0_operatorVolume+2 ), a
---
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator1.field_3)
                ld      c, (iy+InstrumentParameters.voiceDefinition.operator1.field_2)
                ld      d, (iy+InstrumentParameters.voiceDefinition.operator1.field_1)
                call    getKeyboardLevelScaling
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator1.field_5)
                ld      d, (iy+InstrumentParameters.voiceDefinition.operator1.field_1)
                call    carrierOrModulatorTableLookup
                add     a, (iy+InstrumentParameters.operator2TotalLevel)
                jp      p, loc_1D47
                ld      a, 7Fh          ; if a>0x7F then a = 0x7F

loc_1D47:                               ; CODE XREF: ym_calculateAndUpdateOperatorVolumes+6D↑j
                ld      (ix+ YmChannelData.channel0_operatorVolume+1 ), a
---
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator3.field_3)
                ld      c, (iy+InstrumentParameters.voiceDefinition.operator3.field_2)
                ld      d, (iy+InstrumentParameters.voiceDefinition.operator3.field_1)
                call    getKeyboardLevelScaling
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator3.field_5)
                ld      d, (iy+InstrumentParameters.voiceDefinition.operator3.field_1)
                call    carrierOrModulatorTableLookup
                add     a, (iy+InstrumentParameters.operator4TotalLevel)
                jp      p, loc_1D67
                ld      a, 7Fh          ; if a>0x7F then a = 0x7F

loc_1D67:                               ; CODE XREF: ym_calculateAndUpdateOperatorVolumes+8D↑j
                ld      (ix+ YmChannelData.channel0_operatorVolume+3 ), a
---
                jp      ym_updateOperatorVolumes
; End of function ym_calculateAndUpdateOperatorVolumes


; =============== S U B R O U T I N E =======================================

; b = OperatorDefinition.field_5 / c = ??? / d = OperatorDefinition.field_1 / l = ??? -> a = ??

carrierOrModulatorTableLookup:          ; CODE XREF: ym_calculateAndUpdateOperatorVolumes+27↑p
                                        ; ym_calculateAndUpdateOperatorVolumes+47↑p ...
                push    hl
                ld      a, d
                add     a, a            ; a = OperatorDefinition.field_1 << 1 = OperatorDefinition.field_1.VSTL
                and     0E0h            ; a = OperatorDefinition.field_1.VSTL << 5
                add     a, l            ; a = (OperatorDefinition.field_1.VSTL << 5) + l-reg
                ld      hl, carrierTable
                bit     7, b            ; check OperatorDefinition.field_5.Modulator/Carrier
                jr      nz, loc_1D7D    ; if (bit 7 of b != 0) jmp loc_1D7D
                ld      hl, modulatorTable

loc_1D7D:                               ; CODE XREF: carrierOrModulatorTableLookup+B↑j
                add     hl, a
                ld      a, (hl)         ; a = (carrierTable or modulatorTable)[(OperatorDefinition.field_1.VSTL << 5) + l-reg]
                add     a, c            ; a = (carrierTable or modulatorTable)[(OperatorDefinition.field_1.VSTL << 5) + l-reg] + c-reg
                pop     hl
                ret
; End of function carrierOrModulatorTableLookup


; =============== S U B R O U T I N E =======================================

; b = OperatorDefinition.field_3 / c = OperatorDefinition.field_2 / d = OperatorDefinition.field_1 / h = ??? ---->  c

getKeyboardLevelScaling:                ; CODE XREF: ym_calculateAndUpdateOperatorVolumes+1E↑p
                                        ; ym_calculateAndUpdateOperatorVolumes+3E↑p ...
                push    hl
                ld      a, h
                bit     7, d            ; check "Keyboard level scaling type (KLS Bit0)"
                jr      z, loc_1D8C     ; if (bit 7 of d == 0) jmp loc_1D8C
                add     a, 40h ; '@'

loc_1D8C:                               ; CODE XREF: getKeyboardLevelScaling+4↑j
                bit     7, b            ; check "KLS bit 1"
                jr      z, loc_1D92     ; if (bit 7 of b == 0) jmp loc_1D92
                add     a, 80h

loc_1D92:                               ; CODE XREF: getKeyboardLevelScaling+A↑j
                ld      hl, byte_1FBA
                add     hl, a
                ld      e, (hl)
                ld      d, 0
                ld      hl, 0
---
                bit     7, c
                jr      z, loc_1DA3     ; if (bit 7 of c == 0) jmp loc_1DA3
                add     hl, de

loc_1DA3:                               ; CODE XREF: getKeyboardLevelScaling+1C↑j
                add     hl, hl
---
                bit     6, c
                jr      z, loc_1DA9     ; if (bit 6 of c == 0) jmp loc_1DA9
                add     hl, de

loc_1DA9:                               ; CODE XREF: getKeyboardLevelScaling+22↑j
                add     hl, hl
---
                bit     5, c
                jr      z, loc_1DAF     ; if (bit 5 of c == 0) jmp loc_1DAF
                add     hl, de

loc_1DAF:                               ; CODE XREF: getKeyboardLevelScaling+28↑j
                add     hl, hl
---
                bit     4, c
                jr      z, loc_1DB5     ; if (bit 4 of c == 0) jmp loc_1DB5
                add     hl, de

loc_1DB5:                               ; CODE XREF: getKeyboardLevelScaling+2E↑j
                add     hl, hl
---
                add     hl, hl
                ld      c, h
                pop     hl
                ret
; End of function getKeyboardLevelScaling

; ---------------------------------------------------------------------------
carrierTable:   db  18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h
                                        ; DATA XREF: carrierOrModulatorTableLookup+6↑o
                db  18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h, 18h
                db  1Bh, 1Bh, 1Bh, 1Bh, 1Ah, 1Ah, 1Ah, 1Ah, 19h, 19h, 19h, 19h, 19h, 18h, 18h, 18h
                db  18h, 18h, 18h, 17h, 17h, 17h, 17h, 17h, 16h, 16h, 16h, 16h, 15h, 15h, 15h, 15h
                db  1Eh, 1Eh, 1Dh, 1Dh, 1Ch, 1Ch, 1Bh, 1Bh, 1Ah, 1Ah, 1Ah, 19h, 19h, 19h, 18h, 18h
                db  18h, 18h, 17h, 17h, 17h, 16h, 16h, 16h, 15h, 15h, 14h, 14h, 13h, 13h, 12h, 12h
                db  21h, 20h, 1Fh, 1Eh, 1Eh, 1Dh, 1Dh, 1Ch, 1Ch, 1Bh, 1Bh, 1Ah, 1Ah, 19h, 19h, 18h
                db  18h, 17h, 17h, 16h, 16h, 15h, 15h, 14h, 14h, 13h, 13h, 12h, 12h, 11h, 10h, 0Fh
                db  24h, 23h, 22h, 21h, 20h, 1Fh, 1Eh, 1Dh, 1Ch, 1Bh, 1Bh, 1Ah, 1Ah, 19h, 19h, 18h
                db  18h, 17h, 17h, 16h, 16h, 15h, 15h, 14h, 13h, 12h, 11h, 10h, 0Fh, 0Eh, 0Dh, 0Ch
                db  27h, 26h, 25h, 24h, 23h, 22h, 21h, 20h, 1Fh, 1Eh, 1Dh, 1Ch, 1Bh, 1Ah, 19h, 18h
                db  18h, 17h, 16h, 15h, 14h, 13h, 12h, 11h, 10h, 0Fh, 0Eh, 0Dh, 0Ch, 0Bh, 0Ah, 09h
                db  2Ah, 28h, 27h, 26h, 25h, 24h, 22h, 21h, 20h, 1Fh, 1Dh, 1Ch, 1Bh, 1Ah, 19h, 18h
                db  18h, 17h, 16h, 15h, 14h, 13h, 11h, 10h, 0Fh, 0Eh, 0Ch, 0Bh, 0Ah, 09h, 07h, 06h
                db  2Dh, 2Bh, 2Ah, 28h, 27h, 25h, 24h, 22h, 21h, 1Fh, 1Eh, 1Ch, 1Bh, 1Ah, 19h, 18h
                db  18h, 17h, 15h, 14h, 13h, 11h, 10h, 0Eh, 0Dh, 0Bh, 0Ah, 08h, 06h, 04h, 02h, 00h
modulatorTable: db    8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8
                                        ; DATA XREF: carrierOrModulatorTableLookup+D↑o
                db    8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8
                db    9,   9,   9,   9,   9,   9,   9,   9,   8,   8,   8,   8,   8,   8,   8,   8
                db    8,   8,   8,   8,   8,   8,   8,   8,   7,   7,   7,   7,   7,   7,   7,   7
                db   10,  10,  10,  10,  10,  10,   9,   9,   9,   9,   9,   9,   8,   8,   8,   8
                db    8,   8,   8,   8,   7,   7,   7,   7,   7,   7,   6,   6,   6,   6,   6,   6
                db   11,  11,  11,  11,  10,  10,  10,  10,   9,   9,   9,   9,   9,   8,   8,   8
                db    8,   8,   8,   7,   7,   7,   7,   7,   6,   6,   6,   6,   5,   5,   5,   5
                db   12,  12,  12,  11,  11,  11,  10,  10,  10,   9,   9,   9,   9,   8,   8,   8
                db    8,   8,   8,   7,   7,   7,   7,   6,   6,   6,   5,   5,   5,   4,   4,   4
                db   13,  13,  12,  12,  12,  11,  11,  11,  10,  10,  10,   9,   9,   9,   8,   8
                db    8,   8,   7,   7,   7,   6,   6,   6,   5,   5,   5,   4,   4,   4,   3,   3
                db   14,  14,  13,  13,  12,  12,  11,  11,  10,  10,  10,   9,   9,   9,   8,   8
                db    8,   8,   7,   7,   7,   6,   6,   6,   5,   5,   4,   4,   3,   3,   2,   2
                db   15,  15,  14,  14,  13,  13,  12,  12,  11,  11,  10,  10,   9,   9,   8,   8
                db    8,   8,   7,   7,   6,   6,   5,   5,   4,   4,   3,   3,   2,   2,   1,   0
byte_1FBA:      db  00h, 00h, 00h, 00h, 00h, 00h, 00h, 02h, 05h, 07h, 0Ah, 0Ch, 0Fh, 11h, 13h, 16h
                                        ; DATA XREF: getKeyboardLevelScaling:loc_1D92↑o
                db  18h, 1Bh, 1Dh, 20h, 22h, 25h, 27h, 2Ah, 2Ch, 2Fh, 31h, 33h, 36h, 38h, 3Bh, 3Dh
                db  40h, 42h, 45h, 47h, 4Ah, 4Ch, 4Fh, 51h, 53h, 56h, 58h, 5Bh, 5Dh, 60h, 62h, 65h
                db  67h, 6Ah, 6Ch, 6Fh, 71h, 73h, 76h, 78h, 7Bh, 7Dh, 7Fh, 7Fh, 7Fh, 7Fh, 7Fh, 7Fh
                db  7Fh, 7Fh, 7Fh, 7Fh, 7Fh, 7Fh, 7Fh, 7Fh, 7Fh, 7Eh, 7Eh, 7Dh, 7Ch, 7Bh, 79h, 78h
                db  76h, 74h, 72h, 6Fh, 6Dh, 6Ah, 67h, 64h, 61h, 5Dh, 59h, 55h, 51h, 4Dh, 49h, 44h
                db  3Fh, 3Ah, 36h, 31h, 2Dh, 29h, 25h, 21h, 1Eh, 1Bh, 17h, 15h, 12h, 0Fh, 0Dh, 0Bh
                db  09h, 07h, 05h, 04h, 03h, 02h, 01h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h
                db  00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 01h, 03h, 06h
                db  09h, 0Ch, 0Fh, 14h, 18h, 1Eh, 23h, 2Ah, 2Ch, 30h, 34h, 38h, 3Ch, 40h, 44h, 48h
                db  4Ch, 50h, 54h, 58h, 5Ch, 61h, 77h, 7Fh, 88h, 93h, 9Fh,0ABh,0B8h,0C4h,0D0h,0DCh
                db 0E7h,0F1h,0FBh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
                db 0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FEh,0FEh,0FDh,0FAh,0F6h,0F1h
                db 0EBh,0E4h,0DCh,0D2h,0C6h,0B9h,0ABh, 9Ch, 8Eh, 81h, 75h, 6Ah, 60h, 57h, 4Fh, 48h
                db  41h, 3Bh, 36h, 31h, 2Dh, 29h, 25h, 21h, 1Eh, 1Bh, 17h, 15h, 12h, 0Fh, 0Dh, 0Bh
                db  09h, 07h, 05h, 04h, 03h, 02h, 01h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h

; =============== S U B R O U T I N E =======================================

; c = The master output level adjusts the output level of the entine music card. The values range from a minimum of 0 through a maximum of 127

setNodeParameterMasterOutputLevel:      ; CODE XREF: setNodeParameter+6↑j
                                        ; DATA XREF: setNodeParameter:nodeParameterMethods↑o
                ld      a, c
                cpl                     ; CPL inverts all bits of A
                and     7Fh
                ld      (masterOutputLevel), a
                ld      b, 8
                ld      c, 0

loc_20C5:                               ; CODE XREF: setNodeParameterMasterOutputLevel+17↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                call    setInstrumentVolume
                pop     bc
                djnz    loc_20C5
                ret
; End of function setNodeParameterMasterOutputLevel


; =============== S U B R O U T I N E =======================================

; c=value / iy=ptr to InstrumentParameters

setInstrumentParameter_OutputLevel:     ; CODE XREF: setInstrumentParameter+A↑j
                                        ; DATA XREF: setInstrumentParameter:setInstrumentConfigurationLookup↑o
                ld      (iy+InstrumentParameters.instrumentConfiguration.outputLevel), c
                jp      setInstrumentVolume
; End of function setInstrumentParameter_OutputLevel


; =============== S U B R O U T I N E =======================================

; c = control value / iy=ptr to InstrumentParameters

setInstrumentParameterVolume:           ; CODE XREF: ym2151_executeMidiCommand+39↑j
                                        ; setDefaultInstrumentParameters+1D↓p
                rrc     c
                res     7, c
                ld      a, c
                ld      hl, volume_table
                add     hl, a
                ld      a, (hl)
                ld      (iy+InstrumentParameters.volume), a
                jp      setInstrumentVolume
; End of function setInstrumentParameterVolume

; ---------------------------------------------------------------------------
volume_table:   db  3Fh, 3Dh, 3Bh, 39h, 37h, 35h, 33h, 31h, 2Fh, 2Dh, 2Bh, 29h, 27h, 25h, 23h, 21h
                                        ; DATA XREF: setInstrumentParameterVolume+5↑o
                db  20h, 1Fh, 1Eh, 1Dh, 1Ch, 1Bh, 1Ah, 19h, 18h, 17h, 16h, 15h, 14h, 13h, 12h, 11h
                db  10h, 0Fh, 0Fh, 0Eh, 0Eh, 0Dh, 0Dh, 0Ch, 0Ch, 0Bh, 0Bh, 0Ah, 0Ah, 09h, 09h, 08h
                db  08h, 07h, 07h, 06h, 06h, 05h, 05h, 04h, 04h, 03h, 03h, 02h, 02h, 01h, 01h, 00h

; =============== S U B R O U T I N E =======================================


ym_allOperators_sendKeyScaleAndAttackRate:
                                        ; CODE XREF: ym_noteON+3↓p
                ld      a, (ix+YmChannelData.channel0_to_ym_channel)
                and     7
                add     a, 80h
                ld      c, a            ; x = 0x80 + (channel0_to_ym_channel & 7)
---
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator0.field_4)
                ld      e, (iy+InstrumentParameters.voiceDefinition.operator0.field_5)
                call    ym_singleOperator_sendKeyScaleAndAttackRate ; c = 0x80 + ch
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator2.field_4)
                ld      e, (iy+InstrumentParameters.voiceDefinition.operator2.field_5)
                call    ym_singleOperator_sendKeyScaleAndAttackRate ; c = 0x88 + ch
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator1.field_4)
                ld      e, (iy+InstrumentParameters.voiceDefinition.operator1.field_5)
                call    ym_singleOperator_sendKeyScaleAndAttackRate ; c = 0x90 + ch
                ld      b, (iy+InstrumentParameters.voiceDefinition.operator3.field_4)
                ld      e, (iy+InstrumentParameters.voiceDefinition.operator3.field_5)
; End of function ym_allOperators_sendKeyScaleAndAttackRate

c = 0x98 + ch

; =============== S U B R O U T I N E =======================================

; b = voiceDefinition.operator.field_4 / c = ym register / e = voiceDefinition.operator.field_5
; Note: c will be incremented by 8

ym_singleOperator_sendKeyScaleAndAttackRate:
                                        ; CODE XREF: ym_allOperators_sendKeyScaleAndAttackRate+E↑p
                                        ; ym_allOperators_sendKeyScaleAndAttackRate+17↑p ...
                ld      a, e            ; a = field_5
                rlca
                rlca
                rlca
                and     3               ; a = <bb> <b>: Velocity sensitivity to attack rate (VSAR)
                jr      z, loc_218B
-------
                ld      e, a
                ld      a, (lastMidiOnOff_KeyVelocity)
                add     a, a            ; a = lastMidiOnOff_KeyVelocity*2
                and     0F0h            ; a = lastMidiOnOff_KeyVelocity*2 & 0xF0
                or      e               ; a = lastMidiOnOff_KeyVelocity*2 & 0xF0 | <00bb>
                rrca
                rrca
                rrca
                rrca                    ; a = (lastMidiOnOff_KeyVelocity>>3 & 0x0F) | <00bb0000>
                ld      hl, byte_2194
                add     hl, a
                ld      e, (hl)         ; e = byte_2194[(lastMidiOnOff_KeyVelocity>>3 & 0x0F) | <00bb0000>]
                ld      a, b
                and     1Fh             ; a = attack rate from field4
                add     a, e            ; a = attack rate from field4 + byte_2194[(lastMidiOnOff_KeyVelocity>>3 & 0x0F) | <00bb0000>]
                jp      m, loc_2183
                cp      2
                jr      c, loc_2183     ; if (a < 0x02) jmp loc_2183
                cp      20h ; ' '
                jr      c, loc_2185     ; if (a < 0x20) jmp loc_2185
                ld      a, 1Fh
                jr      loc_2185
; ---------------------------------------------------------------------------

loc_2183:                               ; CODE XREF: ym_singleOperator_sendKeyScaleAndAttackRate+1F↑j
                                        ; ym_singleOperator_sendKeyScaleAndAttackRate+24↑j
                ld      a, 2

loc_2185:                               ; CODE XREF: ym_singleOperator_sendKeyScaleAndAttackRate+28↑j
                                        ; ym_singleOperator_sendKeyScaleAndAttackRate+2C↑j
                ld      e, a
                ld      a, b
                and     0C0h
                or      e
                ld      b, a

loc_218B:                               ; CODE XREF: ym_singleOperator_sendKeyScaleAndAttackRate+6↑j
                ld      a, b
                call    sendToYM2151_no_interrupts_allowed ; set KS (Key Scaling) and AR (Attack Rate)
                ld      a, c
                add     a, 8
                ld      c, a
                ret
; End of function ym_singleOperator_sendKeyScaleAndAttackRate

; ---------------------------------------------------------------------------
byte_2194:      db    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
                                        ; DATA XREF: ym_singleOperator_sendKeyScaleAndAttackRate+14↑o
                db   -4,  -3,  -3,  -2,  -2,  -1,  -1,   0,   0,   1,   1,   2,   2,   3,   3,   4
                db   -8,  -6,  -5,  -4,  -3,  -2,  -1,   0,   0,   1,   2,   3,   4,   5,   6,   8
                db  -12, -10,  -8,  -6,  -4,  -2,  -1,   0,   0,   1,   2,   4,   6,   8,  10,  12

; =============== S U B R O U T I N E =======================================


ym_key_off_on_all_channels:             ; CODE XREF: RESTART_IN_THRU_MODE+F↑p
                                        ; readMidiDataWithTimeout+7B↑p ...
                call    jmpStartMusicProcessing
------
                ld      b, 20h ; ' '
                ld      c, 0E0h
                ld      a, 0Fh

loc_21DD:                               ; CODE XREF: ym_key_off_on_all_channels+D↓j
                call    sendToYM2151_no_interrupts_allowed ; D1L (First Decay Level) / RR (Release Rate)
                inc     c
                djnz    loc_21DD
-------
KEY OFF on all channels
                ld      b, 8
                ld      c, 8
                ld      a, 0

loc_21E9:                               ; CODE XREF: ym_key_off_on_all_channels+19↓j
                call    sendToYM2151_no_interrupts_allowed ; (SN)^KON / (CH #)
                inc     a
                djnz    loc_21E9
---------
                ld      b, 8
                ld      c, 0

loc_21F3:                               ; CODE XREF: ym_key_off_on_all_channels+2C↓j
                push    bc
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                call    setDefaultInstrumentParameters
                pop     bc
                inc     c
                djnz    loc_21F3
-------
                jp      jmpStopMusicProcessing
; End of function ym_key_off_on_all_channels


; =============== S U B R O U T I N E =======================================

; iy=ptr to InstrumentParameters

setDefaultInstrumentParameters:         ; CODE XREF: setInstrumentParameter_MidiChannelNumber+3B↑j
                                        ; sub_154F↑p ...
                call    jmpStartMusicProcessing
                call    applyInstrumentConfiguration?
                ld      c, 0
                call    setInstrumentParameterSustainOnOff
                ld      c, 7Fh
                call    setInstrumentParameterPortamentoOnOff
                ld      c, 0
                call    setInstrumentParameterSostenutoOnOff
                ld      de, 40h ; '@'
                call    executeMidiCommand_PitchBender
                ld      c, 7Fh
                call    setInstrumentParameterVolume
                ld      a, (iy+InstrumentParameters.channelMask)
--------
                ld      b, 8
                ld      de, 4
                ld      ix, strangeMemory

loc_2231:                               ; CODE XREF: setDefaultInstrumentParameters+32↓j
                rrca
                call    c, resetYmChannelData
                add     ix, de
                djnz    loc_2231
-------
                jp      jmpStopMusicProcessing
; End of function setDefaultInstrumentParameters


; =============== S U B R O U T I N E =======================================

; ix = ptrStrangeMemory / iy = ptrInstrumentParameters

resetYmChannelData:                     ; CODE XREF: setDefaultInstrumentParameters+2D↑p
                ld      hl, 0
                ld      (ix+YmChannelData.channel0_currentlyPlaying), l
                ld      (ix+YmChannelData.channel0_currentlyPlaying.note), h
                ld      (ix+YmChannelData.channel0_portamentoTarget), l
                ld      (ix+YmChannelData.channel0_portamentoTarget.note), h
                ld      (ix-20h), l     ; WTF ?!
                ld      (ix-1Fh), h     ; WTF ?!
                push    ix
                pop     hl
                ld      (iy+InstrumentParameters.strangeMemoryLSB), l
                ld      (iy+InstrumentParameters.strangeMemoryMSB), h
                ret
; End of function resetYmChannelData


; =============== S U B R O U T I N E =======================================

; iy=ptr to InstrumentParameters

applyInstrumentConfiguration?:          ; CODE XREF: setInstrumentParameter_MonoPolyMode+B↑p
                                        ; applyInstrumentParameter?+3↑p ...
                call    jmpStartMusicProcessing
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 ), 80h
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h
                ld      b, 8
                ld      c, 0
                ld      a, (iy+InstrumentParameters.channelMask)

loc_226D:                               ; CODE XREF: applyInstrumentConfiguration?+24↓j
                rrca
                jr      nc, loc_227E
                push    af
                push    bc
                ld      a, c
                call    getYmChannelData
                push    hl
                pop     ix
                call    ym_noteOFF_fastRelease
                pop     bc
                pop     af

loc_227E:                               ; CODE XREF: applyInstrumentConfiguration?+13↑j
                inc     c
                djnz    loc_226D
                jp      jmpStopMusicProcessing
; End of function applyInstrumentConfiguration?


; =============== S U B R O U T I N E =======================================

; c = control value / iy=ptr to InstrumentParameters

setInstrumentParameter_AllNotesOFF:     ; CODE XREF: ym2151_executeMidiCommand+52↑j
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 ), 80h
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h
                ld      b, 8
                ld      c, 0
                ld      a, (iy+InstrumentParameters.channelMask)

loc_2293:                               ; CODE XREF: setInstrumentParameter_AllNotesOFF+21↓j
                rrca
                jr      nc, nextChannel
                push    af
                push    bc
                ld      a, c
                call    getYmChannelData
                push    hl
                pop     ix
                call    ym_noteOFF
                pop     bc
                pop     af

nextChannel:                            ; CODE XREF: setInstrumentParameter_AllNotesOFF+10↑j
                inc     c
                djnz    loc_2293
                ret
; End of function setInstrumentParameter_AllNotesOFF


; =============== S U B R O U T I N E =======================================

; 0xFA: When the music card receives a start message (0xFA), the MIDI real-time clock resets and begins to count
; 0xFB: When the music card receives a continue message (0xFB), the MIDI real-time clock resumes counting

processSystemRealTimeMessage_FA_and_FB: ; CODE XREF: processSystemRealTimeMessage+6↑j
                                        ; DATA XREF: processSystemRealTimeMessage:jpt_548↑o
                call    jmpStartMusicProcessing
                ld      a, 1
                ld      (systemRealtimeMessageInProgress), a
                call    logErrorOrSuccess
                jp      jmpStopMusicProcessing
; End of function processSystemRealTimeMessage_FA_and_FB


; =============== S U B R O U T I N E =======================================

; When the music card receives a stop message (0xFC), the MIDI real-time clock stops counting and stops playing notes started by an event list

processSystemRealTimeMessage_FC:        ; CODE XREF: SOFT_REBOOT+31↑p
                                        ; readMidiDataWithTimeout+83↑p ...
                call    jmpStartMusicProcessing ; jumptable 00000548 case 4
                ld      b, 8
                ld      c, 0

loc_22BD:                               ; CODE XREF: processSystemRealTimeMessage_FC+1C↓j
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (iy+InstrumentParameters.channelMask)
                and     a
                jr      z, noActiveChannels
                bit     0, (iy+InstrumentParameters.instrumentConfiguration.polyMonoMode)
                call    nz, realTimeMessage_FC_MonoMode ; if (bit 0 of (iy+InstrumentParameters.instrumentConfiguration.monoPolyMode) != 0) call sub_22F4

noActiveChannels:                       ; CODE XREF: processSystemRealTimeMessage_FC+12↑j
                inc     c
                djnz    loc_22BD
-------
                ld      b, 8
                ld      de, 4
                ld      ix, strangeMemory

nextChannel:                            ; CODE XREF: processSystemRealTimeMessage_FC+32↓j
                ld      a, (ix+YmChannelData.channel0_remainingDuration)
                or      (ix+ YmChannelData.channel0_remainingDuration+1 )
                call    nz, noteOffDueToMidiRealTimeClock
                add     ix, de
                djnz    nextChannel
-------
                xor     a
                ld      (systemRealtimeMessageInProgress), a
                call    logErrorOrSuccess
                jp      jmpStopMusicProcessing
; End of function processSystemRealTimeMessage_FC


; =============== S U B R O U T I N E =======================================


realTimeMessage_FC_MonoMode:            ; CODE XREF: processSystemRealTimeMessage_FC+18↑p
                ld      a, (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 )
                bit     7, a
                jr      nz, loc_2304    ; if (bit 7 of a != 0) jmp loc_2304
                or      (iy+InstrumentParameters.lastMidiOnOff_Duration_YYY)
                jr      z, loc_2304
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h

loc_2304:                               ; CODE XREF: realTimeMessage_FC_MonoMode+5↑j
                                        ; realTimeMessage_FC_MonoMode+A↑j
                ld      a, (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 )
                bit     7, a
                jr      nz, locret_232C ; if (bit 7 of a != 0) jmp locret_232C
                or      (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX)
                jr      z, locret_232C
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_Duration_YYY)
                ld      (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX), a
---
                ld      a, (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 )
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 ), a
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX), a
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.note)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.note), a
---
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h

locret_232C:                            ; CODE XREF: realTimeMessage_FC_MonoMode+15↑j
                                        ; realTimeMessage_FC_MonoMode+1A↑j
                ret
; End of function realTimeMessage_FC_MonoMode


; =============== S U B R O U T I N E =======================================

; The music card uses the duration count of the MIDI real-time clock (sync clock) when processing the system exclusive message event list

processSystemRealTimeMessage_F8:        ; CODE XREF: processSystemRealTimeMessage+6↑j
                                        ; DATA XREF: processSystemRealTimeMessage:jpt_548↑o
                ld      a, (systemRealtimeMessageInProgress)
                bit     0, a
                ret     z               ; if (bit 0 of a == 0) return
                call    jmpStartMusicProcessing
                ld      b, 8
                ld      c, 0

loc_233A:                               ; CODE XREF: processSystemRealTimeMessage_F8+22↓j
                ld      a, c
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (iy+InstrumentParameters.channelMask)
                and     a
                jr      z, loc_234E
                bit     0, (iy+InstrumentParameters.instrumentConfiguration.polyMonoMode)
                call    nz, sub_2377    ; if (bit 0 of (iy+InstrumentParameters.instrumentConfiguration.monoPolyMode) != 0) call sub_2377

loc_234E:                               ; CODE XREF: processSystemRealTimeMessage_F8+18↑j
                inc     c
                djnz    loc_233A
---
                ld      b, 8
                ld      de, 4
                ld      ix, strangeMemory

loc_235A:                               ; CODE XREF: processSystemRealTimeMessage_F8+45↓j
                ld      l, (ix+YmChannelData.channel0_remainingDuration)
                ld      h, (ix+ YmChannelData.channel0_remainingDuration+1 )
                ld      a, l
                or      h
                jr      z, loc_2370
                dec     hl
                ld      (ix+YmChannelData.channel0_remainingDuration), l
                ld      (ix+ YmChannelData.channel0_remainingDuration+1 ), h
                ld      a, l
                or      h
                call    z, noteOffDueToMidiRealTimeClock

loc_2370:                               ; CODE XREF: processSystemRealTimeMessage_F8+35↑j
                add     ix, de
                djnz    loc_235A
                jp      jmpStopMusicProcessing
; End of function processSystemRealTimeMessage_F8


; =============== S U B R O U T I N E =======================================


sub_2377:                               ; CODE XREF: processSystemRealTimeMessage_F8+1E↑p
                ld      l, (iy+InstrumentParameters.lastMidiOnOff_Duration_YYY)
                ld      h, (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 )
                bit     7, h
                jr      nz, loc_2394    ; if (bit 7 of h != 0) jmp loc_2394
                ld      a, l
                or      h
                jr      z, loc_2394
                dec     hl
                ld      (iy+InstrumentParameters.lastMidiOnOff_Duration_YYY), l
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), h
                ld      a, l
                or      h
                jr      nz, loc_2394
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h
-------

loc_2394:                               ; CODE XREF: sub_2377+8↑j
                                        ; sub_2377+C↑j ...
                ld      l, (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX)
                ld      h, (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 )
                bit     7, h
                jr      nz, locret_23C9 ; if (bit 7 of h != 0) jmp locret_23C9
                ld      a, l
                or      h
                jr      z, locret_23C9
                dec     hl
                ld      (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX), l
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 ), h
                ld      a, l
                or      h
                jr      nz, locret_23C9
-------
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_Duration_YYY)
                ld      (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX), a
---
                ld      a, (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 )
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 ), a
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.fraction)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.fraction), a
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.note)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.note), a
---
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h

locret_23C9:                            ; CODE XREF: sub_2377+25↑j
                                        ; sub_2377+29↑j ...
                ret
; End of function sub_2377


; =============== S U B R O U T I N E =======================================


noteOffDueToMidiRealTimeClock:          ; CODE XREF: processSystemRealTimeMessage_FC+2D↑p
                                        ; processSystemRealTimeMessage_F8+40↑p
                push    bc
                push    de
                ld      l, (ix+YmChannelData.channel0_ptrInstrumentParameters)
                ld      h, (ix+ YmChannelData.channel0_ptrInstrumentParameters+1 )
                push    hl
                pop     iy
                bit     0, (iy+InstrumentParameters.instrumentConfiguration.polyMonoMode)
                jr      nz, monoMode    ; if (bit 0 of (iy+InstrumentParameters.instrumentConfiguration.monoPolyMode) != 0) jmp loc_23E1
polyMode:
                call    ym_noteOFF
                pop     de
                pop     bc
                ret
; ---------------------------------------------------------------------------

monoMode:                               ; CODE XREF: noteOffDueToMidiRealTimeClock+F↑j
                call    sub_2613
                pop     de
                pop     bc
                ret
; End of function noteOffDueToMidiRealTimeClock


; =============== S U B R O U T I N E =======================================

; c = control value / iy=ptr to InstrumentParameters

setInstrumentParameterSustainOnOff:     ; CODE XREF: ym2151_executeMidiCommand+43↑j
                                        ; setDefaultInstrumentParameters+8↑p
                set     0, (iy+InstrumentParameters.flags)
                bit     6, c
                ret     nz              ; if (bit 6 of c != 0) return
                res     0, (iy+InstrumentParameters.flags)
                ld      b, 8
                ld      c, (iy+InstrumentParameters.channelMask)
                ld      ix, strangeMemory

loc_23FB:                               ; CODE XREF: setInstrumentParameterSustainOnOff+2E↓j
                rrc     c
                jr      nc, nextChannel
                bit     6, (ix+YmChannelData.channel0_flags)
                jr      z, nextChannel  ; if (bit 6 of (ix+StrangeMemory.channel0_memC.byte1) == 0) jmp loc_2410
                bit     7, (ix+YmChannelData.channel0_flags)
                jr      nz, nextChannel ; if (bit 7 of (ix+StrangeMemory.channel0_memC.byte1) != 0) jmp loc_2410
                push    bc
                call    ym_noteOFF
                pop     bc

nextChannel:                            ; CODE XREF: setInstrumentParameterSustainOnOff+16↑j
                                        ; setInstrumentParameterSustainOnOff+1C↑j ...
                ld      de, 4
                add     ix, de
                djnz    loc_23FB
                ret
; End of function setInstrumentParameterSustainOnOff


; =============== S U B R O U T I N E =======================================

; c = control value / iy=ptr to InstrumentParameters

setInstrumentParameterSostenutoOnOff:   ; CODE XREF: ym2151_executeMidiCommand+4D↑j
                                        ; setDefaultInstrumentParameters+12↑p
                bit     6, c
                jr      nz, loc_2446    ; if (bit 6 of c != 0) jmp loc_2446
---
                ld      b, 8
                ld      c, (iy+InstrumentParameters.channelMask)
                ld      ix, strangeMemory

loc_2425:                               ; CODE XREF: setInstrumentParameterSostenutoOnOff+2B↓j
                rrc     c
                jr      nc, nextChannel
                res     4, (ix+YmChannelData.channel0_flags)
                bit     6, (ix+YmChannelData.channel0_flags)
                jr      z, nextChannel  ; if (bit 6 of (ix+StrangeMemory.channel0_memC.byte1) == 0) jmp loc_243E
                bit     7, (ix+YmChannelData.channel0_flags)
                jr      nz, nextChannel ; if (bit 7 of (ix+StrangeMemory.channel0_memC.byte1) != 0) jmp loc_243E
                push    bc
                call    ym_noteOFF
                pop     bc

nextChannel:                            ; CODE XREF: setInstrumentParameterSostenutoOnOff+F↑j
                                        ; setInstrumentParameterSostenutoOnOff+19↑j ...
                ld      de, 4
                add     ix, de
                djnz    loc_2425
                ret
; ---------------------------------------------------------------------------

loc_2446:                               ; CODE XREF: setInstrumentParameterSostenutoOnOff+2↑j
                ld      b, 8
                ld      c, (iy+InstrumentParameters.channelMask)
                ld      de, 4
                ld      ix, strangeMemory

loc_2452:                               ; CODE XREF: setInstrumentParameterSostenutoOnOff+4A↓j
                rrc     c
                jr      nc, loc_2460
                bit     7, (ix+YmChannelData.channel0_flags)
                jr      z, loc_2460     ; if (bit 7 of (ix+StrangeMemory.channel0_memC.byte1) == 0) jmp loc_2460
                set     4, (ix+YmChannelData.channel0_flags)

loc_2460:                               ; CODE XREF: setInstrumentParameterSostenutoOnOff+3C↑j
                                        ; setInstrumentParameterSostenutoOnOff+42↑j
                add     ix, de
                djnz    loc_2452
                ret
; End of function setInstrumentParameterSostenutoOnOff


; =============== S U B R O U T I N E =======================================

; de = Note number(d) + fraction (e) / hl=duration / iy=ptr to InstrumentParameters

noActiveChannels_forward_to_midiout:    ; CODE XREF: executeMidiCommand_NoteONOFF_internal+F↓j
                                        ; executeMidiCommand_NoteONOFF_internal+62↓j ...
                bit     0, (iy+InstrumentParameters.overflowToMidiOut)
                ret     z               ; if (bit 0 of (iy+InstrumentParameters.field_69) == 0) return
                ld      hl, (lastMidiOnOff_Duration)
                ld      a, l
                add     hl, hl
                and     7Fh
                ld      l, a            ; hl = hl(16bit) -> 0b0aaaaaaa + 0b0aaaaaaa
---
                ld      a, (lastMidiOnOff_FractionAndNoteNumber.note)
                ld      e, a
---
                ld      a, (lastMidiOnOff_FractionAndNoteNumber.fraction)
                rrca
                and     7Fh
                ld      d, a
---
                ld      a, l
                or      h
                jr      nz, forwardToMidiOut_7bytes
                ld      a, d
                and     a
                jr      nz, forwardToMidiOut_5bytes
---
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.midiChannel)
                or      90h
                ld      (outgoingMusicCardMessageData), a
                ld      a, e
                ld      (outgoingMusicCardMessageData+1), a
                ld      a, (lastMidiOnOff_KeyVelocity)
                ld      (outgoingMusicCardMessageData+2), a
                ld      b, 3
                jr      forwardToMidiOut
; End of function noActiveChannels_forward_to_midiout


; =============== S U B R O U T I N E =======================================

; de = Note number(d) + fraction (e) / iy=ptr to InstrumentParameters

forwardToMidiOut_5bytes:                ; CODE XREF: noActiveChannels_forward_to_midiout+1E↑j
                ld      a, 0FFh
                ld      (outgoingMusicCardMessageData), a ; outgoingMusicCardMessageData[0] = 0xFF
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.midiChannel)
                or      10h
                ld      (outgoingMusicCardMessageData+1), a ; outgoingMusicCardMessageData[1] = (iy+InstrumentParameters.instrumentConfiguration.midiChannel) | 0x10
                                        ;
                                        ; midiChannel + 16
                ld      (outgoingMusicCardMessageData+2), de ; outgoingMusicCardMessageData[2] = Note number(d)
                                        ; outgoingMusicCardMessageData[3] = fraction (e)
                ld      a, (lastMidiOnOff_KeyVelocity)
                ld      (outgoingMusicCardMessageData+4), a ; outgoingMusicCardMessageData[4] = lastMidiOnOff_KeyVelocity
                ld      b, 5
                jr      forwardToMidiOut
; End of function forwardToMidiOut_5bytes


; =============== S U B R O U T I N E =======================================

; de = Note number(d) + fraction (e) / hl=duration / iy=ptr to InstrumentParameters

forwardToMidiOut_7bytes:                ; CODE XREF: noActiveChannels_forward_to_midiout+1A↑j
                ld      a, 0FFh
                ld      (outgoingMusicCardMessageData), a ; outgoingMusicCardMessageData[0] = 0xFF
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.midiChannel)
                or      20h ; ' '       ; midi channel + 32
                ld      (outgoingMusicCardMessageData+1), a ; outgoingMusicCardMessageData[1] = (iy+InstrumentParameters.instrumentConfiguration.midiChannel) | 0x20
                ld      (outgoingMusicCardMessageData+2), de ; outgoingMusicCardMessageData[2] = Note number(d)
                                        ; outgoingMusicCardMessageData[3] = fraction (e)
                ld      a, (lastMidiOnOff_KeyVelocity)
                ld      (outgoingMusicCardMessageData+4), a ; outgoingMusicCardMessageData[4] = lastMidiOnOff_KeyVelocity
                ld      (outgoingMusicCardMessageData+5), hl ; outgoingMusicCardMessageData[5&6] = duration
                ld      b, 7
; End of function forwardToMidiOut_7bytes


; =============== S U B R O U T I N E =======================================

; b = number of bytes to send

forwardToMidiOut:                       ; CODE XREF: noActiveChannels_forward_to_midiout+34↑j
                                        ; forwardToMidiOut_5bytes+19↑j
                ld      hl, outgoingMusicCardMessageData
                jp      sendMidiResponse_to_MidiOut
; End of function forwardToMidiOut


; =============== S U B R O U T I N E =======================================

; c = MidiCmdByte (0x8X, 0x9X) / d = note number (0-127) / e = key velocity / iy=ptr to InstrumentParameters

executeMidiCommand_NoteONOFF:           ; CODE XREF: ym2151_executeMidiCommand:ym2151_executeMidiCommand_NoteON↑j
                ld      c, e
                ld      e, 0
                ld      hl, 0
                jp      executeMidiCommand_NoteONOFF_internal
; End of function executeMidiCommand_NoteONOFF


; =============== S U B R O U T I N E =======================================

; c = Key velocity / d = Note number / e = fraction / hl=duration / iy=ptr to InstrumentParameters

executeMidiCommand_NoteONOFF_internal_guard:
                                        ; CODE XREF: executeMidiCommand_NoteONOFFForAllAssignInstruments+70↓p
                call    jmpStartMusicProcessing
                call    executeMidiCommand_NoteONOFF_internal
                jp      jmpStopMusicProcessing
; End of function executeMidiCommand_NoteONOFF_internal_guard


; =============== S U B R O U T I N E =======================================

; c = Key velocity / d = Note number / e = fraction / hl=duration / iy=ptr to InstrumentParameters

executeMidiCommand_NoteONOFF_internal:  ; CODE XREF: executeMidiCommand_NoteONOFF+6↑j
                                        ; executeMidiCommand_NoteONOFF_internal_guard+3↑p
                ld      (lastMidiOnOff_FractionAndNoteNumber.fraction), de
                ld      a, c
                ld      (lastMidiOnOff_KeyVelocity), a
                ld      (lastMidiOnOff_Duration), hl
---
                ld      a, (iy+InstrumentParameters.channelMask)
                and     a
                jp      z, noActiveChannels_forward_to_midiout
---
                ld      a, (activeConfiguration.noteNumberReceptionMode)
                cp      1               ; 1=Even
                jr      nz, loc_2508    ; if (a != 0x01) jmp loc_2508
; this section is for even
                bit     0, d
                ret     nz              ; if (bit 0 of d != 0) return
                jr      allEvenAndOddNotes
; ---------------------------------------------------------------------------

loc_2508:                               ; CODE XREF: executeMidiCommand_NoteONOFF_internal+17↑j
                cp      2               ; 2=Odd
                jr      nz, allEvenAndOddNotes ; if (a != 0x02) jmp loc_250F
; this section is for odd
                bit     0, d
                ret     z               ; if (bit 0 of d == 0) return

allEvenAndOddNotes:                     ; CODE XREF: executeMidiCommand_NoteONOFF_internal+1C↑j
                                        ; executeMidiCommand_NoteONOFF_internal+20↑j
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitHigh)
                cp      d
                ret     c               ; if (currentNote > instrumentConfiguration.noteNumberLimitHigh) return
---
                ld      a, d
                cp      (iy+InstrumentParameters.instrumentConfiguration.noteNumberLimitLow)
                ret     c               ; if (instrumentConfiguration.noteNumberLimitLow < currentNote) return
---
                bit     0, (iy+InstrumentParameters.instrumentConfiguration.polyMonoMode)
                jp      nz, applySub25B9_for_first_active_channel_because_MONO_MODE ; if (bit 0 of (iy+InstrumentParameters.instrumentConfiguration.monoPolyMode) != 0) jmp loc_25A8
---
                ld      a, c            ; a = keyVelocity
                and     a
                jr      nz, POLY_MODE_KeyVelocity_non_zero ; if (keyVelocity != 0) jmp loc_254F
; POLY_MODE_KeyVelocity_zero
                ld      b, 8
                ld      c, (iy+InstrumentParameters.channelMask)
                ld      ix, strangeMemory

loc_252D:                               ; CODE XREF: executeMidiCommand_NoteONOFF_internal+60↓j
                rrc     c
                jr      nc, channelNotAssigned
                bit     7, (ix+YmChannelData.channel0_flags)
                jr      z, channelNotAssigned ; if (bit 7 of (ix+StrangeMemory.channel0_memC.byte1) == 0) jmp loc_2543
                ld      l, (ix-20h)     ; WTF ?!?
                ld      h, (ix-1Fh)     ; WTF ?!?
                or      a
                sbc     hl, de          ; hl = hl - de - carryFlag
                jp      z, ym_noteOFF

channelNotAssigned:                     ; CODE XREF: executeMidiCommand_NoteONOFF_internal+45↑j
                                        ; executeMidiCommand_NoteONOFF_internal+4B↑j
                push    de
                ld      de, 4
                add     ix, de
                pop     de
                djnz    loc_252D
                jp      noActiveChannels_forward_to_midiout
; ---------------------------------------------------------------------------

POLY_MODE_KeyVelocity_non_zero:         ; CODE XREF: executeMidiCommand_NoteONOFF_internal+38↑j
                ld      de, 4
                ld      b, 8
                ld      c, (iy+InstrumentParameters.lastUsedChannel)

loc_2557:                               ; CODE XREF: executeMidiCommand_NoteONOFF_internal:loc_256E↓j
                rlc     c               ; 8-bit rotation to the left. The bit leaving on the left is copied into the carry, and to bit 0.
                ld      a, (iy+InstrumentParameters.channelMask)
                and     c
                jr      z, loc_256E
                call    getYmChannelData_for_first_active_channel
                bit     6, (ix+YmChannelData.channel0_flags)
                jr      nz, loc_256E    ; if (bit 6 of (ix+StrangeMemory.channel0_memC.byte1) != 0) jmp loc_256E
                ld      (iy+InstrumentParameters.lastUsedChannel), c
                jp      ym_fastNoteOFF_noteON
; ---------------------------------------------------------------------------

loc_256E:                               ; CODE XREF: executeMidiCommand_NoteONOFF_internal+73↑j
                                        ; executeMidiCommand_NoteONOFF_internal+7C↑j
                djnz    loc_2557
no_available_channels:
                ld      a, (chainMode)
                bit     0, a
                jp      nz, noActiveChannels_forward_to_midiout ; if (chainMode == CHAIN_ON) jmp noActiveChannels_forward_to_midiout
chainMode is OFF
try to find another way
                ld      b, 8

loc_257A:                               ; CODE XREF: executeMidiCommand_NoteONOFF_internal:loc_258B↓j
                rlc     c               ; 8-bit rotation to the left. The bit leaving on the left is copied into the carry, and to bit 0.
                ld      a, (iy+InstrumentParameters.channelMask)
                and     c
                jr      z, loc_258B
                call    getYmChannelData_for_first_active_channel
                bit     7, (ix+YmChannelData.channel0_flags)
                jr      z, loc_2598     ; if (bit 7 of (ix+StrangeMemory.channel0_memC.byte1) == 0) jmp loc_2598

loc_258B:                               ; CODE XREF: executeMidiCommand_NoteONOFF_internal+96↑j
                djnz    loc_257A
still no luck on finding a free channel
Just get the next channel

loc_258D:                               ; CODE XREF: executeMidiCommand_NoteONOFF_internal+A9↓j
                rlc     c               ; 8-bit rotation to the left. The bit leaving on the left is copied into the carry, and to bit 0.
                ld      a, (iy+InstrumentParameters.channelMask)
                and     c
                jr      z, loc_258D
                call    getYmChannelData_for_first_active_channel

loc_2598:                               ; CODE XREF: executeMidiCommand_NoteONOFF_internal+9F↑j
                ld      (iy+InstrumentParameters.lastUsedChannel), c
                jp      ym_fastNoteOFF_delay_noteON
; End of function executeMidiCommand_NoteONOFF_internal


; =============== S U B R O U T I N E =======================================

; a = channelMask -> ix = ptr StrangeMemory

getYmChannelData_for_first_active_channel:
                                        ; CODE XREF: executeMidiCommand_NoteONOFF_internal+75↑p
                                        ; executeMidiCommand_NoteONOFF_internal+98↑p ...
                ld      ix, strangeMemory

loc_25A2:                               ; CODE XREF: getYmChannelData_for_first_active_channel+8↓j
                rrca
                ret     c
                add     ix, de
                jr      loc_25A2
; End of function getYmChannelData_for_first_active_channel


; =============== S U B R O U T I N E =======================================

; d = Note number / e = fraction / iy = ptrInstrumentParameters

applySub25B9_for_first_active_channel_because_MONO_MODE:
                                        ; CODE XREF: executeMidiCommand_NoteONOFF_internal+33↑j
                ld      a, (iy+InstrumentParameters.channelMask)
                ld      bc, 4
                ld      ix, strangeMemory

loc_25B2:                               ; CODE XREF: applySub25B9_for_first_active_channel_because_MONO_MODE+F↓j
                rrca
                jr      c, loc_25B9
                add     ix, bc
                jr      loc_25B2
; ---------------------------------------------------------------------------

loc_25B9:                               ; CODE XREF: applySub25B9_for_first_active_channel_because_MONO_MODE+B↑j
                ld      a, (lastMidiOnOff_KeyVelocity)
                and     a
                jp      nz, sub_264B
---
                bit     7, (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 )
                jr      nz, sub_25D6    ; if (bit 7 of (iy+InstrumentParameters.field_64) != 0) jmp loc_25D6
---
                ld      l, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.fraction)
                ld      h, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.note)
                or      a
                sbc     hl, de          ; Sum of second operand and carry flag is subtracted from the first operand. Results are written into the first operand.
                jr      nz, sub_25D6
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h
                ret
; End of function applySub25B9_for_first_active_channel_because_MONO_MODE


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters / de = ???

sub_25D6:                               ; CODE XREF: applySub25B9_for_first_active_channel_because_MONO_MODE+1C↑j
                                        ; applySub25B9_for_first_active_channel_because_MONO_MODE+27↑j
                bit     7, (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 )
                jr      nz, loc_2604    ; if (bit 7 of (iy+InstrumentParameters.field_60) != 0) jmp loc_2604
                ld      l, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX)
                ld      h, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.note)
                or      a
                sbc     hl, de          ; Sum of second operand and carry flag is subtracted from the first operand. Results are written into the first operand.
                jr      nz, loc_2604
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_Duration_YYY)
                ld      (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX), a
                ld      a, (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 )
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 ), a
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX), a
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.note)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.note), a
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h
                ret
; ---------------------------------------------------------------------------

loc_2604:                               ; CODE XREF: sub_25D6+4↑j
                                        ; sub_25D6+F↑j
                bit     7, (ix+YmChannelData.channel0_flags)
                ret     z               ; if (bit 7 of (ix+StrangeMemory.channel0_memC.byte1) == 0) return
                ld      l, (ix-20h)     ; WTF
                ld      h, (ix-1Fh)     ; WTF
                or      a
                sbc     hl, de
                ret     nz
; End of function sub_25D6


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

sub_2613:                               ; CODE XREF: noteOffDueToMidiRealTimeClock:monoMode↑p
                bit     7, (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 )
                jp      nz, ym_noteOFF  ; if (bit 7 of (iy+InstrumentParameters.field_60) != 0) jmp sub_2689
-------
                ld      l, (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX)
                ld      h, (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 )
                ld      (lastMidiOnOff_Duration), hl ; lastMidiOnOff_Duration = (field_60, field_5F)
------
                ld      l, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX)
                ld      h, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.note)
                ld      (lastMidiOnOff_FractionAndNoteNumber.fraction), hl ; lastMidiOnOff_FractionAndNoteNumber = (field_62, field_61)
------
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_Duration_YYY)
                ld      (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX), a ; field_5F = field_63
                ld      a, (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 )
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 ), a ; field_60 = field_64
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX), a ; field_61 = field_65
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.note)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.note), a ; field_62 = field_66
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), 80h ; field_64 = 0x80
                jp      sub_26DA
; End of function sub_2613


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

sub_264B:                               ; CODE XREF: applySub25B9_for_first_active_channel_because_MONO_MODE+15↑j
                bit     7, (ix+YmChannelData.channel0_flags)
                jp      z, sub_26E0     ; if (bit 7 of (ix+65) == 0) jmp loc_26E0
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.note)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.note), a ; field_66 = field_62
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.fraction)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_YYY.fraction), a ; field_65 = field_61
---
                ld      a, (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 )
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_YYY+1 ), a ; field_64 = field_60
---
                ld      a, (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX)
                ld      (iy+InstrumentParameters.lastMidiOnOff_Duration_YYY), a ; field_63 = field_5F
---
                ld      l, (ix-20h)     ; WTF ?!?
                ld      h, (ix-1Fh)     ; WTF ?!?
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX), l ; field_61 = (ix+0E0h)
                ld      (iy+InstrumentParameters.lastMidiOnOff_FractionAndNoteNumber_XXX.note), h ; field_62 = (ix+0E1h)
---
                ld      l, (ix+YmChannelData.channel0_remainingDuration)
                ld      h, (ix+ YmChannelData.channel0_remainingDuration+1 )
                ld      (iy+InstrumentParameters.lastMidiOnOff_Duration_XXX), l ; field_5F = (ix+StrangeMemory.channel0_memC.byte2)
                ld      (iy+ InstrumentParameters.lastMidiOnOff_Duration_XXX+1 ), h ; field_60 = (ix+StrangeMemory.channel0_memC.byte3)
---
                jp      sub_26DA
; End of function sub_264B


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

ym_noteOFF_fastRelease:                 ; CODE XREF: applyInstrumentConfiguration?+1E↑p
                                        ; sub_26E0↓p ...
                ld      d, 0Fh
                jr      loc_2699
; End of function ym_noteOFF_fastRelease


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

ym_noteOFF:                             ; CODE XREF: setInstrumentParameter_AllNotesOFF+1B↑p
                                        ; noteOffDueToMidiRealTimeClock+11↑p ...
                res     7, (ix+YmChannelData.channel0_flags)
                bit     0, (iy+InstrumentParameters.flags) ; sustain flag
                ret     nz              ; if (bit 0 of (iy+InstrumentParameters.field_57) != 0) return
                bit     4, (ix+YmChannelData.channel0_flags)
                ret     nz              ; if (bit 4 of (ix+StrangeMemory.channel0_memC.byte1) != 0) return
                ld      d, 0

loc_2699:                               ; CODE XREF: ym_noteOFF_fastRelease+2↑j
                call    ym_setFirstDecayLevelAndReleaseRate
                ld      hl, 0
                ld      (ix+YmChannelData.channel0_remainingDuration), l
                ld      (ix+ YmChannelData.channel0_remainingDuration+1 ), h
                ld      (ix+YmChannelData.channel0_flags), 0
                ld      a, (ix+YmChannelData.channel0_to_ym_channel)
                and     7
                ld      c, 8
                call    sendToYM2151_no_interrupts_allowed ;  Key OFF
                ret
; End of function ym_noteOFF


; =============== S U B R O U T I N E =======================================

; d = value to be ORed to ymCmdValue (0x00 or 0x0F) / ix = ptrStangeMemory / iy = ptrInstrumentParameters

ym_setFirstDecayLevelAndReleaseRate:    ; CODE XREF: ym_noteOFF:loc_2699↑p
                ld      a, (ix+YmChannelData.channel0_to_ym_channel)
                and     7
                add     a, 0E0h
                ld      c, a
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator0.field_7)
                call    loc_26D1
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator2.field_7)
                call    loc_26D1
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator1.field_7)
                call    loc_26D1
                ld      a, (iy+InstrumentParameters.voiceDefinition.operator3.field_7)

loc_26D1:                               ; CODE XREF: ym_setFirstDecayLevelAndReleaseRate+B↑p
                                        ; ym_setFirstDecayLevelAndReleaseRate+11↑p ...
                or      d
                call    sendToYM2151_no_interrupts_allowed
                ld      a, c
                add     a, 8
                ld      c, a
                ret
; End of function ym_setFirstDecayLevelAndReleaseRate


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

sub_26DA:                               ; CODE XREF: sub_2613+35↑j
                                        ; sub_264B+37↑j
                call    sub_2724
                jp      ym_registerKey_setKeyCodeAndFraction_IncludingPortamento
; End of function sub_26DA


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

sub_26E0:                               ; CODE XREF: sub_264B+4↑j
                call    ym_noteOFF_fastRelease
                call    sub_2724
                call    ym_registerKey_setKeyCodeAndFraction_Special
                jr      ym_noteON
; End of function sub_26E0


; =============== S U B R O U T I N E =======================================


ym_fastNoteOFF_delay_noteON:            ; CODE XREF: executeMidiCommand_NoteONOFF_internal+B1↑j
                call    ym_noteOFF_fastRelease
                ld      b, 0

loc_26F0:                               ; CODE XREF: ym_fastNoteOFF_delay_noteON:loc_26F0↓j
                djnz    $               ; delay
                ld      b, 0

loc_26F4:                               ; CODE XREF: ym_fastNoteOFF_delay_noteON:loc_26F4↓j
                djnz    $               ; delay
                jr      sub_26FB
; End of function ym_fastNoteOFF_delay_noteON


; =============== S U B R O U T I N E =======================================


ym_fastNoteOFF_noteON:                  ; CODE XREF: executeMidiCommand_NoteONOFF_internal+81↑j
                call    ym_noteOFF_fastRelease
; End of function ym_fastNoteOFF_noteON


; =============== S U B R O U T I N E =======================================


sub_26FB:                               ; CODE XREF: ym_fastNoteOFF_delay_noteON+B↑j
                call    sub_2724
                call    ym_registerKey_setKeyCodeAndFraction_IncludingPortamento
; End of function sub_26FB


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

ym_noteON:                              ; CODE XREF: sub_26E0+9↑j
                call    ym_calculateAndUpdateOperatorVolumes
                call    ym_allOperators_sendKeyScaleAndAttackRate
                bit     7, (iy+InstrumentParameters.flags)
                jr      z, loc_271B     ; if (bit 7 of (iy+InstrumentParameters.field_57) == 0) jmp loc_271B
-- LFO sync mode
                ld      a, 2
                ld      c, 9
                call    sendToYM2151_with_disabled_interrupts
                nop
                nop
                ld      a, 0
                call    sendToYM2151_no_interrupts_allowed

loc_271B:                               ; CODE XREF: ym_noteON+A↑j
                ld      a, (ix+YmChannelData.channel0_to_ym_channel) ; get the channel AND the operator enabled flags
                ld      c, 8
                call    sendToYM2151_no_interrupts_allowed ; Set KeyON/OFF
                ret
; End of function ym_noteON


; =============== S U B R O U T I N E =======================================

; ix = ptrStangeMemory / iy = ptrInstrumentParameters

sub_2724:                               ; CODE XREF: sub_26DA↑p
                                        ; sub_26E0+3↑p ...
                ld      (ix+YmChannelData.channel0_flags), 0C0h
                ld      hl, (lastMidiOnOff_FractionAndNoteNumber.fraction)
                ld      d, (iy+InstrumentParameters.voiceDefinition.transpose)
                ld      e, 0
                call    cropToPlayableRange
                ld      (ix+YmChannelData.channel0_portamentoTarget.fraction), l
                ld      (ix+YmChannelData.channel0_portamentoTarget.note), h
                ret
; End of function sub_2724


; =============== S U B R O U T I N E =======================================


SoundProcessor_SetToInitialState:       ; CODE XREF: set_MidiIn_To_SP_InitialState+8↑p
                                        ; set_System_To_SP_InitialState+8↑p ...
                xor     a
                ld      (soundProcessorMidiInterpreterState), a
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                ld      (hl), a         ; SP_MidiDataOfMidiCommandInProgress[0] = 0
                ld      d, h
                ld      e, l
                inc     de
                ld      bc, 100h
                ldir                    ; memset(SP_MidiDataOfMidiCommandInProgress, 0, 0x100)
                call    initializeSysExStateMatchTable
                jp      initMidiChannelToAssignedInstruments
; End of function SoundProcessor_SetToInitialState


; =============== S U B R O U T I N E =======================================


SoundProcessor_SetState_SysEx_EventListTransferToMusicCard:
                                        ; CODE XREF: soundProcessor_handle_midi_0xFE_0xFF+2↑p
                ld      a, 44h ; 'D'
                ld      (soundProcessorMidiInterpreterState), a
                ld      a, 0
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function SoundProcessor_SetState_SysEx_EventListTransferToMusicCard


; =============== S U B R O U T I N E =======================================


SoundProcessor_SetState_SysEx_ParameterListTransferToMusicCard:
                                        ; CODE XREF: soundProcessor_handle_midi_0xFE_0xFF:loc_863↑p
                ld      a, 45h ; 'E'
                ld      (soundProcessorMidiInterpreterState), a
                ld      a, 0
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function SoundProcessor_SetState_SysEx_ParameterListTransferToMusicCard


; =============== S U B R O U T I N E =======================================

; a = midi byte -> void

SoundProcessor_processMidiByte:         ; CODE XREF: conditional_send_midi_byte_to_SP+22↑p
                ld      c, a
                ld      a, (soundProcessorMidiInterpreterState)
                and     0F0h
                jr      nz, loc_2771
                jp      SoundProcessor_processMidiCommandByte
; ---------------------------------------------------------------------------

loc_2771:                               ; CODE XREF: SoundProcessor_processMidiByte+6↑j
                cp      10h
                jr      nz, loc_2778    ; if (a != 0x10) jmp loc_2778
                jp      SoundProcessor_processMidiByte_3ByteMidiCommandState
; ---------------------------------------------------------------------------

loc_2778:                               ; CODE XREF: SoundProcessor_processMidiByte+D↑j
                cp      20h ; ' '
                jr      nz, loc_277F    ; if (a != 0x20) jmp loc_277F
                jp      SoundProcessor_processMidiByte_2ByteMidiCommandState
; ---------------------------------------------------------------------------

loc_277F:                               ; CODE XREF: SoundProcessor_processMidiByte+14↑j
                jp      SoundProcessor_processSysExStates
; End of function SoundProcessor_processMidiByte


; =============== S U B R O U T I N E =======================================


logMidiError:                           ; CODE XREF: processSysExCmd_NodeMessage_SetVoiceBankData+1D↓p
                                        ; processSysExCmd_NodeMessage_SetConfiguration1+5↓p ...
                ld      hl, midi_error_message_1 ; "  MIDI error !!!"
                jp      logErrorOrSuccess
; End of function logMidiError

; ---------------------------------------------------------------------------
midi_error_message_1:.ascii '  MIDI error !!!'
                                        ; DATA XREF: logMidiError↑o

; =============== S U B R O U T I N E =======================================

; c = midi byte -> void

SoundProcessor_processMidiCommandByte:  ; CODE XREF: SoundProcessor_processMidiByte+8↑j
                                        ; SoundProcessor_processMidiByte_3ByteMidiCommandState+3↓j ...
                xor     a
                ld      (soundProcessorMidiInterpreterState), a
                ld      a, c
                cp      80h
                jr      c, locret_27D2  ; if (a < 0x80) jmp locret_27D2
                cp      0F0h
                jr      nz, loc_27B3    ; if (a != 0xf0) jmp loc_27B3
SoundProcessor_processSysExCommand:
                ld      hl, sp_SysExStateMatchTable
                ld      (soundProcessorSysExCurrentMatchPtr), hl
                xor     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ld      a, 30h ; '0'
                jr      loc_27CB
; ---------------------------------------------------------------------------

loc_27B3:                               ; CODE XREF: SoundProcessor_processMidiCommandByte+B↑j
                and     0F0h
                cp      0A0h
                jr      z, locret_27D2  ; if (a == 0xa0) jmp locret_27D2
                                        ; if (midiByte & 0xF0) == 0xA0 (Polyphonic Key Pressure (Aftertouch)) goto skip
                cp      0F0h
                jr      z, locret_27D2  ; if (a == 0xf0) jmp locret_27D2
                                        ; if (midiByte & 0xF0) == 0xF0 (SysEx)) goto skip
                cp      0C0h
                jr      z, loc_27C9     ; if (a == 0xc0) jmp loc_27C9
                                        ; if (midiByte & 0xF0) == 0xC0 (Program Change) { SoundProcessorMidiInterpreterState = 0x20; }
                cp      0D0h
                jr      z, loc_27C9     ; if (a == 0xd0) jmp loc_27C9
                                        ; if (midiByte & 0xF0) == 0xD0 (Channel Pressure (After-touch)) { SoundProcessorMidiInterpreterState = 0x20; }
                ld      a, 10h          ; SoundProcessorMidiInterpreterState = 0x10 for (midiByte & 0xF0) in (0x80, 0x90, 0xB0, 0xE0)
                jr      loc_27CB
; ---------------------------------------------------------------------------

loc_27C9:                               ; CODE XREF: SoundProcessor_processMidiCommandByte+27↑j
                                        ; SoundProcessor_processMidiCommandByte+2B↑j
                ld      a, 20h ; ' '

loc_27CB:                               ; CODE XREF: SoundProcessor_processMidiCommandByte+19↑j
                                        ; SoundProcessor_processMidiCommandByte+2F↑j
                ld      (soundProcessorMidiInterpreterState), a
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress), a

locret_27D2:                            ; CODE XREF: SoundProcessor_processMidiCommandByte+7↑j
                                        ; SoundProcessor_processMidiCommandByte+1F↑j ...
                ret
; End of function SoundProcessor_processMidiCommandByte


; =============== S U B R O U T I N E =======================================

; c = midi byte -> void

SoundProcessor_processMidiByte_3ByteMidiCommandState:
                                        ; CODE XREF: SoundProcessor_processMidiByte+F↑j
                ld      a, c
                cp      80h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x80) jmp loc_2798
                ld      a, (soundProcessorMidiInterpreterState)
                and     0Fh
                ld      a, c
                jr      nz, loc_27E8
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                ld      a, 11h
                jr      loc_27F0
; ---------------------------------------------------------------------------

loc_27E8:                               ; CODE XREF: SoundProcessor_processMidiByte_3ByteMidiCommandState+C↑j
                ld      (sp_MidiDataOfMidiCommandInProgress+2), a
                call    SoundProcessor_executeMidiCommand
                ld      a, 10h

loc_27F0:                               ; CODE XREF: SoundProcessor_processMidiByte_3ByteMidiCommandState+13↑j
                ld      (soundProcessorMidiInterpreterState), a
                ret
; End of function SoundProcessor_processMidiByte_3ByteMidiCommandState


; =============== S U B R O U T I N E =======================================

; c = midi byte -> void

SoundProcessor_processMidiByte_2ByteMidiCommandState:
                                        ; CODE XREF: SoundProcessor_processMidiByte+16↑j
                ld      a, c
                cp      80h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x80) jmp loc_2798
                ld      l, c
                ld      h, 0
                ld      (sp_MidiDataOfMidiCommandInProgress+1), hl
; End of function SoundProcessor_processMidiByte_2ByteMidiCommandState


; =============== S U B R O U T I N E =======================================

; void -> void

SoundProcessor_executeMidiCommand:      ; CODE XREF: SoundProcessor_processMidiByte_3ByteMidiCommandState+18↑p
                                        ; processSysExCmd_EventList_ControlChange+15↓p ...
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                and     0Fh
                ld      e, a
                rlca
                rlca
                rlca
                add     a, e
                ld      d, 0
                ld      e, a
                ld      hl, midiChannelToAssignedInstruments
                add     hl, de
                ld      a, (hl)
                cp      0FFh
                jr      nz, loc_283E    ; if (a != 0xff) jmp loc_283E
                ld      a, (chainMode)
                bit     0, a
                jr      z, loc_283E     ; if (bit 0 of a == 0) jmp loc_283E
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                cp      0A0h
                jr      nc, loc_283E    ; if (a >= 0xa0) jmp loc_283E
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                cp      90h
                jr      nz, loc_2836    ; if (a != 0x90) jmp loc_2836
                and     0Fh
                or      90h
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                xor     a
                ld      (sp_MidiDataOfMidiCommandInProgress+2), a

loc_2836:                               ; CODE XREF: SoundProcessor_executeMidiCommand+29↑j
                ld      b, 3
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                jp      sendMidiResponse_to_MidiOut
; ---------------------------------------------------------------------------

loc_283E:                               ; CODE XREF: SoundProcessor_executeMidiCommand+14↑j
                                        ; SoundProcessor_executeMidiCommand+1B↑j ...
                ld      a, (hl)
                cp      0FFh
                jr      z, locret_285A  ; if (a == 0xff) jmp locret_285A
                push    hl
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                ld      c, a
                ld      hl, (sp_MidiDataOfMidiCommandInProgress+1)
                ld      d, l
                ld      e, h
                call    ym2151_JumpToExecuteMidiCommand
                pop     hl
                inc     hl
                jr      loc_283E
; ---------------------------------------------------------------------------

locret_285A:                            ; CODE XREF: SoundProcessor_executeMidiCommand+41↑j
                ret
; End of function SoundProcessor_executeMidiCommand


; =============== S U B R O U T I N E =======================================


executeMidiCommand_NoteONOFFForAllAssignInstruments:
                                        ; CODE XREF: processSysExCmd_EventList_NoteOFF+1F↓p
                                        ; processSysExCmd_EventList_NoteONOFF+2B↓p ...
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                and     0Fh
                ld      e, a
                rlca
                rlca
                rlca
                add     a, e
                ld      d, 0
                ld      e, a
                ld      hl, midiChannelToAssignedInstruments
                add     hl, de
                ld      a, (hl)
                cp      0FFh
                jr      nz, loc_28A7    ; if (a != 0xff) jmp loc_28A7
                ld      a, (chainMode)
                bit     0, a
                jr      z, loc_28A7     ; if (bit 0 of a == 0) jmp loc_28A7
                ld      a, 0FFh
                ld      (outgoingMusicCardMessageData), a
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                and     0Fh
                or      20h ; ' '
                ld      (outgoingMusicCardMessageData+1), a
                ld      hl, (sp_MidiDataOfMidiCommandInProgress+1)
                ld      (outgoingMusicCardMessageData+2), hl
                ld      a, (sp_MidiDataOfMidiCommandInProgress+3)
                ld      (outgoingMusicCardMessageData+4), a
                ld      hl, (sp_MidiDataOfMidiCommandInProgress+4)
                ld      (outgoingMusicCardMessageData+5), hl
                ld      b, 5
                ld      a, l
                or      h
                jr      z, loc_28A1
                ld      b, 7

loc_28A1:                               ; CODE XREF: executeMidiCommand_NoteONOFFForAllAssignInstruments+42↑j
                ld      hl, outgoingMusicCardMessageData
                jp      sendMidiResponse_to_MidiOut
; ---------------------------------------------------------------------------

loc_28A7:                               ; CODE XREF: executeMidiCommand_NoteONOFFForAllAssignInstruments+14↑j
                                        ; executeMidiCommand_NoteONOFFForAllAssignInstruments+1B↑j ...
                ld      a, (hl)
                cp      0FFh
                jr      z, locret_28D2  ; if (a == 0xff) jmp locret_28D2
                push    hl
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (sp_MidiDataOfMidiCommandInProgress+1)
                ld      d, a
                ld      a, (sp_MidiDataOfMidiCommandInProgress+2)
                add     a, a
                ld      e, a
                ld      a, (sp_MidiDataOfMidiCommandInProgress+3)
                ld      c, a
                ld      hl, (sp_MidiDataOfMidiCommandInProgress+4)
                rl      l               ; 9-bit rotation to the left. the register's bits are shifted left. The carry value is put into 0th bit of the register, and the leaving 7th bit is put into the carry.
                rr      h               ; 9-bit rotation to the right. The carry is copied into bit 7, and the bit leaving on the right is copied into the carry.
                rr      l               ; 9-bit rotation to the right. The carry is copied into bit 7, and the bit leaving on the right is copied into the carry.
                res     7, h
                call    executeMidiCommand_NoteONOFF_internal_guard
                pop     hl
                inc     hl
                jr      loc_28A7
; ---------------------------------------------------------------------------

locret_28D2:                            ; CODE XREF: executeMidiCommand_NoteONOFFForAllAssignInstruments+4F↑j
                ret
; End of function executeMidiCommand_NoteONOFFForAllAssignInstruments


; =============== S U B R O U T I N E =======================================

; void

processSysExCmd_InstrumentParameterChange:
                                        ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByMidiChannel:loc_2A35↓p
                                        ; processSysExCmd_EventList_ParameterChange:loc_31EA↓p
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                cp      40h ; '@'
                jr      c, midiCmdSmallerThan0x40 ; if (a < 0x40) jmp loc_28E9
midiCmd>=0x40
                ld      a, (sp_MidiDataOfMidiCommandInProgress+2)
                rlca
                rlca
                rlca
                rlca
                ld      e, a
                ld      a, (sp_MidiDataOfMidiCommandInProgress+1)
                or      e
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a

midiCmdSmallerThan0x40:                 ; CODE XREF: processSysExCmd_InstrumentParameterChange+5↑j
                ld      a, (sysEx_ChannelNumber)
                ld      e, a
                rlca
                rlca
                rlca
                add     a, e
                ld      d, 0
                ld      e, a
                ld      hl, midiChannelToAssignedInstruments
                add     hl, de

loc_28F8:                               ; CODE XREF: processSysExCmd_InstrumentParameterChange+3D↓j
                ld      a, (hl)
                cp      0FFh
                jr      z, locret_2912  ; if (a == 0xff) jmp locret_2912
                push    hl
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (sp_MidiDataOfMidiCommandInProgress+1)
                ld      c, a
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                call    setInstrumentParameter
                pop     hl
                inc     hl
                jr      loc_28F8
; ---------------------------------------------------------------------------

locret_2912:                            ; CODE XREF: processSysExCmd_InstrumentParameterChange+28↑j
                ret
; End of function processSysExCmd_InstrumentParameterChange


; =============== S U B R O U T I N E =======================================

; c = midi byte -> void

SoundProcessor_processSysExStates:      ; CODE XREF: SoundProcessor_processMidiByte:loc_277F↑j
                ld      a, (soundProcessorMidiInterpreterState)
                cp      30h ; '0'
                jr      nz, loc_294F    ; if (a != 0x30) jmp loc_294F
-------
                ld      a, c            ; First byte after a 0xF0 (SysEx) command
                cp      80h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x80) jmp SoundProcessor_processMidiCommandByte
---------
                ld      hl, (soundProcessorSysExCurrentMatchPtr)
                ld      a, (hl)

loc_2924:                               ; CODE XREF: SoundProcessor_processSysExStates+26↓j
                ld      b, c
                cp      80h
                jr      c, loc_292C     ; if (a < 0x80) jmp loc_292C
                call    processSysExTemplateCommand

loc_292C:                               ; CODE XREF: SoundProcessor_processSysExStates+14↑j
                cp      b
                jr      z, loc_293E     ; if (a == b) jmp loc_293E
                                        ; does the current midi byte match with the template? yes->continue to next byte / no-> add 7 to
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= b) jmp SoundProcessor_processMidiCommandByte
                ld      de, 7
                add     hl, de
                ld      a, (hl)
                cp      0F0h
                jr      nz, loc_2924    ; if (a != 0xf0) jmp loc_2924
                jp      SoundProcessor_processMidiCommandByte
; ---------------------------------------------------------------------------

loc_293E:                               ; CODE XREF: SoundProcessor_processSysExStates+1A↑j
                inc     hl
                ld      a, (hl)
                cp      0FFh
                jr      nz, loc_294B    ; if (a != 0xff) jmp loc_294B
                inc     hl
                ld      a, (hl)
                ld      (soundProcessorMidiInterpreterState), a
                jr      locret_294E
; ---------------------------------------------------------------------------

loc_294B:                               ; CODE XREF: SoundProcessor_processSysExStates+2F↑j
                ld      (soundProcessorSysExCurrentMatchPtr), hl

locret_294E:                            ; CODE XREF: SoundProcessor_processSysExStates+36↑j
                ret
; ---------------------------------------------------------------------------

loc_294F:                               ; CODE XREF: SoundProcessor_processSysExStates+5↑j
                sub     31h ; '1'
                rlca
                ld      d, 0
                ld      e, a
                ld      hl, codeJumpTable
                add     hl, de
                ld      e, (hl)
                inc     hl
                ld      d, (hl)
                ex      de, hl
                call    (hl)            ; switch 27 cases
                ret
; End of function SoundProcessor_processSysExStates

; ---------------------------------------------------------------------------
codeJumpTable:  dw processSysExCmd_F0_43_0n_0C
                                        ; DATA XREF: SoundProcessor_processSysExStates+42↑o
                dw processSysExCmd_InstrumentParameterChange_ByMidiChannel ; jump table for switch statement
                dw processSysExCmd_F0_43_2n_0C
                dw processSysExCmd_NodeMessage_SetVoiceBankData
                dw processSysExCmd_NodeMessage_SetConfiguration1
                dw processSysExCmd_NodeMessage_SetConfigurationMemory
                dw processSysExCmd_NodeMessage_SetConfigurationRAM
                dw processSysExCmd_InstrumentMessage_SetInstrumentVoice
                dw processSysExCmd_NodeParameterChangeMessage
                dw processSysExCmd_InstrumentParameterChange_ByInstrument
                dw processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank
                dw processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1
                dw processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration
                dw processSysExCmd_NodeDumpRequestMessage_ConfigurationRAM
                dw processSysExCmd_NodeDumpRequestMessage_MusicCardID
                dw processSysExCmd_NodeDumpRequestMessage_MusicCardRevision
                dw processSysExCmd_StoreRequest_StoreConfigurationData
                dw processSysExCmd_F0_43_75_0n_2i_00
                dw processSysExCmd_StoreRequest_StoreVoiceData
                dw processSysExCmd_EventListTransferToMusicCard
                dw processSysExCmd_ParameterListTransferToMusicCard
                dw processSysExCmd_NodeMessage_SetConfiguration2
                dw processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1
                dw processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2
                dw processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2
                dw processSysExCmd_F0_43_75_0n_2i_01
                dw processSysExCmd_F0_43_75_0n_2i_02

; =============== S U B R O U T I N E =======================================

; a = template byte / b = current midi data byte -> a=expected midi value (based on template) / b=new midi value (striped of InstrumentNumber/ChannelNumber)

processSysExTemplateCommand:            ; CODE XREF: SoundProcessor_processSysExStates+16↑p
                ld      d, a
                and     0F0h
                cp      0A0h
                jr      nz, loc_29B1    ; if (a != 0xa0) jmp loc_29B1
-- Template byte is of type ChannelNumber
                ld      a, b
                and     0Fh
                ld      (sysEx_ChannelNumber), a
                ld      a, b
                and     0F0h            ; strip out the channel number from the midi byte
                ld      b, a
                ld      a, d
                rlca
                rlca
                rlca
                rlca
                and     0F0h            ; a = (templateByte<<4) & 0xF0
                jr      locret_29C8
; ---------------------------------------------------------------------------

loc_29B1:                               ; CODE XREF: processSysExTemplateCommand+5↑j
                cp      90h
                jr      nz, locret_29C8 ; if (a != 0x90) jmp locret_29C8
-- Template byte is of type InstrumentNumber
                ld      a, b
                and     7
                ld      (sysEx_InstrumentNumber), a
                ld      a, b
                and     0F8h
                ld      b, a            ; clear the instrument number from the midi data
                ld      a, d
                rlca
                rlca
                rlca
                rlca
                and     0F0h
                or      8               ; a = (templateByte<<4) & 0xF0 | 0x08

locret_29C8:                            ; CODE XREF: processSysExTemplateCommand+18↑j
                                        ; processSysExTemplateCommand+1C↑j
                ret
; End of function processSysExTemplateCommand


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 0

processSysExCmd_F0_43_0n_0C:            ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (memoryProtection)
                or      a
                jr      z, loc_29D4     ; if (a == 0) jmp loc_29D4
                ld      bc, 304h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_29D4:                               ; CODE XREF: processSysExCmd_F0_43_0n_0C+4↑j
                ld      a, c
                cp      80h
                jr      nc, loc_29E4    ; if (a >= 0x80) jmp loc_29E4
                ld      de, voiceDefinitionBankCustom1
                ld      bc, 0C20h
                call    receiveDataPacketTypeA
                jr      nc, loc_29E9

loc_29E4:                               ; CODE XREF: processSysExCmd_F0_43_0n_0C+E↑j
                ld      bc, 203h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_29E9:                               ; CODE XREF: processSysExCmd_F0_43_0n_0C+19↑j
                ld      bc, 102h

localSendResponse:                      ; CODE XREF: processSysExCmd_F0_43_0n_0C+9↑j
                                        ; processSysExCmd_F0_43_0n_0C+1E↑j
                jp      sendResponse
; End of function processSysExCmd_F0_43_0n_0C


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 1

processSysExCmd_InstrumentParameterChange_ByMidiChannel:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, c
                cp      80h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x80) jmp SoundProcessor_processMidiCommandByte
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      z, SysExState0x00 ; if (a == 0) jmp loc_2A05
                cp      1
                jr      z, SysExState0x01 ; if (a == 0x01) jmp loc_2A17
                cp      10h
                jr      z, SysExState0x10 ; if (a == 0x10) jmp loc_2A1D
                jr      SysExStateOther
; ---------------------------------------------------------------------------

SysExState0x00:                         ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByMidiChannel+A↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                cp      40h ; '@'
                jr      nc, loc_2A11    ; if (a >= 0x40) jmp loc_2A11
                ld      a, 1
                jr      loc_2A13
; ---------------------------------------------------------------------------

loc_2A11:                               ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByMidiChannel+1C↑j
                ld      a, 10h

loc_2A13:                               ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByMidiChannel+20↑j
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

SysExState0x01:                         ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByMidiChannel+E↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                jr      loc_2A35
; ---------------------------------------------------------------------------

SysExState0x10:                         ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByMidiChannel+12↑j
                ld      a, c
                cp      10h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x10) jmp SoundProcessor_processMidiCommandByte
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                ld      a, 11h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

SysExStateOther:                        ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByMidiChannel+14↑j
                ld      a, c
                cp      10h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x10) jmp SoundProcessor_processMidiCommandByte
                ld      (sp_MidiDataOfMidiCommandInProgress+2), a

loc_2A35:                               ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByMidiChannel+2C↑j
                call    processSysExCmd_InstrumentParameterChange
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                cp      1
                call    z, initMidiChannelToAssignedInstruments ; if (a == 0x01) call initMidiChannelToAssignedInstruments
                call    logErrorOrSuccess
                xor     a
                ld      (soundProcessorMidiInterpreterState), a
                ret
; End of function processSysExCmd_InstrumentParameterChange_ByMidiChannel


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 2

processSysExCmd_F0_43_2n_0C:            ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, c
                cp      80h
                jr      nc, loc_2A53    ; if (a >= 0x80) jmp loc_2A53
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2A53:                               ; CODE XREF: processSysExCmd_F0_43_2n_0C+3↑j
                push    bc
                ld      a, 0F0h
                call    send_midi_byte
                jr      c, loc_2A75
                ld      a, 43h ; 'C'
                call    send_midi_byte
                jr      c, loc_2A75
                ld      a, (nodeNumber)
                call    send_midi_byte
                jr      c, loc_2A75
                ld      a, 0Ch
                call    send_midi_byte
                jr      c, loc_2A75
                xor     a
                call    sendVoiceDefinitionBank

loc_2A75:                               ; CODE XREF: processSysExCmd_F0_43_2n_0C+11↑j
                                        ; processSysExCmd_F0_43_2n_0C+18↑j ...
                pop     bc
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_F0_43_2n_0C


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 3

processSysExCmd_NodeMessage_SetVoiceBankData:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (memoryProtection)
                or      a
                jr      z, loc_2A84     ; if (a == 0) jmp loc_2A84
                ld      bc, 304h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2A84:                               ; CODE XREF: processSysExCmd_NodeMessage_SetVoiceBankData+4↑j
                ld      a, c
                cp      2
                jr      c, loc_2A8E     ; if (a < 0x02) jmp loc_2A8E
                ld      bc, 4
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2A8E:                               ; CODE XREF: processSysExCmd_NodeMessage_SetVoiceBankData+E↑j
                call    getVoiceDefinitionBank

loc_2A91:                               ; CODE XREF: processSysExCmd_NodeMessage_SetVoiceBankData:loc_2A9E↓j
                call    readMidiData
                jr      nc, loc_2A9E
                call    logMidiError
                ld      bc, 3
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2A9E:                               ; CODE XREF: processSysExCmd_NodeMessage_SetVoiceBankData+1B↑j
                jr      z, loc_2A91
                cp      80h
                jr      nc, loc_2AAD    ; if (a >= 0x80) jmp loc_2AAD
----
                ex      de, hl
                ld      bc, 0C20h
                call    receiveDataPacketTypeA
                jr      nc, loc_2AB2

loc_2AAD:                               ; CODE XREF: processSysExCmd_NodeMessage_SetVoiceBankData+29↑j
                ld      bc, 203h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2AB2:                               ; CODE XREF: processSysExCmd_NodeMessage_SetVoiceBankData+32↑j
                ld      bc, 102h

localSendResponse:                      ; CODE XREF: processSysExCmd_NodeMessage_SetVoiceBankData+9↑j
                                        ; processSysExCmd_NodeMessage_SetVoiceBankData+13↑j ...
                jp      sendResponse
; End of function processSysExCmd_NodeMessage_SetVoiceBankData


; =============== S U B R O U T I N E =======================================


processSysExCmd_NodeMessage_SetConfiguration1:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_NodeMessage_SetConfiguration1:loc_2AC5↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 4
                jr      nc, loc_2AC5
                call    logMidiError
                ld      bc, 3
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2AC5:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration1+3↑j
                jr      z, processSysExCmd_NodeMessage_SetConfiguration1
                cp      80h
                jr      nc, loc_2AD6    ; if (a >= 0x80) jmp loc_2AD6
                ld      bc, 0A0h
                ld      de, sp_MidiDataOfMidiCommandInProgress
                call    receiveDataPacketTypeB
                jr      nc, loc_2ADB

loc_2AD6:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration1+11↑j
                ld      bc, 203h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2ADB:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration1+1C↑j
                ld      bc, 0A0h
                ld      de, activeConfiguration
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                ldir
                call    proc_1393_called_for_Reboot
                call    initMidiChannelToAssignedInstruments
                call    logErrorOrSuccess
                ld      bc, 2

localSendResponse:                      ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration1+B↑j
                                        ; processSysExCmd_NodeMessage_SetConfiguration1+21↑j
                jp      sendResponse
; End of function processSysExCmd_NodeMessage_SetConfiguration1


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 5

processSysExCmd_NodeMessage_SetConfigurationMemory:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (memoryProtection)
                or      a
                jr      z, loc_2B00     ; if (a == 0) jmp loc_2B00
                ld      bc, 304h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2B00:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfigurationMemory+4↑j
                ld      a, c
                cp      10h
                jr      c, loc_2B0A     ; if (a < 0x10) jmp loc_2B0A
                ld      bc, 4
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2B0A:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfigurationMemory+E↑j
                call    getConfigurationData

loc_2B0D:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfigurationMemory:loc_2B1A↓j
                call    readMidiData
                jr      nc, loc_2B1A
                call    logMidiError
                ld      bc, 3
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2B1A:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfigurationMemory+1B↑j
                jr      z, loc_2B0D
                cp      80h
                jr      nc, loc_2B2D    ; if (a >= 0x80) jmp loc_2B2D
                push    hl
                ld      de, sp_MidiDataOfMidiCommandInProgress
                ld      bc, 0A0h
                call    receiveDataPacketTypeB
                pop     de
                jr      nc, loc_2B32

loc_2B2D:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfigurationMemory+29↑j
                ld      bc, 203h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2B32:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfigurationMemory+36↑j
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                ld      bc, 0A0h
                ldir
--------
                ld      bc, 2

localSendResponse:                      ; CODE XREF: processSysExCmd_NodeMessage_SetConfigurationMemory+9↑j
                                        ; processSysExCmd_NodeMessage_SetConfigurationMemory+13↑j ...
                jp      sendResponse
; End of function processSysExCmd_NodeMessage_SetConfigurationMemory

; ---------------------------------------------------------------------------

processSysExCmd_NodeMessage_SetConfigurationRAM:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (memoryProtection) ; jumptable 0000295D case 6
                or      a
                jr      z, loc_2B4B     ; if (a == 0) jmp loc_2B4B
                ld      bc, 304h
                jr      loc_2B71
; ---------------------------------------------------------------------------

loc_2B4B:                               ; CODE XREF: ROM:2B44↑j
                                        ; ROM:loc_2B58↓j
                call    readMidiData
                jr      nc, loc_2B58
                call    logMidiError
                ld      bc, 3
                jr      loc_2B71
; ---------------------------------------------------------------------------

loc_2B58:                               ; CODE XREF: ROM:2B4E↑j
                jr      z, loc_2B4B
                cp      80h
                jr      nc, loc_2B69    ; if (a >= 0x80) jmp loc_2B69
                ld      bc, 0A00h
                ld      de, configurationRAM
                call    receiveDataPacketTypeB
                jr      nc, loc_2B6E

loc_2B69:                               ; CODE XREF: ROM:2B5C↑j
                ld      bc, 203h
                jr      loc_2B71
; ---------------------------------------------------------------------------

loc_2B6E:                               ; CODE XREF: ROM:2B67↑j
                ld      bc, 102h

loc_2B71:                               ; CODE XREF: ROM:2B49↑j
                                        ; ROM:2B56↑j ...
                jp      sendResponse

; =============== S U B R O U T I N E =======================================


processSysExCmd_NodeMessage_SetConfiguration2:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_NodeMessage_SetConfiguration2:loc_2B81↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 21
                jr      nc, loc_2B81
                call    logMidiError
                ld      bc, 3
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2B81:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration2+3↑j
                jr      z, processSysExCmd_NodeMessage_SetConfiguration2
                cp      80h
                jr      nc, loc_2B92    ; if (a >= 0x80) jmp loc_2B92
                ld      bc, 0A0h
                ld      de, sp_MidiDataOfMidiCommandInProgress
                call    receiveDataPacketTypeB
                jr      nc, loc_2B97

loc_2B92:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration2+11↑j
                ld      bc, 203h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2B97:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration2+1C↑j
                ld      a, (activeConfiguration.lfoSpeed)
                push    af
                ld      a, (activeConfiguration.amplitudeModulationDepth)
                push    af
                ld      a, (activeConfiguration.pitchModulationDepth)
                push    af
                ld      a, (activeConfiguration.lfoWaveForm)
                push    af
-------
                ld      bc, 20h ; ' '
                ld      de, activeConfiguration
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                ldir                    ; just copy the pure configuration data without the instrumentConfigurations
------
                pop     af
                ld      (activeConfiguration.lfoWaveForm), a
                pop     af
                ld      (activeConfiguration.pitchModulationDepth), a
                pop     af
                ld      (activeConfiguration.amplitudeModulationDepth), a
                pop     af
                ld      (activeConfiguration.lfoSpeed), a
-----
                ld      a, 8
                ld      bc, 0Bh

loc_2BC7:                               ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration2+5F↓j
                push    bc
                ldir                    ; de = m_activeConfiguration.instrumentConfigurations
                ld      bc, 5
                add     hl, bc
                ex      de, hl
                add     hl, bc
                ex      de, hl
                pop     bc
                dec     a
                jr      nz, loc_2BC7
------
                call    sub_13D1
                call    initMidiChannelToAssignedInstruments
                ld      bc, 2

localSendResponse:                      ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration2+B↑j
                                        ; processSysExCmd_NodeMessage_SetConfiguration2+21↑j
                jp      sendResponse
; End of function processSysExCmd_NodeMessage_SetConfiguration2


; =============== S U B R O U T I N E =======================================


processSysExCmd_InstrumentMessage_SetInstrumentVoice:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentVoice:loc_2BEE↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 7
                jr      nc, loc_2BEE
                call    logMidiError
                ld      bc, 3
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2BEE:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentVoice+3↑j
                jr      z, processSysExCmd_InstrumentMessage_SetInstrumentVoice
                cp      80h
                jr      nc, loc_2BFF    ; if (a >= 0x80) jmp loc_2BFF
                ld      bc, 40h ; '@'
                ld      de, sp_MidiDataOfMidiCommandInProgress
                call    receiveDataPacketTypeA
                jr      nc, loc_2C04

loc_2BFF:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentVoice+11↑j
                ld      bc, 203h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2C04:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentVoice+1C↑j
                ld      a, (sysEx_InstrumentNumber)
                call    getActiveInstrumentParameters
                push    hl
                pop     iy              ; iy = ptr InstrumentParameters
                ld      de, InstrumentParameters.voiceDefinition
                add     hl, de
                ex      de, hl
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                ld      bc, 40h ; '@'
                ldir                    ; memcpy(&instrumentParameters.voiceDefinition, ..., 0x40)
                call    applyInstrumentParameter?
                call    logErrorOrSuccess
                ld      bc, 2

localSendResponse:                      ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentVoice+B↑j
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentVoice+21↑j
                jp      sendResponse
; End of function processSysExCmd_InstrumentMessage_SetInstrumentVoice


; =============== S U B R O U T I N E =======================================


processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1:loc_2C33↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 22
                jr      nc, loc_2C33
                call    logMidiError
                ld      bc, 3
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2C33:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1+3↑j
                jr      z, processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1
                cp      80h
                jr      nc, loc_2C44    ; if (a >= 0x80) jmp loc_2C44
--------
                ld      bc, 10h
                ld      de, sp_MidiDataOfMidiCommandInProgress
                call    receiveDataPacketTypeB
                jr      nc, loc_2C49

loc_2C44:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1+11↑j
                ld      bc, 203h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2C49:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1+1C↑j
                ld      hl, activeConfiguration.instrumentConfigurations
                ld      a, (sysEx_InstrumentNumber)
                push    af
                rlca
                rlca
                rlca
                rlca
                ld      b, 0
                ld      c, a
                add     hl, bc
                push    hl
                pop     ix
                ex      de, hl
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                ld      bc, 10h
                ldir
                pop     af
------
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                call    loadInstrumentParameters_InstrumentConfiguration
                call    initMidiChannelToAssignedInstruments
                ld      bc, 2

localSendResponse:                      ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1+B↑j
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1+21↑j
                jp      sendResponse
; End of function processSysExCmd_InstrumentMessage_SetInstrumentConfiguration1


; =============== S U B R O U T I N E =======================================


processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2:loc_2C84↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 23
                jr      nc, loc_2C84
                call    logMidiError
                ld      bc, 3
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2C84:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2+3↑j
                jr      z, processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2
                cp      80h
                jr      nc, loc_2C95    ; if (a >= 0x80) jmp loc_2C95
                ld      bc, 0Bh
                ld      de, sp_MidiDataOfMidiCommandInProgress
                call    receiveDataPacketTypeB
                jr      nc, loc_2C9A

loc_2C95:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2+11↑j
                ld      bc, 203h
                jr      localSendResponse
; ---------------------------------------------------------------------------

loc_2C9A:                               ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2+1C↑j
                ld      hl, activeConfiguration.instrumentConfigurations
                ld      a, (sysEx_InstrumentNumber)
                push    af
                rlca
                rlca
                rlca
                rlca
                ld      b, 0
                ld      c, a
                add     hl, bc
                push    hl
                pop     ix
                ex      de, hl
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                ld      bc, 0Bh
                ldir
                pop     af
---------
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                call    setInstrumentParameter00_05_safe
                call    initMidiChannelToAssignedInstruments
                ld      bc, 2

localSendResponse:                      ; CODE XREF: processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2+B↑j
                                        ; processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2+21↑j
                jp      sendResponse
; End of function processSysExCmd_InstrumentMessage_SetInstrumentConfiguration2


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 8

processSysExCmd_NodeParameterChangeMessage:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, c
                cp      80h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x80) jmp SoundProcessor_processMidiCommandByte
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_2CDE    ; if (a != 0) jmp loc_2CDE
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                ld      a, 10h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_2CDE:                               ; CODE XREF: processSysExCmd_NodeParameterChangeMessage+A↑j
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                call    setNodeParameter
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                cp      22h ; '"'
                jr      z, loc_2CEF     ; if (a == 0x22) jmp loc_2CEF
                cp      20h ; ' '
                jr      nz, loc_2CF5    ; if (a != 0x20) jmp loc_2CF5

loc_2CEF:                               ; CODE XREF: processSysExCmd_NodeParameterChangeMessage+21↑j
                call    initializeSysExStateMatchTable
                call    initMidiChannelToAssignedInstruments

loc_2CF5:                               ; CODE XREF: processSysExCmd_NodeParameterChangeMessage+25↑j
                call    logErrorOrSuccess
                xor     a
                ld      (soundProcessorMidiInterpreterState), a
                ret
; End of function processSysExCmd_NodeParameterChangeMessage


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 9

processSysExCmd_InstrumentParameterChange_ByInstrument:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, c
                cp      80h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x80) jmp SoundProcessor_processMidiCommandByte
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      z, SysExState0x00 ; if (a == 0) jmp loc_2D13
                cp      1
                jr      z, SysExState0x01 ; if (a == 0x01) jmp loc_2D25
                cp      10h
                jr      z, SysExState0x10 ; if (a == 0x10) jmp loc_2D27
                jr      SysExStateOther
; ---------------------------------------------------------------------------

SysExState0x00:                         ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByInstrument+A↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                cp      40h ; '@'
                jr      nc, loc_2D1F    ; if (a >= 0x40) jmp loc_2D1F
                ld      a, 1
                jr      loc_2D21
; ---------------------------------------------------------------------------

loc_2D1F:                               ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByInstrument+1C↑j
                ld      a, 10h

loc_2D21:                               ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByInstrument+20↑j
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

SysExState0x01:                         ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByInstrument+E↑j
                jr      loc_2D46
; ---------------------------------------------------------------------------

SysExState0x10:                         ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByInstrument+12↑j
                ld      a, c
                cp      10h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x10) jmp SoundProcessor_processMidiCommandByte
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                ld      a, 11h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

SysExStateOther:                        ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByInstrument+14↑j
                ld      a, c
                cp      10h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x10) jmp SoundProcessor_processMidiCommandByte
                rlca
                rlca
                rlca
                rlca
                ld      e, a
                ld      a, (sp_MidiDataOfMidiCommandInProgress+1)
                or      e
                ld      c, a

loc_2D46:                               ; CODE XREF: processSysExCmd_InstrumentParameterChange_ByInstrument:SysExState0x01↑j
                ld      a, (sysEx_InstrumentNumber)
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                call    setInstrumentParameter
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                cp      1
                call    z, initMidiChannelToAssignedInstruments ; if (a == 0x01) call initMidiChannelToAssignedInstruments
                call    logErrorOrSuccess
                xor     a
                ld      (soundProcessorMidiInterpreterState), a
                ret
; End of function processSysExCmd_InstrumentParameterChange_ByInstrument


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 10

processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_2D7F    ; if (a != 0) jmp loc_2D7F
                ld      a, c
                cp      7
                jr      c, loc_2D76     ; if (a < 0x07) jmp loc_2D76
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2D76:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank+9↑j
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                ld      a, 10h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_2D7F:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank+4↑j
                ld      a, c
                cp      80h
                jr      nc, loc_2D8A    ; if (a >= 0x80) jmp loc_2D8A
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2D8A:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank+1D↑j
                push    bc
                call    send_F0_43_75_NodeNumber
                jr      c, loc_2DA9
                xor     a
                call    send_midi_byte
                jr      c, loc_2DA9
                xor     a
                call    send_midi_byte
                jr      c, loc_2DA9
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                ld      b, a
                call    send_midi_byte
                jr      c, loc_2DA9
                ld      a, b
                call    sendVoiceDefinitionBank

loc_2DA9:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank+29↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank+2F↑j ...
                pop     bc
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank


; =============== S U B R O U T I N E =======================================


processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1:loc_2DBB↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 11
                jr      nc, loc_2DBB
                call    logMidiError
                ld      bc, 3
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2DBB:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1+3↑j
                jr      z, processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1
                cp      80h
                jr      nc, loc_2DC7    ; if (a >= 0x80) jmp loc_2DC7
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2DC7:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1+12↑j
                ld      ix, activeInstrumentParameters
                ld      b, 8
                ld      de, activeConfiguration.instrumentConfigurations

loc_2DD0:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1+32↓j
                push    bc
                push    ix
                pop     hl
                ld      bc, 10h
                ldir
                ld      bc, 80h
                add     ix, bc
                pop     bc
                djnz    loc_2DD0
-------
                call    send_F0_43_75_NodeNumber
                jr      c, loc_2E04
                xor     a
                call    send_midi_byte
                jr      c, loc_2E04
                ld      a, 1
                call    send_midi_byte
                jr      c, loc_2E04
                xor     a
                call    send_midi_byte
                jr      c, loc_2E04
                push    bc
                ld      bc, 0A0h
                ld      hl, activeConfiguration
                call    sendDataPacketTypeBInChunksOf2048ByteBlocks
                pop     bc

loc_2E04:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1+37↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1+3D↑j ...
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 12

processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_2E21    ; if (a != 0) jmp loc_2E21
                ld      a, c
                cp      14h
                jr      c, loc_2E18     ; if (a < 0x14) jmp loc_2E18
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2E18:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration+9↑j
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                ld      a, 10h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_2E21:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration+4↑j
                ld      a, c
                cp      80h
                jr      nc, loc_2E2C    ; if (a >= 0x80) jmp loc_2E2C
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2E2C:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration+1D↑j
                push    bc
                call    send_F0_43_75_NodeNumber
                jr      c, loc_2E52
                xor     a
                call    send_midi_byte
                jr      c, loc_2E52
                ld      a, 2
                call    send_midi_byte
                jr      c, loc_2E52
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                ld      b, a
                call    send_midi_byte
                jr      c, loc_2E52
                ld      a, b
                call    getConfigurationData
                ld      bc, 0A0h
                call    sendDataPacketTypeBInChunksOf2048ByteBlocks

loc_2E52:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration+29↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration+2F↑j ...
                pop     bc
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 13

processSysExCmd_NodeDumpRequestMessage_ConfigurationRAM:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_2E62    ; if (a != 0) jmp loc_2E62
                ld      a, 1
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_2E62:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationRAM+4↑j
                ld      a, c
                cp      80h
                jr      nc, loc_2E6D    ; if (a >= 0x80) jmp loc_2E6D
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2E6D:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationRAM+F↑j
                push    bc
                call    send_F0_43_75_NodeNumber
                jr      c, loc_2E89
                xor     a
                call    send_midi_byte
                jr      c, loc_2E89
                ld      a, 3
                call    send_midi_byte
                jr      c, loc_2E89
                xor     a
                call    send_midi_byte
                jr      c, loc_2E89
                call    sendAllConfigurations

loc_2E89:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationRAM+1B↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_ConfigurationRAM+21↑j ...
                pop     bc
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_NodeDumpRequestMessage_ConfigurationRAM


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 14

processSysExCmd_NodeDumpRequestMessage_MusicCardID:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_2E99    ; if (a != 0) jmp loc_2E99
                ld      a, 1
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_2E99:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_MusicCardID+4↑j
                ld      a, c
                cp      80h
                jr      nc, loc_2EA4    ; if (a >= 0x80) jmp loc_2EA4
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2EA4:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_MusicCardID+F↑j
                push    bc
                call    send_F0_43_75_NodeNumber
                jr      c, loc_2EC6
                xor     a
                call    send_midi_byte
                jr      c, loc_2EC6
                ld      a, 4
                call    send_midi_byte
                jr      c, loc_2EC6
                xor     a
                call    send_midi_byte
                jr      c, loc_2EC6
                ld      bc, 10h
                ld      hl, CARD_NAME   ; "YAMAHA IBM MUSIC"
                call    sendDataPacketTypeBInChunksOf2048ByteBlocks

loc_2EC6:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_MusicCardID+1B↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_MusicCardID+21↑j ...
                pop     bc
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_NodeDumpRequestMessage_MusicCardID


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 15

processSysExCmd_NodeDumpRequestMessage_MusicCardRevision:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_2ED6    ; if (a != 0) jmp loc_2ED6
                ld      a, 1
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_2ED6:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_MusicCardRevision+4↑j
                ld      a, c
                cp      80h
                jr      nc, loc_2EE1    ; if (a >= 0x80) jmp loc_2EE1
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2EE1:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_MusicCardRevision+F↑j
                push    bc
                call    send_F0_43_75_NodeNumber
                jr      c, loc_2F03
                xor     a
                call    send_midi_byte
                jr      c, loc_2F03
                ld      a, 5
                call    send_midi_byte
                jr      c, loc_2F03
                xor     a
                call    send_midi_byte
                jr      c, loc_2F03
                ld      bc, 10h
                ld      hl, CARD_REV    ; "rel. M102.00.010"
                call    sendDataPacketTypeBInChunksOf2048ByteBlocks

loc_2F03:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_MusicCardRevision+1B↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_MusicCardRevision+21↑j ...
                pop     bc
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_NodeDumpRequestMessage_MusicCardRevision


; =============== S U B R O U T I N E =======================================


processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2:loc_2F15↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 24
                jr      nc, loc_2F15
                call    logMidiError
                ld      bc, 3
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2F15:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2+3↑j
                jr      z, processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2
                cp      80h
                jr      nc, loc_2F21    ; if (a >= 0x80) jmp loc_2F21
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2F21:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2+12↑j
                ld      ix, activeInstrumentParameters
                ld      b, 8
                ld      de, activeConfiguration.instrumentConfigurations

loc_2F2A:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2+2D↓j
                push    bc
                push    ix
                pop     hl
                ld      bc, 80h
                add     ix, bc
                pop     bc
                djnz    loc_2F2A
                call    send_F0_43_75_NodeNumber
                jr      c, loc_2F59
                xor     a
                call    send_midi_byte
                jr      c, loc_2F59
                ld      a, 6
                call    send_midi_byte
                jr      c, loc_2F59
                xor     a
                call    send_midi_byte
                jr      c, loc_2F59
                push    bc
                ld      bc, 0A0h
                ld      hl, activeConfiguration
                call    sendDataPacketTypeBInChunksOf2048ByteBlocks
                pop     bc

loc_2F59:                               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2+32↑j
                                        ; processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2+38↑j ...
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer2


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 16

processSysExCmd_StoreRequest_StoreConfigurationData:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_2F76    ; if (a != 0) jmp loc_2F76
                ld      a, c
                cp      10h
                jr      c, loc_2F6D     ; if (a < 0x10) jmp loc_2F6D
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2F6D:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreConfigurationData+9↑j
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                ld      a, 10h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_2F76:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreConfigurationData+4↑j
                ld      a, c
                cp      80h
                jr      nc, loc_2F81    ; if (a >= 0x80) jmp loc_2F81
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2F81:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreConfigurationData+1D↑j
                push    bc
                ld      a, (memoryProtection)
                or      a
                jr      z, loc_2F8C     ; if (a == 0) jmp loc_2F8C
                ld      c, 4
                jr      loc_2F95
; ---------------------------------------------------------------------------

loc_2F8C:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreConfigurationData+2A↑j
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                ld      c, a
                call    storeActiveConfigurationToCustomConfiguration
                ld      c, 2

loc_2F95:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreConfigurationData+2E↑j
                call    sendHandshakingMessage
                pop     bc
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_StoreRequest_StoreConfigurationData


; =============== S U B R O U T I N E =======================================


processSysExCmd_F0_43_75_0n_2i_00:      ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_F0_43_75_0n_2i_00:loc_2FAA↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 17
                jr      nc, loc_2FAA
                call    logMidiError
                ld      bc, 3
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2FAA:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_00+3↑j
                jr      z, processSysExCmd_F0_43_75_0n_2i_00
                cp      80h
                jr      nc, loc_2FB6    ; if (a >= 0x80) jmp loc_2FB6
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2FB6:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_00+12↑j
                call    send_F0_43_75_NodeNumber
                jr      c, loc_2FE2
                ld      a, (sysEx_InstrumentNumber)
                ld      b, a
                or      8
                call    send_midi_byte
                jr      c, loc_2FE2
                xor     a
                call    send_midi_byte
                jr      c, loc_2FE2
                xor     a
                call    send_midi_byte
                jr      c, loc_2FE2
                push    bc
                ld      a, b
                call    getActiveInstrumentParameters
                ld      de, 10h
                add     hl, de
                ld      bc, 40h ; '@'
                call    sendDataPacketTypeAInChunksOf2048ByteBlocks
                pop     bc

loc_2FE2:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_00+1D↑j
                                        ; processSysExCmd_F0_43_75_0n_2i_00+28↑j ...
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_F0_43_75_0n_2i_00


; =============== S U B R O U T I N E =======================================


processSysExCmd_F0_43_75_0n_2i_01:      ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_F0_43_75_0n_2i_01:loc_2FF3↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 25
                jr      nc, loc_2FF3
                call    logMidiError
                ld      bc, 3
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2FF3:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_01+3↑j
                jr      z, processSysExCmd_F0_43_75_0n_2i_01
                cp      80h
                jr      nc, loc_2FFF    ; if (a >= 0x80) jmp loc_2FFF
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_2FFF:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_01+12↑j
                call    send_F0_43_75_NodeNumber
                jr      c, loc_3028
                ld      a, (sysEx_InstrumentNumber)
                ld      b, a
                or      8
                call    send_midi_byte
                jr      c, loc_3028
                ld      a, 1
                call    send_midi_byte
                jr      c, loc_3028
                xor     a
                call    send_midi_byte
                jr      c, loc_3028
                push    bc
                ld      a, b
                call    getActiveInstrumentParameters
                ld      bc, 10h
                call    sendDataPacketTypeBInChunksOf2048ByteBlocks
                pop     bc

loc_3028:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_01+1D↑j
                                        ; processSysExCmd_F0_43_75_0n_2i_01+28↑j ...
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_F0_43_75_0n_2i_01


; =============== S U B R O U T I N E =======================================


processSysExCmd_F0_43_75_0n_2i_02:      ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; processSysExCmd_F0_43_75_0n_2i_02:loc_3039↓j
                                        ; DATA XREF: ...
                call    readMidiData    ; jumptable 0000295D case 26
                jr      nc, loc_3039
                call    logMidiError
                ld      bc, 3
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_3039:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_02+3↑j
                jr      z, processSysExCmd_F0_43_75_0n_2i_02
                cp      80h
                jr      nc, loc_3045    ; if (a >= 0x80) jmp loc_3045
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_3045:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_02+12↑j
                call    send_F0_43_75_NodeNumber
                jr      c, loc_306E
                ld      a, (sysEx_InstrumentNumber)
                ld      b, a
                or      8
                call    send_midi_byte
                jr      c, loc_306E
                ld      a, 1
                call    send_midi_byte
                jr      c, loc_306E
                xor     a
                call    send_midi_byte
                jr      c, loc_306E
                push    bc
                ld      a, b
                call    getActiveInstrumentParameters
                ld      bc, 10h
                call    sendDataPacketTypeBInChunksOf2048ByteBlocks
                pop     bc

loc_306E:                               ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_02+1D↑j
                                        ; processSysExCmd_F0_43_75_0n_2i_02+28↑j ...
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_F0_43_75_0n_2i_02


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 18

processSysExCmd_StoreRequest_StoreVoiceData:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_308B    ; if (a != 0) jmp loc_308B
                ld      a, c
                cp      60h ; '`'
                jr      c, loc_3082     ; if (a < 0x60) jmp loc_3082
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_3082:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreVoiceData+9↑j
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                ld      a, 10h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_308B:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreVoiceData+4↑j
                ld      a, c
                cp      80h
                jr      nc, loc_3096    ; if (a >= 0x80) jmp loc_3096
                ld      bc, 4
                jp      sendResponse
; ---------------------------------------------------------------------------

loc_3096:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreVoiceData+1D↑j
                push    bc
                ld      a, (memoryProtection)
                or      a
                jr      z, loc_30A1     ; if (a == 0) jmp loc_30A1
                ld      c, 4
                jr      loc_30B3
; ---------------------------------------------------------------------------

loc_30A1:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreVoiceData+2A↑j
                ld      a, (sysEx_InstrumentNumber)
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                ld      c, a
                call    storeInstrumentParametersToCustomBank
                ld      c, 2

loc_30B3:                               ; CODE XREF: processSysExCmd_StoreRequest_StoreVoiceData+2E↑j
                call    sendHandshakingMessage
                pop     bc
                jp      SoundProcessor_processMidiCommandByte
; End of function processSysExCmd_StoreRequest_StoreVoiceData


; =============== S U B R O U T I N E =======================================

; jumptable 0000295D case 19

processSysExCmd_EventListTransferToMusicCard:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, c
                cp      80h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x80) jmp SoundProcessor_processMidiCommandByte
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_30D4    ; if (a != 0) jmp loc_30D4
SysExState == 0x00
                ld      a, c
                or      80h
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                and     70h ; 'p'
                or      1
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_30D4:                               ; CODE XREF: processSysExCmd_EventListTransferToMusicCard+A↑j
                and     0F0h
                rrca                    ; 8-bit rotation to the right. the bit leaving on the right is copied into the carry, and into bit 7.
                rrca
                rrca
                ld      d, 0
                ld      e, a
                ld      hl, jpt_30E4
                add     hl, de
                ld      e, (hl)
                inc     hl
                ld      d, (hl)
                ex      de, hl
                jp      (hl)            ; switch 8 cases
; End of function processSysExCmd_EventListTransferToMusicCard

; ---------------------------------------------------------------------------
jpt_30E4:       dw processSysExCmd_EventList_NoteOFF
                                        ; DATA XREF: processSysExCmd_EventListTransferToMusicCard+22↑o
                dw processSysExCmd_EventList_NoteONOFF ; jump table for switch statement
                dw processSysExCmd_EventList_NoteONOFFWithDuration
                dw processSysExCmd_EventList_ControlChange
                dw processSysExCmd_EventList_ProgramChangeAndAfterTouch
                dw processSysExCmd_EventList_ProgramChangeAndAfterTouch
                dw processSysExCmd_EventList_PitchbenderRange
                dw processSysExCmd_EventList_ParameterChange

; =============== S U B R O U T I N E =======================================

; jumptable 000030E4 case 0

processSysExCmd_EventList_NoteOFF:      ; CODE XREF: processSysExCmd_EventListTransferToMusicCard+2A↑j
                                        ; DATA XREF: ROM:jpt_30E4↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                cp      1
                jr      nz, switchDefault ; if (a != 0x01) jmp loc_3106
SysExState 0x01
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                ld      a, 2
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

switchDefault:                          ; CODE XREF: processSysExCmd_EventList_NoteOFF+5↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+2), a
                xor     a
                ld      (sp_MidiDataOfMidiCommandInProgress+3), a
                ld      hl, 0
                ld      (sp_MidiDataOfMidiCommandInProgress+4), hl
                call    executeMidiCommand_NoteONOFFForAllAssignInstruments
                xor     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function processSysExCmd_EventList_NoteOFF


; =============== S U B R O U T I N E =======================================

; jumptable 000030E4 case 1

processSysExCmd_EventList_NoteONOFF:    ; CODE XREF: processSysExCmd_EventListTransferToMusicCard+2A↑j
                                        ; DATA XREF: ROM:jpt_30E4↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                cp      11h
                jr      z, SysExState0x11 ; if (a == 0x11) jmp loc_3129
                cp      12h
                jr      z, SysExState0x12 ; if (a == 0x12) jmp loc_3133
                jr      switchDefault
; ---------------------------------------------------------------------------

SysExState0x11:                         ; CODE XREF: processSysExCmd_EventList_NoteONOFF+5↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                ld      a, 12h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

SysExState0x12:                         ; CODE XREF: processSysExCmd_EventList_NoteONOFF+9↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+2), a
                ld      a, 13h
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

switchDefault:                          ; CODE XREF: processSysExCmd_EventList_NoteONOFF+B↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+3), a
                ld      hl, 0
                ld      (sp_MidiDataOfMidiCommandInProgress+4), hl
                call    executeMidiCommand_NoteONOFFForAllAssignInstruments
                xor     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function processSysExCmd_EventList_NoteONOFF


; =============== S U B R O U T I N E =======================================

; jumptable 000030E4 case 2

processSysExCmd_EventList_NoteONOFFWithDuration:
                                        ; CODE XREF: processSysExCmd_EventListTransferToMusicCard+2A↑j
                                        ; DATA XREF: ROM:jpt_30E4↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                push    af
                sub     20h ; ' '
                ld      hl, sp_MidiDataOfMidiCommandInProgress
                ld      d, 0
                ld      e, a
                add     hl, de
                ld      (hl), c
                pop     af
                cp      25h ; '%'
                jr      z, loc_3167     ; if (a == 0x25) jmp loc_3167
                inc     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_3167:                               ; CODE XREF: processSysExCmd_EventList_NoteONOFFWithDuration+11↑j
                call    executeMidiCommand_NoteONOFFForAllAssignInstruments
                xor     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function processSysExCmd_EventList_NoteONOFFWithDuration


; =============== S U B R O U T I N E =======================================


processSysExCmd_EventList_ControlChange:
                                        ; CODE XREF: processSysExCmd_EventListTransferToMusicCard+2A↑j
                                        ; processSysExCmd_EventList_PitchbenderRange+5↓j
                                        ; DATA XREF: ...
                ld      a, (soundProcessorMidiInterpreterSysExState) ; jumptable 000030E4 case 3
                cp      31h ; '1'
                jr      nz, SysExState0x32_default ; if (a != 0x31) jmp loc_3180
SysExState0x31
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                ld      a, 32h ; '2'
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

SysExState0x32_default:                 ; CODE XREF: processSysExCmd_EventList_ControlChange+5↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+2), a
                call    SoundProcessor_executeMidiCommand
                xor     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function processSysExCmd_EventList_ControlChange


; =============== S U B R O U T I N E =======================================

; jumptable 000030E4 cases 4,5

processSysExCmd_EventList_ProgramChangeAndAfterTouch:
                                        ; CODE XREF: processSysExCmd_EventListTransferToMusicCard+2A↑j
                                        ; DATA XREF: ROM:jpt_30E4↑o
                ld      l, c
                ld      h, 0
                ld      (sp_MidiDataOfMidiCommandInProgress+1), hl
                call    SoundProcessor_executeMidiCommand
                xor     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function processSysExCmd_EventList_ProgramChangeAndAfterTouch


; =============== S U B R O U T I N E =======================================

; jumptable 000030E4 case 6

processSysExCmd_EventList_PitchbenderRange:
                                        ; CODE XREF: processSysExCmd_EventListTransferToMusicCard+2A↑j
                                        ; DATA XREF: ROM:jpt_30E4↑o
                ld      a, 31h ; '1'
                ld      (soundProcessorMidiInterpreterSysExState), a
                jr      processSysExCmd_EventList_ControlChange
; End of function processSysExCmd_EventList_PitchbenderRange


; =============== S U B R O U T I N E =======================================

; jumptable 000030E4 case 7

processSysExCmd_EventList_ParameterChange:
                                        ; CODE XREF: processSysExCmd_EventListTransferToMusicCard+2A↑j
                                        ; DATA XREF: ROM:jpt_30E4↑o
                ld      a, (soundProcessorMidiInterpreterSysExState)
                cp      71h ; 'q'
                jr      z, SysExState0x71 ; if (a == 0x71) jmp loc_31B2
                cp      72h ; 'r'
                jr      z, SysExState0x72 ; if (a == 0x72) jmp loc_31CC
                cp      73h ; 's'
                jr      z, SysExState0x73 ; if (a == 0x73) jmp loc_31D2
                jr      switchDefault
; ---------------------------------------------------------------------------

SysExState0x71:                         ; CODE XREF: processSysExCmd_EventList_ParameterChange+5↑j
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                and     0Fh
                ld      (sysEx_ChannelNumber), a
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                cp      40h ; '@'
                jr      nc, loc_31C6    ; if (a >= 0x40) jmp loc_31C6
                ld      a, 72h ; 'r'
                jr      loc_31C8
; ---------------------------------------------------------------------------

loc_31C6:                               ; CODE XREF: processSysExCmd_EventList_ParameterChange+1F↑j
                ld      a, 73h ; 's'

loc_31C8:                               ; CODE XREF: processSysExCmd_EventList_ParameterChange+23↑j
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

SysExState0x72:                         ; CODE XREF: processSysExCmd_EventList_ParameterChange+9↑j
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                jr      loc_31EA
; ---------------------------------------------------------------------------

SysExState0x73:                         ; CODE XREF: processSysExCmd_EventList_ParameterChange+D↑j
                ld      a, c
                cp      10h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x10) jmp SoundProcessor_processMidiCommandByte
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                ld      a, 74h ; 't'
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

switchDefault:                          ; CODE XREF: processSysExCmd_EventList_ParameterChange+F↑j
                ld      a, c
                cp      10h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x10) jmp SoundProcessor_processMidiCommandByte
                ld      (sp_MidiDataOfMidiCommandInProgress+2), a

loc_31EA:                               ; CODE XREF: processSysExCmd_EventList_ParameterChange+2F↑j
                call    processSysExCmd_InstrumentParameterChange
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                cp      1
                call    z, initMidiChannelToAssignedInstruments ; if (a == 0x01) call initMidiChannelToAssignedInstruments
                call    logErrorOrSuccess
                xor     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function processSysExCmd_EventList_ParameterChange


; =============== S U B R O U T I N E =======================================

; c=midiByte

processSysExCmd_ParameterListTransferToMusicCard:
                                        ; CODE XREF: SoundProcessor_processSysExStates+4A↑j
                                        ; DATA XREF: ROM:codeJumpTable↑o
                ld      a, c
                cp      80h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x80) jmp SoundProcessor_processMidiCommandByte
                ld      a, (soundProcessorMidiInterpreterSysExState)
                or      a
                jr      nz, loc_3213    ; if (a != 0) jmp loc_3213
SysExState0x00
                ld      a, c
                ld      (sp_MidiDataOfMidiCommandInProgress), a
                ld      a, 1
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_3213:                               ; CODE XREF: processSysExCmd_ParameterListTransferToMusicCard+A↑j
                cp      2
                jr      nc, loc_3229    ; if (a >= 0x02) jmp loc_3229
SysExState0x01
                ld      a, c
                and     7Fh
                ld      (sp_MidiDataOfMidiCommandInProgress+1), a
                bit     6, c
                ld      a, 2
                jr      z, loc_3225
                ld      a, 3

loc_3225:                               ; CODE XREF: processSysExCmd_ParameterListTransferToMusicCard+24↑j
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

loc_3229:                               ; CODE XREF: processSysExCmd_ParameterListTransferToMusicCard+18↑j
                jr      nz, loc_322D    ; if (a != 0x02) jmp loc_322D
                jr      SysExState0x02
; ---------------------------------------------------------------------------

loc_322D:                               ; CODE XREF: processSysExCmd_ParameterListTransferToMusicCard:loc_3229↑j
                cp      3
                jr      nz, switchDefault ; if (a != 0x03) jmp loc_3240
SysExState0x03
                ld      a, c
                cp      10h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x10) jmp SoundProcessor_processMidiCommandByte
                ld      (sp_MidiDataOfMidiCommandInProgress+2), a
                ld      a, 4
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; ---------------------------------------------------------------------------

switchDefault:                          ; CODE XREF: processSysExCmd_ParameterListTransferToMusicCard+32↑j
                ld      a, c
                cp      10h
                jp      nc, SoundProcessor_processMidiCommandByte ; if (a >= 0x10) jmp SoundProcessor_processMidiCommandByte
                rlca
                rlca
                rlca
                rlca
                ld      e, a
                ld      a, (sp_MidiDataOfMidiCommandInProgress+2)
                or      e
                ld      c, a

SysExState0x02:                         ; CODE XREF: processSysExCmd_ParameterListTransferToMusicCard+2E↑j
                ld      a, (sp_MidiDataOfMidiCommandInProgress)
                ld      e, a
                and     0Fh
                ld      hl, nodeNumber
                cp      (hl)
                jr      nz, loc_327A    ; if (a != (hl)) jmp loc_327A
                ld      a, e
                and     70h ; 'p'
                rrca
                rrca
                rrca
                rrca
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (sp_MidiDataOfMidiCommandInProgress+1)
                call    setInstrumentParameter
                ld      a, (sp_MidiDataOfMidiCommandInProgress+1)
                cp      1
                call    z, initMidiChannelToAssignedInstruments ; if (a == 0x01) call initMidiChannelToAssignedInstruments
                call    logErrorOrSuccess

loc_327A:                               ; CODE XREF: processSysExCmd_ParameterListTransferToMusicCard+5D↑j
                xor     a
                ld      (soundProcessorMidiInterpreterSysExState), a
                ret
; End of function processSysExCmd_ParameterListTransferToMusicCard


; =============== S U B R O U T I N E =======================================

; b=errorNumber / c=messageNumber -> void

sendResponse:                           ; CODE XREF: processSysExCmd_F0_43_0n_0C:localSendResponse↑j
                                        ; processSysExCmd_F0_43_2n_0C+8↑j ...
                call    logDumpError
                call    sendHandshakingMessage
                xor     a
                ld      (soundProcessorMidiInterpreterState), a
                ret
; End of function sendResponse


; =============== S U B R O U T I N E =======================================

; a=? / bc=size / hl=DataPtr -> c-flag for errors

sendDataPacketTypeAInChunksOf2048ByteBlocks:
                                        ; CODE XREF: processSysExCmd_F0_43_75_0n_2i_00+42↑p
                                        ; sendDataPacketTypeAInChunksOf2048ByteBlocks+26↓j
                push    hl
                ld      h, b
                ld      l, c
                ld      de, 2048
                or      a
                sbc     hl, de
                ex      de, hl
                pop     hl
                jr      nc, loc_329F
                push    bc
                pop     ix
                ld      bc, 0
                jr      loc_32A5
; ---------------------------------------------------------------------------

loc_329F:                               ; CODE XREF: sendDataPacketTypeAInChunksOf2048ByteBlocks+B↑j
                ld      ix, 2048
                ld      b, d
                ld      c, e

loc_32A5:                               ; CODE XREF: sendDataPacketTypeAInChunksOf2048ByteBlocks+13↑j
                call    sendDataPacketTypeA
                ret     c
                ld      a, b
                or      c
                jr      z, loc_32B2
                call    waitForDataToBeSent
                jr      sendDataPacketTypeAInChunksOf2048ByteBlocks
; ---------------------------------------------------------------------------

loc_32B2:                               ; CODE XREF: sendDataPacketTypeAInChunksOf2048ByteBlocks+21↑j
                ld      a, 0F7h
                jp      send_midi_byte
; End of function sendDataPacketTypeAInChunksOf2048ByteBlocks


; =============== S U B R O U T I N E =======================================

; bc=number of bytes / hl=memory pointer -> c-flag for errors

sendDataPacketTypeBInChunksOf2048ByteBlocks:
                                        ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1+53↑p
                                        ; processSysExCmd_NodeDumpRequestMessage_IndividualConfiguration+48↑p ...
                push    hl
                ld      h, b
                ld      l, c
                ld      de, 2048
                or      a
                sbc     hl, de
                ex      de, hl
                pop     hl
                jr      nc, loc_32CC
                push    bc
                pop     ix
                ld      bc, 0
                jr      loc_32D2
; ---------------------------------------------------------------------------

loc_32CC:                               ; CODE XREF: sendDataPacketTypeBInChunksOf2048ByteBlocks+B↑j
                ld      ix, 2048
                ld      b, d
                ld      c, e

loc_32D2:                               ; CODE XREF: sendDataPacketTypeBInChunksOf2048ByteBlocks+13↑j
                call    sendDataPacketTypeB
                ret     c
                ld      a, b
                or      c
                jr      z, loc_32DF
                call    waitForDataToBeSent
                jr      sendDataPacketTypeBInChunksOf2048ByteBlocks
; ---------------------------------------------------------------------------

loc_32DF:                               ; CODE XREF: sendDataPacketTypeBInChunksOf2048ByteBlocks+21↑j
                ld      a, 0F7h
                jp      send_midi_byte
; End of function sendDataPacketTypeBInChunksOf2048ByteBlocks


; =============== S U B R O U T I N E =======================================

; a=instrument bank number -> c-flag for errors

sendVoiceDefinitionBank:                ; CODE XREF: processSysExCmd_F0_43_2n_0C+2A↑p
                                        ; processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank+41↑p
                call    getVoiceDefinitionBank
                ld      ix, 20h ; ' '
                call    sendDataPacketTypeA
                ret     c
                ld      b, 30h ; '0'

loc_32F1:                               ; CODE XREF: sendVoiceDefinitionBank+18↓j
                call    waitForDataToBeSent
                ld      ix, 40h ; '@'
                call    sendDataPacketTypeA
                ret     c
                djnz    loc_32F1
                ld      a, 0F7h
                jp      send_midi_byte
; End of function sendVoiceDefinitionBank


; =============== S U B R O U T I N E =======================================

; void -> c-flag for errors

sendAllConfigurations:                  ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_ConfigurationRAM+30↑p
                ld      hl, configurationRAM
                ld      b, 10h

loc_3308:                               ; CODE XREF: sendAllConfigurations+10↓j
                ld      ix, 0A0h
                call    sendDataPacketTypeB
                ret     c
                call    waitForDataToBeSent
                djnz    loc_3308
                ld      a, 0F7h
                jp      send_midi_byte
; End of function sendAllConfigurations


; =============== S U B R O U T I N E =======================================

; void -> void

waitForDataToBeSent:                    ; CODE XREF: sendDataPacketTypeAInChunksOf2048ByteBlocks+23↑p
                                        ; sendDataPacketTypeBInChunksOf2048ByteBlocks+23↑p ...
                push    hl
                ld      hl, 0

loc_331E:                               ; CODE XREF: waitForDataToBeSent+1C↓j
                ld      a, (midi_ReceiveSource_SendTarget)
                bit     0, a
                jr      z, targetIsMidiOut ; if (bit 0 of a == 0) jmp loc_332C
targetIsSystem:
                ld      a, (bufferToSystem_HasDataInBuffer)
                bit     7, a
                jr      loc_3331
; ---------------------------------------------------------------------------

targetIsMidiOut:                        ; CODE XREF: waitForDataToBeSent+9↑j
                ld      a, (bufferToMidiOut_HasDataInBuffer)
                bit     7, a

loc_3331:                               ; CODE XREF: waitForDataToBeSent+10↑j
                jr      nz, loc_3338
                dec     hl
                ld      a, l
                or      h
                jr      nz, loc_331E

loc_3338:                               ; CODE XREF: waitForDataToBeSent:loc_3331↑j
                pop     hl
                ld      de, 85Eh

loc_333C:                               ; CODE XREF: waitForDataToBeSent+25↓j
                dec     de
                ld      a, d
                or      e
                jp      nz, loc_333C
                ret
; End of function waitForDataToBeSent


; =============== S U B R O U T I N E =======================================

; hl=pointer to data / ix=size -> c-flag for errors

sendDataPacketTypeA:                    ; CODE XREF: sendDataPacketTypeAInChunksOf2048ByteBlocks:loc_32A5↑p
                                        ; sendVoiceDefinitionBank+7↑p ...
                push    ix
                pop     de
                ld      a, d
                sla     e
                rla
                sla     e
                rla
                rrc     e
                call    send_midi_byte
                ret     c
                ld      a, e
                call    send_midi_byte
                ret     c
-------
                ld      e, 0

loc_335A:                               ; CODE XREF: sendDataPacketTypeA+3D↓j
                ld      a, (hl)
                ld      d, a
                and     0Fh
                push    af
                call    send_midi_byte
                jr      c, loc_338A
                pop     af
                add     a, e
                ld      e, a
                ld      a, d
                rlca
                rlca
                rlca
                rlca
                and     0Fh
                ld      d, a
                call    send_midi_byte
                ret     c
                ld      a, d
                add     a, e
                ld      e, a
                inc     hl
                dec     ix
                push    hl
                push    ix
                pop     hl
                ld      a, h
                or      l
                pop     hl
                jr      nz, loc_335A
---------
                ld      a, e
                neg
                and     7Fh
                jp      send_midi_byte
; ---------------------------------------------------------------------------

loc_338A:                               ; CODE XREF: sendDataPacketTypeA+1F↑j
                pop     af
                scf
                ret
; End of function sendDataPacketTypeA


; =============== S U B R O U T I N E =======================================

; hl=memory pointer / ix=block size -> c-flag for errors

sendDataPacketTypeB:                    ; CODE XREF: sendDataPacketTypeBInChunksOf2048ByteBlocks:loc_32D2↑p
                                        ; sendAllConfigurations+9↑p
                push    ix
                pop     de
                ld      a, d
                sla     e
                rla
                rrc     e
                call    send_midi_byte
                ret     c
                ld      a, e
                call    send_midi_byte
                ret     c
                ld      e, 0

loc_33A1:                               ; CODE XREF: sendDataPacketTypeB+27↓j
                ld      a, (hl)
                ld      d, a
                call    send_midi_byte
                ret     c
                ld      a, d
                add     a, e
                ld      e, a
                inc     hl
                dec     ix
                push    hl
                push    ix
                pop     hl
                ld      a, h
                or      l
                pop     hl
                jr      nz, loc_33A1
                ld      a, e
                neg
                and     7Fh
                jp      send_midi_byte
; End of function sendDataPacketTypeB


; =============== S U B R O U T I N E =======================================

; a=first byte / de=destimation ptr for the read data / bc=size of buffer  -> c-flag for errors

receiveDataPacketTypeA:                 ; CODE XREF: processSysExCmd_F0_43_0n_0C+16↑p
                                        ; processSysExCmd_NodeMessage_SetVoiceBankData+2F↑p ...
                push    af
                xor     a
                ld      (receiveDataPacketTypeAState), a
                pop     af
                ld      l, 0
                jr      receiveDataPacketTypeA_internal
; ---------------------------------------------------------------------------

almostStart:                            ; CODE XREF: receiveDataPacketTypeA+8C↓j
                ld      l, 0

loopRead1:                              ; CODE XREF: receiveDataPacketTypeA:loopRead1_ok↓j
                call    readMidiData
                jr      nc, loopRead1_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead1_ok:                           ; CODE XREF: receiveDataPacketTypeA+F↑j
                jr      z, loopRead1

receiveDataPacketTypeA_internal:        ; CODE XREF: receiveDataPacketTypeA+8↑j
                ld      h, a            ; h = first byte
                ld      a, (receiveDataPacketTypeAState)
                or      a
                jr      nz, loopRead2   ; if (a != 0) jmp loc_33DE

loopRead2:                              ; CODE XREF: receiveDataPacketTypeA+1E↑j
                                        ; receiveDataPacketTypeA:loopRead2_ok↓j
                call    readMidiData
                jr      nc, loopRead2_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead2_ok:                           ; CODE XREF: receiveDataPacketTypeA+23↑j
                jr      z, loopRead2
---------
                cp      80h
                jp      nc, endError    ; if (a >= 0x80) jmp loc_351A
                push    de
                ld      d, a
                cp      20h ; ' '
                jr      nz, loc_340A    ; if (a != 0x20) jmp loc_340A
                ld      a, h
                or      a
                jr      nz, loc_340A    ; if (a != 0) jmp loc_340A
                ld      a, (soundProcessorMidiInterpreterState)
                cp      31h ; '1'
                jr      nz, loc_340A    ; if (a != 0x31) jmp loc_340A
                ld      a, 1
                ld      (receiveDataPacketTypeAState), a
                ld      a, h
                ld      h, d
                jr      loc_3422
; ---------------------------------------------------------------------------

loc_340A:                               ; CODE XREF: receiveDataPacketTypeA+36↑j
                                        ; receiveDataPacketTypeA+3A↑j ...
                ld      a, (receiveDataPacketTypeAState)
                or      a
                ld      a, d
                jr      z, loc_3422
                cp      10h
                jr      nz, popDe_endError ; if (a != 0x10) jmp loc_341E
                ld      a, h
                cp      40h ; '@'
                jr      nz, popDe_endError ; if (a != 0x40) jmp loc_341E
                ld      a, h
                ld      h, d
                jr      loc_3422
; ---------------------------------------------------------------------------

popDe_endError:                         ; CODE XREF: receiveDataPacketTypeA+55↑j
                                        ; receiveDataPacketTypeA+5A↑j
                pop     de
                jp      endError
; ---------------------------------------------------------------------------

loc_3422:                               ; CODE XREF: receiveDataPacketTypeA+4A↑j
                                        ; receiveDataPacketTypeA+51↑j ...
                rlca                    ; 8-bit rotation to the left. The bit leaving on the left is copied into the carry, and to bit 0.
                srl     h               ; Like SRA, except a 0 is put into bit 7. The bits are all shifted right, with bit 0 put into the carry flag.
                rra                     ; 9-bit rotation to the right. The carry is copied into bit 7, and the bit leaving on the right is copied into the carry.
                ld      d, h
                ld      e, a
                push    de
                pop     ix
ix = ha = midibyte * 128 + byteCountHigh
                pop     de

bigLoop:                                ; CODE XREF: receiveDataPacketTypeA+125↓j
                push    de
                push    ix
                pop     de
                ld      a, d
                or      e
                pop     de
                jr      nz, loopRead4   ; ix != 0

loopRead3:                              ; CODE XREF: receiveDataPacketTypeA:loopRead3_ok↓j
                call    readMidiData
                jr      nc, loopRead3_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead3_ok:                           ; CODE XREF: receiveDataPacketTypeA+7A↑j
                jr      z, loopRead3
                cp      80h
                jp      nc, endError    ; if (a >= 0x80) jmp loc_351A
                add     a, l
                and     7Fh
                jp      z, almostStart
                jp      endError
; ---------------------------------------------------------------------------

loopRead4:                              ; CODE XREF: receiveDataPacketTypeA+75↑j
                                        ; receiveDataPacketTypeA:loopRead4_ok↓j
                call    readMidiData
                jr      nc, loopRead4_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead4_ok:                           ; CODE XREF: receiveDataPacketTypeA+95↑j
                jr      z, loopRead4
                cp      40h ; '@'
                jp      nc, endError    ; if (a >= 0x40) jmp loc_351A
                ld      (soundProcessorMidiInterpreterState), a
                add     a, l
                ld      l, a
                dec     ix

smallLoop:                              ; CODE XREF: receiveDataPacketTypeA+FB↓j
                push    de
                push    ix
                pop     de
                ld      a, d
                or      e
                pop     de
                jr      nz, loopRead8

loopRead5:                              ; CODE XREF: receiveDataPacketTypeA:loopRead5_ok↓j
                call    readMidiData
                jr      nc, loopRead5_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead5_ok:                           ; CODE XREF: receiveDataPacketTypeA+B7↑j
                jr      z, loopRead5
                cp      80h
                jp      nc, endError    ; if (a >= 0x80) jmp loc_351A
                add     a, l
                and     7Fh
                jp      nz, endError
                ld      l, 0            ; checksum = 0

loopRead6:                              ; CODE XREF: receiveDataPacketTypeA:loopRead6_ok↓j
                call    readMidiData    ; read size byte
                jr      nc, loopRead6_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead6_ok:                           ; CODE XREF: receiveDataPacketTypeA+D1↑j
                jr      z, loopRead6
                cp      21h ; '!'
                jr      nc, endError    ; if (a >= 0x21) jmp loc_351A
                ld      h, a

loopRead7:                              ; CODE XREF: receiveDataPacketTypeA:loopRead7_ok↓j
                call    readMidiData    ; read size byte
                jr      nc, loopRead7_ok
                call    logMidiError
                jr      endError
; ---------------------------------------------------------------------------

loopRead7_ok:                           ; CODE XREF: receiveDataPacketTypeA+E3↑j
                jr      z, loopRead7
                cp      80h
                jr      nc, endError    ; if (a >= 0x80) jmp loc_351A
                rlca
                srl     h
                rra
                push    de
                ld      d, h
                ld      e, a
                push    de
                pop     ix
                pop     de
                jr      smallLoop
; ---------------------------------------------------------------------------

loopRead8:                              ; CODE XREF: receiveDataPacketTypeA+B2↑j
                                        ; receiveDataPacketTypeA:loopRead8_ok↓j
                call    readMidiData
                jr      nc, loopRead8_ok
                call    logMidiError
                jr      endError
; ---------------------------------------------------------------------------

loopRead8_ok:                           ; CODE XREF: receiveDataPacketTypeA+100↑j
                jr      z, loopRead8
                cp      40h ; '@'
                jr      nc, endError    ; if (a >= 0x40) jmp loc_351A
                ld      h, a
                add     a, l
                ld      l, a
                rlc     h
                rlc     h
                rlc     h
                rlc     h
                ld      a, (soundProcessorMidiInterpreterState)
                or      h
                ld      (de), a
                inc     de
                dec     bc
                ld      a, b
                or      c
                jr      z, bigLoopEnd
                dec     ix
                jp      bigLoop
; ---------------------------------------------------------------------------
LOOP END ================================

bigLoopEnd:                             ; CODE XREF: receiveDataPacketTypeA+121↑j
                                        ; receiveDataPacketTypeA+143↓j
                dec     ix
                push    ix
                pop     de
                ld      a, d
                or      e
                jr      z, loopRead10

loopRead9:                              ; CODE XREF: receiveDataPacketTypeA:loopRead9_ok↓j
                call    readMidiData
                jr      nc, loopRead9_ok
                call    logMidiError
                jr      endError
; ---------------------------------------------------------------------------

loopRead9_ok:                           ; CODE XREF: receiveDataPacketTypeA+134↑j
                jr      z, loopRead9
                cp      80h
                jr      nc, endError    ; if (a >= 0x80) jmp loc_351A
                add     a, l
                ld      l, a
                jr      bigLoopEnd
; ---------------------------------------------------------------------------
l-reg contains the checksum

read the checksum

loopRead10:                             ; CODE XREF: receiveDataPacketTypeA+12F↑j
                                        ; receiveDataPacketTypeA:loopRead10_ok↓j
                call    readMidiData
                jr      nc, loopRead10_ok
                call    logMidiError
                jr      endError
; ---------------------------------------------------------------------------

loopRead10_ok:                          ; CODE XREF: receiveDataPacketTypeA+148↑j
                jr      z, loopRead10
                cp      80h
                jr      nc, endError    ; if (a >= 0x80) jmp loc_351A
                add     a, l
                and     7Fh
                jr      nz, endError
                or      a
                ret
; ---------------------------------------------------------------------------

endError:                               ; CODE XREF: receiveDataPacketTypeA+14↑j
                                        ; receiveDataPacketTypeA+28↑j ...
                scf
                ret
; End of function receiveDataPacketTypeA


; =============== S U B R O U T I N E =======================================

; a=first byte of data / de=destimation ptr for the read data / bc=number of bytes to copy -> c-flag for errors

receiveDataPacketTypeB:                 ; CODE XREF: processSysExCmd_NodeMessage_SetConfiguration1+19↑p
                                        ; processSysExCmd_NodeMessage_SetConfigurationMemory+32↑p ...
                ld      l, 0
                jr      loc_352F
; ---------------------------------------------------------------------------

loc_3520:                               ; CODE XREF: receiveDataPacketTypeB+4F↓j
                ld      l, 0

loopRead1:                              ; CODE XREF: receiveDataPacketTypeB:loopRead1_ok↓j
                call    readMidiData
                jr      nc, loopRead1_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead1_ok:                           ; CODE XREF: receiveDataPacketTypeB+9↑j
                jr      z, loopRead1

loc_352F:                               ; CODE XREF: receiveDataPacketTypeB+2↑j
                ld      h, a

loopRead2:                              ; CODE XREF: receiveDataPacketTypeB:loopRead2_ok↓j
                call    readMidiData
                jr      nc, loopRead2_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead2_ok:                           ; CODE XREF: receiveDataPacketTypeB+17↑j
                jr      z, loopRead2
                cp      80h
                jp      nc, endError    ; if (a >= 0x80) jmp loc_35C6
                rlca                    ; 8-bit rotation to the left. The bit leaving on the left is copied into the carry, and to bit 0.
                srl     h               ; Like SRA, except a 0 is put into bit 7. The bits are all shifted right, with bit 0 put into the carry flag.
                rra                     ; 9-bit rotation to the right. The carry is copied into bit 7, and the bit leaving on the right is copied into the carry.
                push    de
                ld      d, h
                ld      e, a
                push    de
                pop     ix
                pop     de

loc_354D:                               ; CODE XREF: receiveDataPacketTypeB+73↓j
                push    de
                push    ix
                pop     de
                ld      a, d
                or      e
                pop     de
                jr      nz, loopRead4
read the checksum

loopRead3:                              ; CODE XREF: receiveDataPacketTypeB:loopRead3_ok↓j
                call    readMidiData
                jr      nc, loopRead3_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead3_ok:                           ; CODE XREF: receiveDataPacketTypeB+3D↑j
                jr      z, loopRead3
                cp      80h
                jp      nc, endError    ; if (a >= 0x80) jmp loc_35C6
                add     a, l
                and     7Fh
                jr      z, loc_3520
                jp      endError
; ---------------------------------------------------------------------------

loopRead4:                              ; CODE XREF: receiveDataPacketTypeB+38↑j
                                        ; receiveDataPacketTypeB:loopRead4_ok↓j
                call    readMidiData
                jr      nc, loopRead4_ok
                call    logMidiError
                jp      endError
; ---------------------------------------------------------------------------

loopRead4_ok:                           ; CODE XREF: receiveDataPacketTypeB+57↑j
                jr      z, loopRead4
                cp      80h
                jp      nc, endError    ; if (a >= 0x80) jmp loc_35C6
-------
                ld      h, a
                add     a, l
                ld      l, a            ; update checksum
                ld      a, h            ; a is the read byte
                ld      (de), a
                inc     de
                dec     bc
                ld      a, b
                or      c
                jr      z, loc_3592
                dec     ix
                jp      loc_354D
; ---------------------------------------------------------------------------

loc_3592:                               ; CODE XREF: receiveDataPacketTypeB+6F↑j
                                        ; receiveDataPacketTypeB+91↓j
                dec     ix
                push    ix
                pop     de
                ld      a, d
                or      e
                jr      z, loopRead6

loopRead5:                              ; CODE XREF: receiveDataPacketTypeB:loopRead5_ok↓j
                call    readMidiData
                jr      nc, loopRead5_ok
                call    logMidiError
                jr      endError
; ---------------------------------------------------------------------------

loopRead5_ok:                           ; CODE XREF: receiveDataPacketTypeB+82↑j
                jr      z, loopRead5
                cp      80h
                jr      nc, endError    ; if (a >= 0x80) jmp loc_35C6
                add     a, l
                ld      l, a            ; update checksum
                jr      loc_3592
; ---------------------------------------------------------------------------
checksum read

loopRead6:                              ; CODE XREF: receiveDataPacketTypeB+7D↑j
                                        ; receiveDataPacketTypeB:loopRead6_ok↓j
                call    readMidiData
                jr      nc, loopRead6_ok
                call    logMidiError
                jr      endError
; ---------------------------------------------------------------------------

loopRead6_ok:                           ; CODE XREF: receiveDataPacketTypeB+96↑j
                jr      z, loopRead6
                cp      80h
                jr      nc, endError    ; if (a >= 0x80) jmp loc_35C6
                add     a, l
                and     7Fh
                jr      nz, endError
                or      a
                ret
; ---------------------------------------------------------------------------

endError:                               ; CODE XREF: receiveDataPacketTypeB+E↑j
                                        ; receiveDataPacketTypeB+1C↑j ...
                ld      c, a
                scf
                ret
; End of function receiveDataPacketTypeB


; =============== S U B R O U T I N E =======================================

; void -> c-flag for errors

send_F0_43_75_NodeNumber:               ; CODE XREF: processSysExCmd_NodeDumpRequestMessage_VoiceMemoryBank+26↑p
                                        ; processSysExCmd_NodeDumpRequestMessage_ConfigurationBuffer1+34↑p ...
                ld      a, 0F0h
                call    send_midi_byte
                ret     c
                ld      a, 43h ; 'C'
                call    send_midi_byte
                ret     c
                ld      a, 75h ; 'u'
                call    send_midi_byte
                ret     c
                ld      a, (nodeNumber)
                jp      send_midi_byte
; End of function send_F0_43_75_NodeNumber


; =============== S U B R O U T I N E =======================================

; c = messageNumber -> c-flag for errors

sendHandshakingMessage:                 ; CODE XREF: processSysExCmd_StoreRequest_StoreConfigurationData:loc_2F95↑p
                                        ; processSysExCmd_StoreRequest_StoreVoiceData:loc_30B3↑p ...
                ld      a, 0F0h
                call    send_midi_byte
                ret     c
                ld      a, 43h ; 'C'
                call    send_midi_byte
                ret     c
                ld      a, (nodeNumber)
                or      60h ; '`'
                call    send_midi_byte
                ret     c
                ld      a, c
                call    send_midi_byte
                ret     c
                ld      a, 0F7h
                jp      send_midi_byte
; End of function sendHandshakingMessage


; =============== S U B R O U T I N E =======================================

; b = 0:OK / 1:DumpReceivedError / 2:DumpErrorError 3:DumpProtectedError -> void

logDumpError:                           ; CODE XREF: sendResponse↑p
                push    hl
                push    bc
                ld      a, b
                or      a
                jr      z, loc_3615     ; if (a == 0) jmp loc_3615
                dec     a
                rlca
                rlca
                rlca
                rlca
                ld      hl, DumpReceivedStr ; "dump/received !!"
                ld      b, 0
                ld      c, a
                add     hl, bc
                call    logErrorOrSuccess

loc_3615:                               ; CODE XREF: logDumpError+4↑j
                pop     bc
                pop     hl
                ret
; ---------------------------------------------------------------------------
DumpReceivedStr:.ascii 'dump/received !!'
                                        ; DATA XREF: logDumpError+B↑o
DumpErrorStr:   .ascii 'dump/error   !!!'
DumpProtectedStr:.ascii 'dump/protected !'
; End of function logDumpError


; =============== S U B R O U T I N E =======================================


initMidiChannelToAssignedInstruments:   ; CODE XREF: SoundProcessor_SetToInitialState+13↑j
                                        ; processSysExCmd_InstrumentParameterChange_ByMidiChannel+4E↑p ...
                ld      a, 0FFh         ; void -> void
                ld      hl, midiChannelToAssignedInstruments
                ld      (hl), a
                ld      d, h
                ld      e, l
                inc     de
                ld      bc, 8Fh
                ldir
                ld      b, 0

loc_3658:                               ; CODE XREF: initMidiChannelToAssignedInstruments+35↓j
                ld      a, b
                call    getActiveInstrumentParameters
                push    hl
                pop     iy
                ld      a, (iy+InstrumentParameters.instrumentConfiguration.midiChannel)
                and     0Fh
                ld      e, a
                rlca
                rlca
                rlca
                add     a, e
                ld      d, 0
                ld      e, a
                ld      hl, midiChannelToAssignedInstruments
                add     hl, de

loc_3670:                               ; CODE XREF: initMidiChannelToAssignedInstruments+2E↓j
                ld      a, (hl)
                cp      0FFh
                jr      z, loc_3678     ; if (a == 0xff) jmp loc_3678
                inc     hl
                jr      loc_3670
; ---------------------------------------------------------------------------

loc_3678:                               ; CODE XREF: initMidiChannelToAssignedInstruments+2B↑j
                ld      (hl), b
                inc     b
                ld      a, b
                cp      8
                jr      nz, loc_3658    ; if (a != 0x08) jmp loc_3658
                ret
; End of function initMidiChannelToAssignedInstruments


; =============== S U B R O U T I N E =======================================

; void -> void

initializeSysExStateMatchTable:         ; CODE XREF: SoundProcessor_SetToInitialState+10↑p
                                        ; processSysExCmd_NodeParameterChangeMessage:loc_2CEF↑p
                ld      de, sp_SysExStateMatchTable
                ld      hl, SP_SysExStateMatchTableTemplate
                ld      b, 241          ; sizeof(SP_SysExStateMatchTableTemplate)
                ld      a, (nodeNumber)
                ld      c, a            ; c = nodeNumber

loc_368C:                               ; CODE XREF: initializeSysExStateMatchTable+2A↓j
                ld      a, (hl)
                cp      80h
                jr      c, loc_36A7     ; if (a < 0x80) jmp loc_36A7
                cp      90h
                jr      nc, loc_369E    ; if (a >= 0x90) jmp loc_369E
                rlca
                rlca
                rlca
                rlca
                and     0F0h
                or      c
                jr      loc_36A7
; ---------------------------------------------------------------------------

loc_369E:                               ; CODE XREF: initializeSysExStateMatchTable+13↑j
                cp      0FFh
                jr      nz, loc_36A7    ; if (a != 0xff) jmp loc_36A7
                ld      (de), a
                inc     hl
                inc     de
                dec     b
                ld      a, (hl)

loc_36A7:                               ; CODE XREF: initializeSysExStateMatchTable+F↑j
                                        ; initializeSysExStateMatchTable+1C↑j ...
                ld      (de), a
                inc     hl
                inc     de
                djnz    loc_368C
                ret
; End of function initializeSysExStateMatchTable

; ---------------------------------------------------------------------------
SP_SysExStateMatchTableTemplate:db  43h, 80h, 0Ch,0FFh, 31h,   0,   0, 43h, 80h,0F0h,   0,   0,   0,   0, 43h,0A1h
                                        ; DATA XREF: initializeSysExStateMatchTable+3↑o
                db  15h,0FFh, 32h,   0,   0, 43h,0A1h,0F0h,   0,   0,   0,   0, 43h, 82h, 0Ch,0FFh ; 0x00-0x7F:normal bytes
                db  33h,   0,   0, 43h, 82h,0F0h,   0,   0,   0,   0, 43h, 75h, 80h,   0,   0,0FFh ; 0x8n:NodeByte -> 0xn0 | NodeNumber
                db  34h, 43h, 75h, 80h,   0,   1,0FFh, 35h, 43h, 75h, 80h,   0,   2,0FFh, 36h, 43h ; 0x9n:InstrumentNumber
                db  75h, 80h,   0,   3,0FFh, 37h, 43h, 75h, 80h,   0,   6,0FFh, 46h, 43h, 75h, 80h ; 0xAn:ChannelNumber
                db    0,0F0h,   0,   0, 43h, 75h, 80h, 90h,   0,0FFh, 38h, 43h, 75h, 80h, 90h,   1 ; 0xF0:ignore
                db 0FFh, 47h, 43h, 75h, 80h, 90h,   2,0FFh, 48h, 43h, 75h, 80h, 90h,0F0h,   0,   0 ; 0xFF+0xss:following byte is the new state (0xss)
                db  43h, 75h, 80h, 10h,0FFh, 39h,   0, 43h, 75h, 80h, 91h,0FFh, 3Ah,   0, 43h, 75h
                db  80h, 20h,   0,0FFh, 3Bh, 43h, 75h, 80h, 20h,   1,0FFh, 3Ch, 43h, 75h, 80h, 20h
                db    2,0FFh, 3Dh, 43h, 75h, 80h, 20h,   3,0FFh, 3Eh, 43h, 75h, 80h, 20h,   4,0FFh
                db  3Fh, 43h, 75h, 80h, 20h,   5,0FFh, 40h, 43h, 75h, 80h, 20h,   6,0FFh, 49h, 43h
                db  75h, 80h, 20h, 40h,0FFh, 41h, 43h, 75h, 80h, 20h,0F0h,   0,   0, 43h, 75h, 80h
                db  92h,   0,0FFh, 42h, 43h, 75h, 80h, 92h,   1,0FFh, 4Ah, 43h, 75h, 80h, 92h,   2
                db 0FFh, 4Bh, 43h, 75h, 80h, 92h, 40h,0FFh, 43h, 43h, 75h, 80h,0F0h,0F0h,   0,   0
                db  43h, 75h, 70h,0FFh, 44h,   0,   0, 43h, 75h, 71h,0FFh, 45h,   0,   0,0F0h,0F0h
                db 0F0h
                db [ 926h ], 0FFh
ROMPresetConfiguration16:.ascii '  single'       ; name
                                        ; DATA XREF: getConfigurationData+A↑o
                                        ; initConfigurationMemory+48↑o ...
                db 1                    ; combineMode
                db 66h                  ; lfoSpeed
                db 4                    ; amplitudeModulationDepth
                db 0                    ; pitchModulationDepth
                db 2                    ; lfoWaveForm
                db 0                    ; noteNumberReceptionMode
                db [ 12h ], 0           ; reserved
                db 8                    ; instrumentConfigurations.numberOfNotes
                db 0                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 5                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 5                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 1                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 2                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 3                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 4                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 5                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 6                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 7                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
ROMPresetConfiguration17:.ascii '  mono 8'       ; name
                db 1                    ; combineMode
                db 64h                  ; lfoSpeed
                db 0                    ; amplitudeModulationDepth
                db 32h                  ; pitchModulationDepth
                db 2                    ; lfoWaveForm
                db 0                    ; noteNumberReceptionMode
                db [ 12h ], 0           ; reserved
                db 1                    ; instrumentConfigurations.numberOfNotes
                db 0                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 1                    ; instrumentConfigurations.numberOfNotes
                db 1                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 1                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 4                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 1                    ; instrumentConfigurations.numberOfNotes
                db 2                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 2                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 4                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 1                    ; instrumentConfigurations.numberOfNotes
                db 3                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 3                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 7                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 1                    ; instrumentConfigurations.numberOfNotes
                db 4                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 4                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 1                    ; instrumentConfigurations.numberOfNotes
                db 5                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 5                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 5                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 1                    ; instrumentConfigurations.numberOfNotes
                db 6                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 6                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 1                    ; instrumentConfigurations.numberOfNotes
                db 7                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 7                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 0                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 0                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
ROMPresetConfiguration18:.ascii '    dual'       ; name
                db 1                    ; combineMode
                db 64h                  ; lfoSpeed
                db 0                    ; amplitudeModulationDepth
                db 32h                  ; pitchModulationDepth
                db 2                    ; lfoWaveForm
                db 0                    ; noteNumberReceptionMode
                db [ 12h ], 0           ; reserved
                db 4                    ; instrumentConfigurations.numberOfNotes
                db 0                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 4                    ; instrumentConfigurations.numberOfNotes
                db 0                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 4                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 2                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 3                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 4                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 5                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 6                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 7                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
ROMPresetConfiguration19:.ascii '   split'       ; name
                db 1                    ; combineMode
                db 64h                  ; lfoSpeed
                db 0                    ; amplitudeModulationDepth
                db 32h                  ; pitchModulationDepth
                db 2                    ; lfoWaveForm
                db 0                    ; noteNumberReceptionMode
                db [ 12h ], 0           ; reserved
                db 4                    ; instrumentConfigurations.numberOfNotes
                db 0                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 3Ch                  ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 4                    ; instrumentConfigurations.numberOfNotes
                db 0                    ; instrumentConfigurations.midiChannel
                db 3Bh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 2                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 3                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 4                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 5                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 6                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0                    ; instrumentConfigurations.numberOfNotes
                db 7                    ; instrumentConfigurations.midiChannel
                db 7Fh                  ; instrumentConfigurations.noteNumberLimitHigh
                db 0                    ; instrumentConfigurations.noteNumberLimitLow
                db 2                    ; instrumentConfigurations.voiceBankNumber
                db 0                    ; instrumentConfigurations.voiceNumber
                db 0                    ; instrumentConfigurations.detune
                db 2                    ; instrumentConfigurations.octaveTranspose
                db 7Fh                  ; instrumentConfigurations.outputLevel
                db 40h                  ; instrumentConfigurations.pan
                db 0                    ; instrumentConfigurations.lfoEnable
                db 0                    ; instrumentConfigurations.portamentoTime
                db 2                    ; instrumentConfigurations.pitchbenderRange
                db 0                    ; instrumentConfigurations.polyMonoMode
                db 2                    ; instrumentConfigurations.pmdController
                db 0                    ; instrumentConfigurations.reserved1
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
                db 0FFh
VoiceDefinitionBankRom1:.ascii 'rom1    '       ; name
                                        ; DATA XREF: getVoiceDefinitionBank:voiceDefinitionBankTable↑o
                                        ; initCustomInstrumentData+5↑o
                db [ 18h ], 0           ; reserved
                .ascii 'Brass  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 32h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FDh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 12h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 1                    ; instrumentDefinitions.operator0.field_3
                db 8Dh                  ; instrumentDefinitions.operator0.field_4
                db 9                    ; instrumentDefinitions.operator0.field_5
                db 4                    ; instrumentDefinitions.operator0.field_6
                db 18h                  ; instrumentDefinitions.operator0.field_7
                db 0Fh                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 1000100b             ; instrumentDefinitions.operator1.field_2
                db 60h                  ; instrumentDefinitions.operator1.field_3
                db 4Fh                  ; instrumentDefinitions.operator1.field_4
                db 88h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 18h                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 1000100b             ; instrumentDefinitions.operator2.field_2
                db 51h                  ; instrumentDefinitions.operator2.field_3
                db 15h                  ; instrumentDefinitions.operator2.field_4
                db 8Eh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 28h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0F0h                 ; instrumentDefinitions.operator3.field_1
                db 100100b              ; instrumentDefinitions.operator3.field_2
                db 11h                  ; instrumentDefinitions.operator3.field_3
                db 52h                  ; instrumentDefinitions.operator3.field_4
                db 83h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 28h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 20h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Horn   '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 19h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 10000b               ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 0Eh                  ; instrumentDefinitions.operator0.field_4
                db 9                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 29h                  ; instrumentDefinitions.operator0.field_7
                db 29h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 10000b               ; instrumentDefinitions.operator1.field_2
                db 45h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 11h                  ; instrumentDefinitions.operator1.field_5
                db 80h                  ; instrumentDefinitions.operator1.field_6
                db 0CFh                 ; instrumentDefinitions.operator1.field_7
                db 1Ch                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 0Dh                  ; instrumentDefinitions.operator2.field_4
                db 0Bh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 18h                  ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 12h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Ah                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Trumpet'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 16h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 10h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 10000b               ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 11h                  ; instrumentDefinitions.operator0.field_4
                db 0Eh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 15h                  ; instrumentDefinitions.operator0.field_7
                db 25h                  ; instrumentDefinitions.operator1.totalLevel
                db 30h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 42h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 10h                  ; instrumentDefinitions.operator1.field_5
                db 80h                  ; instrumentDefinitions.operator1.field_6
                db 0AFh                 ; instrumentDefinitions.operator1.field_7
                db 15h                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 11h                  ; instrumentDefinitions.operator2.field_4
                db 11h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 39h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 100b                 ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 55h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Bh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'LoStrig'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CAh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 3Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 13h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 100000b              ; instrumentDefinitions.operator0.field_2
                db 11h                  ; instrumentDefinitions.operator0.field_3
                db 59h                  ; instrumentDefinitions.operator0.field_4
                db 0Ah                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 15h                  ; instrumentDefinitions.operator0.field_7
                db 7                    ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 1010000b             ; instrumentDefinitions.operator1.field_2
                db 15h                  ; instrumentDefinitions.operator1.field_3
                db 59h                  ; instrumentDefinitions.operator1.field_4
                db 0Bh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 58h                  ; instrumentDefinitions.operator1.field_7
                db 27h                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 1                    ; instrumentDefinitions.operator2.field_3
                db 5Ch                  ; instrumentDefinitions.operator2.field_4
                db 0Dh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 26h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0D0h                 ; instrumentDefinitions.operator3.field_1
                db 10000b               ; instrumentDefinitions.operator3.field_2
                db 11h                  ; instrumentDefinitions.operator3.field_3
                db 4Eh                  ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 27h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Strings'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 46h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0Ch                  ; instrumentDefinitions.transpose
                db 12h                  ; instrumentDefinitions.operator0.totalLevel
                db 0C0h                 ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 20h                  ; instrumentDefinitions.operator0.field_3
                db 5Eh                  ; instrumentDefinitions.operator0.field_4
                db 21h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 15h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 11111000b            ; instrumentDefinitions.operator1.field_2
                db 32h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 21h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 15h                  ; instrumentDefinitions.operator1.field_7
                db 1Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 31h                  ; instrumentDefinitions.operator2.field_3
                db 5Eh                  ; instrumentDefinitions.operator2.field_4
                db 21h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 15h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 10000000b            ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 4Dh                  ; instrumentDefinitions.operator3.field_4
                db 0A2h                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Piano  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 84h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 11h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 1Ch                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 1110000b             ; instrumentDefinitions.operator0.field_2
                db 0D1h                 ; instrumentDefinitions.operator0.field_3
                db 56h                  ; instrumentDefinitions.operator0.field_4
                db 5                    ; instrumentDefinitions.operator0.field_5
                db 7                    ; instrumentDefinitions.operator0.field_6
                db 94h                  ; instrumentDefinitions.operator0.field_7
                db 19h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0A3h                 ; instrumentDefinitions.operator1.field_3
                db 56h                  ; instrumentDefinitions.operator1.field_4
                db 0                    ; instrumentDefinitions.operator1.field_5
                db 4                    ; instrumentDefinitions.operator1.field_6
                db 45h                  ; instrumentDefinitions.operator1.field_7
                db 0Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0F1h                 ; instrumentDefinitions.operator2.field_3
                db 5Dh                  ; instrumentDefinitions.operator2.field_4
                db 0                    ; instrumentDefinitions.operator2.field_5
                db 4                    ; instrumentDefinitions.operator2.field_6
                db 45h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0F0h                 ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 11h                  ; instrumentDefinitions.operator3.field_3
                db 97h                  ; instrumentDefinitions.operator3.field_4
                db 0A7h                 ; instrumentDefinitions.operator3.field_5
                db 6                    ; instrumentDefinitions.operator3.field_6
                db 46h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 25h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'NewEP  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 29h                  ; instrumentDefinitions.operator0.totalLevel
                db 50h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 37h                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 84h                  ; instrumentDefinitions.operator0.field_6
                db 37h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 31h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 8Bh                  ; instrumentDefinitions.operator1.field_5
                db 8                    ; instrumentDefinitions.operator1.field_6
                db 27h                  ; instrumentDefinitions.operator1.field_7
                db 17h                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 31h                  ; instrumentDefinitions.operator2.field_3
                db 9Bh                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 24h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 9Bh                  ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 3                    ; instrumentDefinitions.operator3.field_6
                db 26h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EGrand '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 1Eh                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 100000b              ; instrumentDefinitions.operator0.field_2
                db 31h                  ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 3                    ; instrumentDefinitions.operator0.field_6
                db 25h                  ; instrumentDefinitions.operator0.field_7
                db 18h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 11100000b            ; instrumentDefinitions.operator1.field_2
                db 0A5h                 ; instrumentDefinitions.operator1.field_3
                db 16h                  ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 4                    ; instrumentDefinitions.operator1.field_6
                db 25h                  ; instrumentDefinitions.operator1.field_7
                db 15h                  ; instrumentDefinitions.operator2.totalLevel
                db 60h                  ; instrumentDefinitions.operator2.field_1
                db 11000000b            ; instrumentDefinitions.operator2.field_2
                db 0F3h                 ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 2                    ; instrumentDefinitions.operator2.field_6
                db 15h                  ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 98h                  ; instrumentDefinitions.operator3.field_4
                db 9Eh                  ; instrumentDefinitions.operator3.field_5
                db 6                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Jazz Gt'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C9h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F8h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 24h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 4Eh                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Ch                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0FFh                 ; instrumentDefinitions.operator0.field_7
                db 17h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 33h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Ah                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0FFh                 ; instrumentDefinitions.operator1.field_7
                db 19h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 43h                  ; instrumentDefinitions.operator2.field_3
                db 1Ch                  ; instrumentDefinitions.operator2.field_4
                db 6                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0FFh                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 10000000b            ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 8Ah                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0FFh                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EBass  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0D8h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 20h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 25h                  ; instrumentDefinitions.operator0.totalLevel
                db 60h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 37h                  ; instrumentDefinitions.operator0.field_3
                db 9Eh                  ; instrumentDefinitions.operator0.field_4
                db 0Dh                  ; instrumentDefinitions.operator0.field_5
                db 8                    ; instrumentDefinitions.operator0.field_6
                db 0B6h                 ; instrumentDefinitions.operator0.field_7
                db 1Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 60h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 30h                  ; instrumentDefinitions.operator1.field_3
                db 0DCh                 ; instrumentDefinitions.operator1.field_4
                db 6                    ; instrumentDefinitions.operator1.field_5
                db 0Ah                  ; instrumentDefinitions.operator1.field_6
                db 0B6h                 ; instrumentDefinitions.operator1.field_7
                db 0Dh                  ; instrumentDefinitions.operator2.totalLevel
                db 60h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 9Ch                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 36h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 30h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 9Ch                  ; instrumentDefinitions.operator3.field_4
                db 81h                  ; instrumentDefinitions.operator3.field_5
                db 5                    ; instrumentDefinitions.operator3.field_6
                db 26h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'WodBass'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CAh                 ; instrumentDefinitions.lfoSpeed
                db 83h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 3Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 31h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 17h                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 10h                  ; instrumentDefinitions.operator0.field_3
                db 0D7h                 ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 85h                  ; instrumentDefinitions.operator0.field_7
                db 0Fh                  ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 11000000b            ; instrumentDefinitions.operator1.field_2
                db 10h                  ; instrumentDefinitions.operator1.field_3
                db 8                    ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0F8h                 ; instrumentDefinitions.operator1.field_7
                db 0Ah                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 11000000b            ; instrumentDefinitions.operator2.field_2
                db 1                    ; instrumentDefinitions.operator2.field_3
                db 0D4h                 ; instrumentDefinitions.operator2.field_4
                db 29h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 76h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0D0h                 ; instrumentDefinitions.operator3.field_1
                db 10000b               ; instrumentDefinitions.operator3.field_2
                db 11h                  ; instrumentDefinitions.operator3.field_3
                db 94h                  ; instrumentDefinitions.operator3.field_4
                db 0B3h                 ; instrumentDefinitions.operator3.field_5
                db 2                    ; instrumentDefinitions.operator3.field_6
                db 16h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EOrgan1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0AFh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0A8h                 ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 16h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 111b                 ; instrumentDefinitions.operator0.field_2
                db 71h                  ; instrumentDefinitions.operator0.field_3
                db 19h                  ; instrumentDefinitions.operator0.field_4
                db 12h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0Fh                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 111b                 ; instrumentDefinitions.operator1.field_2
                db 32h                  ; instrumentDefinitions.operator1.field_3
                db 1Ch                  ; instrumentDefinitions.operator1.field_4
                db 84h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0Fh                  ; instrumentDefinitions.operator1.field_7
                db 0Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 10111b               ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 14h                  ; instrumentDefinitions.operator2.field_4
                db 0Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0Fh                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0                    ; instrumentDefinitions.operator3.field_1
                db 10111b               ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 1Ch                  ; instrumentDefinitions.operator3.field_4
                db 8Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Fh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 27h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EOrgan2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0D0h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0DFh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 20h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 50h                  ; instrumentDefinitions.operator0.field_1
                db 1111b                ; instrumentDefinitions.operator0.field_2
                db 33h                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 8Dh                  ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 0FBh                 ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 1111b                ; instrumentDefinitions.operator1.field_2
                db 33h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 9Fh                  ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 0Ah                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 1111b                ; instrumentDefinitions.operator2.field_2
                db 72h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 9Fh                  ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 0Ah                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 1111b                ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 0Ah                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'POrgan1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Dh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 19h                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 5Ah                  ; instrumentDefinitions.operator0.field_3
                db 16h                  ; instrumentDefinitions.operator0.field_4
                db 0                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0Ah                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 72h                  ; instrumentDefinitions.operator1.field_3
                db 8Fh                  ; instrumentDefinitions.operator1.field_4
                db 80h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 8                    ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 11010000b            ; instrumentDefinitions.operator2.field_2
                db 70h                  ; instrumentDefinitions.operator2.field_3
                db 98h                  ; instrumentDefinitions.operator2.field_4
                db 0                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 5                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 40h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 30h                  ; instrumentDefinitions.operator3.field_3
                db 8Ch                  ; instrumentDefinitions.operator3.field_4
                db 80h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 5                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'POrgan2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 82h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Dh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 1                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 11000000b            ; instrumentDefinitions.operator0.field_2
                db 73h                  ; instrumentDefinitions.operator0.field_3
                db 8Fh                  ; instrumentDefinitions.operator0.field_4
                db 2                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 3                    ; instrumentDefinitions.operator0.field_7
                db 11h                  ; instrumentDefinitions.operator1.totalLevel
                db 0D0h                 ; instrumentDefinitions.operator1.field_1
                db 11000000b            ; instrumentDefinitions.operator1.field_2
                db 75h                  ; instrumentDefinitions.operator1.field_3
                db 90h                  ; instrumentDefinitions.operator1.field_4
                db 82h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 6                    ; instrumentDefinitions.operator1.field_7
                db 1                    ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 11000000b            ; instrumentDefinitions.operator2.field_2
                db 60h                  ; instrumentDefinitions.operator2.field_3
                db 8Fh                  ; instrumentDefinitions.operator2.field_4
                db 2                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 3                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 10100000b            ; instrumentDefinitions.operator3.field_2
                db 11h                  ; instrumentDefinitions.operator3.field_3
                db 8Fh                  ; instrumentDefinitions.operator3.field_4
                db 82h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 7                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 7                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Flute  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C6h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 2Dh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0Ch                  ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 71h                  ; instrumentDefinitions.operator0.field_3
                db 52h                  ; instrumentDefinitions.operator0.field_4
                db 0Eh                  ; instrumentDefinitions.operator0.field_5
                db 0C3h                 ; instrumentDefinitions.operator0.field_6
                db 65h                  ; instrumentDefinitions.operator0.field_7
                db 34h                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 2                    ; instrumentDefinitions.operator1.field_3
                db 51h                  ; instrumentDefinitions.operator1.field_4
                db 10h                  ; instrumentDefinitions.operator1.field_5
                db 2                    ; instrumentDefinitions.operator1.field_6
                db 55h                  ; instrumentDefinitions.operator1.field_7
                db 1Ch                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 110000b              ; instrumentDefinitions.operator2.field_2
                db 31h                  ; instrumentDefinitions.operator2.field_3
                db 8Bh                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 25h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 4Fh                  ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 8                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Piccolo'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 84h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 28h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FEh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 31h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 18h                  ; instrumentDefinitions.transpose
                db 21h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 1                    ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Ah                  ; instrumentDefinitions.operator0.field_5
                db 0Fh                  ; instrumentDefinitions.operator0.field_6
                db 59h                  ; instrumentDefinitions.operator0.field_7
                db 7                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 101000b              ; instrumentDefinitions.operator1.field_2
                db 1                    ; instrumentDefinitions.operator1.field_3
                db 14h                  ; instrumentDefinitions.operator1.field_4
                db 86h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0F9h                 ; instrumentDefinitions.operator1.field_7
                db 2                    ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 1101000b             ; instrumentDefinitions.operator2.field_2
                db 1                    ; instrumentDefinitions.operator2.field_3
                db 14h                  ; instrumentDefinitions.operator2.field_4
                db 8Bh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 19h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1101000b             ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 14h                  ; instrumentDefinitions.operator3.field_4
                db 8Bh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 19h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Oboe   '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 83h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 31h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 18h                  ; instrumentDefinitions.operator0.totalLevel
                db 60h                  ; instrumentDefinitions.operator0.field_1
                db 1100000b             ; instrumentDefinitions.operator0.field_2
                db 31h                  ; instrumentDefinitions.operator0.field_3
                db 0D9h                 ; instrumentDefinitions.operator0.field_4
                db 0Bh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 13h                  ; instrumentDefinitions.operator0.field_7
                db 1Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 60h                  ; instrumentDefinitions.operator1.field_1
                db 10000000b            ; instrumentDefinitions.operator1.field_2
                db 39h                  ; instrumentDefinitions.operator1.field_3
                db 0DCh                 ; instrumentDefinitions.operator1.field_4
                db 0Ch                  ; instrumentDefinitions.operator1.field_5
                db 0Ch                  ; instrumentDefinitions.operator1.field_6
                db 5Bh                  ; instrumentDefinitions.operator1.field_7
                db 25h                  ; instrumentDefinitions.operator2.totalLevel
                db 60h                  ; instrumentDefinitions.operator2.field_1
                db 1100000b             ; instrumentDefinitions.operator2.field_2
                db 32h                  ; instrumentDefinitions.operator2.field_3
                db 56h                  ; instrumentDefinitions.operator2.field_4
                db 0                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 1Bh                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 110000b              ; instrumentDefinitions.operator3.field_2
                db 34h                  ; instrumentDefinitions.operator3.field_3
                db 54h                  ; instrumentDefinitions.operator3.field_4
                db 86h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Bh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Clarine'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CCh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 18h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 11h                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 42h                  ; instrumentDefinitions.operator0.field_3
                db 53h                  ; instrumentDefinitions.operator0.field_4
                db 12h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 29h                  ; instrumentDefinitions.operator0.field_7
                db 5                    ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 11010000b            ; instrumentDefinitions.operator1.field_2
                db 45h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 11h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 36h                  ; instrumentDefinitions.operator1.field_7
                db 1Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 10010000b            ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 14h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 15h                  ; instrumentDefinitions.operator2.field_7
                db 6                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 110b                 ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 50h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Bh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Glocken'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 33h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0Ch                  ; instrumentDefinitions.transpose
                db 12h                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 1100000b             ; instrumentDefinitions.operator0.field_2
                db 3Fh                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 13h                  ; instrumentDefinitions.operator0.field_5
                db 4                    ; instrumentDefinitions.operator0.field_6
                db 55h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 31h                  ; instrumentDefinitions.operator1.field_3
                db 58h                  ; instrumentDefinitions.operator1.field_4
                db 91h                  ; instrumentDefinitions.operator1.field_5
                db 8                    ; instrumentDefinitions.operator1.field_6
                db 6                    ; instrumentDefinitions.operator1.field_7
                db 28h                  ; instrumentDefinitions.operator2.totalLevel
                db 60h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 75h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 0Eh                  ; instrumentDefinitions.operator2.field_5
                db 5                    ; instrumentDefinitions.operator2.field_6
                db 62h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 91h                  ; instrumentDefinitions.operator3.field_5
                db 8                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 25h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Vibes  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0B9h                 ; instrumentDefinitions.lfoSpeed
                db 99h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 7                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 31h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 2Fh                  ; instrumentDefinitions.operator0.totalLevel
                db 0F0h                 ; instrumentDefinitions.operator0.field_1
                db 11000000b            ; instrumentDefinitions.operator0.field_2
                db 39h                  ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Fh                  ; instrumentDefinitions.operator0.field_5
                db 40h                  ; instrumentDefinitions.operator0.field_6
                db 0B5h                 ; instrumentDefinitions.operator0.field_7
                db 5                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 51h                  ; instrumentDefinitions.operator1.field_3
                db 9Bh                  ; instrumentDefinitions.operator1.field_4
                db 84h                  ; instrumentDefinitions.operator1.field_5
                db 3                    ; instrumentDefinitions.operator1.field_6
                db 83h                  ; instrumentDefinitions.operator1.field_7
                db 2Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 1110000b             ; instrumentDefinitions.operator2.field_2
                db 5                    ; instrumentDefinitions.operator2.field_3
                db 9Eh                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 0Bh                  ; instrumentDefinitions.operator2.field_6
                db 0F6h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0C0h                 ; instrumentDefinitions.operator3.field_1
                db 100000b              ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 9Eh                  ; instrumentDefinitions.operator3.field_4
                db 85h                  ; instrumentDefinitions.operator3.field_5
                db 0Ah                  ; instrumentDefinitions.operator3.field_6
                db 0F4h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Xylophn'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 15h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1110000b             ; instrumentDefinitions.operator0.field_2
                db 46h                  ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 16h                  ; instrumentDefinitions.operator0.field_5
                db 9                    ; instrumentDefinitions.operator0.field_6
                db 66h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 9Fh                  ; instrumentDefinitions.operator1.field_5
                db 0Fh                  ; instrumentDefinitions.operator1.field_6
                db 6                    ; instrumentDefinitions.operator1.field_7
                db 0Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 47h                  ; instrumentDefinitions.operator2.field_3
                db 9Fh                  ; instrumentDefinitions.operator2.field_4
                db 16h                  ; instrumentDefinitions.operator2.field_5
                db 16h                  ; instrumentDefinitions.operator2.field_6
                db 0ACh                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 111000b              ; instrumentDefinitions.operator3.field_2
                db 44h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 11h                  ; instrumentDefinitions.operator3.field_6
                db 8                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Koto   '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 0                    ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F8h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 18h                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 33h                  ; instrumentDefinitions.operator0.field_3
                db 0DAh                 ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 5                    ; instrumentDefinitions.operator0.field_6
                db 22h                  ; instrumentDefinitions.operator0.field_7
                db 18h                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 34h                  ; instrumentDefinitions.operator1.field_3
                db 0DDh                 ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 4                    ; instrumentDefinitions.operator1.field_6
                db 12h                  ; instrumentDefinitions.operator1.field_7
                db 17h                  ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 31h                  ; instrumentDefinitions.operator2.field_3
                db 0DCh                 ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 2                    ; instrumentDefinitions.operator2.field_6
                db 32h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0E0h                 ; instrumentDefinitions.operator3.field_1
                db 100100b              ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 0DFh                 ; instrumentDefinitions.operator3.field_4
                db 8Ah                  ; instrumentDefinitions.operator3.field_5
                db 3                    ; instrumentDefinitions.operator3.field_6
                db 11h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 23h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Zither '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 20h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 16h                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 37h                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 6                    ; instrumentDefinitions.operator0.field_6
                db 1                    ; instrumentDefinitions.operator0.field_7
                db 3Fh                  ; instrumentDefinitions.operator1.totalLevel
                db 20h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 39h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 6                    ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 1                    ; instrumentDefinitions.operator1.field_7
                db 17h                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 21h                  ; instrumentDefinitions.operator2.field_3
                db 9Fh                  ; instrumentDefinitions.operator2.field_4
                db 0Ch                  ; instrumentDefinitions.operator2.field_5
                db 6                    ; instrumentDefinitions.operator2.field_6
                db 1                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000100b             ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 9Fh                  ; instrumentDefinitions.operator3.field_4
                db 8Ch                  ; instrumentDefinitions.operator3.field_5
                db 6                    ; instrumentDefinitions.operator3.field_6
                db 5                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Clav   '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 16h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 3Ch                  ; instrumentDefinitions.operator0.field_3
                db 0D4h                 ; instrumentDefinitions.operator0.field_4
                db 4                    ; instrumentDefinitions.operator0.field_5
                db 4                    ; instrumentDefinitions.operator0.field_6
                db 0F7h                 ; instrumentDefinitions.operator0.field_7
                db 19h                  ; instrumentDefinitions.operator1.totalLevel
                db 20h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 39h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 8                    ; instrumentDefinitions.operator1.field_5
                db 5                    ; instrumentDefinitions.operator1.field_6
                db 27h                  ; instrumentDefinitions.operator1.field_7
                db 7                    ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 0DFh                 ; instrumentDefinitions.operator2.field_4
                db 7                    ; instrumentDefinitions.operator2.field_5
                db 4                    ; instrumentDefinitions.operator2.field_6
                db 37h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 110100b              ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 85h                  ; instrumentDefinitions.operator3.field_5
                db 2                    ; instrumentDefinitions.operator3.field_6
                db 0ACh                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Harpsic'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Fh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 8                    ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 1100000b             ; instrumentDefinitions.operator0.field_2
                db 40h                  ; instrumentDefinitions.operator0.field_3
                db 0DFh                 ; instrumentDefinitions.operator0.field_4
                db 1Dh                  ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 34h                  ; instrumentDefinitions.operator0.field_7
                db 1Ch                  ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 48h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 5                    ; instrumentDefinitions.operator1.field_6
                db 29h                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 19h                  ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 24h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 44h                  ; instrumentDefinitions.operator3.field_3
                db 0DFh                 ; instrumentDefinitions.operator3.field_4
                db 9Ah                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Bells  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C7h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 8Fh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0EDh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 12h                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 33h                  ; instrumentDefinitions.operator0.field_3
                db 1Dh                  ; instrumentDefinitions.operator0.field_4
                db 4                    ; instrumentDefinitions.operator0.field_5
                db 81h                  ; instrumentDefinitions.operator0.field_6
                db 22h                  ; instrumentDefinitions.operator0.field_7
                db 7                    ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 11110101b            ; instrumentDefinitions.operator1.field_2
                db 22h                  ; instrumentDefinitions.operator1.field_3
                db 1Dh                  ; instrumentDefinitions.operator1.field_4
                db 8Fh                  ; instrumentDefinitions.operator1.field_5
                db 43h                  ; instrumentDefinitions.operator1.field_6
                db 13h                  ; instrumentDefinitions.operator1.field_7
                db 11h                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 1000101b             ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 5Bh                  ; instrumentDefinitions.operator2.field_4
                db 8Fh                  ; instrumentDefinitions.operator2.field_5
                db 40h                  ; instrumentDefinitions.operator2.field_6
                db 13h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000101b             ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 5Eh                  ; instrumentDefinitions.operator3.field_4
                db 82h                  ; instrumentDefinitions.operator3.field_5
                db 43h                  ; instrumentDefinitions.operator3.field_6
                db 13h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Harp   '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F9h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 10h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0Ch                  ; instrumentDefinitions.transpose
                db 0Eh                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 11000000b            ; instrumentDefinitions.operator0.field_2
                db 2                    ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Ch                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0F4h                 ; instrumentDefinitions.operator0.field_7
                db 1Ch                  ; instrumentDefinitions.operator1.totalLevel
                db 60h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 1                    ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Dh                  ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 15h                  ; instrumentDefinitions.operator1.field_7
                db 22h                  ; instrumentDefinitions.operator2.totalLevel
                db 60h                  ; instrumentDefinitions.operator2.field_1
                db 10100000b            ; instrumentDefinitions.operator2.field_2
                db 2                    ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 6                    ; instrumentDefinitions.operator2.field_5
                db 5                    ; instrumentDefinitions.operator2.field_6
                db 15h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 1000000b             ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 9Fh                  ; instrumentDefinitions.operator3.field_4
                db 8Ch                  ; instrumentDefinitions.operator3.field_5
                db 7                    ; instrumentDefinitions.operator3.field_6
                db 14h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SmadSyn'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C7h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 50h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 60h                  ; instrumentDefinitions.operator0.field_1
                db 1010b                ; instrumentDefinitions.operator0.field_2
                db 4                    ; instrumentDefinitions.operator0.field_3
                db 5                    ; instrumentDefinitions.operator0.field_4
                db 0A2h                 ; instrumentDefinitions.operator0.field_5
                db 5                    ; instrumentDefinitions.operator0.field_6
                db 3Ah                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 60h                  ; instrumentDefinitions.operator1.field_1
                db 1010b                ; instrumentDefinitions.operator1.field_2
                db 3                    ; instrumentDefinitions.operator1.field_3
                db 0Ah                  ; instrumentDefinitions.operator1.field_4
                db 0A2h                 ; instrumentDefinitions.operator1.field_5
                db 7                    ; instrumentDefinitions.operator1.field_6
                db 3Ah                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 60h                  ; instrumentDefinitions.operator2.field_1
                db 1010b                ; instrumentDefinitions.operator2.field_2
                db 2                    ; instrumentDefinitions.operator2.field_3
                db 0Fh                  ; instrumentDefinitions.operator2.field_4
                db 0A2h                 ; instrumentDefinitions.operator2.field_5
                db 9                    ; instrumentDefinitions.operator2.field_6
                db 3Ah                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 1010b                ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 14h                  ; instrumentDefinitions.operator3.field_4
                db 0A2h                 ; instrumentDefinitions.operator3.field_5
                db 0Bh                  ; instrumentDefinitions.operator3.field_6
                db 3Ah                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Harmoni'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0Dh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 19h                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 10h                  ; instrumentDefinitions.operator0.field_4
                db 1Fh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 9                    ; instrumentDefinitions.operator0.field_7
                db 22h                  ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 44h                  ; instrumentDefinitions.operator1.field_3
                db 10h                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 9                    ; instrumentDefinitions.operator1.field_7
                db 15h                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 0Eh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 7                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 100b                 ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 10h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 9                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SteelDr'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 10h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 19h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 110000b              ; instrumentDefinitions.operator0.field_2
                db 71h                  ; instrumentDefinitions.operator0.field_3
                db 56h                  ; instrumentDefinitions.operator0.field_4
                db 5                    ; instrumentDefinitions.operator0.field_5
                db 6                    ; instrumentDefinitions.operator0.field_6
                db 64h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 1                    ; instrumentDefinitions.operator1.field_3
                db 99h                  ; instrumentDefinitions.operator1.field_4
                db 8Ch                  ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 15h                  ; instrumentDefinitions.operator1.field_7
                db 12h                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 1110000b             ; instrumentDefinitions.operator2.field_2
                db 42h                  ; instrumentDefinitions.operator2.field_3
                db 54h                  ; instrumentDefinitions.operator2.field_4
                db 7                    ; instrumentDefinitions.operator2.field_5
                db 46h                  ; instrumentDefinitions.operator2.field_6
                db 64h                  ; instrumentDefinitions.operator2.field_7
                db 7                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 99h                  ; instrumentDefinitions.operator3.field_4
                db 8Ch                  ; instrumentDefinitions.operator3.field_5
                db 6                    ; instrumentDefinitions.operator3.field_6
                db 65h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Timpani'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C0h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Dh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 12h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 20h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 40h                  ; instrumentDefinitions.operator0.field_3
                db 1Dh                  ; instrumentDefinitions.operator0.field_4
                db 12h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0F3h                 ; instrumentDefinitions.operator0.field_7
                db 8                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 10000000b            ; instrumentDefinitions.operator1.field_2
                db 40h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Fh                  ; instrumentDefinitions.operator1.field_5
                db 92h                  ; instrumentDefinitions.operator1.field_6
                db 33h                  ; instrumentDefinitions.operator1.field_7
                db 24h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 40h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 19h                  ; instrumentDefinitions.operator2.field_5
                db 0Ch                  ; instrumentDefinitions.operator2.field_6
                db 4                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 40h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 99h                  ; instrumentDefinitions.operator3.field_5
                db 0Ch                  ; instrumentDefinitions.operator3.field_6
                db 4                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 7                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'LoStrg2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0B4h                 ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 10h                  ; instrumentDefinitions.operator0.totalLevel
                db 0C0h                 ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 30h                  ; instrumentDefinitions.operator0.field_3
                db 5Eh                  ; instrumentDefinitions.operator0.field_4
                db 24h                  ; instrumentDefinitions.operator0.field_5
                db 2                    ; instrumentDefinitions.operator0.field_6
                db 26h                  ; instrumentDefinitions.operator0.field_7
                db 11h                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 75h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 28h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0C8h                 ; instrumentDefinitions.operator1.field_7
                db 11h                  ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 10h                  ; instrumentDefinitions.operator2.field_4
                db 25h                  ; instrumentDefinitions.operator2.field_5
                db 2                    ; instrumentDefinitions.operator2.field_6
                db 26h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 10000000b            ; instrumentDefinitions.operator3.field_2
                db 70h                  ; instrumentDefinitions.operator3.field_3
                db 0Bh                  ; instrumentDefinitions.operator3.field_4
                db 0A5h                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Horn Lo'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0BEh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 28h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FDh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 11h                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 1                    ; instrumentDefinitions.operator0.field_3
                db 4Ch                  ; instrumentDefinitions.operator0.field_4
                db 0Bh                  ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 28h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 0C0h                 ; instrumentDefinitions.operator1.field_1
                db 100110b              ; instrumentDefinitions.operator1.field_2
                db 1                    ; instrumentDefinitions.operator1.field_3
                db 0Fh                  ; instrumentDefinitions.operator1.field_4
                db 0A5h                 ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 29h                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 110b                 ; instrumentDefinitions.operator2.field_2
                db 2                    ; instrumentDefinitions.operator2.field_3
                db 50h                  ; instrumentDefinitions.operator2.field_4
                db 0A1h                 ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 2Ah                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0D0h                 ; instrumentDefinitions.operator3.field_1
                db 100110b              ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 12h                  ; instrumentDefinitions.operator3.field_4
                db 0A2h                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 19h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Whistle'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 8Ah                  ; instrumentDefinitions.amplitudeModulationDepth
                db 46h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 50h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0Ch                  ; instrumentDefinitions.transpose
                db 25h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 31h                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Fh                  ; instrumentDefinitions.operator0.field_5
                db 0C0h                 ; instrumentDefinitions.operator0.field_6
                db 0F9h                 ; instrumentDefinitions.operator0.field_7
                db 1Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 100000b              ; instrumentDefinitions.operator1.field_2
                db 2                    ; instrumentDefinitions.operator1.field_3
                db 0Fh                  ; instrumentDefinitions.operator1.field_4
                db 88h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 9                    ; instrumentDefinitions.operator1.field_7
                db 25h                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 19h                  ; instrumentDefinitions.operator2.field_4
                db 10h                  ; instrumentDefinitions.operator2.field_5
                db 40h                  ; instrumentDefinitions.operator2.field_6
                db 79h                  ; instrumentDefinitions.operator2.field_7
                db 7                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 1000000b             ; instrumentDefinitions.operator3.field_2
                db 2                    ; instrumentDefinitions.operator3.field_3
                db 0Dh                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 19h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'ZingPlp'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0D4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 8                    ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 40h                  ; instrumentDefinitions.operator0.field_3
                db 8Ah                  ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 10h                  ; instrumentDefinitions.operator0.field_6
                db 0F4h                 ; instrumentDefinitions.operator0.field_7
                db 5                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 101b                 ; instrumentDefinitions.operator1.field_2
                db 48h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 84h                  ; instrumentDefinitions.operator1.field_5
                db 10h                  ; instrumentDefinitions.operator1.field_6
                db 0D4h                 ; instrumentDefinitions.operator1.field_7
                db 1Eh                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 1Ch                  ; instrumentDefinitions.operator2.field_4
                db 8                    ; instrumentDefinitions.operator2.field_5
                db 9                    ; instrumentDefinitions.operator2.field_6
                db 0EBh                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 10101b               ; instrumentDefinitions.operator3.field_2
                db 42h                  ; instrumentDefinitions.operator3.field_3
                db 53h                  ; instrumentDefinitions.operator3.field_4
                db 8Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0F6h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2Ch                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Metal  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C9h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Bh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 11h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 75h                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 6                    ; instrumentDefinitions.operator0.field_6
                db 57h                  ; instrumentDefinitions.operator0.field_7
                db 7                    ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 1100000b             ; instrumentDefinitions.operator1.field_2
                db 30h                  ; instrumentDefinitions.operator1.field_3
                db 6                    ; instrumentDefinitions.operator1.field_4
                db 14h                  ; instrumentDefinitions.operator1.field_5
                db 2                    ; instrumentDefinitions.operator1.field_6
                db 1                    ; instrumentDefinitions.operator1.field_7
                db 0Ah                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 1010000b             ; instrumentDefinitions.operator2.field_2
                db 71h                  ; instrumentDefinitions.operator2.field_3
                db 5Fh                  ; instrumentDefinitions.operator2.field_4
                db 0Bh                  ; instrumentDefinitions.operator2.field_5
                db 4                    ; instrumentDefinitions.operator2.field_6
                db 3                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 30h                  ; instrumentDefinitions.operator3.field_3
                db 1Bh                  ; instrumentDefinitions.operator3.field_4
                db 94h                  ; instrumentDefinitions.operator3.field_5
                db 3                    ; instrumentDefinitions.operator3.field_6
                db 28h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Heavy  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F0h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 50h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Ah                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 1110000b             ; instrumentDefinitions.operator0.field_2
                db 40h                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0FFh                 ; instrumentDefinitions.operator0.field_7
                db 12h                  ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 40h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0Fh                  ; instrumentDefinitions.operator1.field_7
                db 0Eh                  ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 40h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0Fh                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 40h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 40h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Fh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'FunkSyn'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CCh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ah                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0DBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 50h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0Ch                  ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 35h                  ; instrumentDefinitions.operator0.field_3
                db 8                    ; instrumentDefinitions.operator0.field_4
                db 0Bh                  ; instrumentDefinitions.operator0.field_5
                db 2                    ; instrumentDefinitions.operator0.field_6
                db 19h                  ; instrumentDefinitions.operator0.field_7
                db 25h                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 10000000b            ; instrumentDefinitions.operator1.field_2
                db 39h                  ; instrumentDefinitions.operator1.field_3
                db 0DFh                 ; instrumentDefinitions.operator1.field_4
                db 6                    ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 5Bh                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 1100000b             ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 54h                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 1Bh                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 40h                  ; instrumentDefinitions.operator3.field_1
                db 110000b              ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 86h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 1Bh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 1                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Voices '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 2Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E9h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 26h                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 10000000b            ; instrumentDefinitions.operator0.field_2
                db 36h                  ; instrumentDefinitions.operator0.field_3
                db 13h                  ; instrumentDefinitions.operator0.field_4
                db 12h                  ; instrumentDefinitions.operator0.field_5
                db 0C4h                 ; instrumentDefinitions.operator0.field_6
                db 54h                  ; instrumentDefinitions.operator0.field_7
                db 1Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 74h                  ; instrumentDefinitions.operator1.field_3
                db 15h                  ; instrumentDefinitions.operator1.field_4
                db 0Eh                  ; instrumentDefinitions.operator1.field_5
                db 0C6h                 ; instrumentDefinitions.operator1.field_6
                db 6Ah                  ; instrumentDefinitions.operator1.field_7
                db 0Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 11010000b            ; instrumentDefinitions.operator2.field_2
                db 71h                  ; instrumentDefinitions.operator2.field_3
                db 0Bh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 0Ah                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 0Eh                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 8                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Marimba'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Fh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 0Fh                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 4Dh                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 1Bh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0F5h                 ; instrumentDefinitions.operator0.field_7
                db 18h                  ; instrumentDefinitions.operator1.totalLevel
                db 30h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 47h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Dh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0F5h                 ; instrumentDefinitions.operator1.field_7
                db 18h                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 47h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 12h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0F4h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 8Ch                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0F6h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 7                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EBass 2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CCh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 1Ah                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 4Dh                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Eh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0DFh                 ; instrumentDefinitions.operator0.field_7
                db 10h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Dh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0DFh                 ; instrumentDefinitions.operator1.field_7
                db 10h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 40h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 9                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0D7h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 40h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 89h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0D8h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SnareDr'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 0                    ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 0Fh                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 17h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 18h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 0                    ; instrumentDefinitions.operator1.field_3
                db 1Ah                  ; instrumentDefinitions.operator1.field_4
                db 91h                  ; instrumentDefinitions.operator1.field_5
                db 0Fh                  ; instrumentDefinitions.operator1.field_6
                db 9Ch                  ; instrumentDefinitions.operator1.field_7
                db 0Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 0                    ; instrumentDefinitions.operator2.field_3
                db 18h                  ; instrumentDefinitions.operator2.field_4
                db 1Ah                  ; instrumentDefinitions.operator2.field_5
                db 54h                  ; instrumentDefinitions.operator2.field_6
                db 98h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 0                    ; instrumentDefinitions.operator3.field_3
                db 1Ch                  ; instrumentDefinitions.operator3.field_4
                db 8Eh                  ; instrumentDefinitions.operator3.field_5
                db 10h                  ; instrumentDefinitions.operator3.field_6
                db 29h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0Ch                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'RD Cymb'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 0                    ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 5                    ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 3                    ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 1Fh                  ; instrumentDefinitions.operator0.field_5
                db 40h                  ; instrumentDefinitions.operator0.field_6
                db 10h                  ; instrumentDefinitions.operator0.field_7
                db 1Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 100b                 ; instrumentDefinitions.operator1.field_2
                db 5                    ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 9Fh                  ; instrumentDefinitions.operator1.field_5
                db 84h                  ; instrumentDefinitions.operator1.field_6
                db 12h                  ; instrumentDefinitions.operator1.field_7
                db 5                    ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 71h                  ; instrumentDefinitions.operator2.field_3
                db 19h                  ; instrumentDefinitions.operator2.field_4
                db 1Ch                  ; instrumentDefinitions.operator2.field_5
                db 85h                  ; instrumentDefinitions.operator2.field_6
                db 33h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 100b                 ; instrumentDefinitions.operator3.field_2
                db 7                    ; instrumentDefinitions.operator3.field_3
                db 9Fh                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0C5h                 ; instrumentDefinitions.operator3.field_6
                db 72h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0Ch                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Tom Tom'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F8h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 50h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 10h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 70h                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 13h                  ; instrumentDefinitions.operator0.field_5
                db 85h                  ; instrumentDefinitions.operator0.field_6
                db 5Ah                  ; instrumentDefinitions.operator0.field_7
                db 19h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 43h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Dh                  ; instrumentDefinitions.operator1.field_5
                db 45h                  ; instrumentDefinitions.operator1.field_6
                db 2Ah                  ; instrumentDefinitions.operator1.field_7
                db 17h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 1110000b             ; instrumentDefinitions.operator2.field_2
                db 42h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 13h                  ; instrumentDefinitions.operator2.field_5
                db 0CAh                 ; instrumentDefinitions.operator2.field_6
                db 25h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 42h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 9Ch                  ; instrumentDefinitions.operator3.field_5
                db 4Fh                  ; instrumentDefinitions.operator3.field_6
                db 7                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Mars to'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0D9h                 ; instrumentDefinitions.lfoSpeed
                db 0FDh                 ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F9h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 3                    ; instrumentDefinitions.pmsAm
                db 20h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 1                    ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 48h                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Dh                  ; instrumentDefinitions.operator0.field_5
                db 10h                  ; instrumentDefinitions.operator0.field_6
                db 22h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 30h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 42h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 4                    ; instrumentDefinitions.operator1.field_5
                db 8                    ; instrumentDefinitions.operator1.field_6
                db 0D2h                 ; instrumentDefinitions.operator1.field_7
                db 1Ch                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 1Ch                  ; instrumentDefinitions.operator2.field_4
                db 8                    ; instrumentDefinitions.operator2.field_5
                db 9                    ; instrumentDefinitions.operator2.field_6
                db 0E2h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 10000b               ; instrumentDefinitions.operator3.field_2
                db 42h                  ; instrumentDefinitions.operator3.field_3
                db 53h                  ; instrumentDefinitions.operator3.field_4
                db 89h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0F2h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0Ch                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Storm  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0D2h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0FFh                 ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F3h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 70h                  ; instrumentDefinitions.pmsAm
                db 60h                  ; instrumentDefinitions.lfoWaveForm
                db 0E8h                 ; instrumentDefinitions.transpose
                db 1Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 31h                  ; instrumentDefinitions.operator0.field_3
                db 8                    ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 0C1h                 ; instrumentDefinitions.operator0.field_6
                db 0A3h                 ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 30h                  ; instrumentDefinitions.operator1.field_3
                db 14h                  ; instrumentDefinitions.operator1.field_4
                db 7                    ; instrumentDefinitions.operator1.field_5
                db 41h                  ; instrumentDefinitions.operator1.field_6
                db 0A4h                 ; instrumentDefinitions.operator1.field_7
                db 11h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 76h                  ; instrumentDefinitions.operator2.field_3
                db 0Ah                  ; instrumentDefinitions.operator2.field_4
                db 9                    ; instrumentDefinitions.operator2.field_5
                db 40h                  ; instrumentDefinitions.operator2.field_6
                db 61h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 70h                  ; instrumentDefinitions.operator3.field_3
                db 0Fh                  ; instrumentDefinitions.operator3.field_4
                db 86h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 31h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 5                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Windbel'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0D8h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 2Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 60h                  ; instrumentDefinitions.pmsAm
                db 60h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Ah                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 44h                  ; instrumentDefinitions.operator0.field_3
                db 1Ch                  ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 40h                  ; instrumentDefinitions.operator0.field_6
                db 13h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 51h                  ; instrumentDefinitions.operator1.field_3
                db 4Eh                  ; instrumentDefinitions.operator1.field_4
                db 84h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 52h                  ; instrumentDefinitions.operator1.field_7
                db 3                    ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 1100000b             ; instrumentDefinitions.operator2.field_2
                db 49h                  ; instrumentDefinitions.operator2.field_3
                db 5Ch                  ; instrumentDefinitions.operator2.field_4
                db 7                    ; instrumentDefinitions.operator2.field_5
                db 40h                  ; instrumentDefinitions.operator2.field_6
                db 10h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 45h                  ; instrumentDefinitions.operator3.field_3
                db 4Dh                  ; instrumentDefinitions.operator3.field_4
                db 89h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 32h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 7                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
VoiceDefinitionBankRom2:.ascii 'rom2    '       ; name
                                        ; DATA XREF: getVoiceDefinitionBank:voiceDefinitionBankTable↑o
                db [ 18h ], 0           ; reserved
                .ascii 'UpPiano'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Bh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 21h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 11000000b            ; instrumentDefinitions.operator0.field_2
                db 0E5h                 ; instrumentDefinitions.operator0.field_3
                db 0D3h                 ; instrumentDefinitions.operator0.field_4
                db 2                    ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 34h                  ; instrumentDefinitions.operator0.field_7
                db 16h                  ; instrumentDefinitions.operator1.totalLevel
                db 20h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0A5h                 ; instrumentDefinitions.operator1.field_3
                db 0D3h                 ; instrumentDefinitions.operator1.field_4
                db 2                    ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 34h                  ; instrumentDefinitions.operator1.field_7
                db 0Dh                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0F1h                 ; instrumentDefinitions.operator2.field_3
                db 93h                  ; instrumentDefinitions.operator2.field_4
                db 2                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 34h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 100b                 ; instrumentDefinitions.operator3.field_2
                db 0C1h                 ; instrumentDefinitions.operator3.field_3
                db 0D3h                 ; instrumentDefinitions.operator3.field_4
                db 82h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 34h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SPiano '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 8                    ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1110000b             ; instrumentDefinitions.operator0.field_2
                db 0A1h                 ; instrumentDefinitions.operator0.field_3
                db 9Eh                  ; instrumentDefinitions.operator0.field_4
                db 17h                  ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 34h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 110b                 ; instrumentDefinitions.operator1.field_2
                db 31h                  ; instrumentDefinitions.operator1.field_3
                db 0D3h                 ; instrumentDefinitions.operator1.field_4
                db 82h                  ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 7                    ; instrumentDefinitions.operator1.field_7
                db 0Eh                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 100000b              ; instrumentDefinitions.operator2.field_2
                db 0B0h                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 14h                  ; instrumentDefinitions.operator2.field_5
                db 4Bh                  ; instrumentDefinitions.operator2.field_6
                db 0DFh                 ; instrumentDefinitions.operator2.field_7
                db 9                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 110b                 ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 17h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 1                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Piano2 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ah                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 1Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 30h                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 11h                  ; instrumentDefinitions.operator0.field_5
                db 8Eh                  ; instrumentDefinitions.operator0.field_6
                db 0FAh                 ; instrumentDefinitions.operator0.field_7
                db 19h                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0A3h                 ; instrumentDefinitions.operator1.field_3
                db 55h                  ; instrumentDefinitions.operator1.field_4
                db 2                    ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 34h                  ; instrumentDefinitions.operator1.field_7
                db 0Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0F1h                 ; instrumentDefinitions.operator2.field_3
                db 9Ch                  ; instrumentDefinitions.operator2.field_4
                db 2                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 34h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 11b                  ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 0D5h                 ; instrumentDefinitions.operator3.field_4
                db 0A2h                 ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 34h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Piano3 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Bh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F9h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 2Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 10110000b            ; instrumentDefinitions.operator0.field_2
                db 0F3h                 ; instrumentDefinitions.operator0.field_3
                db 0                    ; instrumentDefinitions.operator0.field_4
                db 5                    ; instrumentDefinitions.operator0.field_5
                db 2                    ; instrumentDefinitions.operator0.field_6
                db 25h                  ; instrumentDefinitions.operator0.field_7
                db 28h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0F3h                 ; instrumentDefinitions.operator1.field_3
                db 18h                  ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 2                    ; instrumentDefinitions.operator1.field_6
                db 25h                  ; instrumentDefinitions.operator1.field_7
                db 0Ah                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 11000000b            ; instrumentDefinitions.operator2.field_2
                db 0B1h                 ; instrumentDefinitions.operator2.field_3
                db 18h                  ; instrumentDefinitions.operator2.field_4
                db 5                    ; instrumentDefinitions.operator2.field_5
                db 2                    ; instrumentDefinitions.operator2.field_6
                db 25h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 100b                 ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 95h                  ; instrumentDefinitions.operator3.field_4
                db 86h                  ; instrumentDefinitions.operator3.field_5
                db 5                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Piano4 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 11h                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 0B3h                 ; instrumentDefinitions.operator0.field_3
                db 98h                  ; instrumentDefinitions.operator0.field_4
                db 18h                  ; instrumentDefinitions.operator0.field_5
                db 3                    ; instrumentDefinitions.operator0.field_6
                db 2Fh                  ; instrumentDefinitions.operator0.field_7
                db 0Ah                  ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0F1h                 ; instrumentDefinitions.operator1.field_3
                db 0D6h                 ; instrumentDefinitions.operator1.field_4
                db 0Bh                  ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 3                    ; instrumentDefinitions.operator1.field_7
                db 15h                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 11100000b            ; instrumentDefinitions.operator2.field_2
                db 0C1h                 ; instrumentDefinitions.operator2.field_3
                db 95h                  ; instrumentDefinitions.operator2.field_4
                db 13h                  ; instrumentDefinitions.operator2.field_5
                db 91h                  ; instrumentDefinitions.operator2.field_6
                db 2                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 0D7h                 ; instrumentDefinitions.operator3.field_4
                db 91h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 13h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Piano5 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 84h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Dh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 21h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 18h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 85h                  ; instrumentDefinitions.operator0.field_3
                db 5Dh                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 5                    ; instrumentDefinitions.operator0.field_6
                db 54h                  ; instrumentDefinitions.operator0.field_7
                db 1Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0A3h                 ; instrumentDefinitions.operator1.field_3
                db 5Dh                  ; instrumentDefinitions.operator1.field_4
                db 7                    ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 45h                  ; instrumentDefinitions.operator1.field_7
                db 15h                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 1010000b             ; instrumentDefinitions.operator2.field_2
                db 0B1h                 ; instrumentDefinitions.operator2.field_3
                db 5Eh                  ; instrumentDefinitions.operator2.field_4
                db 7                    ; instrumentDefinitions.operator2.field_5
                db 6                    ; instrumentDefinitions.operator2.field_6
                db 46h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000000b             ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 5Dh                  ; instrumentDefinitions.operator3.field_4
                db 86h                  ; instrumentDefinitions.operator3.field_5
                db 8                    ; instrumentDefinitions.operator3.field_6
                db 37h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 25h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'PhGrand'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F3h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Eh                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 0B3h                 ; instrumentDefinitions.operator0.field_3
                db 9Dh                  ; instrumentDefinitions.operator0.field_4
                db 17h                  ; instrumentDefinitions.operator0.field_5
                db 2                    ; instrumentDefinitions.operator0.field_6
                db 24h                  ; instrumentDefinitions.operator0.field_7
                db 0Ch                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0F1h                 ; instrumentDefinitions.operator1.field_3
                db 96h                  ; instrumentDefinitions.operator1.field_4
                db 0Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 2                    ; instrumentDefinitions.operator1.field_7
                db 0Eh                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0B1h                 ; instrumentDefinitions.operator2.field_3
                db 95h                  ; instrumentDefinitions.operator2.field_4
                db 3                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 15h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 0D3h                 ; instrumentDefinitions.operator3.field_4
                db 9Dh                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Grand  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 16h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 1110000b             ; instrumentDefinitions.operator0.field_2
                db 0A1h                 ; instrumentDefinitions.operator0.field_3
                db 58h                  ; instrumentDefinitions.operator0.field_4
                db 1                    ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 0F3h                 ; instrumentDefinitions.operator0.field_7
                db 22h                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0F7h                 ; instrumentDefinitions.operator1.field_3
                db 98h                  ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 0F3h                 ; instrumentDefinitions.operator1.field_7
                db 0Ch                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0C1h                 ; instrumentDefinitions.operator2.field_3
                db 56h                  ; instrumentDefinitions.operator2.field_4
                db 1                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 34h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 101b                 ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 94h                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 36h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'DpGrand'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Bh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 18h                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 0A1h                 ; instrumentDefinitions.operator0.field_3
                db 58h                  ; instrumentDefinitions.operator0.field_4
                db 1                    ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 0F3h                 ; instrumentDefinitions.operator0.field_7
                db 22h                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0F7h                 ; instrumentDefinitions.operator1.field_3
                db 58h                  ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 0F3h                 ; instrumentDefinitions.operator1.field_7
                db 6                    ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0C0h                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 1                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 34h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 100b                 ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 94h                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 35h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'LPiano1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 14h                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 0B1h                 ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 3                    ; instrumentDefinitions.operator0.field_6
                db 25h                  ; instrumentDefinitions.operator0.field_7
                db 1Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 30h                  ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0AFh                 ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 4                    ; instrumentDefinitions.operator1.field_6
                db 25h                  ; instrumentDefinitions.operator1.field_7
                db 11h                  ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0D3h                 ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 3                    ; instrumentDefinitions.operator2.field_5
                db 2                    ; instrumentDefinitions.operator2.field_6
                db 15h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 9Dh                  ; instrumentDefinitions.operator3.field_4
                db 9Eh                  ; instrumentDefinitions.operator3.field_5
                db 7                    ; instrumentDefinitions.operator3.field_6
                db 9                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'LPiano2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CAh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Dh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 0Fh                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 11100000b            ; instrumentDefinitions.operator0.field_2
                db 0F1h                 ; instrumentDefinitions.operator0.field_3
                db 19h                  ; instrumentDefinitions.operator0.field_4
                db 2                    ; instrumentDefinitions.operator0.field_5
                db 4                    ; instrumentDefinitions.operator0.field_6
                db 16h                  ; instrumentDefinitions.operator0.field_7
                db 13h                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 10100000b            ; instrumentDefinitions.operator1.field_2
                db 0B7h                 ; instrumentDefinitions.operator1.field_3
                db 15h                  ; instrumentDefinitions.operator1.field_4
                db 0Ah                  ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 24h                  ; instrumentDefinitions.operator1.field_7
                db 11h                  ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0B3h                 ; instrumentDefinitions.operator2.field_3
                db 19h                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 5                    ; instrumentDefinitions.operator2.field_6
                db 0F5h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 101b                 ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 56h                  ; instrumentDefinitions.operator3.field_4
                db 8Fh                  ; instrumentDefinitions.operator3.field_5
                db 4                    ; instrumentDefinitions.operator3.field_6
                db 17h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EGrand2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 19h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 17h                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 0B9h                 ; instrumentDefinitions.operator0.field_3
                db 0DCh                 ; instrumentDefinitions.operator0.field_4
                db 8                    ; instrumentDefinitions.operator0.field_5
                db 86h                  ; instrumentDefinitions.operator0.field_6
                db 53h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 11001000b            ; instrumentDefinitions.operator1.field_2
                db 0C1h                 ; instrumentDefinitions.operator1.field_3
                db 0D9h                 ; instrumentDefinitions.operator1.field_4
                db 88h                  ; instrumentDefinitions.operator1.field_5
                db 1Fh                  ; instrumentDefinitions.operator1.field_6
                db 0F6h                 ; instrumentDefinitions.operator1.field_7
                db 3                    ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0F3h                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 3                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 33h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 94h                  ; instrumentDefinitions.operator3.field_4
                db 83h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 36h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Honkey1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Fh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F0h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 2Dh                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 0F5h                 ; instrumentDefinitions.operator0.field_3
                db 58h                  ; instrumentDefinitions.operator0.field_4
                db 1                    ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 0F3h                 ; instrumentDefinitions.operator0.field_7
                db 22h                  ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 0F5h                 ; instrumentDefinitions.operator1.field_3
                db 58h                  ; instrumentDefinitions.operator1.field_4
                db 1Bh                  ; instrumentDefinitions.operator1.field_5
                db 44h                  ; instrumentDefinitions.operator1.field_6
                db 23h                  ; instrumentDefinitions.operator1.field_7
                db 9                    ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 11000000b            ; instrumentDefinitions.operator2.field_2
                db 0F1h                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 3                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 34h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 110b                 ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 94h                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 35h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Honkey2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F0h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 2Eh                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 0E5h                 ; instrumentDefinitions.operator0.field_3
                db 58h                  ; instrumentDefinitions.operator0.field_4
                db 1                    ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 0F3h                 ; instrumentDefinitions.operator0.field_7
                db 19h                  ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 11110000b            ; instrumentDefinitions.operator1.field_2
                db 0F7h                 ; instrumentDefinitions.operator1.field_3
                db 58h                  ; instrumentDefinitions.operator1.field_4
                db 1                    ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 0F3h                 ; instrumentDefinitions.operator1.field_7
                db 2                    ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0A1h                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 3                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 34h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 101b                 ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 94h                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 35h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Pfbell '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0BFh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 0Ch                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 0B3h                 ; instrumentDefinitions.operator0.field_3
                db 9Bh                  ; instrumentDefinitions.operator0.field_4
                db 4                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0F6h                 ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 87h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0F7h                 ; instrumentDefinitions.operator1.field_7
                db 1Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 1010000b             ; instrumentDefinitions.operator2.field_2
                db 0FEh                 ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 7                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0E4h                 ; instrumentDefinitions.operator2.field_7
                db 4                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 74h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0F7h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'PfVibe '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0BFh                 ; instrumentDefinitions.lfoSpeed
                db 95h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 14h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 31h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 24h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 4Ch                  ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Ch                  ; instrumentDefinitions.operator0.field_5
                db 12h                  ; instrumentDefinitions.operator0.field_6
                db 0F5h                 ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1111b                ; instrumentDefinitions.operator1.field_2
                db 71h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 85h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0F5h                 ; instrumentDefinitions.operator1.field_7
                db 28h                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 47h                  ; instrumentDefinitions.operator2.field_3
                db 5Fh                  ; instrumentDefinitions.operator2.field_4
                db 8                    ; instrumentDefinitions.operator2.field_5
                db 12h                  ; instrumentDefinitions.operator2.field_6
                db 0F6h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1111b                ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 85h                  ; instrumentDefinitions.operator3.field_5
                db 12h                  ; instrumentDefinitions.operator3.field_6
                db 0F6h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 21h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'NewEP2 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C1h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 38h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 3Fh                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Eh                  ; instrumentDefinitions.operator0.field_5
                db 0Fh                  ; instrumentDefinitions.operator0.field_6
                db 6Eh                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 101b                 ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 92h                  ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 18h                  ; instrumentDefinitions.operator1.field_7
                db 0Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0C1h                 ; instrumentDefinitions.operator2.field_3
                db 5Fh                  ; instrumentDefinitions.operator2.field_4
                db 0Fh                  ; instrumentDefinitions.operator2.field_5
                db 5                    ; instrumentDefinitions.operator2.field_6
                db 1Bh                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 110101b              ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 92h                  ; instrumentDefinitions.operator3.field_5
                db 6                    ; instrumentDefinitions.operator3.field_6
                db 18h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 21h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'NewEP3 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 38h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 0B7h                 ; instrumentDefinitions.operator0.field_3
                db 98h                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 0C4h                 ; instrumentDefinitions.operator0.field_6
                db 37h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000101b             ; instrumentDefinitions.operator1.field_2
                db 31h                  ; instrumentDefinitions.operator1.field_3
                db 58h                  ; instrumentDefinitions.operator1.field_4
                db 8Bh                  ; instrumentDefinitions.operator1.field_5
                db 8                    ; instrumentDefinitions.operator1.field_6
                db 26h                  ; instrumentDefinitions.operator1.field_7
                db 7                    ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0B1h                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 24h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1100101b             ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 96h                  ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 3                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'NewEP4 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 82h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 21h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 20h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1100000b             ; instrumentDefinitions.operator0.field_2
                db 0F1h                 ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 4                    ; instrumentDefinitions.operator0.field_5
                db 2                    ; instrumentDefinitions.operator0.field_6
                db 0Fh                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 110000b              ; instrumentDefinitions.operator1.field_2
                db 22h                  ; instrumentDefinitions.operator1.field_3
                db 5Ch                  ; instrumentDefinitions.operator1.field_4
                db 9Fh                  ; instrumentDefinitions.operator1.field_5
                db 5                    ; instrumentDefinitions.operator1.field_6
                db 18h                  ; instrumentDefinitions.operator1.field_7
                db 39h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 1100000b             ; instrumentDefinitions.operator2.field_2
                db 8Ah                  ; instrumentDefinitions.operator2.field_3
                db 9Ah                  ; instrumentDefinitions.operator2.field_4
                db 3                    ; instrumentDefinitions.operator2.field_5
                db 0C3h                 ; instrumentDefinitions.operator2.field_6
                db 36h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000000b             ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 98h                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 6                    ; instrumentDefinitions.operator3.field_6
                db 38h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'NewEP5 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 20h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 24h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 110000b              ; instrumentDefinitions.operator0.field_2
                db 0B7h                 ; instrumentDefinitions.operator0.field_3
                db 9Ah                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 0C4h                 ; instrumentDefinitions.operator0.field_6
                db 37h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1100101b             ; instrumentDefinitions.operator1.field_2
                db 21h                  ; instrumentDefinitions.operator1.field_3
                db 5Ah                  ; instrumentDefinitions.operator1.field_4
                db 8Bh                  ; instrumentDefinitions.operator1.field_5
                db 8                    ; instrumentDefinitions.operator1.field_6
                db 26h                  ; instrumentDefinitions.operator1.field_7
                db 0Ah                  ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0B1h                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 24h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 10010101b            ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 96h                  ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 3                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EPiano1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 3Eh                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 100000b              ; instrumentDefinitions.operator0.field_2
                db 0CCh                 ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 11h                  ; instrumentDefinitions.operator0.field_5
                db 6                    ; instrumentDefinitions.operator0.field_6
                db 99h                  ; instrumentDefinitions.operator0.field_7
                db 2Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 110000b              ; instrumentDefinitions.operator1.field_2
                db 4Ch                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 10h                  ; instrumentDefinitions.operator1.field_5
                db 0C6h                 ; instrumentDefinitions.operator1.field_6
                db 7Fh                  ; instrumentDefinitions.operator1.field_7
                db 23h                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 1100000b             ; instrumentDefinitions.operator2.field_2
                db 0C1h                 ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 0Eh                  ; instrumentDefinitions.operator2.field_5
                db 5                    ; instrumentDefinitions.operator2.field_6
                db 65h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 110000b              ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 9Fh                  ; instrumentDefinitions.operator3.field_4
                db 9Ch                  ; instrumentDefinitions.operator3.field_5
                db 4                    ; instrumentDefinitions.operator3.field_6
                db 8                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EPiano2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0B9h                 ; instrumentDefinitions.lfoSpeed
                db 99h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 9                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E6h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 21h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 1Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 0F0h                 ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 3Eh                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Ch                  ; instrumentDefinitions.operator0.field_5
                db 0C0h                 ; instrumentDefinitions.operator0.field_6
                db 0BAh                 ; instrumentDefinitions.operator0.field_7
                db 11h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 53h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 8Ch                  ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 88h                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 2                    ; instrumentDefinitions.operator2.field_3
                db 57h                  ; instrumentDefinitions.operator2.field_4
                db 8Fh                  ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 7Fh                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0C0h                 ; instrumentDefinitions.operator3.field_1
                db 100000b              ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 5Eh                  ; instrumentDefinitions.operator3.field_4
                db 85h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 37h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EPiano3'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 88h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0Ah                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 21h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 1Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 3Fh                  ; instrumentDefinitions.operator0.field_3
                db 96h                  ; instrumentDefinitions.operator0.field_4
                db 1Ch                  ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 0A7h                 ; instrumentDefinitions.operator0.field_7
                db 11h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 33h                  ; instrumentDefinitions.operator1.field_3
                db 0D9h                 ; instrumentDefinitions.operator1.field_4
                db 86h                  ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 27h                  ; instrumentDefinitions.operator1.field_7
                db 11h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 97h                  ; instrumentDefinitions.operator2.field_4
                db 12h                  ; instrumentDefinitions.operator2.field_5
                db 0C1h                 ; instrumentDefinitions.operator2.field_6
                db 0E7h                 ; instrumentDefinitions.operator2.field_7
                db 7                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 0D9h                 ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 17h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EPiano4'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C0h                 ; instrumentDefinitions.lfoSpeed
                db 0ADh                 ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 12h                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 40h                  ; instrumentDefinitions.operator0.field_3
                db 9Ch                  ; instrumentDefinitions.operator0.field_4
                db 13h                  ; instrumentDefinitions.operator0.field_5
                db 8Dh                  ; instrumentDefinitions.operator0.field_6
                db 34h                  ; instrumentDefinitions.operator0.field_7
                db 1Fh                  ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 72h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 4                    ; instrumentDefinitions.operator1.field_7
                db 1Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 31h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 5                    ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 51h                  ; instrumentDefinitions.operator3.field_3
                db 9Fh                  ; instrumentDefinitions.operator3.field_4
                db 89h                  ; instrumentDefinitions.operator3.field_5
                db 2                    ; instrumentDefinitions.operator3.field_6
                db 16h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 21h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EPiano5'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C8h                 ; instrumentDefinitions.lfoSpeed
                db 0A8h                 ; instrumentDefinitions.amplitudeModulationDepth
                db 23h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0DBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 31h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 25h                  ; instrumentDefinitions.operator0.totalLevel
                db 50h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 8                    ; instrumentDefinitions.operator0.field_3
                db 0D6h                 ; instrumentDefinitions.operator0.field_4
                db 11h                  ; instrumentDefinitions.operator0.field_5
                db 45h                  ; instrumentDefinitions.operator0.field_6
                db 0AFh                 ; instrumentDefinitions.operator0.field_7
                db 2Ah                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 1010000b             ; instrumentDefinitions.operator1.field_2
                db 4                    ; instrumentDefinitions.operator1.field_3
                db 0D9h                 ; instrumentDefinitions.operator1.field_4
                db 6                    ; instrumentDefinitions.operator1.field_5
                db 2                    ; instrumentDefinitions.operator1.field_6
                db 0AFh                 ; instrumentDefinitions.operator1.field_7
                db 11h                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 2                    ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 0Ch                  ; instrumentDefinitions.operator2.field_5
                db 2                    ; instrumentDefinitions.operator2.field_6
                db 0A5h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 30h                  ; instrumentDefinitions.operator3.field_1
                db 1000000b             ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 9Fh                  ; instrumentDefinitions.operator3.field_4
                db 86h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 36h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'HighTin'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0BBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 8                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 2Ch                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 1100000b             ; instrumentDefinitions.operator0.field_2
                db 0CBh                 ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Bh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0F6h                 ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 100b                 ; instrumentDefinitions.operator1.field_2
                db 71h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 89h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0FFh                 ; instrumentDefinitions.operator1.field_7
                db 13h                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 10000b               ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 8                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0F7h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 100b                 ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 15h                  ; instrumentDefinitions.operator3.field_6
                db 0F8h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 21h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'HardTin'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C0h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 14h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Dh                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 10000b               ; instrumentDefinitions.operator0.field_2
                db 40h                  ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 12h                  ; instrumentDefinitions.operator0.field_5
                db 0C0h                 ; instrumentDefinitions.operator0.field_6
                db 0F6h                 ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 100b                 ; instrumentDefinitions.operator1.field_2
                db 71h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 91h                  ; instrumentDefinitions.operator1.field_5
                db 0C0h                 ; instrumentDefinitions.operator1.field_6
                db 0FFh                 ; instrumentDefinitions.operator1.field_7
                db 4                    ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 11000000b            ; instrumentDefinitions.operator2.field_2
                db 0C1h                 ; instrumentDefinitions.operator2.field_3
                db 5Fh                  ; instrumentDefinitions.operator2.field_4
                db 8                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0F7h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1010100b             ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 15h                  ; instrumentDefinitions.operator3.field_6
                db 0E8h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 21h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'PercPf '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0BBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 0Ch                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 11110000b            ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Dh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0Ch                  ; instrumentDefinitions.operator0.field_7
                db 23h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 4Dh                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Bh                  ; instrumentDefinitions.operator1.field_5
                db 50h                  ; instrumentDefinitions.operator1.field_6
                db 26h                  ; instrumentDefinitions.operator1.field_7
                db 31h                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 1100000b             ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 5Ah                  ; instrumentDefinitions.operator2.field_4
                db 12h                  ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 35h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 5Dh                  ; instrumentDefinitions.operator3.field_4
                db 91h                  ; instrumentDefinitions.operator3.field_5
                db 7                    ; instrumentDefinitions.operator3.field_6
                db 18h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 21h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'WoodPf '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C3h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 10h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 15h                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Ch                  ; instrumentDefinitions.operator0.field_5
                db 7                    ; instrumentDefinitions.operator0.field_6
                db 0C8h                 ; instrumentDefinitions.operator0.field_7
                db 1                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1111b                ; instrumentDefinitions.operator1.field_2
                db 70h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 89h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0F8h                 ; instrumentDefinitions.operator1.field_7
                db 18h                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 5Fh                  ; instrumentDefinitions.operator2.field_4
                db 5                    ; instrumentDefinitions.operator2.field_5
                db 7                    ; instrumentDefinitions.operator2.field_6
                db 8                    ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1111b                ; instrumentDefinitions.operator3.field_2
                db 40h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 89h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0F8h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 21h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EPStrng'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C9h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 3Fh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Ch                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 31h                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 6Ah                  ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 12h                  ; instrumentDefinitions.operator0.field_7
                db 9                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 71h                  ; instrumentDefinitions.operator1.field_3
                db 84h                  ; instrumentDefinitions.operator1.field_4
                db 0E1h                 ; instrumentDefinitions.operator1.field_5
                db 2                    ; instrumentDefinitions.operator1.field_6
                db 23h                  ; instrumentDefinitions.operator1.field_7
                db 23h                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 11110000b            ; instrumentDefinitions.operator2.field_2
                db 0BEh                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 0Ch                  ; instrumentDefinitions.operator2.field_5
                db 8                    ; instrumentDefinitions.operator2.field_6
                db 44h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 96h                  ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'EPBrass'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 15h                  ; instrumentDefinitions.operator0.totalLevel
                db 50h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 31h                  ; instrumentDefinitions.operator0.field_3
                db 48h                  ; instrumentDefinitions.operator0.field_4
                db 63h                  ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 27h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1010b                ; instrumentDefinitions.operator1.field_2
                db 71h                  ; instrumentDefinitions.operator1.field_3
                db 8Dh                  ; instrumentDefinitions.operator1.field_4
                db 0E1h                 ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 25h                  ; instrumentDefinitions.operator1.field_7
                db 22h                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 1110000b             ; instrumentDefinitions.operator2.field_2
                db 0BEh                 ; instrumentDefinitions.operator2.field_3
                db 96h                  ; instrumentDefinitions.operator2.field_4
                db 0Ch                  ; instrumentDefinitions.operator2.field_5
                db 8                    ; instrumentDefinitions.operator2.field_6
                db 44h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1011b                ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 96h                  ; instrumentDefinitions.operator3.field_4
                db 84h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Clav2  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Dh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 14h                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 10000b               ; instrumentDefinitions.operator0.field_2
                db 43h                  ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 34h                  ; instrumentDefinitions.operator0.field_7
                db 2Ah                  ; instrumentDefinitions.operator1.totalLevel
                db 20h                  ; instrumentDefinitions.operator1.field_1
                db 10000b               ; instrumentDefinitions.operator1.field_2
                db 49h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 9                    ; instrumentDefinitions.operator1.field_5
                db 4                    ; instrumentDefinitions.operator1.field_6
                db 24h                  ; instrumentDefinitions.operator1.field_7
                db 0Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 40h                  ; instrumentDefinitions.operator2.field_3
                db 5Fh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 5                    ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 110b                 ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 58h                  ; instrumentDefinitions.operator3.field_4
                db 90h                  ; instrumentDefinitions.operator3.field_5
                db 9                    ; instrumentDefinitions.operator3.field_6
                db 0Bh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Clav3  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 20h                  ; instrumentDefinitions.operator0.field_3
                db 9Eh                  ; instrumentDefinitions.operator0.field_4
                db 1Ch                  ; instrumentDefinitions.operator0.field_5
                db 5                    ; instrumentDefinitions.operator0.field_6
                db 30h                  ; instrumentDefinitions.operator0.field_7
                db 1Eh                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 1110000b             ; instrumentDefinitions.operator1.field_2
                db 16h                  ; instrumentDefinitions.operator1.field_3
                db 5Dh                  ; instrumentDefinitions.operator1.field_4
                db 1                    ; instrumentDefinitions.operator1.field_5
                db 0C1h                 ; instrumentDefinitions.operator1.field_6
                db 0F0h                 ; instrumentDefinitions.operator1.field_7
                db 0Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 10000b               ; instrumentDefinitions.operator2.field_2
                db 10h                  ; instrumentDefinitions.operator2.field_3
                db 17h                  ; instrumentDefinitions.operator2.field_4
                db 1Ah                  ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 20h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 42h                  ; instrumentDefinitions.operator3.field_3
                db 98h                  ; instrumentDefinitions.operator3.field_4
                db 9Bh                  ; instrumentDefinitions.operator3.field_5
                db 5                    ; instrumentDefinitions.operator3.field_6
                db 37h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Clav4  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F0h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 18h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 100000b              ; instrumentDefinitions.operator0.field_2
                db 46h                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Bh                  ; instrumentDefinitions.operator0.field_5
                db 8                    ; instrumentDefinitions.operator0.field_6
                db 6Fh                  ; instrumentDefinitions.operator0.field_7
                db 1Eh                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 11100000b            ; instrumentDefinitions.operator1.field_2
                db 45h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 10h                  ; instrumentDefinitions.operator1.field_5
                db 5                    ; instrumentDefinitions.operator1.field_6
                db 6                    ; instrumentDefinitions.operator1.field_7
                db 0Dh                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 40h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 0Ch                  ; instrumentDefinitions.operator2.field_5
                db 8                    ; instrumentDefinitions.operator2.field_6
                db 5                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 5Ch                  ; instrumentDefinitions.operator3.field_4
                db 94h                  ; instrumentDefinitions.operator3.field_5
                db 8                    ; instrumentDefinitions.operator3.field_6
                db 1Ch                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'FuzzClv'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Fh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0DBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Dh                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 100000b              ; instrumentDefinitions.operator0.field_2
                db 2Eh                  ; instrumentDefinitions.operator0.field_3
                db 9Eh                  ; instrumentDefinitions.operator0.field_4
                db 1Ch                  ; instrumentDefinitions.operator0.field_5
                db 5                    ; instrumentDefinitions.operator0.field_6
                db 39h                  ; instrumentDefinitions.operator0.field_7
                db 1Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1100000b             ; instrumentDefinitions.operator1.field_2
                db 1Ah                  ; instrumentDefinitions.operator1.field_3
                db 9Dh                  ; instrumentDefinitions.operator1.field_4
                db 1                    ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 0FCh                 ; instrumentDefinitions.operator1.field_7
                db 2                    ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 10000b               ; instrumentDefinitions.operator2.field_2
                db 60h                  ; instrumentDefinitions.operator2.field_3
                db 1Eh                  ; instrumentDefinitions.operator2.field_4
                db 1Bh                  ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 29h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 43h                  ; instrumentDefinitions.operator3.field_3
                db 9Eh                  ; instrumentDefinitions.operator3.field_4
                db 9Ch                  ; instrumentDefinitions.operator3.field_5
                db 5                    ; instrumentDefinitions.operator3.field_6
                db 39h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'MuteClv'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 20h                  ; instrumentDefinitions.operator0.field_3
                db 9Eh                  ; instrumentDefinitions.operator0.field_4
                db 1Ch                  ; instrumentDefinitions.operator0.field_5
                db 0Ah                  ; instrumentDefinitions.operator0.field_6
                db 30h                  ; instrumentDefinitions.operator0.field_7
                db 1Eh                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1110000b             ; instrumentDefinitions.operator1.field_2
                db 36h                  ; instrumentDefinitions.operator1.field_3
                db 9Dh                  ; instrumentDefinitions.operator1.field_4
                db 1                    ; instrumentDefinitions.operator1.field_5
                db 0CBh                 ; instrumentDefinitions.operator1.field_6
                db 0F0h                 ; instrumentDefinitions.operator1.field_7
                db 0Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 10000b               ; instrumentDefinitions.operator2.field_2
                db 10h                  ; instrumentDefinitions.operator2.field_3
                db 17h                  ; instrumentDefinitions.operator2.field_4
                db 1Ah                  ; instrumentDefinitions.operator2.field_5
                db 0Fh                  ; instrumentDefinitions.operator2.field_6
                db 20h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 42h                  ; instrumentDefinitions.operator3.field_3
                db 58h                  ; instrumentDefinitions.operator3.field_4
                db 93h                  ; instrumentDefinitions.operator3.field_5
                db 0Fh                  ; instrumentDefinitions.operator3.field_6
                db 37h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'MuteCl2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 20h                  ; instrumentDefinitions.operator0.field_3
                db 9Eh                  ; instrumentDefinitions.operator0.field_4
                db 15h                  ; instrumentDefinitions.operator0.field_5
                db 0Ah                  ; instrumentDefinitions.operator0.field_6
                db 0F0h                 ; instrumentDefinitions.operator0.field_7
                db 1Eh                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1110000b             ; instrumentDefinitions.operator1.field_2
                db 3Fh                  ; instrumentDefinitions.operator1.field_3
                db 9Dh                  ; instrumentDefinitions.operator1.field_4
                db 1                    ; instrumentDefinitions.operator1.field_5
                db 0Bh                  ; instrumentDefinitions.operator1.field_6
                db 0F0h                 ; instrumentDefinitions.operator1.field_7
                db 0Fh                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 10000b               ; instrumentDefinitions.operator2.field_2
                db 10h                  ; instrumentDefinitions.operator2.field_3
                db 17h                  ; instrumentDefinitions.operator2.field_4
                db 9                    ; instrumentDefinitions.operator2.field_5
                db 0Fh                  ; instrumentDefinitions.operator2.field_6
                db 0F1h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 42h                  ; instrumentDefinitions.operator3.field_3
                db 58h                  ; instrumentDefinitions.operator3.field_4
                db 8Dh                  ; instrumentDefinitions.operator3.field_5
                db 0Fh                  ; instrumentDefinitions.operator3.field_6
                db 0FAh                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 2                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SynClv1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 82h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E0h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 31h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 5                    ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 30h                  ; instrumentDefinitions.operator0.field_3
                db 47h                  ; instrumentDefinitions.operator0.field_4
                db 9                    ; instrumentDefinitions.operator0.field_5
                db 5                    ; instrumentDefinitions.operator0.field_6
                db 27h                  ; instrumentDefinitions.operator0.field_7
                db 11h                  ; instrumentDefinitions.operator1.totalLevel
                db 30h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 35h                  ; instrumentDefinitions.operator1.field_3
                db 0DDh                 ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 4                    ; instrumentDefinitions.operator1.field_6
                db 14h                  ; instrumentDefinitions.operator1.field_7
                db 17h                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 9Ch                  ; instrumentDefinitions.operator2.field_4
                db 6                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 36h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0E0h                 ; instrumentDefinitions.operator3.field_1
                db 100000b              ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 5Fh                  ; instrumentDefinitions.operator3.field_4
                db 94h                  ; instrumentDefinitions.operator3.field_5
                db 3                    ; instrumentDefinitions.operator3.field_6
                db 1Fh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SynClv2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 22h                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 3Ch                  ; instrumentDefinitions.operator0.field_3
                db 0DFh                 ; instrumentDefinitions.operator0.field_4
                db 4                    ; instrumentDefinitions.operator0.field_5
                db 4                    ; instrumentDefinitions.operator0.field_6
                db 0F7h                 ; instrumentDefinitions.operator0.field_7
                db 19h                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 39h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 4                    ; instrumentDefinitions.operator1.field_6
                db 7                    ; instrumentDefinitions.operator1.field_7
                db 8                    ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 4                    ; instrumentDefinitions.operator2.field_6
                db 17h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 110000b              ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 0DFh                 ; instrumentDefinitions.operator3.field_4
                db 8Fh                  ; instrumentDefinitions.operator3.field_5
                db 2                    ; instrumentDefinitions.operator3.field_6
                db 4Ch                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SynClv3'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0EAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 10100000b            ; instrumentDefinitions.operator0.field_2
                db 81h                  ; instrumentDefinitions.operator0.field_3
                db 47h                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 4                    ; instrumentDefinitions.operator0.field_6
                db 7Ah                  ; instrumentDefinitions.operator0.field_7
                db 11h                  ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 1010000b             ; instrumentDefinitions.operator1.field_2
                db 1Fh                  ; instrumentDefinitions.operator1.field_3
                db 0DFh                 ; instrumentDefinitions.operator1.field_4
                db 14h                  ; instrumentDefinitions.operator1.field_5
                db 4                    ; instrumentDefinitions.operator1.field_6
                db 56h                  ; instrumentDefinitions.operator1.field_7
                db 14h                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 40h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 0Ch                  ; instrumentDefinitions.operator2.field_5
                db 4                    ; instrumentDefinitions.operator2.field_6
                db 6                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 100b                 ; instrumentDefinitions.operator3.field_2
                db 53h                  ; instrumentDefinitions.operator3.field_3
                db 9Fh                  ; instrumentDefinitions.operator3.field_4
                db 85h                  ; instrumentDefinitions.operator3.field_5
                db 2                    ; instrumentDefinitions.operator3.field_6
                db 2Ch                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SynClv4'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 7                    ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 0                    ; instrumentDefinitions.operator0.field_3
                db 14h                  ; instrumentDefinitions.operator0.field_4
                db 2                    ; instrumentDefinitions.operator0.field_5
                db 1                    ; instrumentDefinitions.operator0.field_6
                db 3Ah                  ; instrumentDefinitions.operator0.field_7
                db 11h                  ; instrumentDefinitions.operator1.totalLevel
                db 20h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 1                    ; instrumentDefinitions.operator1.field_3
                db 14h                  ; instrumentDefinitions.operator1.field_4
                db 2                    ; instrumentDefinitions.operator1.field_5
                db 1                    ; instrumentDefinitions.operator1.field_6
                db 3Ah                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 2                    ; instrumentDefinitions.operator2.field_3
                db 14h                  ; instrumentDefinitions.operator2.field_4
                db 2                    ; instrumentDefinitions.operator2.field_5
                db 1                    ; instrumentDefinitions.operator2.field_6
                db 3Ah                  ; instrumentDefinitions.operator2.field_7
                db 11h                  ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 14h                  ; instrumentDefinitions.operator3.field_4
                db 82h                  ; instrumentDefinitions.operator3.field_5
                db 1                    ; instrumentDefinitions.operator3.field_6
                db 3Ah                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Harpsi2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0CCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0Ch                  ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 12h                  ; instrumentDefinitions.operator0.field_3
                db 0DDh                 ; instrumentDefinitions.operator0.field_4
                db 11h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 20h                  ; instrumentDefinitions.operator0.field_7
                db 4                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 60h                  ; instrumentDefinitions.operator1.field_3
                db 97h                  ; instrumentDefinitions.operator1.field_4
                db 88h                  ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 36h                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 10h                  ; instrumentDefinitions.operator2.field_3
                db 0DDh                 ; instrumentDefinitions.operator2.field_4
                db 0Eh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 20h                  ; instrumentDefinitions.operator2.field_7
                db 2                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 54h                  ; instrumentDefinitions.operator3.field_3
                db 97h                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 6                    ; instrumentDefinitions.operator3.field_6
                db 36h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 0                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Harpsi3'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 20h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 13h                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 1                    ; instrumentDefinitions.operator0.field_3
                db 0DFh                 ; instrumentDefinitions.operator0.field_4
                db 1Dh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 2Ah                  ; instrumentDefinitions.operator0.field_7
                db 0Dh                  ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 1110000b             ; instrumentDefinitions.operator1.field_2
                db 48h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 5                    ; instrumentDefinitions.operator1.field_6
                db 2Ah                  ; instrumentDefinitions.operator1.field_7
                db 7                    ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 71h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 19h                  ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 24h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 30h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 44h                  ; instrumentDefinitions.operator3.field_3
                db 0DDh                 ; instrumentDefinitions.operator3.field_4
                db 9Ah                  ; instrumentDefinitions.operator3.field_5
                db 3                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Harpsi4'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0DCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0                    ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 63h                  ; instrumentDefinitions.operator0.field_3
                db 9Ah                  ; instrumentDefinitions.operator0.field_4
                db 13h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 20h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 31h                  ; instrumentDefinitions.operator1.field_3
                db 97h                  ; instrumentDefinitions.operator1.field_4
                db 88h                  ; instrumentDefinitions.operator1.field_5
                db 6                    ; instrumentDefinitions.operator1.field_6
                db 35h                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 20h                  ; instrumentDefinitions.operator2.field_3
                db 0CFh                 ; instrumentDefinitions.operator2.field_4
                db 10h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 20h                  ; instrumentDefinitions.operator2.field_7
                db 5                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 14h                  ; instrumentDefinitions.operator3.field_3
                db 97h                  ; instrumentDefinitions.operator3.field_4
                db 88h                  ; instrumentDefinitions.operator3.field_5
                db 6                    ; instrumentDefinitions.operator3.field_6
                db 35h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Harpsi5'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Eh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0E2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 0                    ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 1Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 10100000b            ; instrumentDefinitions.operator0.field_2
                db 0                    ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 4                    ; instrumentDefinitions.operator0.field_6
                db 16h                  ; instrumentDefinitions.operator0.field_7
                db 7                    ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 1010000b             ; instrumentDefinitions.operator1.field_2
                db 19h                  ; instrumentDefinitions.operator1.field_3
                db 0DFh                 ; instrumentDefinitions.operator1.field_4
                db 18h                  ; instrumentDefinitions.operator1.field_5
                db 3                    ; instrumentDefinitions.operator1.field_6
                db 26h                  ; instrumentDefinitions.operator1.field_7
                db 15h                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 43h                  ; instrumentDefinitions.operator2.field_3
                db 5Fh                  ; instrumentDefinitions.operator2.field_4
                db 18h                  ; instrumentDefinitions.operator2.field_5
                db 3                    ; instrumentDefinitions.operator2.field_6
                db 18h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 20h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 51h                  ; instrumentDefinitions.operator3.field_3
                db 9Fh                  ; instrumentDefinitions.operator3.field_4
                db 85h                  ; instrumentDefinitions.operator3.field_5
                db 7                    ; instrumentDefinitions.operator3.field_6
                db 25h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 4                    ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Circust'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 50h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 9                    ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 45h                  ; instrumentDefinitions.operator0.field_3
                db 1Dh                  ; instrumentDefinitions.operator0.field_4
                db 16h                  ; instrumentDefinitions.operator0.field_5
                db 0CCh                 ; instrumentDefinitions.operator0.field_6
                db 0F6h                 ; instrumentDefinitions.operator0.field_7
                db 7                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 101000b              ; instrumentDefinitions.operator1.field_2
                db 48h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 8Dh                  ; instrumentDefinitions.operator1.field_5
                db 10h                  ; instrumentDefinitions.operator1.field_6
                db 0F4h                 ; instrumentDefinitions.operator1.field_7
                db 3Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 42h                  ; instrumentDefinitions.operator2.field_3
                db 1Ch                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0Fh                  ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 10h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Bh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 27h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Celeste'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CAh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0C4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0Ch                  ; instrumentDefinitions.transpose
                db 16h                  ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 71h                  ; instrumentDefinitions.operator0.field_3
                db 59h                  ; instrumentDefinitions.operator0.field_4
                db 1Ch                  ; instrumentDefinitions.operator0.field_5
                db 0C0h                 ; instrumentDefinitions.operator0.field_6
                db 0E6h                 ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 31h                  ; instrumentDefinitions.operator1.field_3
                db 5Fh                  ; instrumentDefinitions.operator1.field_4
                db 8Ah                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0E6h                 ; instrumentDefinitions.operator1.field_7
                db 27h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 37h                  ; instrumentDefinitions.operator2.field_3
                db 5Fh                  ; instrumentDefinitions.operator2.field_4
                db 10h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0E6h                 ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 8Dh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0E4h                 ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 20h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Squeeze'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 9                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F9h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 50h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 17h                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 10000b               ; instrumentDefinitions.operator0.field_2
                db 73h                  ; instrumentDefinitions.operator0.field_3
                db 10h                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 15h                  ; instrumentDefinitions.operator0.field_7
                db 1Eh                  ; instrumentDefinitions.operator1.totalLevel
                db 40h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 32h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Bh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0Ah                  ; instrumentDefinitions.operator1.field_7
                db 1Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 74h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 5                    ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 110b                 ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 0Eh                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Ah                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
VoiceDefinitionBankRom3:.ascii 'rom3    '       ; name
                                        ; DATA XREF: getVoiceDefinitionBank:voiceDefinitionBankTable↑o
                db [ 18h ], 0           ; reserved
                .ascii 'Horn2  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CAh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0Ch                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 16h                  ; instrumentDefinitions.operator0.totalLevel
                db 50h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 4Eh                  ; instrumentDefinitions.operator0.field_4
                db 9                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 18h                  ; instrumentDefinitions.operator0.field_7
                db 3Fh                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 42h                  ; instrumentDefinitions.operator1.field_3
                db 0Fh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 80h                  ; instrumentDefinitions.operator1.field_6
                db 0Fh                  ; instrumentDefinitions.operator1.field_7
                db 23h                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 0Eh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 8                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 52h                  ; instrumentDefinitions.operator3.field_4
                db 0BFh                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 9                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Horn3  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 10h                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 1                    ; instrumentDefinitions.operator0.field_3
                db 0Dh                  ; instrumentDefinitions.operator0.field_4
                db 28h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 38h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 0D0h                 ; instrumentDefinitions.operator1.field_1
                db 100001b              ; instrumentDefinitions.operator1.field_2
                db 1                    ; instrumentDefinitions.operator1.field_3
                db 10h                  ; instrumentDefinitions.operator1.field_4
                db 0A2h                 ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 18h                  ; instrumentDefinitions.operator1.field_7
                db 16h                  ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 1                    ; instrumentDefinitions.operator2.field_3
                db 10h                  ; instrumentDefinitions.operator2.field_4
                db 28h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 38h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0D0h                 ; instrumentDefinitions.operator3.field_1
                db 100001b              ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 10h                  ; instrumentDefinitions.operator3.field_4
                db 0A5h                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 28h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Horns  '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FDh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 15h                  ; instrumentDefinitions.operator0.totalLevel
                db 40h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 0Dh                  ; instrumentDefinitions.operator0.field_4
                db 1Fh                  ; instrumentDefinitions.operator0.field_5
                db 0Bh                  ; instrumentDefinitions.operator0.field_6
                db 7                    ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1100b                ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 10h                  ; instrumentDefinitions.operator1.field_4
                db 0BFh                 ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 9                    ; instrumentDefinitions.operator1.field_7
                db 13h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 1100b                ; instrumentDefinitions.operator2.field_2
                db 31h                  ; instrumentDefinitions.operator2.field_3
                db 0Eh                  ; instrumentDefinitions.operator2.field_4
                db 9Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 8                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1100b                ; instrumentDefinitions.operator3.field_2
                db 31h                  ; instrumentDefinitions.operator3.field_3
                db 0Fh                  ; instrumentDefinitions.operator3.field_4
                db 0BFh                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 8                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Flugelh'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 14h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 19h                  ; instrumentDefinitions.operator0.totalLevel
                db 60h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 4Ch                  ; instrumentDefinitions.operator0.field_4
                db 5                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0F8h                 ; instrumentDefinitions.operator0.field_7
                db 1Fh                  ; instrumentDefinitions.operator1.totalLevel
                db 50h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 42h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Fh                  ; instrumentDefinitions.operator1.field_5
                db 80h                  ; instrumentDefinitions.operator1.field_6
                db 0F8h                 ; instrumentDefinitions.operator1.field_7
                db 29h                  ; instrumentDefinitions.operator2.totalLevel
                db 70h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 0Fh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 8                    ; instrumentDefinitions.operator2.field_7
                db 6                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 11h                  ; instrumentDefinitions.operator3.field_3
                db 50h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 9                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Trombon'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 19h                  ; instrumentDefinitions.operator0.totalLevel
                db 60h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 0Fh                  ; instrumentDefinitions.operator0.field_4
                db 1Fh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 8                    ; instrumentDefinitions.operator0.field_7
                db 9                    ; instrumentDefinitions.operator1.totalLevel
                db 20h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 42h                  ; instrumentDefinitions.operator1.field_3
                db 9Fh                  ; instrumentDefinitions.operator1.field_4
                db 0Eh                  ; instrumentDefinitions.operator1.field_5
                db 80h                  ; instrumentDefinitions.operator1.field_6
                db 0F8h                 ; instrumentDefinitions.operator1.field_7
                db 2Dh                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 0Fh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 8                    ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 11h                  ; instrumentDefinitions.operator3.field_3
                db 13h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 8                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Trumpt2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 14h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 16h                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 50h                  ; instrumentDefinitions.operator0.field_4
                db 1Fh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 8                    ; instrumentDefinitions.operator0.field_7
                db 3Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 20h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 42h                  ; instrumentDefinitions.operator1.field_3
                db 10h                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 80h                  ; instrumentDefinitions.operator1.field_6
                db 8                    ; instrumentDefinitions.operator1.field_7
                db 23h                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 0Eh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 8                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 40h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 52h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 9                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Brass2 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 1Bh                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FDh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 12h                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 0Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Ah                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 25h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 60h                  ; instrumentDefinitions.operator1.field_1
                db 1100b                ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 15h                  ; instrumentDefinitions.operator1.field_4
                db 9Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0Ah                  ; instrumentDefinitions.operator1.field_7
                db 0                    ; instrumentDefinitions.operator2.totalLevel
                db 60h                  ; instrumentDefinitions.operator2.field_1
                db 1100b                ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 15h                  ; instrumentDefinitions.operator2.field_4
                db 9Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0Ah                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 1100b                ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 15h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Ah                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'Brass3 '        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F4h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 30h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 110000b              ; instrumentDefinitions.operator0.field_2
                db 30h                  ; instrumentDefinitions.operator0.field_3
                db 0Ch                  ; instrumentDefinitions.operator0.field_4
                db 27h                  ; instrumentDefinitions.operator0.field_5
                db 3                    ; instrumentDefinitions.operator0.field_6
                db 5                    ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 60h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 70h                  ; instrumentDefinitions.operator1.field_3
                db 57h                  ; instrumentDefinitions.operator1.field_4
                db 0ADh                 ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 5                    ; instrumentDefinitions.operator1.field_7
                db 4                    ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 1010000b             ; instrumentDefinitions.operator2.field_2
                db 30h                  ; instrumentDefinitions.operator2.field_3
                db 0Eh                  ; instrumentDefinitions.operator2.field_4
                db 27h                  ; instrumentDefinitions.operator2.field_5
                db 2                    ; instrumentDefinitions.operator2.field_6
                db 16h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 70h                  ; instrumentDefinitions.operator3.field_3
                db 56h                  ; instrumentDefinitions.operator3.field_4
                db 0ADh                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'HardBr1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 11h                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 1000000b             ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 10h                  ; instrumentDefinitions.operator0.field_4
                db 1Fh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 0Ah                  ; instrumentDefinitions.operator0.field_7
                db 27h                  ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 0Fh                  ; instrumentDefinitions.operator1.field_7
                db 21h                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0Fh                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 19h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Ah                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 27h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'HardBr2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 99h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FDh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 0Bh                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 1010000b             ; instrumentDefinitions.operator0.field_2
                db 1                    ; instrumentDefinitions.operator0.field_3
                db 50h                  ; instrumentDefinitions.operator0.field_4
                db 0Fh                  ; instrumentDefinitions.operator0.field_5
                db 4                    ; instrumentDefinitions.operator0.field_6
                db 17h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 1010000b             ; instrumentDefinitions.operator1.field_2
                db 1                    ; instrumentDefinitions.operator1.field_3
                db 52h                  ; instrumentDefinitions.operator1.field_4
                db 82h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 9                    ; instrumentDefinitions.operator1.field_7
                db 7                    ; instrumentDefinitions.operator2.totalLevel
                db 0                    ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 3                    ; instrumentDefinitions.operator2.field_3
                db 58h                  ; instrumentDefinitions.operator2.field_4
                db 82h                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 19h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 0                    ; instrumentDefinitions.operator3.field_1
                db 1000001b             ; instrumentDefinitions.operator3.field_2
                db 1                    ; instrumentDefinitions.operator3.field_3
                db 59h                  ; instrumentDefinitions.operator3.field_4
                db 82h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 19h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 27h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'HardBr3'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CAh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 29h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F8h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 1Dh                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 33h                  ; instrumentDefinitions.operator0.field_3
                db 10h                  ; instrumentDefinitions.operator0.field_4
                db 0Fh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 33h                  ; instrumentDefinitions.operator0.field_7
                db 1Ah                  ; instrumentDefinitions.operator1.totalLevel
                db 30h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 13h                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 5                    ; instrumentDefinitions.operator1.field_7
                db 14h                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 1Ah                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 3                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 1Bh                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Bh                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 27h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'HardBr4'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F2h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 0Eh                  ; instrumentDefinitions.operator0.totalLevel
                db 30h                  ; instrumentDefinitions.operator0.field_1
                db 10000b               ; instrumentDefinitions.operator0.field_2
                db 31h                  ; instrumentDefinitions.operator0.field_3
                db 11h                  ; instrumentDefinitions.operator0.field_4
                db 5                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 15h                  ; instrumentDefinitions.operator0.field_7
                db 0Bh                  ; instrumentDefinitions.operator1.totalLevel
                db 30h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 31h                  ; instrumentDefinitions.operator1.field_3
                db 14h                  ; instrumentDefinitions.operator1.field_4
                db 0Bh                  ; instrumentDefinitions.operator1.field_5
                db 0Fh                  ; instrumentDefinitions.operator1.field_6
                db 0Ah                  ; instrumentDefinitions.operator1.field_7
                db 24h                  ; instrumentDefinitions.operator2.totalLevel
                db 30h                  ; instrumentDefinitions.operator2.field_1
                db 0                    ; instrumentDefinitions.operator2.field_2
                db 71h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 4                    ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 55h                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 71h                  ; instrumentDefinitions.operator3.field_3
                db 14h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 0Ah                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'HuffBrs'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 0                    ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FCh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 14h                  ; instrumentDefinitions.operator0.totalLevel
                db 50h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 31h                  ; instrumentDefinitions.operator0.field_3
                db 4Dh                  ; instrumentDefinitions.operator0.field_4
                db 0Dh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 27h                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1000b                ; instrumentDefinitions.operator1.field_2
                db 71h                  ; instrumentDefinitions.operator1.field_3
                db 4Dh                  ; instrumentDefinitions.operator1.field_4
                db 8Dh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 48h                  ; instrumentDefinitions.operator1.field_7
                db 9                    ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 1100000b             ; instrumentDefinitions.operator2.field_2
                db 31h                  ; instrumentDefinitions.operator2.field_3
                db 4Dh                  ; instrumentDefinitions.operator2.field_4
                db 0Dh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 0Ah                  ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 1000b                ; instrumentDefinitions.operator3.field_2
                db 61h                  ; instrumentDefinitions.operator3.field_3
                db 4Dh                  ; instrumentDefinitions.operator3.field_4
                db 8Dh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 48h                  ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'PercBr1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 31h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0F9h                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 12h                  ; instrumentDefinitions.operator0.totalLevel
                db 50h                  ; instrumentDefinitions.operator0.field_1
                db 100000b              ; instrumentDefinitions.operator0.field_2
                db 4Bh                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 11h                  ; instrumentDefinitions.operator0.field_5
                db 13h                  ; instrumentDefinitions.operator0.field_6
                db 4Ch                  ; instrumentDefinitions.operator0.field_7
                db 0                    ; instrumentDefinitions.operator1.totalLevel
                db 20h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 11h                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 13h                  ; instrumentDefinitions.operator1.field_7
                db 20h                  ; instrumentDefinitions.operator2.totalLevel
                db 40h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 41h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 0Bh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 3                    ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 60h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 42h                  ; instrumentDefinitions.operator3.field_3
                db 19h                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 5                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'PercBr2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CDh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 32h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FBh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 6                    ; instrumentDefinitions.operator0.totalLevel
                db 70h                  ; instrumentDefinitions.operator0.field_1
                db 0                    ; instrumentDefinitions.operator0.field_2
                db 41h                  ; instrumentDefinitions.operator0.field_3
                db 1Fh                  ; instrumentDefinitions.operator0.field_4
                db 13h                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 43h                  ; instrumentDefinitions.operator0.field_7
                db 13h                  ; instrumentDefinitions.operator1.totalLevel
                db 30h                  ; instrumentDefinitions.operator1.field_1
                db 1000000b             ; instrumentDefinitions.operator1.field_2
                db 41h                  ; instrumentDefinitions.operator1.field_3
                db 1Fh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 3                    ; instrumentDefinitions.operator1.field_7
                db 0Ah                  ; instrumentDefinitions.operator2.totalLevel
                db 50h                  ; instrumentDefinitions.operator2.field_1
                db 1000000b             ; instrumentDefinitions.operator2.field_2
                db 45h                  ; instrumentDefinitions.operator2.field_3
                db 1Fh                  ; instrumentDefinitions.operator2.field_4
                db 15h                  ; instrumentDefinitions.operator2.field_5
                db 11h                  ; instrumentDefinitions.operator2.field_6
                db 33h                  ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 50h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 41h                  ; instrumentDefinitions.operator3.field_3
                db 1Fh                  ; instrumentDefinitions.operator3.field_4
                db 9Fh                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 5                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'String1'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 35h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 14h                  ; instrumentDefinitions.operator0.totalLevel
                db 10h                  ; instrumentDefinitions.operator0.field_1
                db 110000b              ; instrumentDefinitions.operator0.field_2
                db 32h                  ; instrumentDefinitions.operator0.field_3
                db 5Dh                  ; instrumentDefinitions.operator0.field_4
                db 1Fh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 5                    ; instrumentDefinitions.operator0.field_7
                db 17h                  ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 1100000b             ; instrumentDefinitions.operator1.field_2
                db 14h                  ; instrumentDefinitions.operator1.field_3
                db 5Dh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 5                    ; instrumentDefinitions.operator1.field_7
                db 1Dh                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 1010000b             ; instrumentDefinitions.operator2.field_2
                db 56h                  ; instrumentDefinitions.operator2.field_3
                db 5Dh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 4                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 44h                  ; instrumentDefinitions.operator3.field_3
                db 4Ah                  ; instrumentDefinitions.operator3.field_4
                db 0BFh                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'String2'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 35h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0E8h                 ; instrumentDefinitions.transpose
                db 18h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 110000b              ; instrumentDefinitions.operator0.field_2
                db 32h                  ; instrumentDefinitions.operator0.field_3
                db 5Dh                  ; instrumentDefinitions.operator0.field_4
                db 1Fh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 2                    ; instrumentDefinitions.operator0.field_7
                db 15h                  ; instrumentDefinitions.operator1.totalLevel
                db 70h                  ; instrumentDefinitions.operator1.field_1
                db 1100000b             ; instrumentDefinitions.operator1.field_2
                db 44h                  ; instrumentDefinitions.operator1.field_3
                db 5Dh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 3                    ; instrumentDefinitions.operator1.field_7
                db 1Dh                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 1010000b             ; instrumentDefinitions.operator2.field_2
                db 76h                  ; instrumentDefinitions.operator2.field_3
                db 5Dh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 3                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 44h                  ; instrumentDefinitions.operator3.field_3
                db 4Bh                  ; instrumentDefinitions.operator3.field_4
                db 0BFh                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'String3'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0C6h                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 35h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0                    ; instrumentDefinitions.transpose
                db 14h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 10000b               ; instrumentDefinitions.operator0.field_2
                db 40h                  ; instrumentDefinitions.operator0.field_3
                db 9Fh                  ; instrumentDefinitions.operator0.field_4
                db 6                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 11h                  ; instrumentDefinitions.operator0.field_7
                db 18h                  ; instrumentDefinitions.operator1.totalLevel
                db 10h                  ; instrumentDefinitions.operator1.field_1
                db 0                    ; instrumentDefinitions.operator1.field_2
                db 43h                  ; instrumentDefinitions.operator1.field_3
                db 9Ch                  ; instrumentDefinitions.operator1.field_4
                db 5                    ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 55h                  ; instrumentDefinitions.operator1.field_7
                db 12h                  ; instrumentDefinitions.operator2.totalLevel
                db 20h                  ; instrumentDefinitions.operator2.field_1
                db 11010000b            ; instrumentDefinitions.operator2.field_2
                db 40h                  ; instrumentDefinitions.operator2.field_3
                db 5Bh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 3                    ; instrumentDefinitions.operator2.field_7
                db 0                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 40h                  ; instrumentDefinitions.operator3.field_3
                db 4Dh                  ; instrumentDefinitions.operator3.field_4
                db 83h                  ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 24h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'String4'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 35h                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 0Eh                  ; instrumentDefinitions.operator0.totalLevel
                db 0                    ; instrumentDefinitions.operator0.field_1
                db 110000b              ; instrumentDefinitions.operator0.field_2
                db 12h                  ; instrumentDefinitions.operator0.field_3
                db 5Fh                  ; instrumentDefinitions.operator0.field_4
                db 0Bh                  ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 25h                  ; instrumentDefinitions.operator0.field_7
                db 16h                  ; instrumentDefinitions.operator1.totalLevel
                db 0                    ; instrumentDefinitions.operator1.field_1
                db 110000b              ; instrumentDefinitions.operator1.field_2
                db 44h                  ; instrumentDefinitions.operator1.field_3
                db 5Dh                  ; instrumentDefinitions.operator1.field_4
                db 1Fh                  ; instrumentDefinitions.operator1.field_5
                db 0                    ; instrumentDefinitions.operator1.field_6
                db 5                    ; instrumentDefinitions.operator1.field_7
                db 1Bh                  ; instrumentDefinitions.operator2.totalLevel
                db 10h                  ; instrumentDefinitions.operator2.field_1
                db 1010000b             ; instrumentDefinitions.operator2.field_2
                db 66h                  ; instrumentDefinitions.operator2.field_3
                db 5Dh                  ; instrumentDefinitions.operator2.field_4
                db 1Fh                  ; instrumentDefinitions.operator2.field_5
                db 0                    ; instrumentDefinitions.operator2.field_6
                db 4                    ; instrumentDefinitions.operator2.field_7
                db 1                    ; instrumentDefinitions.operator3.totalLevel
                db 70h                  ; instrumentDefinitions.operator3.field_1
                db 0                    ; instrumentDefinitions.operator3.field_2
                db 44h                  ; instrumentDefinitions.operator3.field_3
                db 4Ah                  ; instrumentDefinitions.operator3.field_4
                db 0BFh                 ; instrumentDefinitions.operator3.field_5
                db 0                    ; instrumentDefinitions.operator3.field_6
                db 6                    ; instrumentDefinitions.operator3.field_7
                db [ 0Ah ], 0           ; instrumentDefinitions.reserved2
                db 0                    ; instrumentDefinitions.field_3A
                db 22h                  ; instrumentDefinitions.field_3B
                db [ 4 ], 0             ; instrumentDefinitions.reserved3
                .ascii 'SoloVio'        ; instrumentDefinitions.name
                db 0                    ; instrumentDefinitions.reserved1
                db 0CBh                 ; instrumentDefinitions.lfoSpeed
                db 80h                  ; instrumentDefinitions.amplitudeModulationDepth
                db 2Ah                  ; instrumentDefinitions.pitchModulationDepth
                db 78h                  ; instrumentDefinitions.operatorEnable
                db 0FAh                 ; instrumentDefinitions.feedbackLevelAlgorithm
                db 40h                  ; instrumentDefinitions.pmsAm
                db 40h                  ; instrumentDefinitions.lfoWaveForm
                db 0F4h                 ; instrumentDefinitions.transpose
                db 15h                  ; instrumentDefinitions.operator0.totalLevel
                db 20h                  ; instrumentDefinitions.operator0.field_1
                db 10000b               ; instrumentDefinitions.operator0.field_2
                db 12h                  ; instrumentDefinitions.operator0.field_3
                db 1Bh                  ; instrumentDefinitions.operator0.field_4
                db 5                    ; instrumentDefinitions.operator0.field_5
                db 0                    ; instrumentDefinitions.operator0.field_6
                db 17h                  ; instrumentDefinitions.operator0.field_7
                db 18h